/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.ui.mapping.ITeamStateChangeEvent;

public class TeamStateChangeEvent
implements ITeamStateChangeEvent {
    private Set<IResource> changes = new HashSet<IResource>();
    private Set<IResource> addedRoots = new HashSet<IResource>();
    private Set<IResource> removedRoots = new HashSet<IResource>();

    public TeamStateChangeEvent() {
    }

    public TeamStateChangeEvent(ISubscriberChangeEvent[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            ISubscriberChangeEvent event = deltas[i];
            IResource resource = event.getResource();
            if ((event.getFlags() & 2) != 0) {
                this.rootAdded(resource);
            }
            if ((event.getFlags() & 4) != 0) {
                this.rootRemoved(resource);
            }
            if ((event.getFlags() & 1) != 0) {
                this.changed(resource);
            }
            while (resource.getType() != 4) {
                resource = resource.getParent();
                this.changed(resource);
            }
            ++i;
        }
    }

    public void changed(IResource resource) {
        this.changes.add(resource);
    }

    public void rootRemoved(IResource resource) {
        this.removedRoots.add(resource);
    }

    public void rootAdded(IResource resource) {
        this.addedRoots.add(resource);
    }

    @Override
    public IResource[] getAddedRoots() {
        return this.addedRoots.toArray(new IResource[this.addedRoots.size()]);
    }

    @Override
    public IResource[] getRemovedRoots() {
        return this.removedRoots.toArray(new IResource[this.removedRoots.size()]);
    }

    @Override
    public IResource[] getChangedResources() {
        return this.changes.toArray(new IResource[this.changes.size()]);
    }

    @Override
    public boolean hasChange(IResource resource) {
        if (this.changes.contains(resource)) {
            return true;
        }
        return this.isChildOfChangedRoot(resource);
    }

    private boolean isChildOfChangedRoot(IResource resource) {
        if (resource == null || resource.getType() == 8) {
            return false;
        }
        if (this.addedRoots.contains(resource) || this.removedRoots.contains(resource)) {
            return true;
        }
        return this.isChildOfChangedRoot((IResource)resource.getParent());
    }
}

