/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class OpenBookmarkAction
extends BookmarkAction {
    public OpenBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.OpenBookmark_text);
        this.setToolTipText(BookmarkMessages.OpenBookmark_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.open_bookmark_action_context");
        this.setEnabled(false);
    }

    public void run() {
        IWorkbenchPage page = this.getView().getSite().getPage();
        for (IMarker marker : this.getStructuredSelection()) {
            try {
                IDE.openEditor(page, marker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                CoreException nestedException = null;
                IStatus status = e.getStatus();
                if (status != null && status.getException() instanceof CoreException) {
                    nestedException = (CoreException)status.getException();
                }
                if (nestedException != null) {
                    ErrorDialog.openError((Shell)this.getView().getShell(), (String)BookmarkMessages.OpenBookmark_errorTitle, (String)e.getMessage(), (IStatus)nestedException.getStatus());
                    continue;
                }
                MessageDialog.openError((Shell)this.getView().getShell(), (String)BookmarkMessages.OpenBookmark_errorTitle, (String)e.getMessage());
            }
        }
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.setEnabled(!sel.isEmpty());
    }
}

