/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.util.TransactionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChangeDescription
extends ChangeDescriptionImpl
implements TransactionChangeDescription {
    private final List<ChangeDescription> changes = new ArrayList<ChangeDescription>();
    private List<ChangeDescription> detached;

    @Override
    public final boolean isEmpty() {
        return this.changes.isEmpty() && (this.detached == null || this.detached.isEmpty());
    }

    public final void clear() {
        this.changes.clear();
        this.detached = null;
        this.objectChanges = null;
        this.objectsToDetach = null;
        this.objectsToAttach = null;
        this.resourceChanges = null;
    }

    public final void detach() {
        if (this.detached == null) {
            this.detached = new ArrayList<ChangeDescription>(this.changes);
        } else {
            this.detached.addAll(this.changes);
        }
        this.changes.clear();
    }

    void dispose() {
        for (ChangeDescription next : this.changes) {
            TransactionUtil.dispose(next);
        }
        if (this.detached != null) {
            for (ChangeDescription next : this.detached) {
                TransactionUtil.dispose(next);
            }
        }
    }

    @Override
    public boolean canApply() {
        boolean result = true;
        Iterator<ChangeDescription> iter = this.changes.iterator();
        while (result && iter.hasNext()) {
            ChangeDescription next = iter.next();
            if (!(next instanceof TransactionChangeDescription)) continue;
            result = ((TransactionChangeDescription)next).canApply();
        }
        return result;
    }

    public void apply() {
        ListIterator<ChangeDescription> iter = this.changes.listIterator(this.changes.size());
        while (iter.hasPrevious()) {
            iter.previous().apply();
        }
        this.changes.clear();
        this.detached = null;
    }

    public void applyAndReverse() {
        ListIterator<ChangeDescription> iter = this.changes.listIterator(this.changes.size());
        while (iter.hasPrevious()) {
            iter.previous().applyAndReverse();
        }
        Collections.reverse(this.changes);
    }

    public void add(ChangeDescription change) {
        if (!this.isEmpty(change)) {
            if (change instanceof CompositeChangeDescription) {
                CompositeChangeDescription other = (CompositeChangeDescription)change;
                for (ChangeDescription next : other.changes) {
                    this.add(next);
                }
                if (other.detached != null) {
                    for (ChangeDescription next : other.detached) {
                        this.addDetached(next);
                    }
                }
            } else {
                this.changes.add(change);
                this.appendChanges(change);
            }
        }
    }

    private void addDetached(ChangeDescription change) {
        if (!this.isEmpty(change)) {
            if (change instanceof CompositeChangeDescription) {
                CompositeChangeDescription other = (CompositeChangeDescription)change;
                for (ChangeDescription next : other.changes) {
                    this.addDetached(next);
                }
                if (other.detached != null) {
                    for (ChangeDescription next : other.detached) {
                        this.addDetached(next);
                    }
                }
            } else {
                if (this.detached == null) {
                    this.detached = new ArrayList<ChangeDescription>();
                }
                this.detached.add(change);
                this.appendChanges(change);
            }
        }
    }

    private void appendChanges(ChangeDescription change) {
        if (this.objectChanges != null) {
            this.objectChanges.addAll((Collection)change.getObjectChanges());
        }
        if (this.objectsToAttach != null) {
            this.objectsToAttach.addAll((Collection)change.getObjectsToAttach());
        }
        if (this.resourceChanges != null) {
            this.resourceChanges.addAll((Collection)change.getResourceChanges());
        }
    }

    private boolean isEmpty(ChangeDescription changeDescription) {
        boolean result;
        boolean bl = result = changeDescription == null;
        if (!result) {
            result = changeDescription instanceof TransactionChangeDescription ? ((TransactionChangeDescription)changeDescription).isEmpty() : changeDescription.getObjectChanges().isEmpty() && changeDescription.getObjectsToAttach().isEmpty() && changeDescription.getResourceChanges().isEmpty();
        }
        return result;
    }

    public EMap<EObject, EList<FeatureChange>> getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new BasicEMap();
            for (ChangeDescription next : this.changes) {
                this.objectChanges.addAll((Collection)next.getObjectChanges());
            }
        }
        return this.objectChanges;
    }

    public EList<EObject> getObjectsToDetach() {
        LinkedHashSet result = new LinkedHashSet();
        for (ChangeDescription next : this.changes) {
            result.addAll(next.getObjectsToDetach());
        }
        if (this.detached != null) {
            for (ChangeDescription next : this.detached) {
                result.addAll(next.getObjectsToDetach());
            }
        }
        return new BasicEList(result);
    }

    public EList<EObject> getObjectsToAttach() {
        if (this.objectsToAttach == null) {
            this.objectsToAttach = new BasicEList();
            for (ChangeDescription next : this.changes) {
                this.objectsToAttach.addAll((Collection)next.getObjectsToAttach());
            }
        }
        return this.objectsToAttach;
    }

    public EList<ResourceChange> getResourceChanges() {
        if (this.resourceChanges == null) {
            this.resourceChanges = new BasicEList();
            for (ChangeDescription next : this.changes) {
                this.resourceChanges.addAll((Collection)next.getResourceChanges());
            }
        }
        return this.resourceChanges;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("CompositeChangeDescription[");
        result.append(this.getObjectChanges().size()).append(", ");
        result.append(this.getObjectsToAttach().size()).append(", ");
        result.append(this.getObjectsToDetach().size()).append(", ");
        result.append(this.getResourceChanges().size()).append(']');
        return result.toString();
    }
}

