/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;

public class DecoratableResourceHelper {
    private static Map<Repository, String> branchState = Collections.synchronizedMap(new WeakHashMap());

    static String getRepositoryName(Repository repository) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        RepositoryState state = repository.getRepositoryState();
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    static String getShortBranch(Repository repository) throws IOException {
        return Activator.getDefault().getRepositoryUtil().getShortBranch(repository);
    }

    static RevCommit getHeadCommit(Repository repository) {
        return Activator.getDefault().getRepositoryUtil().parseHeadCommit(repository);
    }

    static String getBranchStatus(Repository repo) throws IOException {
        String cachedStatus = branchState.get(repo);
        if (cachedStatus != null) {
            return cachedStatus;
        }
        String branchName = repo.getBranch();
        if (branchName == null) {
            return null;
        }
        BranchTrackingStatus status = BranchTrackingStatus.of((Repository)repo, (String)branchName);
        if (status == null) {
            return null;
        }
        if (status.getAheadCount() == 0 && status.getBehindCount() == 0) {
            return null;
        }
        String formattedStatus = GitLabels.formatBranchTrackingStatus(status);
        branchState.put(repo, formattedStatus);
        return formattedStatus;
    }

    static void clearState(Repository repo) {
        branchState.remove(repo);
    }
}

