/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.ICSSInfo;
import org.eclipse.pde.internal.core.iproduct.IPreferencesInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.product.SplashInfo;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.util.TemplateFileGenerator;
import org.eclipse.pde.internal.ui.wizards.product.BaseManifestOperation;
import org.eclipse.pde.internal.ui.wizards.product.ISplashHandlerConstants;
import org.eclipse.pde.internal.ui.wizards.product.RemoveSplashHandlerBindingAction;
import org.eclipse.pde.internal.ui.wizards.product.UpdateSplashHandlerAction;
import org.eclipse.pde.internal.ui.wizards.product.UpdateSplashProgressOperation;
import org.eclipse.swt.widgets.Shell;

public class ProductDefinitionOperation
extends BaseManifestOperation {
    private static final String APPLICATION_CSS = "applicationCSS";
    private String fProductId;
    private String fApplication;
    private IProduct fProduct;
    protected IProject fProject;
    private UpdateSplashHandlerAction fUpdateSplashAction;
    private RemoveSplashHandlerBindingAction fRemoveSplashAction;
    private UpdateSplashProgressOperation fUpdateSplashProgressOperation;

    public ProductDefinitionOperation(IProduct product, String pluginId, String productId, String application, Shell shell) {
        super(shell, pluginId);
        this.fProductId = productId;
        this.fApplication = application;
        this.fProduct = product;
        this.fProject = null;
    }

    public ProductDefinitionOperation(IProduct product, String pluginId, String productId, String application, Shell shell, IProject project) {
        super(shell, pluginId);
        this.fProductId = productId;
        this.fApplication = application;
        this.fProduct = product;
        this.fProject = project;
    }

    protected String getFormattedPackageName(String id) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString().toLowerCase(Locale.ENGLISH);
    }

    protected String createTargetPackage() {
        String packageName = this.getFormattedPackageName(this.fPluginId);
        if (packageName.length() == 0) {
            return "splashHandlers";
        }
        return String.valueOf(packageName) + '.' + "splashHandlers";
    }

    private String createAttributeValueClass() {
        String targetPackage = this.createTargetPackage();
        String targetClass = this.createTargetClass();
        if (targetClass == null) {
            return null;
        }
        return String.valueOf(targetPackage) + "." + targetClass;
    }

    private String createTargetClass() {
        String splashHandlerType = this.getSplashHandlerType();
        if (splashHandlerType == null) {
            return null;
        }
        int i = 0;
        while (i < ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES.length) {
            String choice = ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES[i][0];
            if (splashHandlerType.equals(choice)) {
                return ISplashHandlerConstants.F_SPLASH_SCREEN_CLASSES[i];
            }
            ++i;
        }
        return null;
    }

    private String createAttributeValueID() {
        return String.valueOf(this.createTargetPackage()) + "." + this.getSplashHandlerType();
    }

    private UpdateSplashProgressOperation getUpdateSplashProgressOperation() {
        if (this.fUpdateSplashProgressOperation == null) {
            this.fUpdateSplashProgressOperation = new UpdateSplashProgressOperation();
        } else {
            this.fUpdateSplashProgressOperation.reset();
        }
        return this.fUpdateSplashProgressOperation;
    }

    private void updateSplashProgress(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        if (this.fProject == null) {
            return;
        }
        if (model == null) {
            return;
        }
        if (monitor == null) {
            return;
        }
        UpdateSplashProgressOperation operation = this.getUpdateSplashProgressOperation();
        operation.setModel(model);
        operation.setShowProgress(this.isProgressDefined());
        operation.setProject(this.fProject);
        operation.setProductID(this.fProduct.getProductId());
        operation.setPluginID(this.fPluginId);
        operation.run(monitor);
    }

    private boolean isProgressDefined() {
        ISplashInfo info = this.fProduct.getProduct().getSplashInfo();
        if (info == null) {
            return false;
        }
        return info.isDefinedGeometry();
    }

    private String getSplashHandlerType() {
        ISplashInfo info = this.fProduct.getProduct().getSplashInfo();
        if (info == null) {
            return null;
        }
        if (!info.isDefinedSplashHandlerType()) {
            return null;
        }
        return info.getFieldSplashHandlerType();
    }

    private void updateSplashHandler(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        this.updateSplashHandlerFiles(model, monitor);
        this.updateSplashHandlerModel(model, monitor);
    }

    private void updateSplashHandlerFiles(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        if (this.fProject == null) {
            return;
        }
        String splashHandlerType = this.getSplashHandlerType();
        if (splashHandlerType == null) {
            return;
        }
        TemplateFileGenerator generator = new TemplateFileGenerator(this.fProject, model, this.fPluginId, this.createTargetPackage(), this.createTargetClass(), splashHandlerType);
        generator.generateFiles(monitor);
    }

    private void updateSplashHandlerModel(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        String splashHandlerType = this.getSplashHandlerType();
        if (splashHandlerType == null) {
            this.runRemoveSplashAction(model, monitor);
        } else {
            this.runUpdateSplashAction(model, monitor, splashHandlerType);
        }
    }

    private void runRemoveSplashAction(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        this.fRemoveSplashAction = new RemoveSplashHandlerBindingAction();
        this.fRemoveSplashAction.setFieldProductID(this.fProduct.getProductId());
        this.fRemoveSplashAction.setFieldTargetPackage(this.createTargetPackage());
        this.fRemoveSplashAction.setModel(model);
        this.fRemoveSplashAction.setMonitor(monitor);
        this.fRemoveSplashAction.run();
        this.fRemoveSplashAction.hasException();
    }

    private void runUpdateSplashAction(IPluginModelBase model, IProgressMonitor monitor, String splashHandlerType) throws CoreException {
        this.fUpdateSplashAction = new UpdateSplashHandlerAction();
        String id = this.createAttributeValueID();
        this.fUpdateSplashAction.setFieldID(id);
        this.fUpdateSplashAction.setFieldClass(this.createAttributeValueClass());
        this.fUpdateSplashAction.setFieldSplashID(id);
        this.fUpdateSplashAction.setFieldProductID(this.fProduct.getProductId());
        this.fUpdateSplashAction.setFieldTemplate(splashHandlerType);
        this.fUpdateSplashAction.setFieldPluginID(this.fPluginId);
        this.fUpdateSplashAction.setModel(model);
        this.fUpdateSplashAction.setMonitor(monitor);
        this.fUpdateSplashAction.run();
        this.fUpdateSplashAction.hasException();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IFile file = this.getFile();
            if (!file.exists()) {
                this.createNewFile(file, monitor);
            } else {
                this.modifyExistingFile(file, monitor);
            }
            this.updateSingleton(monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void createNewFile(IFile file, IProgressMonitor monitor) throws CoreException {
        WorkspacePluginModelBase model = (WorkspacePluginModelBase)this.getModel(file);
        IPluginBase base = model.getPluginBase();
        base.setSchemaVersion(TargetPlatformHelper.getSchemaVersion());
        base.add(this.createExtension((IPluginModelBase)model));
        this.updateSplashHandler((IPluginModelBase)model, monitor);
        this.updateSplashProgress((IPluginModelBase)model, monitor);
        model.save();
    }

    private IPluginExtension createExtension(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = model.getFactory().createExtension();
        extension.setPoint("org.eclipse.core.runtime.products");
        extension.setId(this.fProductId);
        extension.add((IPluginObject)this.createExtensionContent(extension));
        return extension;
    }

    private IPluginElement createExtensionContent(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("product");
        element.setAttribute("name", this.fProduct.getName());
        element.setAttribute("application", this.fApplication);
        IPluginElement child = this.createElement(element, "windowImages", this.getWindowImagesString());
        if (child != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, "aboutText", this.getAboutText())) != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, "aboutImage", this.getAboutImage())) != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, "startupForegroundColor", this.getForegroundColor())) != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, "startupProgressRect", this.getProgressRect())) != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, "startupMessageRect", this.getMessageRect())) != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, "preferenceCustomization", this.getPreferenceCustomization())) != null) {
            element.add((IPluginObject)child);
        }
        if ((child = this.createElement(element, APPLICATION_CSS, this.getApplicationCSS())) != null) {
            element.add((IPluginObject)child);
        }
        return element;
    }

    private IPluginElement createElement(IPluginElement parent, String name, String value) throws CoreException {
        IPluginElement element = null;
        if (value != null && value.length() > 0) {
            element = parent.getModel().getFactory().createElement((IPluginObject)parent);
            element.setName("property");
            element.setAttribute("name", name);
            element.setAttribute("value", value);
        }
        return element;
    }

    private String getAboutText() {
        IAboutInfo info = this.fProduct.getAboutInfo();
        if (info != null) {
            String text = info.getText();
            return text == null || text.length() == 0 ? null : text;
        }
        return null;
    }

    private String getAboutImage() {
        IAboutInfo info = this.fProduct.getAboutInfo();
        return info != null ? this.getURL(info.getImagePath()) : null;
    }

    private String getURL(String location) {
        IPluginModelBase model;
        if (location == null || location.trim().length() == 0) {
            return null;
        }
        Path path = new Path(location);
        if (!path.isAbsolute()) {
            return location;
        }
        String projectName = path.segment(0);
        IProject project = PDEPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && (model = PluginRegistry.findModel((IProject)project)) != null) {
            String id = model.getPluginBase().getId();
            if (this.fPluginId.equals(id)) {
                return path.removeFirstSegments(1).toString();
            }
            return "platform:/plugin/" + id + "/" + path.removeFirstSegments(1);
        }
        return location;
    }

    private String getFullyQualifiedURL(String location) {
        IPluginModelBase model;
        if (location == null || location.trim().length() == 0) {
            return null;
        }
        Path path = new Path(location);
        if (!path.isAbsolute()) {
            return location;
        }
        String projectName = path.segment(0);
        IProject project = PDEPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && (model = PluginRegistry.findModel((IProject)project)) != null) {
            String id = model.getPluginBase().getId();
            return "platform:/plugin/" + id + "/" + path.removeFirstSegments(1);
        }
        return location;
    }

    private String getWindowImagesString() {
        IWindowImages images = this.fProduct.getWindowImages();
        StringBuilder buffer = new StringBuilder();
        if (images != null) {
            int i = 0;
            while (i < 6) {
                String image = this.getURL(images.getImagePath(i));
                if (image != null) {
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append(image);
                }
                ++i;
            }
        }
        return buffer.length() == 0 ? null : buffer.toString();
    }

    private String getForegroundColor() {
        ISplashInfo info = this.fProduct.getSplashInfo();
        return info != null ? info.getForegroundColor() : null;
    }

    private String getProgressRect() {
        ISplashInfo info = this.fProduct.getSplashInfo();
        return info != null ? SplashInfo.getGeometryString((int[])info.getProgressGeometry()) : null;
    }

    private String getMessageRect() {
        ISplashInfo info = this.fProduct.getSplashInfo();
        return info != null ? SplashInfo.getGeometryString((int[])info.getMessageGeometry()) : null;
    }

    private String getPreferenceCustomization() {
        IPreferencesInfo info = this.fProduct.getPreferencesInfo();
        if (info != null) {
            String text = info.getPreferenceCustomizationPath();
            return text == null || text.length() == 0 ? null : this.getFullyQualifiedURL(text);
        }
        return null;
    }

    private String getApplicationCSS() {
        ICSSInfo info = this.fProduct.getCSSInfo();
        if (info != null) {
            String text = info.getFilePath();
            return text == null || text.length() == 0 ? null : this.getFullyQualifiedURL(text);
        }
        return null;
    }

    private void modifyExistingFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IStatus status = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.getShell());
        if (status.getSeverity() != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, NLS.bind((String)PDEUIMessages.ProductDefinitionOperation_readOnly, (Object)this.fPluginId), null));
        }
        ModelModification mod = new ModelModification(file){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IPluginModelBase)) {
                    return;
                }
                IPluginExtension extension = ProductDefinitionOperation.this.findProductExtension((IPluginModelBase)model);
                if (extension == null) {
                    ProductDefinitionOperation.this.insertNewExtension((IPluginModelBase)model);
                } else {
                    ProductDefinitionOperation.this.modifyExistingExtension(extension);
                }
                ProductDefinitionOperation.this.updateSplashHandler((IPluginModelBase)model, monitor);
                ProductDefinitionOperation.this.updateSplashProgress((IPluginModelBase)model, monitor);
            }
        };
        PDEModelUtility.modifyModel(mod, monitor);
    }

    private IPluginExtension findProductExtension(IPluginModelBase model) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = model.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            String point = extension.getPoint();
            String id = extension.getId();
            if (this.fProductId.equals(id) && "org.eclipse.core.runtime.products".equals(point)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    private void insertNewExtension(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = this.createExtension(model);
        model.getPluginBase().add(extension);
    }

    private void modifyExistingExtension(IPluginExtension extension) throws CoreException {
        if (extension.getChildCount() == 0) {
            this.insertNewProductElement(extension);
            return;
        }
        PluginElementNode element = (PluginElementNode)extension.getChildren()[0];
        if (!"product".equals(element.getName())) {
            this.insertNewProductElement(extension);
            return;
        }
        element.setAttribute("application", this.fApplication);
        element.setAttribute("name", this.fProduct.getName());
        this.synchronizeChild((IPluginElement)element, "appName", this.fProduct.getName());
        this.synchronizeChild((IPluginElement)element, "aboutImage", this.getAboutImage());
        this.synchronizeChild((IPluginElement)element, "aboutText", this.getAboutText());
        this.synchronizeChild((IPluginElement)element, "windowImages", this.getWindowImagesString());
        this.synchronizeChild((IPluginElement)element, "startupForegroundColor", this.getForegroundColor());
        this.synchronizeChild((IPluginElement)element, "startupMessageRect", this.getMessageRect());
        this.synchronizeChild((IPluginElement)element, "startupProgressRect", this.getProgressRect());
        this.synchronizeChild((IPluginElement)element, "preferenceCustomization", this.getPreferenceCustomization());
        if (this.fProduct.getCSSInfo() != null) {
            this.synchronizeChild((IPluginElement)element, APPLICATION_CSS, this.getApplicationCSS());
        }
    }

    private void synchronizeChild(IPluginElement element, String propertyName, String value) throws CoreException {
        IPluginObject[] children;
        IPluginElement child = null;
        IPluginObject[] iPluginObjectArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginAttribute attr;
            IPluginObject childObject = iPluginObjectArray[n2];
            IPluginElement candidate = (IPluginElement)childObject;
            if (candidate.getName().equals("property") && (attr = candidate.getAttribute("name")) != null && attr.getValue().equals(propertyName)) {
                child = candidate;
                break;
            }
            ++n2;
        }
        if (child != null && value == null) {
            element.remove(child);
        }
        if (value == null) {
            return;
        }
        if (child == null) {
            child = element.getModel().getFactory().createElement((IPluginObject)element);
            child.setName("property");
            element.add((IPluginObject)child);
        }
        child.setAttribute("value", value);
        child.setAttribute("name", propertyName);
    }

    private void insertNewProductElement(IPluginExtension extension) throws CoreException {
        IPluginElement element = this.createExtensionContent(extension);
        extension.add((IPluginObject)element);
    }
}

