/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runtime.ui;

import java.net.InetAddress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.core.launching.events.AutEvent;
import org.eclipse.rcptt.core.launching.events.AutEventInit;
import org.eclipse.rcptt.core.launching.events.AutEventStart;
import org.eclipse.rcptt.core.launching.events.AutSendEvent;
import org.eclipse.rcptt.core.launching.events.AutStartState;
import org.eclipse.rcptt.core.launching.events.Capability;
import org.eclipse.rcptt.core.launching.events.EventsFactory;
import org.eclipse.rcptt.ecl.client.tcp.EclTcpClientManager;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.runtime.ui.Activator;
import org.eclipse.rcptt.runtime.ui.Q7ServerStarter;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.swt.SWT;
import org.osgi.framework.Bundle;

public class AutEventManager {
    private static AutEventManager eventManager = null;
    private static String q7Id = null;
    private static int q7EclPort = -1;

    private static String getAutIdentity() {
        if (q7Id == null) {
            return System.getProperty("q7id");
        }
        return q7Id;
    }

    public static int getQ7EclPort() {
        if (q7EclPort == -1) {
            String q7EclPort = System.getProperty("q7EclPort");
            if (q7EclPort == null || q7EclPort.trim().length() == 0) {
                return -1;
            }
            return Integer.parseInt(q7EclPort);
        }
        return q7EclPort;
    }

    private ISession createEclSession() throws CoreException {
        int port;
        block3: {
            try {
                port = AutEventManager.getQ7EclPort();
                if (port != -1) break block3;
                return null;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.runtime.ui", "Couldn't open ECL session", (Throwable)e));
            }
        }
        return EclTcpClientManager.Instance.startClientSession(InetAddress.getByName("localhost"), port);
    }

    public static synchronized AutEventManager getInstance() {
        if (eventManager == null) {
            eventManager = new AutEventManager();
        }
        return eventManager;
    }

    public Object execute(Command command, long timeout, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ISession session = this.createEclSession();
        if (session == null) {
            Activator.log("Failed to send Aut Event: " + command, new Exception("Failed to send Aut Event: " + command));
            return null;
        }
        try {
            IPipe out = session.createPipe();
            IProcess rc = session.execute(command, null, out);
            IStatus status = rc.waitFor(timeout, monitor);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            Object object = out.take(timeout);
            return object;
        }
        finally {
            this.safeClose(session);
        }
    }

    private void safeClose(ISession session) {
        try {
            session.close();
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    public Object sendEvent(AutEvent event) throws CoreException, InterruptedException {
        AutSendEvent cmd = EventsFactory.eINSTANCE.createAutSendEvent();
        cmd.setId(AutEventManager.getAutIdentity());
        cmd.setEvent(event);
        return this.execute((Command)cmd, TeslaLimits.getAUTStartupTimeout(), (IProgressMonitor)new NullProgressMonitor());
    }

    public void sendStartup() {
        AutEventStart startEvent = EventsFactory.eINSTANCE.createAutEventStart();
        int eclPort = Q7ServerStarter.INSTANCE.getEclPort();
        int teslaPort = Q7ServerStarter.INSTANCE.getTeslaPort();
        startEvent.setEclPort(eclPort);
        startEvent.setTeslaPort(teslaPort);
        startEvent.setPlatform(AutEventManager.getPlatform());
        startEvent.setCapability(AutEventManager.getCapability());
        if (eclPort != -1 && teslaPort != -1) {
            startEvent.setState(AutStartState.OK);
        } else {
            if (eclPort == -1) {
                startEvent.setMessage("Failed to start ECL server");
            } else if (teslaPort == -1) {
                startEvent.setMessage("Failed to start Q7 Runtime server");
            }
            startEvent.setState(AutStartState.FAIL);
        }
        try {
            AutEventManager.getInstance().sendEvent((AutEvent)startEvent);
        }
        catch (CoreException e) {
            Activator.log(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendInitialStartupFail(String msg) {
        AutEventStart startEvent = EventsFactory.eINSTANCE.createAutEventStart();
        startEvent.setState(AutStartState.FAIL);
        startEvent.setMessage(msg);
        try {
            AutEventManager.getInstance().sendEvent((AutEvent)startEvent);
        }
        catch (CoreException e) {
            Activator.log(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void reconnect(String id, int port) {
        q7Id = id;
        q7EclPort = port;
    }

    public void sendInit() {
        IBundleGroupProvider[] providers;
        AutEventInit initObj = EventsFactory.eINSTANCE.createAutEventInit();
        IBundleGroupProvider[] iBundleGroupProviderArray = providers = Platform.getBundleGroupProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroup[] groups;
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = groups = provider.getBundleGroups();
            int n3 = groups.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle[] bundles;
                IBundleGroup group = iBundleGroupArray[n4];
                Bundle[] bundleArray = bundles = group.getBundles();
                int n5 = bundles.length;
                int n6 = 0;
                while (n6 < n5) {
                    Bundle bundle = bundleArray[n6];
                    AutBundleState state = EventsFactory.eINSTANCE.createAutBundleState();
                    state.setId(bundle.getSymbolicName());
                    state.setLocation(bundle.getLocation());
                    switch (bundle.getState()) {
                        case 32: {
                            state.setState("active");
                            break;
                        }
                        case 2: {
                            state.setState("installed");
                            break;
                        }
                        case 4: {
                            state.setState("resolved");
                            break;
                        }
                        case 8: {
                            state.setState("starting");
                            break;
                        }
                        case 16: {
                            state.setState("stopping");
                            break;
                        }
                        case 1: {
                            state.setState("uninstalled");
                        }
                    }
                    initObj.getBundleState().add((Object)state);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        try {
            this.sendEvent((AutEvent)initObj);
        }
        catch (CoreException e) {
            Activator.log(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static org.eclipse.rcptt.core.launching.events.Platform getPlatform() {
        String os = SWT.getPlatform();
        if (os.indexOf("cocoa") >= 0) {
            return org.eclipse.rcptt.core.launching.events.Platform.MAC_OS;
        }
        if (os.indexOf("win") >= 0) {
            return org.eclipse.rcptt.core.launching.events.Platform.WINDOWS;
        }
        if (os.indexOf("gtk") >= 0) {
            return org.eclipse.rcptt.core.launching.events.Platform.LINUX;
        }
        return org.eclipse.rcptt.core.launching.events.Platform.OTHER;
    }

    private static Capability getCapability() {
        if (TeslaCore.isEclipse4()) {
            return Capability.E4;
        }
        return Capability.E3;
    }
}

