/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ui;

import java.util.Iterator;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.bindings.keys.formatting.AbstractKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.rcptt.util.KeysAndButtons;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class Q7KeyFormatter
extends AbstractKeyFormatter {
    protected String getKeyDelimiter() {
        return "+";
    }

    protected String getKeyStrokeDelimiter() {
        return " ";
    }

    protected int[] sortModifierKeys(int modifierKeys) {
        int[] sortedKeys = new int[KeysAndButtons.getModifiers().size()];
        int index = 0;
        Iterator iterator = KeysAndButtons.getModifiers().keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if ((modifierKeys & i) == 0) continue;
            sortedKeys[index++] = i;
        }
        return sortedKeys;
    }

    public String format(int key) {
        String result = (String)KeysAndButtons.getModifiers().get(key);
        return result == null ? super.format(key) : result;
    }

    public static void installQ7Formatter() {
        KeyFormatterFactory.setDefault((IKeyFormatter)new Q7KeyFormatter());
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            if (w instanceof WorkbenchWindow) {
                WorkbenchWindow ww = (WorkbenchWindow)w;
                final Shell shell = ww.getShell();
                try {
                    final CoolBarManager coolBarManager = ww.getCoolBarManager();
                    if (shell != null && coolBarManager != null) {
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    shell.setLayoutDeferred(true);
                                    IContributionItem[] items = coolBarManager.getItems();
                                    coolBarManager.setItems(new IContributionItem[0]);
                                    coolBarManager.setItems(items);
                                }
                                finally {
                                    shell.setLayoutDeferred(false);
                                }
                            }
                        });
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }
}

