/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rcptt.core.model.IOpenable;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7Model;

public abstract class Openable
extends Q7Element
implements IOpenable {
    protected Openable(Q7Element parent) throws IllegalArgumentException {
        super(parent);
    }

    public boolean canBeRemovedFromCache() {
        return true;
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map<IQ7Element, Object> var3, IResource var4) throws ModelException;

    protected void openParent(Object childInfo, Map<IQ7Element, Object> newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected boolean parentExists() {
        IQ7Element parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    @Override
    public void open(IProgressMonitor pm) throws ModelException {
        this.getElementInfo(pm);
    }

    @Override
    protected void generateInfos(Object info, Map<IQ7Element, Object> newElements, IProgressMonitor monitor) throws ModelException {
        this.openParent(info, newElements, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        newElements.put(this, info);
        try {
            OpenableElementInfo openableElementInfo = (OpenableElementInfo)info;
            boolean isStructureKnown = this.buildStructure(openableElementInfo, monitor, newElements, this.getResource());
            openableElementInfo.setIsStructureKnown(isStructureKnown);
        }
        catch (ModelException e) {
            newElements.remove(this);
            throw e;
        }
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public boolean isOpen() {
        return ModelManager.getModelManager().getInfo(this) != null;
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return Q7Model.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    @Override
    public boolean isStructureKnown() throws ModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    @Override
    public IOpenable getOpenable() {
        return this;
    }
}

