/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.debug.commands.CommandsFactory;
import org.eclipse.rcptt.ecl.debug.commands.ServerInfo;
import org.eclipse.rcptt.ecl.debug.commands.StartServer;
import org.eclipse.rcptt.ecl.debug.commands.StopServer;
import org.eclipse.rcptt.ecl.debug.core.Debugger;
import org.eclipse.rcptt.ecl.debug.core.DebuggerTransport;
import org.eclipse.rcptt.ecl.debug.core.EclDebug;
import org.eclipse.rcptt.ecl.debug.core.NullDebuggerTransport;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7Process;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.launching.AutLaunch;

public class TestCaseDebugger {
    private final String sessionId;
    private final AutLaunch aut;
    private final Debugger debugger;
    private DebuggerTransport transport;
    private final BiFunction<String, Integer, DebuggerTransport> transportFactory;

    public TestCaseDebugger(AutLaunch aut, Q7Process process, BiFunction<String, Integer, DebuggerTransport> connect) throws CoreException {
        this.aut = Objects.requireNonNull(aut);
        this.transportFactory = Objects.requireNonNull(connect);
        this.sessionId = UUID.randomUUID().toString();
        this.debugger = EclDebug.createDebugger((IProcess)process);
        this.connect();
    }

    public IDebugTarget getDebugTarget() {
        return this.debugger;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void beforeRestart() {
        this.debugger.setTransport((DebuggerTransport)new NullDebuggerTransport());
    }

    public void afterRestart() throws CoreException {
        try {
            this.connect();
        }
        catch (CoreException e) {
            throw new CoreException(Q7LaunchingPlugin.createStatus("Couldn't connect to debugger after AUT restart", e));
        }
    }

    private synchronized void connect() throws CoreException {
        try {
            StartServer start = CommandsFactory.eINSTANCE.createStartServer();
            start.setId(this.sessionId);
            ServerInfo info = (ServerInfo)this.aut.execute((Command)start);
            int port = info.getPort();
            String host = this.aut instanceof BaseAutLaunch ? ((BaseAutLaunch)this.aut).getHost() : "localhost";
            this.transport = this.transportFactory.apply(host, port);
            this.debugger.setTransport(this.transport);
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public void terminate() {
        StopServer stop = CommandsFactory.eINSTANCE.createStopServer();
        stop.setId(this.sessionId);
        try {
            this.aut.cancelTestExecution();
            this.aut.execute((Command)stop);
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (IOException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
    }
}

