/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.jface.text.source.inlined.LineHeaderAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class InlinedAnnotationDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    InlinedAnnotationDrawingStrategy() {
    }

    @Override
    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (!(annotation instanceof AbstractInlinedAnnotation)) {
            return;
        }
        if (!((AbstractInlinedAnnotation)annotation).isInVisibleLines()) {
            return;
        }
        InlinedAnnotationDrawingStrategy.draw((AbstractInlinedAnnotation)annotation, gc, textWidget, offset, length, color);
    }

    public static void draw(AbstractInlinedAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (annotation instanceof LineHeaderAnnotation) {
            InlinedAnnotationDrawingStrategy.draw((LineHeaderAnnotation)annotation, gc, textWidget, offset, length, color);
        } else {
            InlinedAnnotationDrawingStrategy.draw((LineContentAnnotation)annotation, gc, textWidget, offset, length, color);
        }
    }

    private static void draw(LineHeaderAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(offset);
        }
        catch (Exception exception) {
            return;
        }
        if (annotation.isMarkedDeleted() || annotation.getPosition().isDeleted()) {
            if (style != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            int x = bounds.x;
            int y = bounds.y;
            gc.setBackground(textWidget.getBackground());
            Rectangle client = textWidget.getClientArea();
            gc.fillRectangle(0, y, client.width, annotation.getHeight());
            annotation.setLocation(x, y);
            annotation.draw(gc, textWidget, offset, length, color, x, y);
            int height = annotation.getHeight();
            if (height != 0) {
                String s = textWidget.getText(offset, offset);
                Point charBounds = gc.stringExtent(s);
                int charWidth = charBounds.x;
                int charHeight = charBounds.y;
                annotation.setRedrawnCharacterWidth(charWidth);
                annotation.setRedrawnCharacterHeight(charHeight);
                StyleRange newStyle = InlinedAnnotationDrawingStrategy.updateStyle(annotation, style);
                if (newStyle != null) {
                    textWidget.setStyleRange(newStyle);
                    return;
                }
                int charX = x + bounds.width - charWidth;
                int charY = y + bounds.height - textWidget.getLineHeight();
                if (style != null) {
                    if (style.background != null) {
                        gc.setBackground(style.background);
                        gc.fillRectangle(charX, charY, charWidth + 1, bounds.height);
                    }
                    if (style.foreground != null) {
                        gc.setForeground(style.foreground);
                    } else {
                        gc.setForeground(textWidget.getForeground());
                    }
                    gc.setFont(annotation.getFont(style.fontStyle));
                }
                gc.drawString(s, charX, charY, true);
            } else if (style != null && style.metrics != null && style.metrics.ascent != 0) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
        } else if (style != null && style.metrics != null) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            Rectangle client = textWidget.getClientArea();
            textWidget.redraw(0, bounds.y, client.width, bounds.height, false);
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }

    static StyleRange updateStyle(LineHeaderAnnotation annotation, StyleRange style) {
        int width = annotation.getRedrawnCharacterWidth();
        if (width == 0) {
            return null;
        }
        int height = annotation.getHeight();
        if (height == 0) {
            return null;
        }
        int fullHeight = height + annotation.getRedrawnCharacterHeight();
        if (style == null) {
            style = new StyleRange();
            Position position = annotation.getPosition();
            style.start = position.getOffset();
            style.length = 1;
        }
        GlyphMetrics metrics = style.metrics;
        if (!annotation.isMarkedDeleted()) {
            if (metrics == null) {
                metrics = new GlyphMetrics(fullHeight, 0, width);
            } else {
                if (metrics.ascent == fullHeight) {
                    return null;
                }
                metrics = new GlyphMetrics(fullHeight, 0, width);
            }
        } else {
            metrics = null;
        }
        style.metrics = metrics;
        return style;
    }

    private static void draw(LineContentAnnotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        StyleRange style = null;
        try {
            style = textWidget.getStyleRangeAtOffset(offset);
        }
        catch (Exception exception) {
            return;
        }
        if (annotation.isMarkedDeleted() || annotation.getPosition().isDeleted()) {
            if (style != null) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
            return;
        }
        if (gc != null) {
            Rectangle bounds = textWidget.getTextBounds(offset, offset);
            int x = bounds.x;
            int y = bounds.y;
            String s = textWidget.getText(offset, offset);
            Point charBounds = gc.stringExtent(s);
            int charWidth = charBounds.x;
            int charHeight = charBounds.y;
            annotation.setLocation(x, y += bounds.height - charHeight);
            annotation.draw(gc, textWidget, offset, length, color, x, y);
            int width = annotation.getWidth();
            if (width != 0) {
                annotation.setRedrawnCharacterWidth(charWidth);
                StyleRange newStyle = InlinedAnnotationDrawingStrategy.updateStyle(annotation, style);
                if (newStyle != null) {
                    textWidget.setStyleRange(newStyle);
                    return;
                }
                if (!"\r".equals(s) && !"\n".equals(s)) {
                    int charX = x + bounds.width - charWidth;
                    int charY = y;
                    if (style != null) {
                        if (style.background != null) {
                            gc.setBackground(style.background);
                            gc.fillRectangle(charX, charY, charWidth + 1, bounds.height);
                        }
                        if (style.foreground != null) {
                            gc.setForeground(style.foreground);
                        } else {
                            gc.setForeground(textWidget.getForeground());
                        }
                        gc.setFont(annotation.getFont(style.fontStyle));
                    }
                    gc.drawString(s, charX, charY, true);
                }
            } else if (style != null && style.metrics != null && style.metrics.width != 0) {
                style.metrics = null;
                textWidget.setStyleRange(style);
            }
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }

    static StyleRange updateStyle(LineContentAnnotation annotation, StyleRange style) {
        int width = annotation.getWidth();
        if (width == 0) {
            return null;
        }
        int fullWidth = width + annotation.getRedrawnCharacterWidth();
        if (style == null) {
            style = new StyleRange();
            Position position = annotation.getPosition();
            style.start = position.getOffset();
            style.length = 1;
        }
        GlyphMetrics metrics = style.metrics;
        if (!annotation.isMarkedDeleted()) {
            if (metrics == null) {
                metrics = new GlyphMetrics(0, 0, fullWidth);
            } else {
                if (metrics.width == fullWidth) {
                    return null;
                }
                metrics = new GlyphMetrics(0, 0, fullWidth);
            }
        } else {
            metrics = null;
        }
        style.metrics = metrics;
        return style;
    }
}

