/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.plain;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.persistence.BasePersistenceModel;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.core.persistence.plain.IPlainTextPersistenceExtension;
import org.eclipse.rcptt.core.persistence.plain.PlainFormatException;
import org.eclipse.rcptt.core.persistence.plain.PlainReader;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceExtensionManager;
import org.eclipse.rcptt.core.persistence.plain.PlainWriter;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.ScenarioProperty;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;
import org.osgi.framework.Bundle;

public class PlainTextPersistenceModel
extends BasePersistenceModel
implements IPlainConstants {
    private static final String KIND_PROJECT_METADATA = "projectMetadata";
    private static final String KIND_TESTSUITE = "testsuite";
    private static final String KIND_CONTEXT = "context";
    private static final String KIND_VERIFICATION = "verification";
    private static final String KIND_TESTCASE = "testcase";
    private static final String TESTCASE_ITEMS = "testcase-items";
    private static final String ATTR_ELEMENT_TYPE = "Element-Type";
    private static final String ATTR_MANUALY_ORDERED = "Manually-Ordered";
    private static final String ATTR_CONTEXTS = "Contexts";
    private static final String ATTR_VERIFICATIONS = "Verifications";
    private static final String ATTR_IGNORED_TESTCASES = "Ignored-TestCases";
    private static final String ATTR_CONTEXT_TYPE = "Context-Type";
    private static final String ATTR_VERIFICATION_TYPE = "Verification-Type";
    private static final String ATTR_TESTCASE_TYPE = "Testcase-Type";
    private static final String ATTR_EXTERNAL_REFERENCE = "External-Reference";
    private static final String ATTR_PROPERTY_PREFIX = "Property-";
    private static final String ATTR_ELEMENT_VERSION = "Element-Version";
    private static final String ATTR_ID = "Id";
    private static final String ATTR_TAGS = "Tags";
    private static final String ATTR_ELEMENT_NAME = "Element-Name";
    private Map<String, String> masterAttributes = new HashMap<String, String>();
    private String plainStoreFormat = "--- RCPTT testcase ---";

    public PlainTextPersistenceModel(Resource element) {
        super(element);
    }

    @Override
    public boolean isSupportMultiItems() {
        return true;
    }

    @Override
    protected synchronized void doExtractAll(InputStream contents) throws IOException {
        block17: {
            try (PlainReader reader = null;){
                try {
                    reader = new PlainReader(contents);
                    Map<String, String> header = reader.readHeader();
                    if (header == null) break block17;
                    String version = header.get("Format-Version");
                    if (version != null && version.equals("1.0")) {
                        while (true) {
                            PlainReader.Entry entry;
                            if ((entry = reader.readEntry()) == null) {
                                break block17;
                            }
                            File file = (File)this.files.get(entry.name);
                            if (file == null || file.exists()) continue;
                            OutputStream outputStream = this.internalStore(entry.name);
                            try {
                                byte[] data = null;
                                if (entry.getContent() instanceof String) {
                                    data = ((String)entry.getContent()).getBytes("utf-8");
                                } else if (entry.getContent() instanceof byte[]) {
                                    data = (byte[])entry.getContent();
                                }
                                if (data != null) {
                                    FileUtil.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)outputStream);
                                    continue;
                                }
                                throw new IOException("Wrong Plain file format");
                            }
                            finally {
                                outputStream.close();
                                continue;
                            }
                            break;
                        }
                    }
                    throw new Exception("Q7 plain format version is unsupported.");
                }
                catch (Exception e) {
                    RcpttPlugin.log(e);
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
        }
    }

    @Override
    protected void doExtractFile(String fName, InputStream contents) throws IOException {
        block18: {
            try (PlainReader reader = null;){
                try {
                    reader = new PlainReader(contents);
                    Map<String, String> header = reader.readHeader();
                    if (header == null) break block18;
                    String version = header.get("Format-Version");
                    if (version != null && version.equals("1.0")) {
                        while (true) {
                            PlainReader.Entry entry;
                            if ((entry = reader.readEntry()) == null) {
                                break block18;
                            }
                            if (!fName.equals(entry.name)) continue;
                            OutputStream outputStream = this.internalStore(fName);
                            byte[] data = null;
                            if (entry.getContent() instanceof String) {
                                data = ((String)entry.getContent()).getBytes("utf-8");
                            } else if (entry.getContent() instanceof byte[]) {
                                data = (byte[])entry.getContent();
                            }
                            if (data == null) {
                                outputStream.close();
                                this.delete(fName);
                                throw new IOException("Wrong Plain file format");
                            }
                            FileUtil.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)outputStream);
                            outputStream.close();
                        }
                    }
                    throw new Exception("Q7 plain format version is unsupported.");
                }
                catch (PlainFormatException e) {
                    IFile file;
                    IFile iFile = file = this.element != null ? Q7Utils.getLocation(this.element) : null;
                    if (file != null) {
                        e.setFileName(file.getLocation().toString());
                    }
                    RcpttPlugin.log(e);
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    RcpttPlugin.log(e);
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
        }
    }

    @Override
    protected synchronized void doReadIndex(InputStream contents) {
        block10: {
            try (PlainReader reader = null;){
                try {
                    reader = new PlainReader(contents);
                    Map<String, String> header = reader.readHeader();
                    if (header == null) break block10;
                    String version = header.get("Format-Version");
                    if (version != null && version.equals("1.0")) {
                        while (true) {
                            PlainReader.Entry entry;
                            if ((entry = reader.readEntry()) == null) {
                                break block10;
                            }
                            IPath filePath = this.rootPath.append((IPath)new Path(entry.name));
                            this.putFileItem(entry.name, filePath);
                        }
                    }
                    throw new Exception("Q7 plain format version is unsupported.");
                }
                catch (Exception e) {
                    RcpttPlugin.log(e);
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
        }
    }

    @Override
    protected synchronized void doStoreTo(File file) throws FileNotFoundException, IOException {
        try (PlainWriter writer = null;){
            writer = new PlainWriter(new BufferedOutputStream(new FileOutputStream(file)), this.plainStoreFormat);
            HashMap<String, String> saveAttrs = new HashMap<String, String>();
            if (this.masterAttributes != null) {
                saveAttrs.putAll(this.masterAttributes);
            }
            saveAttrs.put("Save-Time", DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date(System.currentTimeMillis())));
            Bundle runtimeBundle = Platform.getBundle((String)"org.eclipse.rcptt.updates.runtime");
            if (runtimeBundle != null) {
                saveAttrs.put("Runtime-Version", runtimeBundle.getVersion().toString());
            }
            writer.writeHeader(saveAttrs);
            ArrayList<String> ordered = new ArrayList<String>();
            HashSet unordered = new HashSet(this.files.keySet());
            if (unordered.contains(".description")) {
                ordered.add(".description");
                unordered.remove(".description");
            }
            if (unordered.contains(".content")) {
                ordered.add(".content");
                unordered.remove(".content");
            }
            ordered.addAll(unordered);
            for (String fName : ordered) {
                File value = (File)this.files.get(fName);
                if (!value.exists()) continue;
                BufferedInputStream in = this.getInput(value);
                try {
                    byte[] content;
                    IPlainTextPersistenceExtension[] extensions;
                    HashMap<String, String> attrs = new HashMap<String, String>();
                    String storeAsText = null;
                    IPlainTextPersistenceExtension[] iPlainTextPersistenceExtensionArray = extensions = PlainTextPersistenceExtensionManager.getInstance().getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPlainTextPersistenceExtension ext = iPlainTextPersistenceExtensionArray[n2];
                        storeAsText = ext.getTextContentType(fName);
                        if (storeAsText != null) break;
                        ++n2;
                    }
                    if (storeAsText != null) {
                        attrs.put("Content-Type", storeAsText);
                        content = FileUtil.getStreamContent((InputStream)in);
                        writer.writeNode(fName, attrs, new String(content, "utf-8"));
                        continue;
                    }
                    if (fName.equals(".content")) {
                        attrs.put("Content-Type", "text/ecl");
                        content = FileUtil.getStreamContent((InputStream)in);
                        writer.writeNode(fName, attrs, new String(content, "utf-8"));
                        continue;
                    }
                    if (fName.equals(".description")) {
                        attrs.put("Content-Type", "text/plain");
                        content = FileUtil.getStreamContent((InputStream)in);
                        writer.writeNode(fName, attrs, new String(content, "utf-8"));
                        continue;
                    }
                    if (fName.equals(TESTCASE_ITEMS)) {
                        attrs.put("Content-Type", "text/testcase");
                        content = FileUtil.getStreamContent((InputStream)in);
                        writer.writeNode(fName, attrs, new String(content, "utf-8"));
                        continue;
                    }
                    content = FileUtil.getStreamContent((InputStream)in);
                    writer.writeNode(fName, attrs, content);
                }
                finally {
                    FileUtil.safeClose((Closeable)in);
                }
            }
        }
    }

    @Override
    public boolean isContentEntryRequired() {
        IPlainTextPersistenceExtension[] extensions;
        EList contents = this.element.getContents();
        boolean optional = false;
        IPlainTextPersistenceExtension[] iPlainTextPersistenceExtensionArray = extensions = PlainTextPersistenceExtensionManager.getInstance().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPlainTextPersistenceExtension ext = iPlainTextPersistenceExtensionArray[n2];
            if (ext.isContentEntryOptional((EList<EObject>)contents)) {
                optional = true;
                break;
            }
            ++n2;
        }
        return contents.size() != 1 || !(contents.get(0) instanceof Scenario) && !(contents.get(0) instanceof TestSuite) && !(contents.get(0) instanceof ProjectMetadata) && !optional;
    }

    @Override
    public boolean isAllowEmptyMetadataContent() {
        return true;
    }

    @Override
    public void updateAttributes() {
        this.masterAttributes.clear();
        if (this.element == null) {
            return;
        }
        EList contents = this.element.getContents();
        for (EObject eObject : contents) {
            IPlainTextPersistenceExtension[] extensions;
            if (eObject instanceof NamedElement) {
                this.updateGeneralAttributes(eObject);
            }
            if (eObject instanceof Scenario) {
                this.updateScenarioAttributes(eObject);
            }
            if (eObject instanceof Context) {
                this.updateContextAttributes(eObject);
            }
            if (eObject instanceof Verification) {
                this.updateVerificationAttributes(eObject);
            }
            if (eObject instanceof TestSuite) {
                this.updateTestSuiteAttributes(eObject);
            }
            if (eObject instanceof ProjectMetadata) {
                this.updateProjectMetadataAttributes(eObject);
            }
            IPlainTextPersistenceExtension[] iPlainTextPersistenceExtensionArray = extensions = PlainTextPersistenceExtensionManager.getInstance().getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPlainTextPersistenceExtension ext = iPlainTextPersistenceExtensionArray[n2];
                ext.updateAttributes(this, this.masterAttributes, eObject);
                ++n2;
            }
        }
    }

    private void updateGeneralAttributes(EObject eObject) {
        NamedElement el = (NamedElement)eObject;
        this.masterAttributes.put(ATTR_ELEMENT_NAME, el.getName());
        if (el.getTags() != null && el.getTags().length() > 0) {
            this.masterAttributes.put(ATTR_TAGS, el.getTags());
        }
        this.masterAttributes.put(ATTR_ID, el.getId());
        this.masterAttributes.put(ATTR_ELEMENT_VERSION, el.getVersion());
    }

    private void updateTestSuiteAttributes(EObject eObject) {
        block11: {
            TestSuite suite = (TestSuite)eObject;
            this.masterAttributes.put(ATTR_ELEMENT_TYPE, KIND_TESTSUITE);
            if (suite.isManuallyOrdered()) {
                this.masterAttributes.put(ATTR_MANUALY_ORDERED, String.valueOf(suite.isManuallyOrdered()));
            }
            EList items = suite.getItems();
            this.delete(TESTCASE_ITEMS);
            if (items.size() > 0) {
                OutputStreamWriter stream = null;
                try {
                    try {
                        stream = new OutputStreamWriter(this.store(TESTCASE_ITEMS));
                        for (TestSuiteItem testSuiteItem : items) {
                            stream.append(testSuiteItem.getNamedElementId());
                            stream.append("\t//");
                            if (testSuiteItem.getKind() != null) {
                                stream.append(" kind: '").append(testSuiteItem.getKind()).append("'");
                            }
                            if (testSuiteItem.getNamedElemetName() != null) {
                                stream.append(" name: '").append(testSuiteItem.getNamedElemetName()).append("'");
                            }
                            if (testSuiteItem.getPath() != null) {
                                stream.append(" path: '").append(testSuiteItem.getPath()).append("'");
                            }
                            stream.append("\n");
                        }
                    }
                    catch (IOException e) {
                        RcpttPlugin.log(e);
                        FileUtil.safeClose(stream);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.safeClose(stream);
                    throw throwable;
                }
                FileUtil.safeClose((Closeable)stream);
            }
        }
    }

    private void updateProjectMetadataAttributes(EObject eObject) {
        ProjectMetadata md = (ProjectMetadata)eObject;
        this.masterAttributes.put(ATTR_ELEMENT_TYPE, KIND_PROJECT_METADATA);
        if (md.getContexts().size() > 0) {
            this.masterAttributes.put(ATTR_CONTEXTS, this.namesToString((List<String>)md.getContexts()));
        }
        if (md.getVerifications().size() > 0) {
            this.masterAttributes.put(ATTR_VERIFICATIONS, this.namesToString((List<String>)md.getVerifications()));
        }
        if (md.getIgnores().size() > 0) {
            this.masterAttributes.put(ATTR_IGNORED_TESTCASES, this.namesToString((List<String>)md.getIgnores()));
        }
    }

    private void updateContextAttributes(EObject eObject) {
        Context ctx = (Context)eObject;
        this.masterAttributes.put(ATTR_ELEMENT_TYPE, KIND_CONTEXT);
        this.masterAttributes.put(ATTR_CONTEXT_TYPE, ContextTypeManager.getInstance().getTypeByContext(ctx).getId());
    }

    private void updateVerificationAttributes(EObject eObject) {
        Verification verification = (Verification)eObject;
        this.masterAttributes.put(ATTR_ELEMENT_TYPE, KIND_VERIFICATION);
        this.masterAttributes.put(ATTR_VERIFICATION_TYPE, VerificationTypeManager.getInstance().getTypeByVerification(verification).getId());
    }

    private void updateScenarioAttributes(EObject eObject) {
        Scenario sc = (Scenario)eObject;
        this.masterAttributes.put(ATTR_ELEMENT_TYPE, KIND_TESTCASE);
        this.masterAttributes.put(ATTR_EXTERNAL_REFERENCE, sc.getExternalReference());
        EList properties = sc.getProperties();
        for (ScenarioProperty p : properties) {
            this.masterAttributes.put(ATTR_PROPERTY_PREFIX + p.getName(), p.getValue());
        }
        this.masterAttributes.put(ATTR_TESTCASE_TYPE, sc.getType());
        if (sc.getContexts().size() > 0) {
            this.masterAttributes.put(ATTR_CONTEXTS, this.namesToString((List<String>)sc.getContexts()));
        }
        if (sc.getVerifications().size() > 0) {
            this.masterAttributes.put(ATTR_VERIFICATIONS, this.namesToString((List<String>)sc.getVerifications()));
        }
    }

    private String namesToString(List<String> names) {
        StringBuilder bd = new StringBuilder();
        int i = 0;
        while (i < names.size()) {
            bd.append(names.get(i));
            if (i != names.size() - 1) {
                bd.append(",");
            }
            ++i;
        }
        return bd.toString();
    }

    @Override
    public void updateMetadata() {
        InputStream contents;
        block35: {
            IFile file;
            if (this.element != null && (file = Q7Utils.getLocation(this.element)) != null && !file.exists()) {
                return;
            }
            contents = this.getContentsStream();
            if (contents == null) {
                return;
            }
            try {
                PlainReader reader;
                block34: {
                    reader = null;
                    try {
                        try {
                            reader = new PlainReader(contents);
                            Map<String, String> header = reader.readHeader();
                            if (header == null) break block34;
                            String version = header.get("Format-Version");
                            if (version != null && version.equals("1.0")) {
                                EList eList = this.element.getContents();
                                if (eList.size() == 0) {
                                    TestSuite suite;
                                    Object type;
                                    String elementType = header.get(ATTR_ELEMENT_TYPE);
                                    if (KIND_TESTCASE.equals(elementType)) {
                                        Scenario scenario = ScenarioFactory.eINSTANCE.createScenario();
                                        eList.add((Object)scenario);
                                    } else if (KIND_CONTEXT.equals(elementType)) {
                                        String contextType = header.get(ATTR_CONTEXT_TYPE);
                                        type = ContextTypeManager.getInstance().getTypeById(contextType);
                                        if (type != null) {
                                            Context context = ((ContextType)type).create(this.element, "");
                                            eList.add((Object)context);
                                        }
                                    } else if (KIND_VERIFICATION.equals(elementType)) {
                                        String verificationType = header.get(ATTR_VERIFICATION_TYPE);
                                        type = VerificationTypeManager.getInstance().getTypeById(verificationType);
                                        if (type != null) {
                                            Verification verification = type.create(this.element, "");
                                            eList.add((Object)verification);
                                        }
                                    } else if (KIND_TESTSUITE.equals(elementType)) {
                                        suite = ScenarioFactory.eINSTANCE.createTestSuite();
                                        eList.add((Object)suite);
                                    } else if (KIND_PROJECT_METADATA.equals(elementType)) {
                                        suite = ScenarioFactory.eINSTANCE.createProjectMetadata();
                                        eList.add((Object)suite);
                                    }
                                }
                                for (EObject eObject : eList) {
                                    IPlainTextPersistenceExtension[] extensions;
                                    if (eObject instanceof NamedElement) {
                                        this.processGeneralNamedElementAttrs(header, eObject);
                                    }
                                    if (eObject instanceof ProjectMetadata) {
                                        this.processProjectMetadataAttrs(header, eObject);
                                    }
                                    if (eObject instanceof Scenario) {
                                        this.processScenarioAttrs(header, eObject);
                                    }
                                    if (eObject instanceof TestSuite) {
                                        this.processTestSuiteAttrs(header, eObject);
                                    }
                                    IPlainTextPersistenceExtension[] iPlainTextPersistenceExtensionArray = extensions = PlainTextPersistenceExtensionManager.getInstance().getExtensions();
                                    int n = extensions.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IPlainTextPersistenceExtension ext = iPlainTextPersistenceExtensionArray[n2];
                                        ext.updateMetadata(this, header, eObject);
                                        ++n2;
                                    }
                                }
                                break block34;
                            }
                            throw new Exception("Q7 plain format version is unsupported.");
                        }
                        catch (Exception e) {
                            RcpttPlugin.log(e);
                            if (reader != null) {
                                reader.close();
                            }
                            break block35;
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable throwable) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            contents.close();
        }
        catch (IOException iOException) {}
        this.element.setModified(false);
    }

    private void processTestSuiteAttrs(Map<String, String> header, EObject eObject) throws IOException {
        TestSuite sc = (TestSuite)eObject;
        InputStream items = this.read(TESTCASE_ITEMS);
        sc.setManuallyOrdered(header.containsKey(ATTR_MANUALY_ORDERED) && header.get(ATTR_MANUALY_ORDERED).equalsIgnoreCase("true"));
        if (items != null) {
            try {
                String line;
                BufferedReader stream = new BufferedReader(new InputStreamReader(items));
                while ((line = stream.readLine()) != null) {
                    int pos;
                    if (line.trim().length() <= 0 || (pos = line.indexOf("\t//")) == -1) continue;
                    String id = line.substring(0, pos);
                    TestSuiteItem item = ScenarioFactory.eINSTANCE.createTestSuiteItem();
                    item.setNamedElementId(id);
                    sc.getItems().add((Object)item);
                }
            }
            finally {
                items.close();
            }
        }
    }

    private void processScenarioAttrs(Map<String, String> header, EObject eObject) {
        Scenario sc = (Scenario)eObject;
        if (header.containsKey(ATTR_EXTERNAL_REFERENCE)) {
            sc.setExternalReference(header.get(ATTR_EXTERNAL_REFERENCE));
        }
        if (header.containsKey(ATTR_TESTCASE_TYPE)) {
            sc.setType(header.get(ATTR_TESTCASE_TYPE));
        }
        for (Map.Entry<String, String> e : header.entrySet()) {
            if (!e.getKey().startsWith(ATTR_PROPERTY_PREFIX)) continue;
            EList properties = sc.getProperties();
            ScenarioProperty prop = ScenarioFactory.eINSTANCE.createScenarioProperty();
            prop.setName(e.getKey().substring(ATTR_PROPERTY_PREFIX.length()));
            prop.setValue(e.getValue());
            properties.add((Object)prop);
        }
        if (header.containsKey(ATTR_CONTEXTS)) {
            String contexts = header.get(ATTR_CONTEXTS);
            sc.getContexts().clear();
            sc.getContexts().addAll(Arrays.asList(contexts.split(",")));
        }
        if (header.containsKey(ATTR_VERIFICATIONS)) {
            String verifications = header.get(ATTR_VERIFICATIONS);
            sc.getVerifications().clear();
            sc.getVerifications().addAll(Arrays.asList(verifications.split(",")));
        }
    }

    private void processProjectMetadataAttrs(Map<String, String> header, EObject eObject) throws IOException {
        ProjectMetadata md = (ProjectMetadata)eObject;
        if (header.containsKey(ATTR_CONTEXTS)) {
            String contexts = header.get(ATTR_CONTEXTS);
            md.getContexts().clear();
            md.getContexts().addAll(Arrays.asList(contexts.split(",")));
        }
        if (header.containsKey(ATTR_VERIFICATIONS)) {
            String verifications = header.get(ATTR_VERIFICATIONS);
            md.getVerifications().clear();
            md.getVerifications().addAll(Arrays.asList(verifications.split(",")));
        }
        if (header.containsKey(ATTR_IGNORED_TESTCASES)) {
            String ignores = header.get(ATTR_IGNORED_TESTCASES);
            md.getIgnores().clear();
            md.getIgnores().addAll(Arrays.asList(ignores.split(",")));
        }
    }

    private void processGeneralNamedElementAttrs(Map<String, String> header, EObject eObject) {
        NamedElement e = (NamedElement)eObject;
        if (header.containsKey(ATTR_ID)) {
            e.setId(header.get(ATTR_ID));
        }
        if (header.containsKey(ATTR_ELEMENT_NAME)) {
            e.setName(header.get(ATTR_ELEMENT_NAME));
        }
        if (header.containsKey(ATTR_TAGS)) {
            e.setTags(header.get(ATTR_TAGS));
        }
        if (header.containsKey(ATTR_ELEMENT_VERSION)) {
            e.setVersion(header.get(ATTR_ELEMENT_VERSION));
        }
    }

    public void setSaveFormat(String plainStoreFormat) {
        this.plainStoreFormat = plainStoreFormat;
    }
}

