/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkFixed;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    public long embeddedHandle;
    long imHandle;
    long socketHandle;
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    long fixClipHandle;
    long[] fixClipHandleChildren = new long[0];
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, Composite.checkStyle(style));
    }

    static int checkStyle(int style) {
        style &= 0xFFFBFFFF;
        return style &= 0xBFFFFFFF;
    }

    Control[] _getChildren() {
        long parentHandle = this.parentingHandle();
        long list = GTK.gtk_container_get_children(parentHandle);
        if (list == 0L) {
            return new Control[0];
        }
        int count = OS.g_list_length(list);
        Control[] children = new Control[count];
        int i = 0;
        long temp = list;
        while (temp != 0L) {
            Widget widget;
            long handle = OS.g_list_data(temp);
            if (handle != 0L && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
                children[i++] = (Control)widget;
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (i == count) {
            return children;
        }
        Control[] newChildren = new Control[i];
        System.arraycopy(children, 0, newChildren, 0, i);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    @Deprecated
    public void changed(Control[] changed) {
        this.layout(changed, 4);
    }

    @Override
    void checkBuffered() {
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            return;
        }
        super.checkBuffered();
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    long childStyle() {
        if (this.scrolledHandle != 0L) {
            return 0L;
        }
        return super.childStyle();
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        this.display.runSkin();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = DPIUtil.autoScaleUp(this.layout.computeSize(this, DPIUtil.autoScaleDown(wHint), DPIUtil.autoScaleDown(hHint), changed |= (this.state & 0x40000) != 0));
                this.state &= 0xFFFBFFFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
            if (size.x == 0) {
                size.x = 64;
            }
            if (size.y == 0) {
                size.y = 64;
            }
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = DPIUtil.autoScaleUp(this.computeTrim(0, 0, DPIUtil.autoScaleDown(size.x), DPIUtil.autoScaleDown(size.y)));
        return new Point(trim.width, trim.height);
    }

    @Override
    Widget[] computeTabList() {
        Widget[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length != 0) {
                Widget[] newResult = new Widget[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    @Override
    void createHandle(int index) {
        boolean scrolled;
        this.state |= 0x200000A;
        boolean bl = scrolled = (this.style & 0x300) != 0;
        if (!scrolled) {
            this.state |= 0x10000;
        }
        this.createHandle(index, true, scrolled || (this.style & 0x800) != 0);
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0x300) == 0 ? 1 : 0;
    }

    void createHandle(int index, boolean fixed, boolean scrolled) {
        if (scrolled) {
            long hadj;
            long vadj;
            if (fixed) {
                this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
                if (this.fixedHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_widget_set_has_window(this.fixedHandle, true);
            }
            if ((vadj = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
                this.error(2);
            }
            if ((hadj = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
                this.error(2);
            }
            this.scrolledHandle = GTK.gtk_scrolled_window_new(hadj, vadj);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
        }
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.handle, true);
        GTK.gtk_widget_set_can_focus(this.handle, true);
        if ((this.style & 0x1000000) == 0 && (this.state & 2) != 0 && this.display.getData(NO_INPUT_METHOD) == null) {
            this.imHandle = GTK.gtk_im_multicontext_new();
            if (this.imHandle == 0L) {
                this.error(2);
            }
        }
        if (scrolled) {
            if (fixed) {
                GTK.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            }
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            GTK.gtk_container_add(this.scrolledHandle, this.handle);
            this.display.setWarnings(warnings);
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
            if (this.hasBorder()) {
                GTK.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x1000000) != 0) {
            if (!OS.isX11()) {
                if (Device.DEBUG) {
                    new SWTError(5, "SWT.EMBEDDED is currently not yet supported in Wayland. \nPlease refer to https://bugs.eclipse.org/bugs/show_bug.cgi?id=514487 for development status.").printStackTrace();
                }
            } else {
                this.socketHandle = GTK.gtk_socket_new();
                if (this.socketHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_container_add(this.handle, this.socketHandle);
            }
        }
        if ((this.style & 0x100000) != 0 && (this.style & 0x4000000) == 0) {
            GTK.gtk_widget_set_redraw_on_allocate(this.handle, false);
        }
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            GTK.gtk_widget_set_double_buffered(this.handle, false);
        }
    }

    void fixChildClippings() {
        if (this.fixClipHandleChildren == null) {
            return;
        }
        GtkRequisition minimumSize = new GtkRequisition();
        GtkRequisition naturalSize = new GtkRequisition();
        GtkAllocation clip = new GtkAllocation();
        GtkAllocation allocation = new GtkAllocation();
        long[] lArray = this.fixClipHandleChildren;
        int n = this.fixClipHandleChildren.length;
        int n2 = 0;
        while (n2 < n) {
            long widget = lArray[n2];
            GTK.gtk_widget_get_allocation(widget, allocation);
            GTK.gtk_widget_get_clip(widget, clip);
            if (clip.x < 0) {
                clip.width += clip.x;
                clip.x = 0;
                if (allocation.x < -1 && (allocation.width > 1 || allocation.height > 1)) {
                    allocation.width += allocation.x;
                    allocation.x = 0;
                    GTK.gtk_widget_get_preferred_size(widget, minimumSize, naturalSize);
                    GTK.gtk_widget_size_allocate(widget, allocation);
                    GTK.gtk_widget_queue_resize(widget);
                }
            }
            GTK.gtk_widget_set_clip(widget, allocation);
            ++n2;
        }
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            long context = GTK.gtk_widget_get_style_context(widget);
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(widget, allocation);
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            GTK.gtk_render_background(context, cairo, 0.0, 0.0, width, height);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) && widget == this.fixClipHandle) {
                this.fixChildClippings();
            }
        }
        return super.gtk_draw(widget, cairo);
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.socketHandle != 0L) {
            this.display.removeWidget(this.socketHandle);
        }
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        this.checkWidget();
        Rectangle rect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        offsetX = DPIUtil.autoScaleUp(offsetX);
        offsetY = DPIUtil.autoScaleUp(offsetY);
        this.drawBackgroundInPixels(gc, rect.x, rect.y, rect.width, rect.height, offsetX, offsetY);
    }

    void drawBackgroundInPixels(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            GCData data = gc.getGCData();
            long cairo = data.cairo;
            Cairo.cairo_save(cairo);
            if (control.backgroundImage != null) {
                long pattern;
                Point pt = this.display.mapInPixels(this, control, 0, 0);
                Cairo.cairo_translate(cairo, -pt.x - offsetX, -pt.y - offsetY);
                x += pt.x + offsetX;
                y += pt.y + offsetY;
                long surface = control.backgroundImage.surface;
                if (surface == 0L) {
                    long drawable = control.backgroundImage.pixmap;
                    int[] w = new int[1];
                    int[] h = new int[1];
                    GDK.gdk_pixmap_get_size(drawable, w, h);
                    if (OS.isX11()) {
                        long xDisplay = GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default());
                        long xVisual = GDK.gdk_x11_visual_get_xvisual(GDK.gdk_visual_get_system());
                        long xDrawable = GDK.GDK_PIXMAP_XID(drawable);
                        surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, w[0], h[0]);
                    } else {
                        surface = Cairo.cairo_image_surface_create(0, w[0], h[0]);
                    }
                    if (surface == 0L) {
                        this.error(2);
                    }
                } else {
                    Cairo.cairo_surface_reference(surface);
                }
                if ((pattern = Cairo.cairo_pattern_create_for_surface(surface)) == 0L) {
                    this.error(2);
                }
                Cairo.cairo_pattern_set_extend(pattern, 1);
                if ((data.style & 0x8000000) != 0) {
                    double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(pattern, matrix);
                }
                Cairo.cairo_set_source(cairo, pattern);
                Cairo.cairo_surface_destroy(surface);
                Cairo.cairo_pattern_destroy(pattern);
            } else if (GTK.GTK3) {
                GdkRGBA rgba = control.getBackgroundGdkRGBA();
                Cairo.cairo_set_source_rgba(cairo, rgba.red, rgba.green, rgba.blue, rgba.alpha);
            } else {
                GdkColor color = control.getBackgroundGdkColor();
                Cairo.cairo_set_source_rgba_compatibility(cairo, color);
            }
            Cairo.cairo_rectangle(cairo, x, y, width, height);
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
        } else {
            gc.fillRectangle(DPIUtil.autoScaleDown(new Rectangle(x, y, width, height)));
        }
    }

    @Override
    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.enableWidget(enabled);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    @Override
    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    @Override
    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            ++i;
        }
    }

    @Override
    void fixParentGdkWindow() {
        assert (GTK.GTK3);
        Control[] controlArray = this._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.fixParentGdkWindow();
            ++n2;
        }
    }

    @Override
    void fixModal(long group, long modalGroup) {
        Control[] controls = this._getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].fixModal(group, modalGroup);
            ++i;
        }
    }

    @Override
    void fixStyle() {
        super.fixStyle();
        if (this.scrolledHandle == 0L) {
            this.fixStyle(this.handle);
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].fixStyle();
            ++i;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    void fixZOrder() {
        if ((this.state & 2) != 0) {
            return;
        }
        long parentHandle = this.parentingHandle();
        long parentWindow = this.gtk_widget_get_window(parentHandle);
        if (parentWindow == 0L) {
            return;
        }
        long[] userData = new long[1];
        long windowList = GDK.gdk_window_get_children(parentWindow);
        if (windowList != 0L) {
            long windows = windowList;
            while (windows != 0L) {
                long window = OS.g_list_data(windows);
                if (window != this.redrawWindow) {
                    GDK.gdk_window_get_user_data(window, userData);
                    if (userData[0] == 0L || OS.G_OBJECT_TYPE(userData[0]) != this.display.gtk_fixed_get_type()) {
                        GDK.gdk_window_lower(window);
                    }
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(windowList);
        }
    }

    @Override
    long focusHandle() {
        if (this.socketHandle != 0L) {
            return this.socketHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean forceFocus(long focusHandle) {
        if (this.socketHandle != 0L) {
            GTK.gtk_widget_set_can_focus(focusHandle, true);
        }
        boolean result = super.forceFocus(focusHandle);
        if (this.socketHandle != 0L) {
            GTK.gtk_widget_set_can_focus(focusHandle, false);
        }
        return result;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        long list = GTK.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        int count = OS.g_list_length(list);
        OS.g_list_free(list);
        return count;
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        if ((this.state & 2) != 0) {
            if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            this.forceResize();
            long clientHandle = this.clientHandle();
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(clientHandle, allocation);
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            return new Rectangle(0, 0, width, height);
        }
        return super.getClientAreaInPixels();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
            if (gdkEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
        }
        return result;
    }

    @Override
    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if ((this.state & 2) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if ((this.style & 0x200000) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
        long[] rectangles = new long[1];
        int[] n_rectangles = new int[1];
        GDK.gdk_region_get_rectangles(gdkEvent.region, rectangles, n_rectangles);
        GdkRectangle rect = new GdkRectangle();
        int i = 0;
        while (i < n_rectangles[0]) {
            Event event = new Event();
            OS.memmove(rect, rectangles[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            event.setBounds(DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height)));
            if ((this.style & 0x8000000) != 0) {
                event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.width - event.x;
            }
            long damageRgn = GDK.gdk_region_new();
            GDK.gdk_region_union_with_rect(damageRgn, rect);
            GCData data = new GCData();
            data.damageRgn = damageRgn;
            GC gc = event.gc = GC.gtk_new(this, data);
            this.sendEvent(9, event);
            gc.dispose();
            GDK.gdk_region_destroy(damageRgn);
            event.gc = null;
            ++i;
        }
        OS.g_free(rectangles[0]);
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.state & 2) != 0 && this.socketHandle == 0L) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    return 1L;
                }
            }
        }
        return result;
    }

    @Override
    long gtk_focus(long widget, long directionType) {
        if (widget == this.socketHandle) {
            return 0L;
        }
        return super.gtk_focus(widget, directionType);
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        return (this.state & 2) != 0 ? 1L : result;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        return (this.state & 2) != 0 ? 1L : result;
    }

    @Override
    long gtk_map(long widget) {
        this.fixZOrder();
        return 0L;
    }

    @Override
    long gtk_realize(long widget) {
        long window;
        long result = super.gtk_realize(widget);
        if ((this.style & 0x40000) != 0 && (window = this.gtk_widget_get_window(this.paintHandle())) != 0L) {
            if (GTK.GTK3) {
                GDK.gdk_window_set_background_pattern(window, 0L);
            } else {
                GDK.gdk_window_set_back_pixmap(window, 0L, false);
            }
        }
        if (this.socketHandle != 0L) {
            this.embeddedHandle = GTK.gtk_socket_get_id(this.socketHandle);
        }
        return result;
    }

    @Override
    long gtk_scroll_child(long widget, long scrollType, long horizontal) {
        OS.g_signal_stop_emission_by_name(widget, OS.scroll_child);
        return 1L;
    }

    @Override
    long gtk_style_set(long widget, long previousStyle) {
        long window;
        long result = super.gtk_style_set(widget, previousStyle);
        if ((this.style & 0x40000) != 0 && (window = this.gtk_widget_get_window(this.paintHandle())) != 0L) {
            GDK.gdk_window_set_back_pixmap(window, 0L, false);
        }
        return result;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            GTK.gtk_widget_add_events(this.handle, 8);
            if (this.scrolledHandle != 0L) {
                OS.g_signal_connect_closure(this.scrolledHandle, OS.scroll_child, this.display.getClosure(42), false);
            }
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    @Override
    long imHandle() {
        return this.imHandle;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    @Override
    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i = 0;
            while (i < changed.length) {
                Control control = changed[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control.parent;
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite.parent;
                }
                if (!ancestor) {
                    this.error(32);
                }
                ++i;
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            int i2 = 0;
            while (i2 < changed.length) {
                Control child = changed[i2];
                Composite composite = child.parent;
                child.markLayout(false, false);
                while (child != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x20000;
                        if (!composite.layout.flushCache(child)) {
                            composite.state |= 0x40000;
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child.parent;
                }
                ++i2;
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            i2 = updateCount - 1;
            while (i2 >= 0) {
                update[i2].updateLayout(false);
                --i2;
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    @Override
    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x20000;
            if (changed) {
                this.state |= 0x40000;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    void moveAbove(long child, long sibling) {
        if (child == sibling) {
            return;
        }
        long parentHandle = this.parentingHandle();
        if (GTK.GTK3) {
            OS.swt_fixed_restack(parentHandle, child, sibling, true);
            return;
        }
        GtkFixed fixed = new GtkFixed();
        OS.memmove(fixed, parentHandle);
        long children = fixed.children;
        if (children == 0L) {
            return;
        }
        long[] data = new long[1];
        long[] widget = new long[1];
        long childData = 0L;
        long childLink = 0L;
        long siblingLink = 0L;
        long temp = children;
        while (temp != 0L) {
            C.memmove(data, temp, (long)C.PTR_SIZEOF);
            C.memmove(widget, data[0], (long)C.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0L && (sibling == 0L || siblingLink != 0L)) break;
            temp = OS.g_list_next(temp);
        }
        children = OS.g_list_remove_link(children, childLink);
        if (siblingLink == 0L || OS.g_list_previous(siblingLink) == 0L) {
            OS.g_list_free_1(childLink);
            children = OS.g_list_prepend(children, childData);
        } else {
            temp = OS.g_list_previous(siblingLink);
            OS.g_list_set_previous(childLink, temp);
            OS.g_list_set_next(temp, childLink);
            OS.g_list_set_next(childLink, siblingLink);
            OS.g_list_set_previous(siblingLink, childLink);
        }
        fixed.children = children;
        OS.memmove(parentHandle, fixed);
    }

    void moveBelow(long child, long sibling) {
        if (child == sibling) {
            return;
        }
        long parentHandle = this.parentingHandle();
        if (sibling == 0L && parentHandle == this.fixedHandle) {
            this.moveAbove(child, this.scrolledHandle != 0L ? this.scrolledHandle : this.handle);
            return;
        }
        if (GTK.GTK3) {
            OS.swt_fixed_restack(parentHandle, child, sibling, false);
            return;
        }
        GtkFixed fixed = new GtkFixed();
        OS.memmove(fixed, parentHandle);
        long children = fixed.children;
        if (children == 0L) {
            return;
        }
        long[] data = new long[1];
        long[] widget = new long[1];
        long childData = 0L;
        long childLink = 0L;
        long siblingLink = 0L;
        long temp = children;
        while (temp != 0L) {
            C.memmove(data, temp, (long)C.PTR_SIZEOF);
            C.memmove(widget, data[0], (long)C.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0L && (sibling == 0L || siblingLink != 0L)) break;
            temp = OS.g_list_next(temp);
        }
        children = OS.g_list_remove_link(children, childLink);
        if (siblingLink == 0L || OS.g_list_next(siblingLink) == 0L) {
            OS.g_list_free_1(childLink);
            children = OS.g_list_append(children, childData);
        } else {
            temp = OS.g_list_next(siblingLink);
            OS.g_list_set_next(childLink, temp);
            OS.g_list_set_previous(temp, childLink);
            OS.g_list_set_previous(childLink, siblingLink);
            OS.g_list_set_next(siblingLink, childLink);
        }
        fixed.children = children;
        OS.memmove(parentHandle, fixed);
    }

    @Override
    void moveChildren(int oldWidth) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            int controlWidth;
            Control child = children[i];
            long topHandle = child.topHandle();
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(topHandle, allocation);
            int x = allocation.x;
            int y = allocation.y;
            int n = controlWidth = (child.state & 0x200) != 0 ? 0 : allocation.width;
            if (oldWidth > 0) {
                x = oldWidth - controlWidth - x;
            }
            int clientWidth = this.getClientWidth();
            x = clientWidth - controlWidth - x;
            if (child.enableWindow != 0L) {
                GDK.gdk_window_move(child.enableWindow, x, y);
            }
            child.moveHandle(x, y);
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(topHandle, requisition);
            allocation.x = x;
            allocation.y = y;
            GTK.gtk_widget_size_allocate(topHandle, allocation);
            Control control = child.findBackgroundControl();
            if (control != null && control.backgroundImage != null && child.isVisible()) {
                child.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            ++i;
        }
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this._getChildren();
        Rectangle clientArea = DPIUtil.autoScaleUp(this.getClientArea());
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = DPIUtil.autoScaleUp(children[i].getBounds());
            width = Math.max(width, rect.x - clientArea.x + rect.width);
            height = Math.max(height, rect.y - clientArea.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    long parentingHandle() {
        if ((this.state & 2) != 0) {
            return this.handle;
        }
        return this.fixedHandle != 0L ? this.fixedHandle : this.handle;
    }

    @Override
    void printWidget(GC gc, long drawable, int depth, int x, int y) {
        Region oldClip = new Region(gc.getDevice());
        Region newClip = new Region(gc.getDevice());
        Point loc = DPIUtil.autoScaleDown(new Point(x, y));
        gc.getClipping(oldClip);
        Rectangle rect = this.getBounds();
        newClip.add(oldClip);
        newClip.intersect(loc.x, loc.y, rect.width, rect.height);
        gc.setClipping(newClip);
        super.printWidget(gc, drawable, depth, x, y);
        Rectangle clientRect = this.getClientAreaInPixels();
        Point pt = this.display.mapInPixels(this, this.parent, clientRect.x, clientRect.y);
        clientRect.x = x + pt.x - rect.x;
        clientRect.y = y + pt.y - rect.y;
        newClip.intersect(DPIUtil.autoScaleDown(clientRect));
        gc.setClipping(newClip);
        Control[] children = this._getChildren();
        int i = children.length - 1;
        while (i >= 0) {
            Control child = children[i];
            if (child.getVisible()) {
                Point location = child.getLocationInPixels();
                child.printWidget(gc, drawable, depth, x + location.x, y + location.y);
            }
            --i;
        }
        gc.setClipping(oldClip);
        oldClip.dispose();
        newClip.dispose();
    }

    void connectFixedHandleDraw() {
        long paintHandle = this.fixedHandle;
        int paintMask = 2;
        GTK.gtk_widget_add_events(paintHandle, paintMask);
        OS.g_signal_connect_closure_by_id(paintHandle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
    }

    void propagateDraw(long container, long cairo) {
        if (container == this.fixedHandle && GTK.GTK3) {
            long list;
            long temp = list = GTK.gtk_container_get_children(container);
            while (temp != 0L) {
                Widget widget;
                long child = OS.g_list_data(temp);
                if (child != 0L && (widget = this.display.getWidget(child)) != this) {
                    GTK.gtk_container_propagate_draw(container, child, cairo);
                }
                temp = OS.g_list_next(temp);
            }
            OS.g_list_free(list);
        }
    }

    @Override
    void redrawChildren() {
        super.redrawChildren();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if ((child.state & 0x8000) != 0) {
                child.redrawWidget(0, 0, 0, 0, true, false, true);
                child.redrawChildren();
            }
            ++i;
        }
    }

    @Override
    void register() {
        super.register();
        if (this.socketHandle != 0L) {
            this.display.addWidget(this.socketHandle, this);
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.embeddedHandle = 0L;
        this.socketHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imHandle != 0L) {
            OS.g_object_unref(this.imHandle);
        }
        this.imHandle = 0L;
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    @Override
    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null) {
                child.reskin(flags);
            }
            ++i;
        }
    }

    @Override
    void resizeHandle(int width, int height) {
        super.resizeHandle(width, height);
        if (this.socketHandle != 0L) {
            if (GTK.GTK3) {
                OS.swt_fixed_resize(this.handle, this.socketHandle, width, height);
            } else {
                GTK.gtk_widget_set_size_request(this.socketHandle, width, height);
            }
        }
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result;
        long topHandle = this.topHandle();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 8, 0) && this.fixedHandle != 0L && this.handle != 0L && this.getVisible() && !GTK.gtk_widget_get_visible(topHandle) && topHandle == this.fixedHandle && width > 0 && height > 0 && resize) {
            GTK.gtk_widget_show(topHandle);
        }
        if (((result = super.setBounds(x, y, width, height, move, resize)) & 0x100) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return result;
    }

    @Override
    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getVisible() && child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        this.checkWidget();
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x80000) != 0 || (this.state & 0x20000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (!create) {
            int flags = 0x6000000;
            int orientation = this.style & flags;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setOrientation(orientation);
                ++i;
            }
            if ((this.style & 0x4000000) != 0 != ((this.style & 0x8000000) != 0)) {
                this.moveChildren(-1);
            }
        }
    }

    @Override
    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    @Override
    boolean setTabGroupFocus(boolean next) {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus(next);
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (this.socketHandle != 0L) {
            takeFocus = true;
        }
        if (takeFocus && this.setTabItemFocus(next)) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus(next)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean setTabItemFocus(boolean next) {
        if (!super.setTabItemFocus(next)) {
            return false;
        }
        if (this.socketHandle != 0L) {
            int direction = next ? 0 : 1;
            GTK.GTK_WIDGET_UNSET_FLAGS(this.socketHandle, 4096);
            GTK.gtk_widget_child_focus(this.socketHandle, direction);
            GTK.GTK_WIDGET_SET_FLAGS(this.socketHandle, 4096);
        }
        return true;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.socketHandle != 0L) {
            GTK.gtk_widget_show(this.socketHandle);
            this.embeddedHandle = GTK.gtk_socket_get_id(this.socketHandle);
        }
        if (this.scrolledHandle == 0L) {
            this.fixStyle(this.handle);
        }
    }

    @Override
    boolean checkSubwindow() {
        return (this.state & 0x2000000) != 0;
    }

    @Override
    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    int traversalCode(int key, GdkEventKey event) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, event);
    }

    @Override
    boolean translateTraversal(GdkEventKey keyEvent) {
        if (this.socketHandle != 0L) {
            return false;
        }
        return super.translateTraversal(keyEvent);
    }

    @Override
    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    @Override
    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x80000;
            return;
        }
        if ((this.state & 0x20000) != 0) {
            boolean changed = (this.state & 0x40000) != 0;
            this.state &= 0xFFF9FFFF;
            this.display.runSkin();
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFF7FFFF;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(all);
                ++i;
            }
        }
    }
}

