/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.ArrayList;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public abstract class CommandCopyFilter {
    private static final ArrayList<CommandCopyFilter> fFilters = new ArrayList();
    public static final CommandCopyFilter NONE = new CommandCopyFilter(){

        @Override
        public String getLabelText() {
            return PDEUIMessages.CommandCopyFilter_noFilter;
        }

        @Override
        public String getToolTipText() {
            return PDEUIMessages.CommandCopyFilter_noFilterDesc;
        }

        @Override
        protected String escape(String serializedCommand) {
            return serializedCommand;
        }

        @Override
        protected String markup(String escapedSerializedCommand, String markupLabel) {
            return escapedSerializedCommand;
        }
    };
    public static final CommandCopyFilter HELP = new CommandCopyFilter(){

        @Override
        public String getLabelText() {
            return PDEUIMessages.CommandCopyFilter_help;
        }

        @Override
        public String getToolTipText() {
            return PDEUIMessages.CommandCopyFilter_helpDesc;
        }

        @Override
        protected String escape(String serializedCommand) {
            return serializedCommand;
        }

        @Override
        protected String markup(String escapedSerializedCommand, String markupLabel) {
            StringBuilder sb = new StringBuilder();
            sb.append("<a href='javascript:executeCommand(\"");
            sb.append(escapedSerializedCommand);
            sb.append("\")'>");
            if (markupLabel != null) {
                sb.append(markupLabel);
            }
            sb.append("</a>");
            return sb.toString();
        }
    };
    public static final CommandCopyFilter CHEATSHEET = new CommandCopyFilter(){

        @Override
        public String getLabelText() {
            return PDEUIMessages.CommandCopyFilter_cheatsheet;
        }

        @Override
        public String getToolTipText() {
            return PDEUIMessages.CommandCopyFilter_cheatsheetDesc;
        }

        @Override
        protected String escape(String serializedCommand) {
            return serializedCommand;
        }

        @Override
        protected String markup(String escapedSerializedCommand, String markupLabel) {
            StringBuilder sb = new StringBuilder();
            sb.append("<command serialization=\"");
            sb.append(escapedSerializedCommand);
            sb.append("\"/>");
            return sb.toString();
        }
    };
    public static final CommandCopyFilter INTRO = new CommandCopyFilter(){

        @Override
        public String getLabelText() {
            return PDEUIMessages.CommandCopyFilter_intro;
        }

        @Override
        public String getToolTipText() {
            return PDEUIMessages.CommandCopyFilter_introDesc;
        }

        @Override
        protected String escape(String serializedCommand) {
            return serializedCommand;
        }

        @Override
        protected String markup(String escapedSerializedCommand, String markupLabel) {
            StringBuilder sb = new StringBuilder();
            sb.append("<link\n");
            if (markupLabel != null) {
                sb.append("label=\"");
                sb.append(markupLabel);
                sb.append("\"\n");
            }
            sb.append("id=\"TODO\"\n");
            sb.append("url=\"");
            sb.append(escapedSerializedCommand);
            sb.append("\"\n");
            sb.append("<text>TODO</text>\n");
            sb.append("</link>");
            return sb.toString();
        }
    };

    private CommandCopyFilter() {
        fFilters.add(this);
    }

    public final String filter(String serializedCommand, boolean surroundWithMarkup, String markupLabel) {
        if (surroundWithMarkup) {
            return this.markup(this.escape(serializedCommand), markupLabel);
        }
        return this.escape(serializedCommand);
    }

    protected abstract String escape(String var1);

    protected abstract String markup(String var1, String var2);

    public abstract String getLabelText();

    public abstract String getToolTipText();

    public static CommandCopyFilter[] getFilters() {
        return fFilters.toArray(new CommandCopyFilter[fFilters.size()]);
    }

    public static CommandCopyFilter getFilter(int index) {
        return fFilters.get(index);
    }

    public static int indexOf(CommandCopyFilter filter) {
        int index = 0;
        for (CommandCopyFilter f : fFilters) {
            if (f == filter) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    /* synthetic */ CommandCopyFilter(CommandCopyFilter commandCopyFilter) {
        this();
    }
}

