/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ViewFilterAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;

public class ShowSystemThreadsAction
extends ViewFilterAction
implements IDebugEventSetListener {
    @Override
    protected String getPreferenceKey() {
        return IJavaDebugUIConstants.PREF_SHOW_SYSTEM_THREADS;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IJavaThread thread;
        if (!this.getValue() && (thread = this.getJavaThread(element)) != null) {
            try {
                return !thread.isSystemThread() || thread.isSuspended();
            }
            catch (DebugException debugException) {}
        }
        return true;
    }

    private IJavaThread getJavaThread(Object element) {
        IJavaThread thread = null;
        if (element instanceof IJavaThread) {
            thread = (IJavaThread)element;
        } else if (element instanceof IAdaptable) {
            thread = (IJavaThread)((IAdaptable)element).getAdapter(IJavaThread.class);
        }
        return thread;
    }

    @Override
    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.getValue()) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 1: {
                    if (event.getDetail() != 32) break;
                    this.refresh(event.getSource());
                }
            }
            ++i;
        }
    }

    private void refresh(Object source) {
        IJavaThread thread = this.getJavaThread(source);
        if (thread != null) {
            try {
                if (thread.isSystemThread()) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            StructuredViewer viewer = ShowSystemThreadsAction.this.getStructuredViewer();
                            if (viewer != null) {
                                viewer.refresh();
                            }
                        }
                    };
                    JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
                    return;
                }
            }
            catch (DebugException debugException) {}
        }
    }
}

