/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JavaFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList<IDocument> fDocuments = new LinkedList();
    private final LinkedList<TypedPosition> fPartitions = new LinkedList();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void format() {
        super.format();
        IDocument document = this.fDocuments.removeFirst();
        TypedPosition partition = this.fPartitions.removeFirst();
        if (document == null || partition == null) return;
        Map partitioners = null;
        try {
            try {
                TextEdit edit = CodeFormatterUtil.reformat((int)4104, (String)document.get(), (int)partition.getOffset(), (int)partition.getLength(), (int)0, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document), (Map)this.getPreferences());
                if (edit == null) return;
                if (edit.getChildrenSize() > 20) {
                    partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
                }
                edit.apply(document);
                return;
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
                if (partitioners == null) return;
                TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
                return;
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
                if (partitioners == null) return;
                TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
                return;
            }
        }
        finally {
            if (partitioners != null) {
                TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast((TypedPosition)context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast((IDocument)context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

