/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class AddJavaDocStubOperation
implements IWorkspaceRunnable {
    private IMember[] fMembers;

    public AddJavaDocStubOperation(IMember[] members) {
        Assert.isLegal((members.length > 0 ? 1 : 0) != 0);
        this.fMembers = members;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        String[] typeParameterNames = StubUtility.getTypeParameterNames(type.getTypeParameters());
        return CodeGeneration.getTypeComment(type.getCompilationUnit(), type.getTypeQualifiedName('.'), typeParameterNames, lineDelimiter);
    }

    private String createMethodComment(IMethod meth, String lineDelimiter) throws CoreException {
        IType declaringType = meth.getDeclaringType();
        IMethod overridden = null;
        if (!meth.isConstructor()) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)declaringType);
            MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
            overridden = tester.findOverriddenMethod(meth, true);
        }
        return CodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws JavaModelException, CoreException {
        String typeName = Signature.toString((String)field.getTypeSignature());
        String fieldName = field.getElementName();
        return CodeGeneration.getFieldComment(field.getCompilationUnit(), typeName, fieldName, lineDelimiter);
    }

    public ISchedulingRule getScheduleRule() {
        return this.fMembers[0].getResource();
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(CodeGenerationMessages.AddJavaDocStubOperation_description, this.fMembers.length + 2);
            this.addJavadocComments(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void addJavadocComments(IProgressMonitor monitor) throws CoreException {
        ICompilationUnit cu = this.fMembers[0].getCompilationUnit();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = cu.getPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            try {
                IDocument document = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                MultiTextEdit edit = new MultiTextEdit();
                int i = 0;
                while (i < this.fMembers.length) {
                    IMember curr = this.fMembers[i];
                    int memberStartOffset = this.getMemberStartOffset(curr, document);
                    String comment = null;
                    switch (curr.getElementType()) {
                        case 7: {
                            comment = this.createTypeComment((IType)curr, lineDelim);
                            break;
                        }
                        case 8: {
                            comment = this.createFieldComment((IField)curr, lineDelim);
                            break;
                        }
                        case 9: {
                            comment = this.createMethodComment((IMethod)curr, lineDelim);
                        }
                    }
                    if (comment == null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("/**").append(lineDelim);
                        buf.append(" *").append(lineDelim);
                        buf.append(" */").append(lineDelim);
                        comment = buf.toString();
                    } else if (!comment.endsWith(lineDelim)) {
                        comment = String.valueOf(comment) + lineDelim;
                    }
                    IJavaProject project = cu.getJavaProject();
                    IRegion region = document.getLineInformationOfOffset(memberStartOffset);
                    String line = document.get(region.getOffset(), region.getLength());
                    String indentString = Strings.getIndentString((String)line, (IJavaProject)project);
                    String indentedComment = Strings.changeIndent((String)comment, (int)0, (IJavaProject)project, (String)indentString, (String)lineDelim);
                    edit.addChild((TextEdit)new InsertEdit(memberStartOffset, indentedComment));
                    monitor.worked(1);
                    ++i;
                }
                edit.apply(document);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        finally {
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private int getMemberStartOffset(IMember curr, IDocument document) throws JavaModelException {
        int offset = curr.getSourceRange().getOffset();
        TokenScanner scanner = new TokenScanner(document, curr.getJavaProject());
        try {
            return scanner.getNextStartOffset(offset, true);
        }
        catch (CoreException coreException) {
            return offset;
        }
    }
}

