/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.ClassPrepareBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public class ClassPrepareBreakpointTypeChange
extends ClassPrepareBreakpointChange {
    private IType fDestType;

    public ClassPrepareBreakpointTypeChange(IJavaClassPrepareBreakpoint breakpoint, IType destType) throws CoreException {
        super(breakpoint);
        this.fDestType = destType;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.ClassPrepareBreakpointTypeChange_0, (Object[])new String[]{this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()), this.fDestType.getElementName()});
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)this.fDestType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)this.fDestType);
        map.put("workingset_name", this.getOriginalWorkingSets());
        ISourceRange range = this.fDestType.getNameRange();
        IJavaClassPrepareBreakpoint breakpoint = JDIDebugModel.createClassPrepareBreakpoint((IResource)resource, (String)this.fDestType.getFullyQualifiedName(), (int)this.getMemberType(), (int)range.getOffset(), (int)(range.getOffset() + range.getLength()), (boolean)true, map);
        this.apply((IJavaBreakpoint)breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

