/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class RepositoryActionHandler
extends AbstractHandler {
    private IEvaluationContext evaluationContext;
    private IStructuredSelection mySelection;

    RepositoryActionHandler() {
    }

    public void setSelection(ISelection selection) {
        this.mySelection = SelectionUtils.getStructuredSelection(selection);
    }

    private IProject[] getProjectsForSelectedResources(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        for (IResource resource : this.getSelectedAdaptables((ISelection)selection, IResource.class)) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null && mapping.getContainer() instanceof IProject) {
                ret.add((IProject)mapping.getContainer());
                continue;
            }
            return new IProject[0];
        }
        ret.addAll(this.extractProjectsFromMappings(selection));
        return ret.toArray(new IProject[ret.size()]);
    }

    private Set<IProject> extractProjectsFromMappings(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        for (ResourceMapping mapping : this.getSelectedAdaptables((ISelection)selection, ResourceMapping.class)) {
            IProject[] mappedProjects = mapping.getProjects();
            if (mappedProjects == null || mappedProjects.length == 0) continue;
            ArrayList<IProject> projects = new ArrayList<IProject>(Arrays.asList(mappedProjects));
            Collections.sort(projects, CommonUtils.RESOURCE_NAME_COMPARATOR);
            ret.addAll(projects);
        }
        return ret;
    }

    protected IProject[] getProjectsForSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return this.getProjectsForSelectedResources(selection);
    }

    protected IProject[] getProjectsForSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsForSelectedResources(selection);
    }

    protected Repository[] getRepositoriesFor(IProject[] projects) {
        LinkedHashSet<Repository> ret = new LinkedHashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[ret.size()]);
    }

    protected boolean haveSelectedResourcesWithRepository() {
        IResource[] resources;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && (resources = SelectionUtils.getSelectedResources(selection)).length > 0) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource == null || RepositoryMapping.getMapping((IResource)resource) == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected Repository getRepository(boolean warn, ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        if (warn) {
            Shell shell = this.getShell(event);
            return SelectionUtils.getRepositoryOrWarn(selection, shell);
        }
        return SelectionUtils.getRepository(selection);
    }

    protected Repository getRepository() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getRepository(selection);
    }

    protected Repository[] getRepositories(ExecutionEvent event) throws ExecutionException {
        IProject[] selectedProjects = this.getProjectsForSelectedResources(event);
        if (selectedProjects.length > 0) {
            return this.getRepositoriesFor(selectedProjects);
        }
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        if (!selection.isEmpty()) {
            LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Repository repo = (Repository)AdapterUtils.adapt((Object)o, Repository.class);
                if (repo != null) {
                    repos.add(repo);
                }
                ++n2;
            }
            return repos.toArray(new Repository[repos.size()]);
        }
        return new Repository[0];
    }

    public Repository[] getRepositories() {
        IProject[] selectedProjects = this.getProjectsForSelectedResources();
        if (selectedProjects.length > 0) {
            return this.getRepositoriesFor(selectedProjects);
        }
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Repository repo = (Repository)AdapterUtils.adapt((Object)o, Repository.class);
                if (repo == null) {
                    return new Repository[0];
                }
                repos.add(repo);
                ++n2;
            }
            return repos.toArray(new Repository[repos.size()]);
        }
        return new Repository[0];
    }

    protected static IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        if (event == null) {
            throw new IllegalArgumentException("event must not be NULL");
        }
        Object context = event.getApplicationContext();
        if (context instanceof IEvaluationContext) {
            return SelectionUtils.getSelection((IEvaluationContext)context);
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getSelection() {
        if (this.mySelection != null) {
            return this.mySelection;
        }
        return SelectionUtils.getSelection(this.evaluationContext);
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = (IEvaluationContext)evaluationContext;
    }

    private <T> List<T> getSelectedAdaptables(ISelection selection, Class<T> c) {
        List result;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = AdapterUtils.adapt(elements.next(), c);
                if (adapter == null) continue;
                result.add(adapter);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    protected IResource[] getSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedResources(selection);
    }

    protected IPath[] getSelectedLocations(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedLocations(selection);
    }

    protected IResource[] getSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedResources(selection);
    }

    protected IPath[] getSelectedLocations() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedLocations(selection);
    }

    protected boolean selectionMapsToSingleRepository() {
        return this.getRepository() != null;
    }

    protected Shell getShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    protected IWorkbenchPage getPartPage(ExecutionEvent event) throws ExecutionException {
        return this.getPart(event).getSite().getPage();
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    protected boolean containsHead(Repository repository) {
        try {
            return repository != null ? repository.resolve("HEAD") != null : false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLocalBranchCheckedout(Repository repository) {
        try {
            String fullBranch = repository.getFullBranch();
            return fullBranch != null && fullBranch.startsWith("refs/heads/");
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getPreviousPath(Repository repository, ObjectReader reader, RevCommit headCommit, RevCommit previousCommit, String path) throws IOException {
        DiffEntry diffEntry = CompareCoreUtils.getChangeDiffEntry((Repository)repository, (String)path, (RevCommit)headCommit, (RevCommit)previousCommit, (ObjectReader)reader);
        if (diffEntry != null) {
            return diffEntry.getOldPath();
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<PreviousCommit> findPreviousCommits() throws IOException {
        ArrayList<PreviousCommit> result = new ArrayList<PreviousCommit>();
        Repository repository = this.getRepository();
        IResource resource = this.getSelectedResources()[0];
        if (resource == null) {
            return result;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping == null) {
            return result;
        }
        String path = mapping.getRepoRelativePath(resource);
        if (path == null) {
            return result;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            RevWalk rw = new RevWalk(repository);
            try {
                Ref head;
                rw.sort(RevSort.COMMIT_TIME_DESC, true);
                rw.sort(RevSort.BOUNDARY, true);
                if (path.length() > 0) {
                    DiffConfig diffConfig = (DiffConfig)repository.getConfig().get(DiffConfig.KEY);
                    FollowFilter filter = FollowFilter.create((String)path, (DiffConfig)diffConfig);
                    rw.setTreeFilter((TreeFilter)filter);
                }
                if ((head = repository.exactRef("HEAD")) == null) {
                    return result;
                }
                RevCommit headCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
                rw.markStart(headCommit);
                headCommit = rw.next();
                if (headCommit == null) {
                    return result;
                }
                List<RevCommit> directParents = Arrays.asList(headCommit.getParents());
                RevCommit previousCommit = rw.next();
                while (true) {
                    if (previousCommit == null || result.size() >= directParents.size()) {
                        rw.dispose();
                        return result;
                    }
                    if (directParents.contains(previousCommit)) {
                        String previousPath = this.getPreviousPath(repository, rw.getObjectReader(), headCommit, previousCommit, path);
                        result.add(new PreviousCommit(previousCommit, previousPath));
                    }
                    previousCommit = rw.next();
                }
            }
            finally {
                if (rw == null) return result;
                rw.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public boolean isEnabled() {
        return this.getProjectsForSelectedResources().length > 0;
    }

    protected static final class PreviousCommit {
        final RevCommit commit;
        final String path;

        PreviousCommit(RevCommit commit, String path) {
            this.commit = commit;
            this.path = path;
        }
    }
}

