/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.plugin.PluginBaseNode;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.ui.IFileEditorInput;

public class FormatOperation
implements IRunnableWithProgress {
    private Object[] fObjects;

    public FormatOperation(Object[] objects) {
        this.fObjects = objects;
    }

    public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        mon.beginTask(PDEUIMessages.FormatManifestOperation_task, this.fObjects.length);
        int i = 0;
        while (!mon.isCanceled() && i < this.fObjects.length) {
            Object obj = this.fObjects[i];
            if (obj instanceof IFileEditorInput) {
                obj = ((IFileEditorInput)obj).getFile();
            }
            if (obj instanceof IFile) {
                mon.subTask(NLS.bind((String)PDEUIMessages.FormatManifestOperation_subtask, (Object)((IFile)obj).getFullPath().toString()));
                FormatOperation.format((IFile)obj, mon);
            }
            mon.worked(1);
            ++i;
        }
    }

    public static void format(IFile file, IProgressMonitor mon) {
        PDEModelUtility.modifyModel(new ModelModification(file){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                IPluginBase pluginModel;
                if (model instanceof IBundlePluginModelBase) {
                    IBundleModel bundleModel = ((IBundlePluginModelBase)model).getBundleModel();
                    if (bundleModel.getBundle() instanceof Bundle) {
                        FormatOperation.formatBundle((Bundle)bundleModel.getBundle());
                    }
                } else if (model instanceof IPluginModelBase && (pluginModel = ((IPluginModelBase)model).getPluginBase()) instanceof PluginBaseNode) {
                    FormatOperation.formatXML((PluginBaseNode)pluginModel);
                }
            }

            @Override
            public boolean saveOpenEditor() {
                return false;
            }
        }, mon);
    }

    private static void formatBundle(Bundle bundle) {
        Iterator headers = bundle.getHeaders().values().iterator();
        while (headers.hasNext()) {
            ((IManifestHeader)headers.next()).update(true);
        }
        BundleModel model = (BundleModel)bundle.getModel();
        model.adjustOffsets(model.getDocument());
    }

    private static void formatXML(PluginBaseNode node) {
    }
}

