/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;

public final class FillArgumentNamesCompletionProposalCollector
extends CompletionProposalCollector {
    private final boolean fIsGuessArguments;

    public FillArgumentNamesCompletionProposalCollector(JavaContentAssistInvocationContext context) {
        super(context.getCompilationUnit(), true);
        this.setInvocationContext(context);
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        this.fIsGuessArguments = preferenceStore.getBoolean("content_assist_guess_method_arguments");
        if (preferenceStore.getBoolean("content_assist_fill_method_arguments")) {
            this.setRequireExtendedContext(true);
        }
    }

    @Override
    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: 
            case 24: 
            case 26: {
                return this.createMethodReferenceProposal(proposal);
            }
            case 9: {
                return this.createTypeProposal(proposal);
            }
        }
        return super.createJavaCompletionProposal(proposal);
    }

    private IJavaCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        String completion = String.valueOf(methodProposal.getCompletion());
        if (completion.length() == 0 || completion.length() == 1 && completion.charAt(0) == ')' || Signature.getParameterCount((char[])methodProposal.getSignature()) == 0 || this.getContext().isInJavadoc()) {
            return super.createJavaCompletionProposal(methodProposal);
        }
        JavaMethodCompletionProposal proposal = null;
        proposal = ParameterGuessingProposal.createProposal(methodProposal, this.getInvocationContext(), this.fIsGuessArguments);
        if (proposal == null) {
            proposal = new FilledArgumentNamesMethodProposal(methodProposal, this.getInvocationContext());
        }
        return proposal;
    }

    IJavaCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null || this.getContext() != null && this.getContext().isInJavadoc()) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        IJavaProject project = cu.getJavaProject();
        if (!this.shouldProposeGenerics(project)) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        char[] completion = typeProposal.getCompletion();
        if (completion.length > 0 && (completion[completion.length - 1] == ';' || completion[completion.length - 1] == '.')) {
            return super.createJavaCompletionProposal(typeProposal);
        }
        LazyGenericTypeProposal newProposal = new LazyGenericTypeProposal(typeProposal, this.getInvocationContext());
        return newProposal;
    }

    private final boolean shouldProposeGenerics(IJavaProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return JavaModelUtil.is50OrHigher(sourceVersion);
    }
}

