/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.regex.Matcher;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    boolean ignoreResize;
    boolean lockText;
    int scrollWidth;
    int visibleCount;
    int cbtHook;
    String[] items = new String[0];
    int[] segments;
    int clearSegmentsCount = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, lpWndClass);
        ComboProc = lpWndClass.lpfnWndProc;
    }

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((result = OS.SendMessage(this.handle, 323, 0, buffer = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (result == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(buffer, true);
        }
    }

    public void add(String string, int index) {
        TCHAR buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if ((result = OS.SendMessage(this.handle, 330, index, buffer = new TCHAR(this.getCodePage(), string, true))) == -2 || result == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(buffer, true);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(listener));
        int selection = -1;
        if (!this.noSelection) {
            selection = OS.SendMessage(this.handle, 327, 0, 0);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (selection != -1) {
            OS.SendMessage(this.handle, 334, selection, 0);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    void applyEditSegments() {
        int separator;
        if (--this.clearSegmentsCount != 0) {
            return;
        }
        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) {
            return;
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        int length = OS.GetWindowTextLength(hwndText);
        int cp = this.getCodePage();
        TCHAR buffer = new TCHAR(cp, length + 1);
        if (length > 0) {
            OS.GetWindowText(hwndText, buffer, length + 1);
        }
        String string = buffer.toString(0, length);
        this.segments = null;
        Event event = this.getSegments(string);
        if (event == null || event.segments == null) {
            return;
        }
        this.segments = event.segments;
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return;
        }
        char[] segmentsChars = event.segmentsChars;
        int limit = OS.SendMessage(hwndText, 213, 0, 0) & Integer.MAX_VALUE;
        OS.SendMessage(hwndText, 197, limit + Math.min(nSegments, LIMIT - limit), 0);
        char[] newChars = new char[(length += nSegments) + 1];
        int charCount = 0;
        int segmentCount = 0;
        int defaultSeparator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount - segmentCount == this.segments[segmentCount]) {
                separator = segmentsChars != null && segmentsChars.length > segmentCount ? segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount++] = separator;
                ++segmentCount;
                continue;
            }
            if (string == null) continue;
            newChars[charCount] = string.charAt(charCount++ - segmentCount);
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount - segmentCount;
            separator = segmentsChars != null && segmentsChars.length > segmentCount ? segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount++] = separator;
            ++segmentCount;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(hwndText, 176, start, end);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            start[0] = this.mbcsToWcsPos(start[0]);
            end[0] = this.mbcsToWcsPos(end[0]);
        }
        boolean oldIgnoreCharacter = this.ignoreCharacter;
        boolean oldIgnoreModify = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        newChars[length] = '\u0000';
        buffer = new TCHAR(cp, newChars, false);
        OS.SendMessage(hwndText, 177, 0, -1);
        int undo = OS.SendMessage(hwndText, 198, 0, 0);
        OS.SendMessage(hwndText, 194, undo, buffer);
        start[0] = this.translateOffset(start[0]);
        end[0] = this.translateOffset(end[0]);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            start[0] = this.wcsToMbcsPos(start[0]);
            end[0] = this.wcsToMbcsPos(end[0]);
        }
        if (segmentsChars != null && segmentsChars.length > 0) {
            int auto = this.state & 0x400000;
            if (segmentsChars[0] == '\u202b') {
                super.updateTextDirection(0x4000000);
            } else if (segmentsChars[0] == '\u202a') {
                super.updateTextDirection(0x2000000);
            }
            this.state |= auto;
        }
        OS.SendMessage(hwndText, 177, start[0], end[0]);
        this.ignoreCharacter = oldIgnoreCharacter;
        this.ignoreModify = oldIgnoreModify;
    }

    void applyListSegments() {
        boolean add;
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (count == -1) {
            return;
        }
        boolean bl = add = this.items.length != count;
        if (add) {
            this.items = new String[count];
        }
        int index = this.items.length;
        int selection = -1;
        int cp = this.getCodePage();
        if (!this.noSelection) {
            selection = OS.SendMessage(this.handle, 327, 0, 0);
        }
        while (index-- > 0) {
            String string;
            TCHAR buffer = null;
            if (add) {
                int length = OS.SendMessage(this.handle, 329, index, 0);
                if (length == -1) {
                    this.error(1);
                }
                if (OS.SendMessage(this.handle, 328, index, buffer = new TCHAR(cp, length + 1)) == -1) {
                    return;
                }
                this.items[index] = string = buffer.toString(0, length);
            } else {
                string = this.items[index];
            }
            if (OS.SendMessage(this.handle, 324, index, 0) == -1) {
                return;
            }
            if (buffer == null) {
                buffer = new TCHAR(cp, string, true);
            }
            if (OS.SendMessage(this.handle, 330, index, buffer) != -1) continue;
            return;
        }
        if (selection != -1) {
            OS.SendMessage(this.handle, 334, selection, 0);
        }
    }

    @Override
    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        if (hwnd == this.handle) {
            switch (msg) {
                case 5: {
                    this.ignoreResize = true;
                    boolean oldLockText = this.lockText;
                    if ((this.style & 8) == 0) {
                        this.lockText = true;
                    }
                    int result = OS.CallWindowProc(ComboProc, hwnd, msg, wParam, lParam);
                    if ((this.style & 8) == 0) {
                        this.lockText = oldLockText;
                    }
                    this.ignoreResize = false;
                    return result;
                }
            }
            return OS.CallWindowProc(ComboProc, hwnd, msg, wParam, lParam);
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwnd == hwndText) {
            if (this.lockText && msg == 12) {
                int hHeap = OS.GetProcessHeap();
                int length = OS.GetWindowTextLength(this.handle);
                TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
                OS.GetWindowText(this.handle, buffer, length + 1);
                int byteCount = buffer.length() * TCHAR.sizeof;
                int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                OS.MoveMemory(pszText, buffer, byteCount);
                int code = OS.CallWindowProc(EditProc, hwndText, msg, wParam, pszText);
                OS.HeapFree(hHeap, 0, pszText);
                return code;
            }
            return OS.CallWindowProc(EditProc, hwnd, msg, wParam, lParam);
        }
        int hwndList = OS.GetDlgItem(this.handle, 1000);
        if (hwnd == hwndList) {
            return OS.CallWindowProc(ListProc, hwnd, msg, wParam, lParam);
        }
        return OS.DefWindowProc(hwnd, msg, wParam, lParam);
    }

    int CBTProc(int nCode, int wParam, int lParam) {
        if (nCode == 3) {
            TCHAR buffer = new TCHAR(0, 128);
            OS.GetClassName(wParam, buffer, buffer.length());
            String className = buffer.toString(0, buffer.strlen());
            if (className.equals("Edit") || className.equals("EDIT")) {
                int bits = OS.GetWindowLong(wParam, -16);
                OS.SetWindowLong(wParam, -16, bits & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, nCode, wParam, lParam);
    }

    @Override
    boolean checkHandle(int hwnd) {
        return hwnd == this.handle || hwnd == OS.GetDlgItem(this.handle, 1001) || hwnd == OS.GetDlgItem(this.handle, 1000);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    void clearSegments(boolean applyText) {
        if (this.clearSegmentsCount++ != 0) {
            return;
        }
        if (this.segments == null) {
            return;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return;
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        int limit = OS.SendMessage(hwndText, 213, 0, 0) & Integer.MAX_VALUE;
        if (limit < LIMIT) {
            OS.SendMessage(hwndText, 197, Math.max(1, limit - nSegments), 0);
        }
        if (!applyText) {
            this.segments = null;
            return;
        }
        boolean oldIgnoreCharacter = this.ignoreCharacter;
        boolean oldIgnoreModify = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        int length = OS.GetWindowTextLength(hwndText);
        int cp = this.getCodePage();
        TCHAR buffer = new TCHAR(cp, length + 1);
        if (length > 0) {
            OS.GetWindowText(hwndText, buffer, length + 1);
        }
        buffer = this.deprocessText(buffer, 0, -1, true);
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(hwndText, 176, start, end);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            start[0] = this.mbcsToWcsPos(start[0]);
            end[0] = this.mbcsToWcsPos(end[0]);
        }
        start[0] = this.untranslateOffset(start[0]);
        end[0] = this.untranslateOffset(end[0]);
        this.segments = null;
        OS.SendMessage(hwndText, 177, 0, -1);
        int undo = OS.SendMessage(hwndText, 198, 0, 0);
        OS.SendMessage(hwndText, 194, undo, buffer);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            start[0] = this.wcsToMbcsPos(start[0]);
            end[0] = this.wcsToMbcsPos(end[0]);
        }
        OS.SendMessage(hwndText, 177, start[0], end[0]);
        this.ignoreCharacter = oldIgnoreCharacter;
        this.ignoreModify = oldIgnoreModify;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1) {
            int oldFont = 0;
            int hDC = OS.GetDC(this.handle);
            int newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            int count = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rect = new RECT();
            int flags = 3072;
            if ((this.style & 8) == 0) {
                flags |= 0x2000;
            }
            int length = OS.GetWindowTextLength(this.handle);
            int cp = this.getCodePage();
            TCHAR buffer = new TCHAR(cp, length + 1);
            OS.GetWindowText(this.handle, buffer, length + 1);
            OS.DrawText(hDC, buffer, length, rect, flags);
            width = Math.max(width, rect.right - rect.left);
            if ((this.style & 0x100) != 0) {
                width = Math.max(width, this.scrollWidth);
            } else {
                int i = 0;
                while (i < count) {
                    length = OS.SendMessage(this.handle, 329, i, 0);
                    if (length != -1) {
                        int result;
                        if (length + 1 > buffer.length()) {
                            buffer = new TCHAR(cp, length + 1);
                        }
                        if ((result = OS.SendMessage(this.handle, 328, i, buffer)) != -1) {
                            OS.DrawText(hDC, buffer, length, rect, flags);
                            width = Math.max(width, rect.right - rect.left);
                        }
                    }
                    ++i;
                }
            }
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        if (hHint == -1 && (this.style & 0x40) != 0) {
            int count = OS.SendMessage(this.handle, 326, 0, 0);
            int itemHeight = OS.SendMessage(this.handle, 340, 0, 0);
            height = count * itemHeight;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if ((this.style & 8) != 0) {
            width += 8;
        } else {
            int hwndText = OS.GetDlgItem(this.handle, 1001);
            if (hwndText != 0) {
                int margins = OS.SendMessage(hwndText, 212, 0, 0);
                int marginWidth = OS.LOWORD(margins) + OS.HIWORD(margins);
                width += marginWidth + 3;
            }
        }
        COMBOBOXINFO pcbi = new COMBOBOXINFO();
        pcbi.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, pcbi)) {
            width += pcbi.itemLeft + (pcbi.buttonRight - pcbi.buttonLeft);
            height = pcbi.buttonBottom - pcbi.buttonTop + pcbi.buttonTop * 2;
        } else {
            int border = OS.GetSystemMetrics(45);
            width += OS.GetSystemMetrics(2) + border * 2;
            int textHeight = OS.SendMessage(this.handle, 340, -1, 0);
            height = (this.style & 4) != 0 ? textHeight + 6 : (height += textHeight + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    @Override
    void createHandle() {
        int hwndList;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            int threadId = OS.GetCurrentThreadId();
            Callback cbtCallback = new Callback(this, "CBTProc", 3);
            int cbtProc = cbtCallback.getAddress();
            if (cbtProc == 0) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, cbtProc, 0, threadId);
            super.createHandle();
            if (this.cbtHook != 0) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0;
            cbtCallback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLongPtr(hwndText, -4);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLongPtr(hwndList, -4);
        }
        if ((this.style & 0x40) != 0) {
            int flags = 52;
            this.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, flags);
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, flags);
        }
    }

    @Override
    void createWidget() {
        int itemHeight;
        super.createWidget();
        this.visibleCount = 5;
        if ((this.style & 0x40) == 0 && (itemHeight = OS.SendMessage(this.handle, 340, 0, 0)) != -1 && itemHeight != 0) {
            int maxHeight = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rect = new RECT();
                OS.SystemParametersInfo(48, 0, rect, 0);
                maxHeight = (rect.bottom - rect.top) / 3;
            } else {
                int hmonitor = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO lpmi = new MONITORINFO();
                lpmi.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(hmonitor, lpmi);
                maxHeight = (lpmi.rcWork_bottom - lpmi.rcWork_top) / 3;
            }
            this.visibleCount = Math.max(this.visibleCount, maxHeight / itemHeight);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    TCHAR deprocessText(TCHAR text, int start, int end, boolean terminate) {
        char[] chars;
        if (text == null || this.segments == null) {
            return text;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return text;
        }
        if (start < 0) {
            start = 0;
        }
        if (OS.IsUnicode) {
            chars = text.chars;
            if (text.chars[length - 1] == '\u0000') {
                --length;
            }
        } else {
            chars = new char[length];
            length = OS.MultiByteToWideChar(this.getCodePage(), 1, text.bytes, length, chars, length);
        }
        if (end == -1) {
            end = length;
        }
        if (end > this.segments[0] && start <= this.segments[nSegments - 1]) {
            int nLeadSegments = 0;
            while (start - nLeadSegments > this.segments[nLeadSegments]) {
                ++nLeadSegments;
            }
            int segmentCount = nLeadSegments;
            int i = start;
            while (i < end) {
                if (segmentCount < nSegments && i - segmentCount == this.segments[segmentCount]) {
                    ++segmentCount;
                } else {
                    chars[i - segmentCount + nLeadSegments] = chars[i];
                }
                ++i;
            }
            length = end - start - segmentCount + nLeadSegments;
        }
        if (start != 0 || end != length) {
            char[] newChars = new char[length];
            System.arraycopy(chars, start, newChars, 0, length);
            return new TCHAR(this.getCodePage(), newChars, terminate);
        }
        return text;
    }

    @Override
    void deregister() {
        int hwndList;
        super.deregister();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            this.display.removeControl(hwndText);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(hwndList);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        int selection = OS.SendMessage(this.handle, 327, 0, 0);
        if (index != selection) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    @Override
    boolean dragDetect(int hwnd, int x, int y, boolean filter, boolean[] detect, boolean[] consume) {
        int hwndText;
        if (filter && (this.style & 8) == 0 && (hwndText = OS.GetDlgItem(this.handle, 1001)) != 0) {
            int lParam;
            int position;
            int[] start = new int[1];
            int[] end = new int[1];
            OS.SendMessage(this.handle, 320, start, end);
            if (start[0] != end[0] && start[0] <= (position = OS.LOWORD(OS.SendMessage(hwndText, 215, 0, lParam = OS.MAKELPARAM(x, y)))) && position < end[0] && super.dragDetect(hwnd, x, y, filter, detect, consume)) {
                if (consume != null) {
                    consume[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(hwnd, x, y, filter, detect, consume);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        int position = this.translateOffset(this.getCaretPosition());
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        int caretPos = OS.SendMessage(hwndText, 214, position, 0);
        if (caretPos == -1) {
            caretPos = 0;
            if (position >= OS.GetWindowTextLength(hwndText)) {
                int cp = this.getCodePage();
                int[] start = new int[1];
                int[] end = new int[1];
                OS.SendMessage(hwndText, 176, start, end);
                OS.SendMessage(hwndText, 177, position, position);
                this.ignoreModify = true;
                this.ignoreCharacter = true;
                OS.SendMessage(hwndText, 194, 0, new TCHAR(cp, " ", true));
                caretPos = OS.SendMessage(hwndText, 214, position, 0);
                OS.SendMessage(hwndText, 177, position, position + 1);
                OS.SendMessage(hwndText, 194, 0, new TCHAR(cp, "", true));
                this.ignoreModify = false;
                this.ignoreCharacter = false;
                OS.SendMessage(hwndText, 177, start[0], start[0]);
                OS.SendMessage(hwndText, 177, start[0], end[0]);
            }
        }
        POINT point = new POINT();
        point.x = OS.GET_X_LPARAM(caretPos);
        point.y = OS.GET_Y_LPARAM(caretPos);
        OS.MapWindowPoints(hwndText, this.handle, point, 1);
        return new Point(point.x, point.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        OS.SendMessage(hwndText, 176, start, end);
        int caret = start[0];
        if (start[0] != end[0] && !OS.IsWinCE) {
            POINT ptCurrentPos;
            int idThread = OS.GetWindowThreadProcessId(hwndText, null);
            GUITHREADINFO lpgui = new GUITHREADINFO();
            lpgui.cbSize = GUITHREADINFO.sizeof;
            if (OS.GetGUIThreadInfo(idThread, lpgui) && (lpgui.hwndCaret == hwndText || lpgui.hwndCaret == 0) && OS.GetCaretPos(ptCurrentPos = new POINT())) {
                int endPos = OS.SendMessage(hwndText, 214, end[0], 0);
                if (endPos == -1) {
                    int startPos = OS.SendMessage(hwndText, 214, start[0], 0);
                    int startX = OS.GET_X_LPARAM(startPos);
                    if (ptCurrentPos.x > startX) {
                        caret = end[0];
                    }
                } else {
                    int endX = OS.GET_X_LPARAM(endPos);
                    if (ptCurrentPos.x >= endX) {
                        caret = end[0];
                    }
                }
            }
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            caret = this.mbcsToWcsPos(caret);
        }
        return this.untranslateOffset(caret);
    }

    public String getItem(int index) {
        this.checkWidget();
        int length = OS.SendMessage(this.handle, 329, index, 0);
        if (length != -1) {
            if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                return this.items[index];
            }
            TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
            int result = OS.SendMessage(this.handle, 328, index, buffer);
            if (result != -1) {
                return buffer.toString(0, length);
            }
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (index >= 0 && index < count) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (count == -1) {
            this.error(36);
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        int result = OS.SendMessage(this.handle, 340, 0, 0);
        if (result == -1) {
            this.error(11);
        }
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0, 0) != 0;
        }
        return true;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, visible ? 1 : 0, 0);
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    Event getSegments(String string) {
        Event event = null;
        if (this.hooks(49) || this.filters(49)) {
            event = new Event();
            event.text = string;
            this.sendEvent(49, event);
            if (event != null && event.segments != null) {
                int i = 1;
                int segmentCount = event.segments.length;
                int lineLength = string == null ? 0 : string.length();
                while (i < segmentCount) {
                    if (event.segments[i] < event.segments[i - 1] || event.segments[i] > lineLength) {
                        SWT.error(5);
                    }
                    ++i;
                }
            }
        }
        if ((this.state & 0x400000) != 0) {
            int direction = BidiUtil.resolveTextDirection(string);
            if (direction == 0) {
                direction = (this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000;
            }
            int[] oldSegments = null;
            char[] oldSegmentsChars = null;
            if (event == null) {
                event = new Event();
            } else {
                oldSegments = event.segments;
                oldSegmentsChars = event.segmentsChars;
            }
            int nSegments = oldSegments == null ? 0 : oldSegments.length;
            event.segments = new int[nSegments + 1];
            event.segmentsChars = new char[nSegments + 1];
            if (oldSegments != null) {
                System.arraycopy(oldSegments, 0, event.segments, 1, nSegments);
            }
            if (oldSegmentsChars != null) {
                System.arraycopy(oldSegmentsChars, 0, event.segmentsChars, 1, nSegments);
            }
            event.segments[0] = 0;
            event.segmentsChars[0] = direction == 0x4000000 ? 8235 : 8234;
        }
        return event;
    }

    String getSegmentsText(String text, Event event) {
        int separator;
        if (text == null || event == null) {
            return text;
        }
        int[] segments = event.segments;
        if (segments == null) {
            return text;
        }
        int nSegments = segments.length;
        if (nSegments == 0) {
            return text;
        }
        char[] segmentsChars = event.segmentsChars;
        int length = text.length();
        char[] oldChars = new char[length];
        text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int defaultSeparator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == segments[segmentCount]) {
                separator = segmentsChars != null && segmentsChars.length > segmentCount ? segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            segments[segmentCount] = charCount;
            separator = segmentsChars != null && segmentsChars.length > segmentCount ? segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, newChars.length);
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.SendMessage(this.handle, 320, start, end);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            start[0] = this.mbcsToWcsPos(start[0]);
            end[0] = this.mbcsToWcsPos(end[0]);
        }
        return new Point(this.untranslateOffset(start[0]), this.untranslateOffset(end[0]));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        if (this.segments != null) {
            buffer = this.deprocessText(buffer, 0, -1, false);
            return buffer.toString();
        }
        return buffer.toString(0, length);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        COMBOBOXINFO pcbi = new COMBOBOXINFO();
        pcbi.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, pcbi)) {
            return pcbi.buttonBottom - pcbi.buttonTop + pcbi.buttonTop * 2;
        }
        int result = OS.SendMessage(this.handle, 340, -1, 0);
        if (result == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? result + 6 : result + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText == 0) {
            return LIMIT;
        }
        int limit = OS.SendMessage(hwndText, 213, 0, 0) & Integer.MAX_VALUE;
        if (this.segments != null && limit < LIMIT) {
            limit = Math.max(1, limit - this.segments.length);
        }
        return limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    boolean hasFocus() {
        int hwndFocus = OS.GetFocus();
        if (hwndFocus == this.handle) {
            return true;
        }
        if (hwndFocus == 0) {
            return false;
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndFocus == hwndText) {
            return true;
        }
        int hwndList = OS.GetDlgItem(this.handle, 1000);
        return hwndFocus == hwndList;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int count = this.getItemCount();
            int i = start;
            while (i < count) {
                if (string.equals(this.getItem(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (start < 0 || start >= count) {
            return -1;
        }
        int index = start - 1;
        int last = 0;
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((index = OS.SendMessage(this.handle, 344, last = index, buffer)) != -1 && index > last) continue;
            return -1;
        } while (!string.equals(this.getItem(index)));
        return index;
    }

    int mbcsToWcsPos(int mbcsPos) {
        if (mbcsPos <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return mbcsPos;
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText == 0) {
            return mbcsPos;
        }
        int mbcsSize = OS.GetWindowTextLengthA(hwndText);
        if (mbcsSize == 0) {
            return 0;
        }
        if (mbcsPos >= mbcsSize) {
            return mbcsSize;
        }
        byte[] buffer = new byte[mbcsSize + 1];
        OS.GetWindowTextA(hwndText, buffer, mbcsSize + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, buffer, mbcsPos, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    @Override
    void register() {
        int hwndList;
        super.register();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            this.display.addControl(hwndText, this);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(hwndList, this);
        }
    }

    public void remove(int index) {
        this.checkWidget();
        this.remove(index, true);
    }

    void remove(int index, boolean notify) {
        int count;
        int length;
        TCHAR buffer = null;
        if ((this.style & 0x100) != 0) {
            int result;
            length = OS.SendMessage(this.handle, 329, index, 0);
            if (length == -1) {
                int count2 = OS.SendMessage(this.handle, 326, 0, 0);
                if (index >= 0 && index < count2) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((result = OS.SendMessage(this.handle, 328, index, buffer = new TCHAR(this.getCodePage(), length + 1))) == -1) {
                count = OS.SendMessage(this.handle, 326, 0, 0);
                if (index >= 0 && index < count) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        length = OS.GetWindowTextLength(this.handle);
        int code = OS.SendMessage(this.handle, 324, index, 0);
        if (code == -1) {
            count = OS.SendMessage(this.handle, 326, 0, 0);
            if (index >= 0 && index < count) {
                this.error(15);
            }
            this.error(6);
        } else if (code == 0) {
            OS.SendMessage(this.handle, 331, 0, 0);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(buffer, true);
        }
        if (notify && length != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int textLength = OS.GetWindowTextLength(this.handle);
        RECT rect = null;
        int hDC = 0;
        int oldFont = 0;
        int newFont = 0;
        int newWidth = 0;
        if ((this.style & 0x100) != 0) {
            rect = new RECT();
            hDC = OS.GetDC(this.handle);
            newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
        }
        int cp = this.getCodePage();
        int flags = 3104;
        int i = start;
        while (i <= end) {
            int result;
            int length;
            TCHAR buffer = null;
            if ((this.style & 0x100) != 0 && ((length = OS.SendMessage(this.handle, 329, start, 0)) == -1 || (result = OS.SendMessage(this.handle, 328, start, buffer = new TCHAR(cp, length + 1))) == -1)) break;
            int result2 = OS.SendMessage(this.handle, 324, start, 0);
            if (result2 == -1) {
                this.error(15);
            } else if (result2 == 0) {
                OS.SendMessage(this.handle, 331, 0, 0);
            }
            if ((this.style & 0x100) != 0) {
                OS.DrawText(hDC, buffer, -1, rect, flags);
                newWidth = Math.max(newWidth, rect.right - rect.left);
            }
            ++i;
        }
        if ((this.style & 0x100) != 0) {
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
            this.setScrollWidth(newWidth, false);
        }
        if (textLength != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener);
        int selection = -1;
        if (!this.noSelection) {
            selection = OS.SendMessage(this.handle, 327, 0, 0);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (selection != -1) {
            OS.SendMessage(this.handle, 334, selection, 0);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    @Override
    boolean sendKeyEvent(int type, int msg, int wParam, int lParam, Event event) {
        String newText;
        if (!super.sendKeyEvent(type, msg, wParam, lParam, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (type != 1) {
            return true;
        }
        if (msg != 258 && msg != 256 && msg != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char key = event.character;
        int stateMask = event.stateMask;
        switch (msg) {
            case 258: {
                if (key != '\b' && key != '\u007f' && key != '\r' && key != '\t' && key != '\n') break;
            }
            case 256: {
                if ((stateMask & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && OS.GetDlgItem(this.handle, 1001) == OS.GetCapture()) {
            return true;
        }
        String oldText = "";
        int[] start = new int[1];
        int[] end = new int[1];
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText == 0) {
            return true;
        }
        OS.SendMessage(hwndText, 176, start, end);
        switch (key) {
            case '\b': {
                if (start[0] != end[0]) break;
                if (start[0] == 0) {
                    return true;
                }
                start[0] = start[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    int[] newStart = new int[1];
                    int[] newEnd = new int[1];
                    OS.SendMessage(hwndText, 177, start[0], end[0]);
                    OS.SendMessage(hwndText, 176, newStart, newEnd);
                    if (start[0] != newStart[0]) {
                        start[0] = start[0] - 1;
                    }
                }
                start[0] = Math.max(start[0], 0);
                break;
            }
            case '\u007f': {
                if (start[0] != end[0]) break;
                int length = OS.GetWindowTextLength(hwndText);
                if (start[0] == length) {
                    return true;
                }
                end[0] = end[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    int[] newStart = new int[1];
                    int[] newEnd = new int[1];
                    OS.SendMessage(hwndText, 177, start[0], end[0]);
                    OS.SendMessage(hwndText, 176, newStart, newEnd);
                    if (end[0] != newEnd[0]) {
                        end[0] = end[0] + 1;
                    }
                }
                end[0] = Math.min(end[0], length);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (key != '\t' && key < ' ') {
                    return true;
                }
                oldText = new String(new char[]{key});
            }
        }
        if ((newText = this.verifyText(oldText, start[0], end[0], event)) == null) {
            return false;
        }
        if (newText == oldText) {
            return true;
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), newText, true);
        OS.SendMessage(hwndText, 177, start[0], end[0]);
        OS.SendMessage(hwndText, 194, 0, buffer);
        return false;
    }

    public void select(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (index >= 0 && index < count) {
            int selection = OS.SendMessage(this.handle, 327, 0, 0);
            int code = OS.SendMessage(this.handle, 334, index, 0);
            if (code != -1 && code != selection) {
                this.sendEvent(24);
            }
        }
    }

    @Override
    void setBackgroundImage(int hBitmap) {
        int hwndList;
        super.setBackgroundImage(hBitmap);
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.InvalidateRect(hwndText, null, true);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(hwndList, null, true);
        }
    }

    @Override
    void setBackgroundPixel(int pixel) {
        int hwndList;
        super.setBackgroundPixel(pixel);
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.InvalidateRect(hwndText, null, true);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(hwndList, null, true);
        }
    }

    @Override
    void setBoundsInPixels(int x, int y, int width, int height, int flags) {
        if ((this.style & 4) != 0) {
            int visibleCount = this.getItemCount() == 0 ? 5 : this.visibleCount;
            height = this.getTextHeightInPixels() + this.getItemHeightInPixels() * visibleCount + 2;
            RECT rect = new RECT();
            OS.GetWindowRect(this.handle, rect);
            if (rect.right - rect.left != 0 && OS.SendMessage(this.handle, 338, 0, rect) != 0) {
                int oldWidth = rect.right - rect.left;
                int oldHeight = rect.bottom - rect.top;
                if (oldWidth == width && oldHeight == height) {
                    flags |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0, x, y, width, height, flags);
        } else {
            super.setBoundsInPixels(x, y, width, height, flags);
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        boolean oldLockText = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        super.setFont(font);
        if ((this.style & 8) == 0) {
            this.lockText = oldLockText;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    @Override
    void setForegroundPixel(int pixel) {
        int hwndList;
        super.setForegroundPixel(pixel);
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.InvalidateRect(hwndText, null, true);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(hwndList, null, true);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int selection = this.getSelectionIndex();
        this.remove(index, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, index);
        if (selection != -1) {
            this.select(selection);
        }
    }

    public void setItems(String ... items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        RECT rect = null;
        int hDC = 0;
        int oldFont = 0;
        int newFont = 0;
        int newWidth = 0;
        if ((this.style & 0x100) != 0) {
            rect = new RECT();
            hDC = OS.GetDC(this.handle);
            newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int codePage = this.getCodePage();
        int i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            TCHAR buffer = new TCHAR(codePage, string, true);
            int code = OS.SendMessage(this.handle, 323, 0, buffer);
            if (code == -1) {
                this.error(14);
            }
            if (code == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) != 0) {
                int flags = 3104;
                OS.DrawText(hDC, buffer, -1, rect, flags);
                newWidth = Math.max(newWidth, rect.right - rect.left);
            }
            ++i2;
        }
        if ((this.style & 0x100) != 0) {
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
            this.setScrollWidth(newWidth + 3);
        }
        this.sendEvent(24);
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
    }

    void setScrollWidth() {
        int newWidth = 0;
        RECT rect = new RECT();
        int oldFont = 0;
        int hDC = OS.GetDC(this.handle);
        int newFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        int cp = this.getCodePage();
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        int flags = 3104;
        int i = 0;
        while (i < count) {
            TCHAR buffer;
            int result;
            int length = OS.SendMessage(this.handle, 329, i, 0);
            if (length != -1 && (result = OS.SendMessage(this.handle, 328, i, buffer = new TCHAR(cp, length + 1))) != -1) {
                OS.DrawText(hDC, buffer, -1, rect, flags);
                newWidth = Math.max(newWidth, rect.right - rect.left);
            }
            ++i;
        }
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        this.setScrollWidth(newWidth + 3);
    }

    void setScrollWidth(int scrollWidth) {
        this.scrollWidth = scrollWidth;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, scrollWidth, 0);
            return;
        }
        boolean scroll = false;
        int count = OS.SendMessage(this.handle, 326, 0, 0);
        if (count > 3) {
            int maxWidth = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rect = new RECT();
                OS.SystemParametersInfo(48, 0, rect, 0);
                maxWidth = (rect.right - rect.left) / 4;
            } else {
                int hmonitor = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO lpmi = new MONITORINFO();
                lpmi.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(hmonitor, lpmi);
                maxWidth = (lpmi.rcWork_right - lpmi.rcWork_left) / 4;
            }
            scroll = scrollWidth > maxWidth;
        }
        boolean oldLockText = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        if (scroll) {
            OS.SendMessage(this.handle, 352, 0, 0);
            OS.SendMessage(this.handle, 350, scrollWidth, 0);
        } else {
            OS.SendMessage(this.handle, 352, scrollWidth += OS.GetSystemMetrics(3), 0);
            OS.SendMessage(this.handle, 350, 0, 0);
        }
        if ((this.style & 8) == 0) {
            this.lockText = oldLockText;
        }
    }

    void setScrollWidth(TCHAR buffer, boolean grow) {
        RECT rect = new RECT();
        int oldFont = 0;
        int hDC = OS.GetDC(this.handle);
        int newFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        int flags = 3104;
        OS.DrawText(hDC, buffer, -1, rect, flags);
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        this.setScrollWidth(rect.right - rect.left, grow);
    }

    void setScrollWidth(int newWidth, boolean grow) {
        if (grow) {
            if (newWidth <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(newWidth + 3);
        } else {
            if (newWidth < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        int start = this.translateOffset(selection.x);
        int end = this.translateOffset(selection.y);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            start = this.wcsToMbcsPos(start);
            end = this.wcsToMbcsPos(end);
        }
        int bits = OS.MAKELPARAM(start, end);
        OS.SendMessage(this.handle, 322, 0, bits);
    }

    public void setText(String string) {
        TCHAR buffer;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
            return;
        }
        this.clearSegments(false);
        int limit = LIMIT;
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            limit = OS.SendMessage(hwndText, 213, 0, 0) & Integer.MAX_VALUE;
        }
        if (string.length() > limit) {
            string = string.substring(0, limit);
        }
        if (OS.SetWindowText(this.handle, buffer = new TCHAR(this.getCodePage(), string, true))) {
            this.applyEditSegments();
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (this.segments != null && limit > 0) {
            OS.SendMessage(this.handle, 321, limit + Math.min(this.segments.length, LIMIT - limit), 0);
        } else {
            OS.SendMessage(this.handle, 321, limit, 0);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        int hwndList = OS.GetDlgItem(this.handle, 1000);
        if (hwndText != 0) {
            shell.setToolTipText(hwndText, string);
        }
        if (hwndList != 0) {
            shell.setToolTipText(hwndList, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
        this.updateDropDownHeight();
    }

    @Override
    void subclass() {
        int hwndList;
        super.subclass();
        int newProc = this.display.windowProc;
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0) {
            OS.SetWindowLongPtr(hwndText, -4, newProc);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLongPtr(hwndList, -4, newProc);
        }
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int i = 0;
        int nSegments = this.segments.length;
        while (i < nSegments && offset - i >= this.segments[i]) {
            ++offset;
            ++i;
        }
        return offset;
    }

    @Override
    boolean translateTraversal(MSG msg) {
        switch (msg.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                return false;
            }
        }
        return super.translateTraversal(msg);
    }

    @Override
    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    @Override
    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseReturn();
    }

    @Override
    void unsubclass() {
        int hwndList;
        super.unsubclass();
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText != 0 && EditProc != 0) {
            OS.SetWindowLongPtr(hwndText, -4, EditProc);
        }
        if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLongPtr(hwndList, -4, ListProc);
        }
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int i = 0;
        int nSegments = this.segments.length;
        while (i < nSegments && offset > this.segments[i]) {
            --offset;
            ++i;
        }
        return offset;
    }

    void updateDropDownHeight() {
        if ((this.style & 4) != 0) {
            RECT rect = new RECT();
            OS.SendMessage(this.handle, 338, 0, rect);
            int visibleCount = this.getItemCount() == 0 ? 5 : this.visibleCount;
            int height = this.getTextHeightInPixels() + this.getItemHeightInPixels() * visibleCount + 2;
            if (height != rect.bottom - rect.top) {
                this.forceResize();
                OS.GetWindowRect(this.handle, rect);
                int flags = 54;
                this.SetWindowPos(this.handle, 0, 0, 0, rect.right - rect.left, height, flags);
            }
        }
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            if (textDirection == 0x6000000 && !OS.IsUnicode) {
                this.state &= 0xFFBFFFFF;
                return false;
            }
            this.clearSegments(true);
            this.applyEditSegments();
            this.applyListSegments();
            return true;
        }
        return false;
    }

    @Override
    void updateOrientation() {
        int bits1;
        int bits = OS.GetWindowLong(this.handle, -20);
        bits = (this.style & 0x4000000) != 0 ? (bits |= 0x400000) : (bits &= 0xFFBFFFFF);
        OS.SetWindowLong(this.handle, -20, bits &= 0xFFFFDFFF);
        int hwndText = 0;
        int hwndList = 0;
        COMBOBOXINFO pcbi = new COMBOBOXINFO();
        pcbi.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, pcbi)) {
            hwndText = pcbi.hwndItem;
            hwndList = pcbi.hwndList;
        }
        if (hwndText != 0) {
            bits1 = OS.GetWindowLong(hwndText, -20);
            int bits2 = OS.GetWindowLong(hwndText, -16);
            if ((this.style & 0x4000000) != 0) {
                bits1 |= 0x3000;
                bits2 |= 2;
            } else {
                bits1 &= 0xFFFFCFFF;
                bits2 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(hwndText, -20, bits1);
            OS.SetWindowLong(hwndText, -16, bits2);
            RECT rect = new RECT();
            OS.GetWindowRect(hwndText, rect);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            OS.GetWindowRect(this.handle, rect);
            int widthCombo = rect.right - rect.left;
            int heightCombo = rect.bottom - rect.top;
            int uFlags = 22;
            this.SetWindowPos(hwndText, 0, 0, 0, width - 1, height - 1, uFlags);
            this.SetWindowPos(this.handle, 0, 0, 0, widthCombo - 1, heightCombo - 1, uFlags);
            this.SetWindowPos(hwndText, 0, 0, 0, width, height, uFlags);
            this.SetWindowPos(this.handle, 0, 0, 0, widthCombo, heightCombo, uFlags);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (hwndList != 0) {
            bits1 = OS.GetWindowLong(hwndList, -20);
            bits1 = (this.style & 0x4000000) != 0 ? (bits1 |= 0x400000) : (bits1 &= 0xFFBFFFFF);
            OS.SetWindowLong(hwndList, -20, bits1);
        }
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event.start = this.mbcsToWcsPos(start);
            event.end = this.mbcsToWcsPos(end);
        }
        event.start = this.untranslateOffset(event.start);
        event.end = this.untranslateOffset(event.end);
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    int wcsToMbcsPos(int wcsPos) {
        if (wcsPos <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return wcsPos;
        }
        int hwndText = OS.GetDlgItem(this.handle, 1001);
        if (hwndText == 0) {
            return wcsPos;
        }
        int mbcsSize = OS.GetWindowTextLengthA(hwndText);
        if (mbcsSize == 0) {
            return 0;
        }
        byte[] buffer = new byte[mbcsSize + 1];
        OS.GetWindowTextA(hwndText, buffer, mbcsSize + 1);
        int mbcsPos = 0;
        int wcsCount = 0;
        while (mbcsPos < mbcsSize) {
            if (wcsPos == wcsCount) break;
            if (OS.IsDBCSLeadByte(buffer[mbcsPos++])) {
                ++mbcsPos;
            }
            ++wcsCount;
        }
        return mbcsPos;
    }

    @Override
    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return bits | 1;
        }
        if ((this.style & 8) != 0) {
            return bits | 3;
        }
        return bits | 2;
    }

    @Override
    TCHAR windowClass() {
        return ComboClass;
    }

    @Override
    int windowProc() {
        return ComboProc;
    }

    @Override
    int windowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        if (hwnd != this.handle) {
            int hwndText = OS.GetDlgItem(this.handle, 1001);
            int hwndList = OS.GetDlgItem(this.handle, 1000);
            if (hwndText != 0 && hwnd == hwndText || hwndList != 0 && hwnd == hwndList) {
                LRESULT result = null;
                boolean processSegments = false;
                boolean redraw = false;
                switch (msg) {
                    case 258: {
                        processSegments = (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) && !this.ignoreCharacter && OS.GetKeyState(17) >= 0 && OS.GetKeyState(18) >= 0;
                        result = this.wmChar(hwnd, wParam, lParam);
                        break;
                    }
                    case 646: {
                        result = this.wmIMEChar(hwnd, wParam, lParam);
                        break;
                    }
                    case 256: {
                        processSegments = wParam == 46 && (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0);
                        result = this.wmKeyDown(hwnd, wParam, lParam);
                        break;
                    }
                    case 257: {
                        result = this.wmKeyUp(hwnd, wParam, lParam);
                        break;
                    }
                    case 262: {
                        result = this.wmSysChar(hwnd, wParam, lParam);
                        break;
                    }
                    case 260: {
                        result = this.wmSysKeyDown(hwnd, wParam, lParam);
                        break;
                    }
                    case 261: {
                        result = this.wmSysKeyUp(hwnd, wParam, lParam);
                        break;
                    }
                    case 533: {
                        result = this.wmCaptureChanged(hwnd, wParam, lParam);
                        break;
                    }
                    case 515: {
                        result = this.wmLButtonDblClk(hwnd, wParam, lParam);
                        break;
                    }
                    case 513: {
                        result = this.wmLButtonDown(hwnd, wParam, lParam);
                        break;
                    }
                    case 514: {
                        result = this.wmLButtonUp(hwnd, wParam, lParam);
                        break;
                    }
                    case 521: {
                        result = this.wmMButtonDblClk(hwnd, wParam, lParam);
                        break;
                    }
                    case 519: {
                        result = this.wmMButtonDown(hwnd, wParam, lParam);
                        break;
                    }
                    case 520: {
                        result = this.wmMButtonUp(hwnd, wParam, lParam);
                        break;
                    }
                    case 673: {
                        result = this.wmMouseHover(hwnd, wParam, lParam);
                        break;
                    }
                    case 675: {
                        result = this.wmMouseLeave(hwnd, wParam, lParam);
                        break;
                    }
                    case 512: {
                        result = this.wmMouseMove(hwnd, wParam, lParam);
                        break;
                    }
                    case 518: {
                        result = this.wmRButtonDblClk(hwnd, wParam, lParam);
                        break;
                    }
                    case 516: {
                        result = this.wmRButtonDown(hwnd, wParam, lParam);
                        break;
                    }
                    case 517: {
                        result = this.wmRButtonUp(hwnd, wParam, lParam);
                        break;
                    }
                    case 525: {
                        result = this.wmXButtonDblClk(hwnd, wParam, lParam);
                        break;
                    }
                    case 523: {
                        result = this.wmXButtonDown(hwnd, wParam, lParam);
                        break;
                    }
                    case 524: {
                        result = this.wmXButtonUp(hwnd, wParam, lParam);
                        break;
                    }
                    case 15: {
                        result = this.wmPaint(hwnd, wParam, lParam);
                        break;
                    }
                    case 123: {
                        result = this.wmContextMenu(hwnd, wParam, lParam);
                        break;
                    }
                    case 198: {
                        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                        return 0;
                    }
                    case 199: 
                    case 772: {
                        if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                            return 0;
                        }
                    }
                    case 768: 
                    case 769: 
                    case 770: 
                    case 771: {
                        processSegments = this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0;
                    }
                    case 12: {
                        if (hwnd != hwndText) break;
                        result = this.wmClipboard(hwnd, msg, wParam, lParam);
                    }
                }
                if (result != null) {
                    return result.value;
                }
                if (processSegments) {
                    if (this.getDrawing() && OS.IsWindowVisible(hwndText)) {
                        redraw = true;
                        OS.DefWindowProc(hwndText, 11, 0, 0);
                    }
                    this.clearSegments(true);
                    int code = this.callWindowProc(hwnd, msg, wParam, lParam);
                    this.applyEditSegments();
                    if (redraw) {
                        OS.DefWindowProc(hwndText, 11, 1, 0);
                        OS.InvalidateRect(hwndText, null, true);
                    }
                    return code;
                }
                return this.callWindowProc(hwnd, msg, wParam, lParam);
            }
        }
        switch (msg) {
            case 334: {
                int code = -1;
                int index = wParam;
                if ((this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
                    String oldText = this.getText();
                    String newText = null;
                    if (wParam == -1) {
                        newText = "";
                    } else if (wParam >= 0 && wParam < this.getItemCount()) {
                        newText = this.getItem(wParam);
                    }
                    if (newText != null && !newText.equals(oldText)) {
                        int length = OS.GetWindowTextLength(this.handle);
                        oldText = newText;
                        if ((newText = this.verifyText(newText, 0, length, null)) == null) {
                            return 0;
                        }
                        if (!newText.equals(oldText) && (index = this.indexOf(newText)) != -1 && index != wParam) {
                            return this.callWindowProc(this.handle, 334, index, lParam);
                        }
                    }
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0 || (code = super.windowProc(hwnd, msg, wParam, lParam)) == -1 || code == -2) break;
                Event event = this.getSegments(this.items[index]);
                int[] nArray = this.segments = event != null ? event.segments : null;
                if (event.segmentsChars != null) {
                    int auto = this.state & 0x400000;
                    if (event.segmentsChars[0] == '\u202b') {
                        super.updateTextDirection(0x4000000);
                    } else if (event.segmentsChars[0] == '\u202a') {
                        super.updateTextDirection(0x2000000);
                    }
                    this.state |= auto;
                }
                return code;
            }
            case 323: 
            case 330: 
            case 344: {
                if (lParam == 0 || !this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                int code = -1;
                int length = OS.IsUnicode ? OS.wcslen(lParam) : OS.strlen(lParam);
                TCHAR buffer = new TCHAR(this.getCodePage(), length);
                OS.MoveMemory(buffer, lParam, buffer.length() * TCHAR.sizeof);
                String string = buffer.toString(0, length);
                Event event = this.getSegments(string);
                if (event != null && event.segments != null) {
                    buffer = new TCHAR(this.getCodePage(), this.getSegmentsText(string, event), true);
                    int hHeap = OS.GetProcessHeap();
                    length = buffer.length() * TCHAR.sizeof;
                    int pszText = OS.HeapAlloc(hHeap, 8, length);
                    OS.MoveMemory(pszText, buffer, length);
                    code = super.windowProc(hwnd, msg, wParam, pszText);
                    OS.HeapFree(hHeap, 0, pszText);
                }
                if (msg == 323 || msg == 330) {
                    int index = msg == 323 ? this.items.length : wParam;
                    String[] newItems = new String[this.items.length + 1];
                    System.arraycopy(this.items, 0, newItems, 0, index);
                    newItems[index] = string;
                    System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
                    this.items = newItems;
                }
                if (code == -1 || code == -2) break;
                return code;
            }
            case 324: {
                int index;
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                int code = super.windowProc(hwnd, msg, wParam, lParam);
                if (code != -1 && code != -2) {
                    index = wParam;
                    if (this.items.length == 1) {
                        this.items = new String[0];
                    } else if (this.items.length > 1) {
                        String[] newItems = new String[this.items.length - 1];
                        System.arraycopy(this.items, 0, newItems, 0, index);
                        System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
                        this.items = newItems;
                    }
                    if (!this.noSelection && (index = OS.SendMessage(this.handle, 327, 0, 0)) == wParam) {
                        this.clearSegments(false);
                        this.applyEditSegments();
                    }
                }
                return code;
            }
            case 331: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                if (this.items.length > 0) {
                    this.items = new String[0];
                }
                this.clearSegments(false);
                this.applyEditSegments();
            }
        }
        return super.windowProc(hwnd, msg, wParam, lParam);
    }

    @Override
    LRESULT WM_CTLCOLOR(int wParam, int lParam) {
        return this.wmColorChild(wParam, lParam);
    }

    @Override
    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        int code = this.callWindowProc(this.handle, 135, wParam, lParam);
        return new LRESULT(code | 1);
    }

    @Override
    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(wParam, lParam);
        }
        return null;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        int newSelection;
        int oldSelection = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if ((this.style & 8) == 0 && oldSelection != (newSelection = OS.SendMessage(this.handle, 327, 0, 0))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendSelectionEvent(13, null, true);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        return null;
    }

    @Override
    LRESULT WM_SIZE(int wParam, int lParam) {
        if (this.ignoreResize) {
            return null;
        }
        if ((this.style & 0x40) != 0) {
            LRESULT result = super.WM_SIZE(wParam, lParam);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    int hwndList;
                    int hwndText = OS.GetDlgItem(this.handle, 1001);
                    if (hwndText != 0) {
                        OS.InvalidateRect(hwndText, null, true);
                    }
                    if ((hwndList = OS.GetDlgItem(this.handle, 1000)) != 0) {
                        OS.InvalidateRect(hwndList, null, true);
                    }
                } else {
                    int uFlags = 133;
                    OS.RedrawWindow(this.handle, null, 0, uFlags);
                }
            }
            return result;
        }
        boolean oldLockText = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if ((this.style & 8) == 0) {
            this.lockText = oldLockText;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return result;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(int wParam, int lParam) {
        LRESULT result = super.WM_UPDATEUISTATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, true);
        return result;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int wParam, int lParam) {
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (OS.IsWinCE) {
            return result;
        }
        if (!this.getDrawing()) {
            return result;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return result;
        }
        if (this.ignoreResize) {
            WINDOWPOS lpwp = new WINDOWPOS();
            OS.MoveMemory(lpwp, lParam, WINDOWPOS.sizeof);
            if ((lpwp.flags & 1) == 0) {
                lpwp.flags |= 8;
                OS.MoveMemory(lParam, lpwp, WINDOWPOS.sizeof);
                OS.InvalidateRect(this.handle, null, true);
                RECT rect = new RECT();
                OS.GetWindowRect(this.handle, rect);
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                if (width != 0 && height != 0) {
                    int hwndParent = this.parent.handle;
                    int hwndChild = OS.GetWindow(hwndParent, 5);
                    OS.MapWindowPoints(0, hwndParent, rect, 2);
                    int rgn1 = OS.CreateRectRgn(rect.left, rect.top, rect.right, rect.bottom);
                    while (hwndChild != 0) {
                        if (hwndChild != this.handle) {
                            OS.GetWindowRect(hwndChild, rect);
                            OS.MapWindowPoints(0, hwndParent, rect, 2);
                            int rgn2 = OS.CreateRectRgn(rect.left, rect.top, rect.right, rect.bottom);
                            OS.CombineRgn(rgn1, rgn1, rgn2, 4);
                            OS.DeleteObject(rgn2);
                        }
                        hwndChild = OS.GetWindow(hwndChild, 2);
                    }
                    int flags = 1029;
                    OS.RedrawWindow(hwndParent, null, rgn1, flags);
                    OS.DeleteObject(rgn1);
                }
            }
        }
        return result;
    }

    @Override
    LRESULT wmChar(int hwnd, int wParam, int lParam) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT result = super.wmChar(hwnd, wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.sendSelectionEvent(14);
                }
                this.ignoreDefaultSelection = false;
                if (this.getSelectionIndex() == -1 && (this.style & 4) != 0 && (this.style & 8) == 0) {
                    if (OS.SendMessage(this.handle, 343, 0, 0) != 0) {
                        OS.SendMessage(this.handle, 335, 0, 0);
                    }
                    return LRESULT.ZERO;
                }
            }
            case 27: {
                if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) == 0) {
                    return LRESULT.ZERO;
                }
            }
            case 127: {
                String actText;
                Matcher m;
                if (OS.GetKeyState(17) >= 0) break;
                if ((this.style & 8) != 0) {
                    return LRESULT.ZERO;
                }
                Point selection = this.getSelection();
                int hwndText = OS.GetDlgItem(this.handle, 1001);
                int x = selection.x;
                int y = selection.y;
                if (x == y && (m = CTRL_BS_PATTERN.matcher(actText = this.getText().substring(0, x))).find()) {
                    x = m.start();
                    y = m.end();
                    OS.SendMessage(hwndText, 177, x, y);
                }
                if (x < y) {
                    OS.SendMessage(hwndText, 194, 1, 0);
                }
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT wmClipboard(int hwndText, int msg, int wParam, int lParam) {
        TCHAR buffer;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean call = false;
        int[] start = new int[1];
        int[] end = new int[1];
        String newText = null;
        switch (msg) {
            case 768: 
            case 771: {
                OS.SendMessage(hwndText, 176, start, end);
                if (this.untranslateOffset(start[0]) == this.untranslateOffset(end[0])) break;
                newText = "";
                call = true;
                break;
            }
            case 770: {
                OS.SendMessage(hwndText, 176, start, end);
                newText = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(hwndText, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, hwndText, msg, wParam, lParam);
                int length = OS.GetWindowTextLength(hwndText);
                int[] newStart = new int[1];
                int[] newEnd = new int[1];
                OS.SendMessage(hwndText, 176, newStart, newEnd);
                if (length != 0 && newStart[0] != newEnd[0]) {
                    TCHAR buffer2 = new TCHAR(this.getCodePage(), length + 1);
                    OS.GetWindowText(hwndText, buffer2, length + 1);
                    newText = buffer2.toString(newStart[0], newEnd[0] - newStart[0]);
                } else {
                    newText = "";
                }
                OS.CallWindowProc(EditProc, hwndText, msg, wParam, lParam);
                OS.SendMessage(hwndText, 176, start, end);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                if (this.lockText) {
                    return null;
                }
                end[0] = OS.GetWindowTextLength(hwndText);
                int length = OS.IsUnicode ? OS.wcslen(lParam) : OS.strlen(lParam);
                buffer = new TCHAR(this.getCodePage(), length);
                int byteCount = buffer.length() * TCHAR.sizeof;
                OS.MoveMemory(buffer, lParam, byteCount);
                newText = buffer.toString(0, length);
            }
        }
        if (newText != null) {
            String oldText = newText;
            if ((newText = this.verifyText(newText, start[0], end[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!newText.equals(oldText)) {
                if (call) {
                    OS.CallWindowProc(EditProc, hwndText, msg, wParam, lParam);
                }
                buffer = new TCHAR(this.getCodePage(), newText, true);
                if (msg == 12) {
                    int hHeap = OS.GetProcessHeap();
                    int byteCount = buffer.length() * TCHAR.sizeof;
                    int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                    OS.MoveMemory(pszText, buffer, byteCount);
                    int code = OS.CallWindowProc(EditProc, hwndText, msg, wParam, pszText);
                    OS.HeapFree(hHeap, 0, pszText);
                    return new LRESULT(code);
                }
                OS.SendMessage(hwndText, 194, 0, buffer);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    @Override
    LRESULT wmCommandChild(int wParam, int lParam) {
        int code = OS.HIWORD(wParam);
        switch (code) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int index = OS.SendMessage(this.handle, 327, 0, 0);
                if (index != -1) {
                    OS.SendMessage(this.handle, 334, index, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 7: {
                this.setCursor();
                this.updateDropDownHeight();
                break;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (!event.doit) {
                    int hwnd = lParam;
                    int bits1 = OS.GetWindowLong(hwnd, -20);
                    int bits2 = OS.GetWindowLong(hwnd, -16);
                    if (code == 1792) {
                        bits1 |= 0x3000;
                        bits2 |= 2;
                    } else {
                        bits1 &= 0xFFFFCFFF;
                        bits2 &= 0xFFFFFFFD;
                    }
                    OS.SetWindowLong(hwnd, -20, bits1);
                    OS.SetWindowLong(hwnd, -16, bits2);
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                this.clearSegments(true);
                this.state &= 0xFFBFFFFF;
                this.applyEditSegments();
            }
        }
        return super.wmCommandChild(wParam, lParam);
    }

    @Override
    LRESULT wmIMEChar(int hwnd, int wParam, int lParam) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = wParam;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, wParam, lParam)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int result = this.callWindowProc(hwnd, 646, wParam, lParam);
        MSG msg = new MSG();
        int flags = 10420227;
        while (OS.PeekMessage(msg, hwnd, 258, 258, flags)) {
            OS.TranslateMessage(msg);
            OS.DispatchMessage(msg);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, wParam, lParam);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(result);
    }

    @Override
    LRESULT wmKeyDown(int hwnd, int wParam, int lParam) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT result = super.wmKeyDown(hwnd, wParam, lParam);
        if (result != null) {
            return result;
        }
        this.ignoreDefaultSelection = false;
        switch (wParam) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (this.segments == null) break;
                int code = 0;
                int[] start = new int[1];
                int[] end = new int[1];
                int[] newStart = new int[1];
                int[] newEnd = new int[1];
                OS.SendMessage(this.handle, 320, start, end);
                while (true) {
                    code = this.callWindowProc(hwnd, 256, wParam, lParam);
                    OS.SendMessage(this.handle, 320, newStart, newEnd);
                    if (newStart[0] != start[0] ? this.untranslateOffset(newStart[0]) != this.untranslateOffset(start[0]) : newEnd[0] == end[0] || this.untranslateOffset(newEnd[0]) != this.untranslateOffset(end[0])) break;
                    start[0] = newStart[0];
                    end[0] = newEnd[0];
                }
                result = code == 0 ? LRESULT.ZERO : new LRESULT(code);
                break;
            }
            case 13: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                this.ignoreDefaultSelection = true;
            }
        }
        return result;
    }

    @Override
    LRESULT wmSysKeyDown(int hwnd, int wParam, int lParam) {
        int oldSelection = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT result = super.wmSysKeyDown(hwnd, wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 8) == 0 && wParam == 40) {
            int code = this.callWindowProc(hwnd, 260, wParam, lParam);
            int newSelection = OS.SendMessage(this.handle, 327, 0, 0);
            if (oldSelection != newSelection) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13, null, true);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(code);
        }
        return result;
    }
}

