/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Activator;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.dto.ExtendedServletDTO;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestWrapperImpl;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    protected static final String MULTIPART_SERVLET_NAME_KEY = "multipart.servlet.name";
    private HttpServiceRuntimeImpl httpServiceRuntimeImpl;
    private String multipartServletName;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.multipartServletName = this.getInitParameter(MULTIPART_SERVLET_NAME_KEY);
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.unregisterHttpService(this);
        super.destroy();
    }

    public void setHttpServiceRuntimeImpl(HttpServiceRuntimeImpl httpServiceRuntimeImpl) {
        this.httpServiceRuntimeImpl = httpServiceRuntimeImpl;
    }

    public void sessionIdChanged(String oldSessionId) {
        this.httpServiceRuntimeImpl.fireSessionIdChanged(oldSessionId);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EndpointRegistration<?> endpointRegistration;
        DispatchTargets dispatchTargets;
        this.checkRuntime();
        String alias = HttpServletRequestWrapperImpl.getDispatchPathInfo(request);
        if (alias == null) {
            alias = "/";
        }
        if ((dispatchTargets = this.httpServiceRuntimeImpl.getDispatchTargets(alias, null)) != null && this.multipartServletName != null && (endpointRegistration = dispatchTargets.getServletRegistration()) instanceof ServletRegistration) {
            RequestDispatcher multipartDispatcher;
            ServletRegistration servletRegistration = (ServletRegistration)endpointRegistration;
            if (((ExtendedServletDTO)((Object)servletRegistration.getD())).multipartSupported && (multipartDispatcher = this.getServletContext().getNamedDispatcher(this.multipartServletName)) != null) {
                request.setAttribute(DispatchTargets.class.getName(), (Object)dispatchTargets);
                multipartDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        if (dispatchTargets != null) {
            dispatchTargets.doDispatch(request, response, alias, request.getDispatcherType());
            return;
        }
        response.sendError(404, "ProxyServlet: " + alias);
    }

    private void checkRuntime() {
        if (this.httpServiceRuntimeImpl == null) {
            throw new IllegalStateException("Proxy servlet not properly initialized. httpServiceRuntimeImpl is null");
        }
    }
}

