/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDEPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode(IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName());
        node.put("PROJECT_OPEN_NEW_PERSPECTIVE", "OPEN_PERSPECTIVE_REPLACE");
        node.putBoolean("SHOW_WORKSPACE_SELECTION_DIALOG", true);
        node.putBoolean("SAVE_ALL_BEFORE_BUILD", false);
        node.putInt("saveInterval", 5);
        node.putBoolean("WELCOME_DIALOG", true);
        node.putBoolean("REFRESH_WORKSPACE_ON_STARTUP", false);
        node.putBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", true);
        node.put("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION", "prompt");
        node.put("OPEN_REQUIRED_PROJECTS", "prompt");
        node.putBoolean("CLOSE_UNRELATED_PROJECTS", false);
        node.putBoolean("WARN_ABOUT_WORKSPACE_INCOMPATIBILITY", true);
        node.putBoolean(this.getHelpSeparatorKey("group.main"), true);
        node.putBoolean(this.getHelpSeparatorKey("group.assist"), true);
        node.putBoolean(this.getHelpSeparatorKey("group.updates"), true);
        node.putBoolean("LIMIT_PROBLEMS", true);
        node.putInt("PROBLEMS_LIMIT", 100);
        node.putBoolean("LIMIT_BOOKMARKS", true);
        node.putInt("BOOKMARKS_LIMIT", 100);
        node.putBoolean("LIMIT_TASKS", true);
        node.putInt("TASKS_LIMIT", 100);
        node.putBoolean("USE_MARKER_LIMITS", true);
        node.putInt("MARKER_LIMITS_VALUE", 100);
        node.put("IMPORT_FILES_AND_FOLDERS_TYPE", "");
        node.putBoolean("IMPORT_FILES_AND_FOLDERS_RELATIVE", true);
        node.putBoolean("BOOKMARKS_FILTERS_MIGRATE", false);
        node.putBoolean("TASKS_FILTERS_MIGRATE", false);
        node.putBoolean("PROBLEMS_FILTERS_MIGRATE", false);
        node.put("IMPORT_FILES_AND_FOLDERS_MODE", "prompt");
        node.put("IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE", "prompt");
        node.put("SYSTEM_EXPLORER", IDEPreferenceInitializer.getShowInSystemExplorerCommand());
        node.put("unassociatedEditorStrategy", "org.eclipse.ui.ide.systemEditorThenTextEditor");
    }

    public static String getShowInSystemExplorerCommand() {
        if (Util.isGtk()) {
            return "dbus-send --print-reply --dest=org.freedesktop.FileManager1 /org/freedesktop/FileManager1 org.freedesktop.FileManager1.ShowItems array:string:\"${selected_resource_uri}\" string:\"\"";
        }
        if (Util.isWindows()) {
            return "explorer /E,/select=${selected_resource_loc}";
        }
        if (Util.isMac()) {
            return "open -R \"${selected_resource_loc}\"";
        }
        return "";
    }

    private String getHelpSeparatorKey(String groupId) {
        return "useSeparator.help." + groupId;
    }
}

