/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerRow;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractTreeViewer {
    private static final String VIRTUAL_DISPOSE_KEY = "org.eclipse.jface.DISPOSE_LISTENER";
    private Tree tree;
    private boolean treeIsDisposed = false;
    private boolean contentProviderIsLazy;
    private boolean contentProviderIsTreeBased;
    private TreeViewerRow cachedRow;
    private boolean insidePreservingSelection;

    public TreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public TreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public TreeViewer(Tree tree) {
        this.tree = tree;
        this.hookControl((Control)tree);
    }

    @Override
    protected void addTreeListener(Control c, TreeListener listener) {
        ((Tree)c).addTreeListener(listener);
    }

    @Override
    protected Widget getColumnViewerOwner(int columnIndex) {
        if (columnIndex < 0 || columnIndex > 0 && columnIndex >= this.getTree().getColumnCount()) {
            return null;
        }
        if (this.getTree().getColumnCount() == 0) {
            return this.getTree();
        }
        return this.getTree().getColumn(columnIndex);
    }

    @Override
    protected Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.tree;
    }

    @Override
    protected boolean getExpanded(Item item) {
        return ((TreeItem)item).getExpanded();
    }

    @Override
    protected Item getItemAt(Point p) {
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length == 1) {
            int columnCount = this.tree.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                if (selection[0].getBounds(i).contains(p)) {
                    return selection[0];
                }
                ++i;
            }
        }
        return this.getTree().getItem(p);
    }

    @Override
    protected int getItemCount(Control widget) {
        return ((Tree)widget).getItemCount();
    }

    @Override
    protected int getItemCount(Item item) {
        return ((TreeItem)item).getItemCount();
    }

    @Override
    protected Item[] getItems(Item item) {
        return ((TreeItem)item).getItems();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    @Override
    protected Item getParentItem(Item item) {
        return ((TreeItem)item).getParentItem();
    }

    @Override
    protected Item[] getSelection(Control widget) {
        return ((Tree)widget).getSelection();
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree treeControl = (Tree)control;
        if ((treeControl.getStyle() & 0x10000000) != 0) {
            treeControl.addDisposeListener(e -> {
                this.treeIsDisposed = true;
                this.unmapAllElements();
            });
            treeControl.addListener(36, event -> {
                if (this.contentProviderIsLazy) {
                    TreeItem item = (TreeItem)event.item;
                    TreeItem parentItem = item.getParentItem();
                    int index = event.index;
                    this.virtualLazyUpdateWidget((Widget)(parentItem == null ? this.getTree() : parentItem), index);
                }
            });
        }
    }

    @Override
    protected ColumnViewerEditor createViewerEditor() {
        return new TreeViewerEditor(this, null, new ColumnViewerEditorActivationStrategy(this), 1);
    }

    @Override
    protected Item newItem(Widget parent, int flags, int ix) {
        TreeItem item = parent instanceof TreeItem ? (TreeItem)this.createNewRowPart(this.getViewerRowFromItem(parent), flags, ix).getItem() : (TreeItem)this.createNewRowPart(null, flags, ix).getItem();
        return item;
    }

    @Override
    protected void removeAll(Control widget) {
        ((Tree)widget).removeAll();
    }

    @Override
    protected void setExpanded(Item node, boolean expand) {
        ((TreeItem)node).setExpanded(expand);
        if (this.contentProviderIsLazy) {
            this.getControl().update();
        }
    }

    @Override
    protected void setSelection(List items) {
        Item[] current = this.getSelection((Control)this.getTree());
        if (this.isSameSelection(items, current)) {
            return;
        }
        TreeItem[] newItems = new TreeItem[items.size()];
        items.toArray(newItems);
        this.getTree().setSelection(newItems);
    }

    @Override
    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }

    @Override
    protected Item getChild(Widget widget, int index) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItem(index);
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItem(index);
        }
        return null;
    }

    @Override
    protected void assertContentProviderType(IContentProvider provider) {
        if (provider instanceof ILazyTreeContentProvider || provider instanceof ILazyTreePathContentProvider) {
            return;
        }
        super.assertContentProviderType(provider);
    }

    @Override
    protected Object[] getRawChildren(Object parent) {
        if (this.contentProviderIsLazy) {
            return new Object[0];
        }
        return super.getRawChildren(parent);
    }

    @Override
    void preservingSelection(Runnable updateCode, boolean reveal) {
        if (this.insidePreservingSelection || !this.getPreserveSelection()) {
            updateCode.run();
            return;
        }
        this.insidePreservingSelection = true;
        try {
            super.preservingSelection(updateCode, reveal);
        }
        finally {
            this.insidePreservingSelection = false;
        }
    }

    public void setChildCount(Object elementOrTreePath, int count) {
        if (this.checkBusy()) {
            return;
        }
        this.preservingSelection(() -> {
            Widget[] items;
            if (this.internalIsInputOrEmptyPath(elementOrTreePath)) {
                this.getTree().setItemCount(count);
                return;
            }
            Widget[] widgetArray = items = this.internalFindItems(elementOrTreePath);
            int n2 = items.length;
            int n3 = 0;
            while (n3 < n2) {
                Widget item = widgetArray[n3];
                TreeItem treeItem = (TreeItem)item;
                treeItem.setItemCount(count);
                ++n3;
            }
        });
    }

    public void replace(Object parentElementOrTreePath, int index, Object element) {
        TreeSelection selection;
        block13: {
            Widget[] parentItems;
            Widget[] itemsToDisassociate;
            Item[] selectedItems;
            block12: {
                if (this.checkBusy()) {
                    return;
                }
                selectedItems = this.getSelection(this.getControl());
                selection = (TreeSelection)this.getSelection();
                if (parentElementOrTreePath instanceof TreePath) {
                    TreePath elementPath = ((TreePath)parentElementOrTreePath).createChildPath(element);
                    itemsToDisassociate = this.internalFindItems(elementPath);
                } else {
                    itemsToDisassociate = this.internalFindItems(element);
                }
                if (!this.internalIsInputOrEmptyPath(parentElementOrTreePath)) break block12;
                if (index >= this.tree.getItemCount()) break block13;
                TreeItem item = this.tree.getItem(index);
                selection = this.adjustSelectionForReplace(selectedItems, selection, item, element, this.getRoot());
                Widget[] widgetArray = itemsToDisassociate;
                int n = itemsToDisassociate.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem itemToDisassociate;
                    Widget widget = widgetArray[n2];
                    if (widget instanceof TreeItem && (itemToDisassociate = (TreeItem)widget) != item && itemToDisassociate.getParentItem() == null) {
                        int indexToDisassociate = this.getTree().indexOf(itemToDisassociate);
                        this.disassociate((Item)itemToDisassociate);
                        this.getTree().clear(indexToDisassociate, true);
                    }
                    ++n2;
                }
                Object oldData = item.getData();
                this.updateItem((Widget)item, element);
                if (this.equals(oldData, element)) break block13;
                item.clearAll(true);
                break block13;
            }
            Widget[] widgetArray = parentItems = this.internalFindItems(parentElementOrTreePath);
            int n = parentItems.length;
            int n3 = 0;
            while (n3 < n) {
                Widget widget = widgetArray[n3];
                TreeItem parentItem = (TreeItem)widget;
                if (index < parentItem.getItemCount()) {
                    TreeItem item = parentItem.getItem(index);
                    selection = this.adjustSelectionForReplace(selectedItems, selection, item, element, parentItem.getData());
                    Widget[] widgetArray2 = itemsToDisassociate;
                    int n4 = itemsToDisassociate.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        TreeItem itemToDisassociate;
                        Widget widgetToDisassociate = widgetArray2[n5];
                        if (widgetToDisassociate instanceof TreeItem && (itemToDisassociate = (TreeItem)widgetToDisassociate) != item && itemToDisassociate.getParentItem() == parentItem) {
                            int indexToDisaccociate = parentItem.indexOf(itemToDisassociate);
                            this.disassociate((Item)itemToDisassociate);
                            parentItem.clear(indexToDisaccociate, true);
                        }
                        ++n5;
                    }
                    Object oldData = item.getData();
                    this.updateItem((Widget)item, element);
                    if (!this.equals(oldData, element)) {
                        item.clearAll(true);
                    }
                }
                ++n3;
            }
        }
        if (!this.insidePreservingSelection) {
            this.setSelectionToWidget(selection, false);
            ISelection newSelection = this.getSelection();
            if (!newSelection.equals(selection)) {
                this.handleInvalidSelection(selection, newSelection);
            }
        }
    }

    private TreeSelection adjustSelectionForReplace(Item[] selectedItems, TreeSelection selection, TreeItem item, Object element, Object parentElement) {
        if (item.getData() != null || selectedItems.length == selection.size() || parentElement == null) {
            return selection;
        }
        Item[] itemArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item selectedItem = itemArray[n2];
            if (item == selectedItem) {
                TreePath[] originalPaths = selection.getPaths();
                int length = originalPaths.length;
                TreePath[] paths = new TreePath[length + 1];
                System.arraycopy(originalPaths, 0, paths, 0, length);
                item.setData(element);
                paths[length] = this.getTreePathFromItem((Item)item);
                item.setData(null);
                return new TreeSelection(paths, selection.getElementComparer());
            }
            ++n2;
        }
        return selection;
    }

    @Override
    public boolean isExpandable(Object element) {
        if (this.contentProviderIsLazy) {
            TreeItem treeItem = (TreeItem)this.internalExpand(element, false);
            if (treeItem == null) {
                return false;
            }
            this.virtualMaterializeItem(treeItem);
            return treeItem.getItemCount() > 0;
        }
        return super.isExpandable(element);
    }

    @Override
    protected Object getParentElement(Object element) {
        boolean oldBusy = this.isBusy();
        this.setBusy(true);
        try {
            ILazyTreePathContentProvider lazyTreePathContentProvider;
            TreePath[] parents;
            if (this.contentProviderIsLazy && !this.contentProviderIsTreeBased && !(element instanceof TreePath)) {
                ILazyTreeContentProvider lazyTreeContentProvider = (ILazyTreeContentProvider)this.getContentProvider();
                Object object = lazyTreeContentProvider.getParent(element);
                return object;
            }
            if (this.contentProviderIsLazy && this.contentProviderIsTreeBased && !(element instanceof TreePath) && (parents = (lazyTreePathContentProvider = (ILazyTreePathContentProvider)this.getContentProvider()).getParents(element)) != null && parents.length > 0) {
                TreePath treePath = parents[0];
                return treePath;
            }
            Object object = super.getParentElement(element);
            return object;
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    @Override
    void createChildren(Widget widget, boolean materialize) {
        if (this.contentProviderIsLazy) {
            Object element = widget.getData();
            if (element == null && widget instanceof TreeItem) {
                this.virtualMaterializeItem((TreeItem)widget);
                element = widget.getData();
            }
            if (element == null) {
                return;
            }
            Item[] children = this.getChildren(widget);
            if (children.length == 1 && children[0].getData() == null) {
                this.virtualLazyUpdateChildCount(widget, children.length);
                children = this.getChildren(widget);
            }
            int i = 0;
            while (i < children.length) {
                if (children[i].getData() == null) {
                    if (materialize) {
                        this.virtualLazyUpdateWidget(widget, i);
                    } else {
                        ((TreeItem)children[i]).clearAll(true);
                    }
                }
                ++i;
            }
            return;
        }
        super.createChildren(widget, materialize);
    }

    @Override
    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        if (this.contentProviderIsLazy) {
            if (widget instanceof TreeItem) {
                TreeItem ti = (TreeItem)widget;
                int count = ti.getItemCount() + childElements.length;
                ti.setItemCount(count);
                ti.clearAll(false);
            } else {
                Tree t = (Tree)widget;
                t.setItemCount(t.getItemCount() + childElements.length);
                t.clearAll(false);
            }
            return;
        }
        super.internalAdd(widget, parentElement, childElements);
    }

    private void virtualMaterializeItem(TreeItem treeItem) {
        Object parentElement;
        if (treeItem.getData() != null) {
            return;
        }
        if (!this.contentProviderIsLazy) {
            return;
        }
        TreeItem parent = treeItem.getParentItem();
        if (parent == null) {
            parent = treeItem.getParent();
        }
        if ((parentElement = parent.getData()) != null) {
            int index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
            this.virtualLazyUpdateWidget((Widget)parent, index);
        }
    }

    @Override
    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        if (this.contentProviderIsLazy) {
            if (widget instanceof Tree) {
                ((Tree)widget).clearAll(true);
            } else if (widget instanceof TreeItem) {
                ((TreeItem)widget).clearAll(true);
            }
            int index = 0;
            TreeItem parent = null;
            if (widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                parent = treeItem.getParentItem();
                if (parent == null) {
                    parent = treeItem.getParent();
                }
                index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
            }
            this.virtualRefreshExpandedItems((Widget)parent, widget, element, index);
            return;
        }
        super.internalRefreshStruct(widget, element, updateLabels);
    }

    private void virtualRefreshExpandedItems(Widget parent, Widget widget, Object element, int index) {
        if (widget instanceof Tree) {
            if (element == null) {
                ((Tree)widget).setItemCount(0);
                return;
            }
            this.virtualLazyUpdateChildCount(widget, this.getChildren(widget).length);
        } else if (((TreeItem)widget).getExpanded()) {
            ((TreeItem)widget).setText(" ");
            this.virtualLazyUpdateWidget(parent, index);
        } else {
            return;
        }
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            this.virtualRefreshExpandedItems(widget, (Widget)item, data, i);
            ++i;
        }
    }

    @Override
    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if ((this.getTree().getStyle() & 0x10000000) != 0 && item.getData(VIRTUAL_DISPOSE_KEY) == null) {
            item.setData(VIRTUAL_DISPOSE_KEY, (Object)Boolean.TRUE);
            item.addDisposeListener(e -> {
                if (!this.treeIsDisposed) {
                    Object data = item.getData();
                    if (this.usingElementMap() && data != null) {
                        this.unmapElement(data, item);
                    }
                }
            });
        }
    }

    @Override
    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new TreeViewerRow((TreeItem)item);
        } else {
            this.cachedRow.setItem((TreeItem)item);
        }
        return this.cachedRow;
    }

    private ViewerRow createNewRowPart(ViewerRow parent, int style, int rowIndex) {
        if (parent == null) {
            if (rowIndex >= 0) {
                return this.getViewerRowFromItem((Widget)new TreeItem(this.tree, style, rowIndex));
            }
            return this.getViewerRowFromItem((Widget)new TreeItem(this.tree, style));
        }
        if (rowIndex >= 0) {
            return this.getViewerRowFromItem((Widget)new TreeItem((TreeItem)parent.getItem(), 0, rowIndex));
        }
        return this.getViewerRowFromItem((Widget)new TreeItem((TreeItem)parent.getItem(), 0));
    }

    @Override
    protected void internalInitializeTree(Control widget) {
        if (this.contentProviderIsLazy && widget instanceof Tree && widget.getData() != null) {
            this.virtualLazyUpdateChildCount((Widget)widget, 0);
            return;
        }
        super.internalInitializeTree((Control)this.tree);
    }

    @Override
    protected void updatePlus(Item item, Object element) {
        if (this.contentProviderIsLazy) {
            Object data = item.getData();
            int itemCount = 0;
            if (data != null) {
                itemCount = ((TreeItem)item).getItemCount();
            }
            this.virtualLazyUpdateHasChildren(item, itemCount);
        } else {
            super.updatePlus(item, element);
        }
    }

    public void remove(Object parentOrTreePath, int index) {
        if (this.checkBusy()) {
            return;
        }
        LinkedList<TreePath> oldSelection = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(() -> {
            TreePath removedPath = null;
            if (this.internalIsInputOrEmptyPath(parentOrTreePath)) {
                Tree tree = (Tree)this.getControl();
                if (index < tree.getItemCount()) {
                    TreeItem item1 = tree.getItem(index);
                    if (item1.getData() != null) {
                        removedPath = this.getTreePathFromItem((Item)item1);
                        this.disassociate((Item)item1);
                    }
                    item1.dispose();
                }
            } else {
                Widget[] parentItems;
                Widget[] widgetArray = parentItems = this.internalFindItems(parentOrTreePath);
                int n2 = parentItems.length;
                int n3 = 0;
                while (n3 < n2) {
                    Widget parentWidget = widgetArray[n3];
                    TreeItem parentItem = (TreeItem)parentWidget;
                    if (!parentItem.isDisposed() && index < parentItem.getItemCount()) {
                        TreeItem item2 = parentItem.getItem(index);
                        if (item2.getData() == null) {
                            if (index > 0 || parentItem.getExpanded()) {
                                item2.dispose();
                            }
                        } else {
                            removedPath = this.getTreePathFromItem((Item)item2);
                            this.disassociate((Item)item2);
                            item2.dispose();
                        }
                    }
                    ++n3;
                }
            }
            if (removedPath != null) {
                boolean removed = false;
                Iterator it = oldSelection.iterator();
                while (it.hasNext()) {
                    TreePath path = (TreePath)it.next();
                    if (!path.startsWith(removedPath, this.getComparer())) continue;
                    it.remove();
                    removed = true;
                }
                if (removed) {
                    this.setSelection(new TreeSelection(oldSelection.toArray(new TreePath[oldSelection.size()]), this.getComparer()), false);
                }
            }
        });
    }

    @Override
    protected void handleTreeExpand(TreeEvent event) {
        if (this.isCellEditorActive()) {
            this.applyEditorValue();
        }
        if (this.contentProviderIsLazy) {
            if (event.item.getData() != null) {
                Item[] children = this.getChildren(event.item);
                if (children.length == 1 && children[0].getData() == null) {
                    this.virtualLazyUpdateChildCount(event.item, children.length);
                }
                this.fireTreeExpanded(new TreeExpansionEvent(this, event.item.getData()));
            }
            return;
        }
        super.handleTreeExpand(event);
    }

    @Override
    protected void handleTreeCollapse(TreeEvent event) {
        if (this.isCellEditorActive()) {
            this.applyEditorValue();
        }
        super.handleTreeCollapse(event);
    }

    @Override
    public void setContentProvider(IContentProvider provider) {
        this.contentProviderIsLazy = provider instanceof ILazyTreeContentProvider || provider instanceof ILazyTreePathContentProvider;
        this.contentProviderIsTreeBased = provider instanceof ILazyTreePathContentProvider;
        super.setContentProvider(provider);
    }

    public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
        if (this.checkBusy()) {
            return;
        }
        this.preservingSelection(() -> {
            Widget[] items;
            if (this.internalIsInputOrEmptyPath(elementOrTreePath)) {
                if (hasChildren) {
                    this.virtualLazyUpdateChildCount((Widget)this.getTree(), this.getChildren((Widget)this.getTree()).length);
                } else {
                    this.setChildCount(elementOrTreePath, 0);
                }
                return;
            }
            Widget[] widgetArray = items = this.internalFindItems(elementOrTreePath);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Widget widget = widgetArray[n2];
                TreeItem item = (TreeItem)widget;
                if (!hasChildren) {
                    item.setItemCount(0);
                } else if (!item.getExpanded()) {
                    item.setItemCount(1);
                    TreeItem child = item.getItem(0);
                    if (child.getData() != null) {
                        this.disassociate((Item)child);
                    }
                    item.clear(0, true);
                } else {
                    this.virtualLazyUpdateChildCount((Widget)item, item.getItemCount());
                }
                ++n2;
            }
        });
    }

    private void virtualLazyUpdateWidget(Widget widget, int index) {
        boolean oldBusy = this.isBusy();
        this.setBusy(false);
        try {
            if (this.contentProviderIsTreeBased) {
                TreePath treePath;
                if (widget instanceof Item) {
                    if (widget.getData() == null) {
                        return;
                    }
                    treePath = this.getTreePathFromItem((Item)widget);
                } else {
                    treePath = TreePath.EMPTY;
                }
                ((ILazyTreePathContentProvider)this.getContentProvider()).updateElement(treePath, index);
            } else {
                ((ILazyTreeContentProvider)this.getContentProvider()).updateElement(widget.getData(), index);
            }
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    private void virtualLazyUpdateChildCount(Widget widget, int currentChildCount) {
        boolean oldBusy = this.isBusy();
        this.setBusy(false);
        try {
            if (this.contentProviderIsTreeBased) {
                TreePath treePath = widget instanceof Item ? this.getTreePathFromItem((Item)widget) : TreePath.EMPTY;
                ((ILazyTreePathContentProvider)this.getContentProvider()).updateChildCount(treePath, currentChildCount);
            } else {
                ((ILazyTreeContentProvider)this.getContentProvider()).updateChildCount(widget.getData(), currentChildCount);
            }
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    private void virtualLazyUpdateHasChildren(Item item, int currentChildCount) {
        boolean oldBusy = this.isBusy();
        this.setBusy(false);
        try {
            if (this.contentProviderIsTreeBased) {
                TreePath treePath = this.getTreePathFromItem(item);
                if (currentChildCount == 0 || !((TreeItem)item).getExpanded()) {
                    ((ILazyTreePathContentProvider)this.getContentProvider()).updateHasChildren(treePath);
                } else {
                    ((ILazyTreePathContentProvider)this.getContentProvider()).updateChildCount(treePath, currentChildCount);
                }
            } else {
                ((ILazyTreeContentProvider)this.getContentProvider()).updateChildCount(item.getData(), currentChildCount);
            }
        }
        finally {
            this.setBusy(oldBusy);
        }
    }

    @Override
    protected void disassociate(Item item) {
        if (this.contentProviderIsLazy) {
            item.setText(" ");
        }
        super.disassociate(item);
    }

    @Override
    protected int doGetColumnCount() {
        return this.tree.getColumnCount();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
        super.setSelection(selection, reveal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void editElement(Object element, int column) {
        if (element instanceof TreePath) {
            try {
                ViewerCell cell;
                ViewerRow row;
                this.getControl().setRedraw(false);
                this.setSelection(new TreeSelection((TreePath)element));
                TreeItem[] items = this.tree.getSelection();
                if (items.length != 1 || (row = this.getViewerRowFromItem((Widget)items[0])) == null || (cell = row.getCell(column)) == null) return;
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell));
                return;
            }
            finally {
                this.getControl().setRedraw(true);
            }
        } else {
            super.editElement(element, column);
        }
    }
}

