/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.OpenPreferencesAction;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class MenuHelper {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("\\p{Alpha}[\\p{Alnum}+.-]*:.*");
    public static final String MAIN_MENU_ID = "org.eclipse.ui.main.menu";
    private static Field urlField;
    private static Field locationField;
    private static Field nameField;

    public static void trace(String msg, Throwable error) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)msg, (Throwable)error);
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = MenuHelper.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = MenuHelper.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            String parentName = parent.getName();
            if (parentName.equals("actionSet") || parentName.equals("viewContribution") || parentName.equals("editorContribution")) {
                actionSetId = MenuHelper.getId(parent);
            }
            obj = parent.getParent();
        }
        return "AUTOGEN:::" + actionSetId + '/' + id;
    }

    public static String getImageUrl(ImageDescriptor imageDescriptor) {
        return MenuHelper.getIconURI(imageDescriptor, null);
    }

    private static URL getUrl(Class<?> idc, ImageDescriptor imageDescriptor) {
        try {
            if (urlField == null) {
                urlField = idc.getDeclaredField("url");
                urlField.setAccessible(true);
            }
            return (URL)urlField.get(imageDescriptor);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Class<?> getLocation(ImageDescriptor imageDescriptor) {
        try {
            if (locationField == null) {
                locationField = imageDescriptor.getClass().getDeclaredField("location");
                locationField.setAccessible(true);
            }
            return (Class)locationField.get(imageDescriptor);
        }
        catch (SecurityException e) {
            WorkbenchPlugin.log(e);
        }
        catch (NoSuchFieldException e) {
            WorkbenchPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            WorkbenchPlugin.log(e);
        }
        return null;
    }

    private static String getName(ImageDescriptor imageDescriptor) {
        try {
            if (nameField == null) {
                nameField = imageDescriptor.getClass().getDeclaredField("name");
                nameField.setAccessible(true);
            }
            return (String)nameField.get(imageDescriptor);
        }
        catch (SecurityException e) {
            WorkbenchPlugin.log(e);
        }
        catch (NoSuchFieldException e) {
            WorkbenchPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            WorkbenchPlugin.log(e);
        }
        return null;
    }

    static boolean getVisibleEnabled(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("visibleWhen");
        String checkEnabled = null;
        if (children.length > 0) {
            checkEnabled = children[0].getAttribute("checkEnabled");
        }
        return checkEnabled != null && checkEnabled.equalsIgnoreCase("true");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MExpression getVisibleWhen(IConfigurationElement commandAddition) {
        try {
            IConfigurationElement[] visibleConfig = commandAddition.getChildren("visibleWhen");
            if (visibleConfig.length <= 0) return null;
            if (visibleConfig.length >= 2) return null;
            IConfigurationElement[] visibleChild = visibleConfig[0].getChildren();
            if (visibleChild.length != 0) {
                if (visibleChild.length <= 0) return null;
                Expression visWhen = ExpressionConverter.getDefault().perform(visibleChild[0]);
                MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
                exp.setCoreExpressionId("programmatic.value");
                exp.setCoreExpression((Object)visWhen);
                return exp;
            }
            String checkEnabled = visibleConfig[0].getAttribute("checkEnabled");
            if (!Boolean.parseBoolean(checkEnabled)) return null;
            final String commandId = MenuHelper.getCommandId(commandAddition);
            if (commandId == null) {
                return null;
            }
            Expression visWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    EHandlerService service = MenuHelper.getFromContext(context, EHandlerService.class);
                    ICommandService commandService = MenuHelper.getFromContext(context, ICommandService.class);
                    if (service == null || commandService == null) {
                        WorkbenchPlugin.log("Could not retrieve EHandlerService or ICommandService from context evaluation context for" + commandId);
                        return EvaluationResult.FALSE;
                    }
                    Command c = commandService.getCommand(commandId);
                    ParameterizedCommand generateCommand = ParameterizedCommand.generateCommand((Command)c, (Map)Collections.EMPTY_MAP);
                    return EvaluationResult.valueOf((boolean)service.canExecute(generateCommand));
                }
            };
            MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
            exp.setCoreExpressionId("programmatic.value");
            exp.setCoreExpression((Object)visWhen);
            return exp;
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static <T> T getFromContext(IEvaluationContext context, Class<T> expectedType) {
        if (context == null || expectedType == null) {
            throw new NullPointerException();
        }
        Object rawValue = context.getVariable(expectedType.getName());
        return expectedType.isInstance(rawValue) ? (T)expectedType.cast(rawValue) : null;
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = MenuHelper.getCommandId(element);
        }
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    static String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    static int getMode(IConfigurationElement element) {
        if ("FORCE_TEXT".equals(element.getAttribute("mode"))) {
            return CommandContributionItem.MODE_FORCE_TEXT;
        }
        return 0;
    }

    static String getLabel(IConfigurationElement element) {
        return element.getAttribute("label");
    }

    static String getPath(IConfigurationElement element) {
        return element.getAttribute("path");
    }

    static String getMenuBarPath(IConfigurationElement element) {
        return element.getAttribute("menubarPath");
    }

    static String getToolBarPath(IConfigurationElement element) {
        return element.getAttribute("toolbarPath");
    }

    static String getMnemonic(IConfigurationElement element) {
        return element.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement element) {
        return element.getAttribute("tooltip");
    }

    public static String getIconURI(IConfigurationElement element, String attr) {
        String iconPath = element.getAttribute(attr);
        if (iconPath == null) {
            return null;
        }
        if (!SCHEME_PATTERN.matcher(iconPath).matches()) {
            ImageDescriptor d = WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor(iconPath);
            if (d != null) {
                return MenuHelper.getImageUrl(d);
            }
            String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
            iconPath = "platform:/plugin/" + extendingPluginId + "/" + iconPath;
        }
        URL url = null;
        try {
            url = FileLocator.find((URL)new URL(iconPath));
        }
        catch (MalformedURLException malformedURLException) {}
        return url == null ? iconPath : MenuHelper.rewriteDurableURL(url.toString());
    }

    static String getHelpContextId(IConfigurationElement element) {
        return element.getAttribute("helpContextId");
    }

    public static boolean isSeparatorVisible(IConfigurationElement element) {
        String val = element.getAttribute("visible");
        return Boolean.valueOf(val);
    }

    public static String getClassSpec(IConfigurationElement element) {
        return element.getAttribute("class");
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static ItemType getStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            return ItemType.PUSH;
        }
        if ("toggle".equals(style)) {
            return ItemType.CHECK;
        }
        if ("radio".equals(style)) {
            return ItemType.RADIO;
        }
        if ("pulldown".equals(style)) {
            MenuHelper.trace("Failed to get style for pulldown", null);
        }
        return ItemType.PUSH;
    }

    public static boolean hasPulldownStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        return "pulldown".equals(style);
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.valueOf(r);
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static Map<String, String> getParameters(IConfigurationElement element) {
        HashMap<String, String> map = new HashMap<String, String>();
        IConfigurationElement[] parameters = element.getChildren("parameter");
        int i = 0;
        while (i < parameters.length) {
            String name = parameters[i].getAttribute("name");
            String value = parameters[i].getAttribute("value");
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++i;
        }
        return map;
    }

    public static MMenu createMenuAddition(IConfigurationElement menuAddition) {
        int idx;
        MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
        String id = MenuHelper.getId(menuAddition);
        element.setElementId(id);
        String text = MenuHelper.getLabel(menuAddition);
        String mnemonic = MenuHelper.getMnemonic(menuAddition);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        element.setVisibleWhen(MenuHelper.getVisibleWhen(menuAddition));
        element.setIconURI(MenuHelper.getIconURI(menuAddition, "icon"));
        element.setLabel(Util.safeString(text));
        return element;
    }

    public static MMenuElement createLegacyMenuActionAdditions(MApplication app, final IConfigurationElement element) {
        int idx;
        String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconURI(element, "icon");
        String cmdId = MenuHelper.getActionSetCommandId(element);
        MCommand cmd = ContributionsAnalyzer.getCommandById((MApplication)app, (String)cmdId);
        if (cmd == null) {
            ECommandService commandService = (ECommandService)app.getContext().get(ECommandService.class);
            Command command = commandService.getCommand(cmdId);
            if (command == null) {
                ICommandService ics = (ICommandService)app.getContext().get(ICommandService.class);
                command = commandService.defineCommand(cmdId, text, null, ics.getCategory(null), null);
            }
            cmd = CommandsFactoryImpl.eINSTANCE.createCommand();
            cmd.setCommandName(text);
            cmd.setElementId(cmdId);
            app.getCommands().add(cmd);
        }
        String style = element.getAttribute("style");
        String pulldown = element.getAttribute("pulldown");
        if ("pulldown".equals(style) || pulldown != null && pulldown.equals("true")) {
            MMenuItem item = RenderedElementUtil.createRenderedMenuItem();
            item.setLabel(text);
            if (iconUri != null) {
                item.setIconURI(iconUri);
            }
            ContextFunction generator = new ContextFunction(){

                public Object compute(IEclipseContext context, String contextKey) {
                    IWorkbenchWindow window = (IWorkbenchWindow)context.get(IWorkbenchWindow.class);
                    if (window == null) {
                        return null;
                    }
                    ActionDescriptor desc = new ActionDescriptor(element, 5, window);
                    final PluginAction action = desc.getAction();
                    return new ActionContributionItem((IAction)action){

                        public void dispose() {
                            super.dispose();
                            action.disposeDelegate();
                        }
                    };
                }
            };
            RenderedElementUtil.setContributionManager((MUIElement)item, (Object)generator);
            return item;
        }
        ItemType type = ItemType.PUSH;
        if ("toggle".equals(style)) {
            type = ItemType.CHECK;
        } else if ("radio".equals(style)) {
            type = ItemType.RADIO;
        }
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setElementId(id);
        item.setLabel(text);
        item.setType(type);
        item.setCommand(cmd);
        if (iconUri != null) {
            item.setIconURI(iconUri);
        }
        return item;
    }

    public static String getDescription(IConfigurationElement configElement) {
        return configElement.getAttribute("description");
    }

    public static MToolBarElement createLegacyToolBarActionAdditions(MApplication app, final IConfigurationElement element) {
        String tooltip;
        int idx;
        String cmdId = MenuHelper.getActionSetCommandId(element);
        final String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconURI(element, "icon");
        String disabledIconUri = MenuHelper.getIconURI(element, "disabledIcon");
        MCommand cmd = ContributionsAnalyzer.getCommandById((MApplication)app, (String)cmdId);
        if (cmd == null) {
            ECommandService commandService = (ECommandService)app.getContext().get(ECommandService.class);
            Command command = commandService.getCommand(cmdId);
            if (command == null) {
                ICommandService ics = (ICommandService)app.getContext().get(ICommandService.class);
                command = commandService.defineCommand(cmdId, text, null, ics.getCategory(null), null);
            }
            cmd = CommandsFactoryImpl.eINSTANCE.createCommand();
            cmd.setCommandName(text);
            cmd.setElementId(cmdId);
            app.getCommands().add(cmd);
        }
        MHandledToolItem item = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        String style = element.getAttribute("style");
        String pulldown = element.getAttribute("pulldown");
        if ("toggle".equals(style)) {
            item.setType(ItemType.CHECK);
            IContextFunction generator = MenuHelper.createToggleFunction(element);
            if (generator != null) {
                item.getTransientData().put(ItemType.CHECK.toString(), generator);
            }
        } else if ("radio".equals(style)) {
            item.setType(ItemType.RADIO);
        } else {
            item.setType(ItemType.PUSH);
        }
        if ("pulldown".equals(style) || pulldown != null && pulldown.equals("true")) {
            MMenu menu = RenderedElementUtil.createRenderedMenu();
            ECommandService cs = (ECommandService)app.getContext().get(ECommandService.class);
            final ParameterizedCommand parmCmd = cs.createCommand(cmdId, null);
            ContextFunction generator = new ContextFunction(){

                public Object compute(IEclipseContext context, String contextKey) {
                    return new IMenuCreator(){
                        private ActionDelegateHandlerProxy handlerProxy;

                        private ActionDelegateHandlerProxy getProxy() {
                            if (this.handlerProxy == null) {
                                this.handlerProxy = new ActionDelegateHandlerProxy(element, "class", id, parmCmd, PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, null, null);
                            }
                            return this.handlerProxy;
                        }

                        private IWorkbenchWindowPulldownDelegate getDelegate() {
                            this.getProxy();
                            if (this.handlerProxy == null) {
                                return null;
                            }
                            if (this.handlerProxy.getDelegate() == null) {
                                this.handlerProxy.loadDelegate();
                                ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                                IActionDelegate delegate = this.handlerProxy.getDelegate();
                                delegate.selectionChanged((IAction)this.handlerProxy.getAction(), service.getSelection());
                            }
                            return (IWorkbenchWindowPulldownDelegate)this.handlerProxy.getDelegate();
                        }

                        public Menu getMenu(Menu parent) {
                            IWorkbenchWindowPulldownDelegate2 delegate = (IWorkbenchWindowPulldownDelegate2)this.getDelegate();
                            if (delegate == null) {
                                return null;
                            }
                            return delegate.getMenu(parent);
                        }

                        public Menu getMenu(Control parent) {
                            return this.getDelegate() == null ? null : this.getDelegate().getMenu(parent);
                        }

                        public void dispose() {
                            if (this.handlerProxy != null) {
                                this.handlerProxy.dispose();
                                this.handlerProxy = null;
                            }
                        }
                    };
                }
            };
            RenderedElementUtil.setContributionManager((MUIElement)menu, (Object)generator);
            item.setMenu(menu);
        }
        item.setElementId(id);
        item.setCommand(cmd);
        if (iconUri == null) {
            item.setLabel(text);
        } else {
            item.setIconURI(iconUri);
        }
        if (disabledIconUri != null) {
            MenuHelper.setDisabledIconURI((MToolItem)item, disabledIconUri);
        }
        item.setTooltip((tooltip = MenuHelper.getTooltip(element)) == null ? text : tooltip);
        return item;
    }

    private static int getType(String name) {
        if (name.equals("actionSet")) {
            return 3;
        }
        if (name.equals("viewContribution")) {
            return 2;
        }
        if (name.equals("editorContribution")) {
            return 4;
        }
        return -1;
    }

    private static IContextFunction createToggleFunction(final IConfigurationElement element) {
        Object ice = element.getParent();
        if (!(ice instanceof IConfigurationElement)) {
            return null;
        }
        IConfigurationElement parent = (IConfigurationElement)ice;
        final int type = MenuHelper.getType(parent.getName());
        if (type == -1) {
            return null;
        }
        ContextFunction generator = new ContextFunction(){

            private ActionDescriptor getDescriptor(IEclipseContext context) {
                switch (type) {
                    case 3: {
                        IWorkbenchWindow window = (IWorkbenchWindow)context.get(IWorkbenchWindow.class);
                        return window == null ? null : new ActionDescriptor(element, type, window);
                    }
                    case 4: {
                        return new ActionDescriptor(element, type, null);
                    }
                    case 2: {
                        Object object;
                        MPart part = (MPart)context.get(MPart.class);
                        if (part != null && (object = part.getObject()) instanceof CompatibilityPart) {
                            return new ActionDescriptor(element, type, ((CompatibilityPart)object).getPart());
                        }
                        return null;
                    }
                }
                return null;
            }

            public Object compute(IEclipseContext context, String contextKey) {
                final MHandledItem model = (MHandledItem)context.get(MHandledItem.class);
                if (model == null) {
                    return null;
                }
                ActionDescriptor desc = this.getDescriptor(context);
                PluginAction action = desc.getAction();
                IPropertyChangeListener propListener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if ("checked".equals(event.getProperty())) {
                            boolean checked = false;
                            if (event.getNewValue() instanceof Boolean) {
                                checked = (Boolean)event.getNewValue();
                            }
                            model.setSelected(checked);
                        }
                    }
                };
                action.addPropertyChangeListener(propListener);
                Runnable obj = new Runnable((IAction)action, propListener){
                    private final /* synthetic */ IAction val$action;
                    private final /* synthetic */ IPropertyChangeListener val$propListener;
                    {
                        this.val$action = iAction;
                        this.val$propListener = iPropertyChangeListener;
                    }

                    @Override
                    @Execute
                    public void run() {
                        this.val$action.removePropertyChangeListener(this.val$propListener);
                    }
                };
                model.setSelected(action.isChecked());
                return obj;
            }
        };
        return generator;
    }

    public static MMenu createMenu(MenuManager manager) {
        MMenu subMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        subMenu.setLabel(manager.getMenuText());
        subMenu.setElementId(manager.getId());
        return subMenu;
    }

    public static MMenuItem createItem(MApplication application, CommandContributionItem cci) {
        MCommand command = MenuHelper.getMCommand(application, cci);
        if (command != null) {
            CommandContributionItemParameter data = cci.getData();
            MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
            menuItem.setCommand(command);
            menuItem.setContributorURI(command.getContributorURI());
            if (data.label != null) {
                menuItem.setLabel(data.label);
            } else {
                menuItem.setLabel(command.getCommandName());
            }
            if (data.mnemonic != null) {
                menuItem.setMnemonics(data.mnemonic);
            }
            if (data.icon != null) {
                menuItem.setIconURI(MenuHelper.getIconURI(data.icon, application.getContext()));
            } else {
                menuItem.setIconURI(MenuHelper.getIconURI(command.getElementId(), application.getContext(), 0));
            }
            String itemId = cci.getId();
            menuItem.setElementId(itemId == null ? command.getElementId() : itemId);
            return menuItem;
        }
        return null;
    }

    public static MHandledToolItem createToolItem(MApplication application, CommandContributionItem cci) {
        MCommand command = MenuHelper.getMCommand(application, cci);
        if (command != null) {
            CommandContributionItemParameter data = cci.getData();
            MHandledToolItem toolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
            toolItem.setCommand(command);
            toolItem.setContributorURI(command.getContributorURI());
            toolItem.setVisible(cci.isVisible());
            String iconURI = null;
            String disabledIconURI = null;
            toolItem.setType(ItemType.PUSH);
            if (data.style == 32) {
                toolItem.setType(ItemType.CHECK);
            } else if (data.style == 16) {
                toolItem.setType(ItemType.RADIO);
            }
            if (data.icon != null) {
                iconURI = MenuHelper.getIconURI(data.icon, application.getContext());
            }
            if (iconURI == null) {
                iconURI = MenuHelper.getIconURI(command.getElementId(), application.getContext(), 0);
            }
            if (iconURI == null) {
                toolItem.setLabel(command.getCommandName());
            } else {
                toolItem.setIconURI(iconURI);
            }
            if (data.disabledIcon != null) {
                disabledIconURI = MenuHelper.getIconURI(data.disabledIcon, application.getContext());
            }
            if (disabledIconURI == null) {
                disabledIconURI = MenuHelper.getIconURI(command.getElementId(), application.getContext(), 1);
            }
            if (disabledIconURI != null) {
                MenuHelper.setDisabledIconURI((MToolItem)toolItem, disabledIconURI);
            }
            if (data.tooltip != null) {
                toolItem.setTooltip(data.tooltip);
            } else if (data.label != null) {
                toolItem.setTooltip(data.label);
            } else {
                toolItem.setTooltip(command.getDescription());
            }
            String itemId = cci.getId();
            toolItem.setElementId(itemId == null ? command.getElementId() : itemId);
            return toolItem;
        }
        return null;
    }

    public static MCommand getMCommand(MApplication application, CommandContributionItem contribution) {
        ParameterizedCommand command = contribution.getCommand();
        if (command != null) {
            for (MCommand mcommand : application.getCommands()) {
                if (!mcommand.getElementId().equals(command.getId())) continue;
                return mcommand;
            }
        }
        return null;
    }

    public static MToolItem createToolItem(MApplication application, ActionContributionItem item) {
        final IAction action = item.getAction();
        String id = action.getActionDefinitionId();
        if (id != null) {
            for (MCommand command : application.getCommands()) {
                String disabledIconURI;
                if (!id.equals(command.getElementId())) continue;
                MHandledToolItem toolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
                toolItem.setCommand(command);
                toolItem.setContributorURI(command.getContributorURI());
                toolItem.setVisible(item.isVisible());
                String iconURI = MenuHelper.getIconURI(action.getImageDescriptor(), application.getContext());
                if (iconURI == null) {
                    iconURI = MenuHelper.getIconURI(id, application.getContext(), 0);
                    if (iconURI == null) {
                        toolItem.setLabel(command.getCommandName());
                    } else {
                        toolItem.setIconURI(iconURI);
                    }
                } else {
                    toolItem.setIconURI(iconURI);
                }
                if (action.getToolTipText() != null) {
                    toolItem.setTooltip(action.getToolTipText());
                }
                if ((disabledIconURI = MenuHelper.getIconURI(action.getDisabledImageDescriptor(), application.getContext())) == null) {
                    disabledIconURI = MenuHelper.getIconURI(id, application.getContext(), 0);
                }
                if (disabledIconURI != null) {
                    MenuHelper.setDisabledIconURI((MToolItem)toolItem, disabledIconURI);
                }
                switch (action.getStyle()) {
                    case 2: {
                        toolItem.setType(ItemType.CHECK);
                        toolItem.setSelected(action.isChecked());
                        break;
                    }
                    case 8: {
                        toolItem.setType(ItemType.RADIO);
                        toolItem.setSelected(action.isChecked());
                        break;
                    }
                    default: {
                        toolItem.setType(ItemType.PUSH);
                    }
                }
                String itemId = item.getId();
                toolItem.setElementId(itemId == null ? id : itemId);
                return toolItem;
            }
        } else {
            final MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
            String itemId = item.getId();
            toolItem.setElementId(itemId);
            toolItem.setVisible(item.isVisible());
            String iconURI = MenuHelper.getIconURI(action.getImageDescriptor(), application.getContext());
            if (iconURI == null) {
                if (itemId == null) {
                    if (action.getText() != null) {
                        toolItem.setLabel(action.getText());
                    }
                } else {
                    iconURI = MenuHelper.getIconURI(itemId, application.getContext(), 0);
                    if (iconURI == null) {
                        if (action.getText() != null) {
                            toolItem.setLabel(action.getText());
                        }
                    } else {
                        toolItem.setIconURI(iconURI);
                    }
                }
            } else {
                toolItem.setIconURI(iconURI);
            }
            if (action.getToolTipText() != null) {
                toolItem.setTooltip(action.getToolTipText());
            }
            switch (action.getStyle()) {
                case 2: {
                    toolItem.setType(ItemType.CHECK);
                    toolItem.setSelected(action.isChecked());
                    break;
                }
                case 8: {
                    toolItem.setType(ItemType.RADIO);
                    toolItem.setSelected(action.isChecked());
                    break;
                }
                default: {
                    toolItem.setType(ItemType.PUSH);
                }
            }
            toolItem.setContributionURI("bundleclass://org.eclipse.ui.workbench/programmic.contribution");
            toolItem.setObject((Object)new DirectProxy(action));
            toolItem.setEnabled(action.isEnabled());
            final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (property.equals("enabled")) {
                        toolItem.setEnabled(action.isEnabled());
                    } else if (property.equals("checked")) {
                        toolItem.setSelected(action.isChecked());
                    } else if (property.equals("text")) {
                        toolItem.setLabel(action.getText());
                    } else if (property.equals("toolTipText")) {
                        toolItem.setLabel(action.getToolTipText());
                    }
                }
            };
            action.addPropertyChangeListener(propertyListener);
            toolItem.getTransientData().put("IDisposable", new Runnable(){

                @Override
                public void run() {
                    action.removePropertyChangeListener(propertyListener);
                }
            });
            return toolItem;
        }
        return null;
    }

    public static MMenuItem createItem(MApplication application, ActionContributionItem item) {
        IAction action = item.getAction();
        String id = action.getActionDefinitionId();
        if (action instanceof OpenPreferencesAction) {
            for (MCommand command : application.getCommands()) {
                if (!"org.eclipse.ui.window.preferences".equals(command.getElementId())) continue;
                MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
                menuItem.setCommand(command);
                menuItem.setLabel(command.getCommandName());
                menuItem.setIconURI(MenuHelper.getIconURI(action.getImageDescriptor(), application.getContext()));
                String text = action.getText();
                int index = text.indexOf(38);
                if (index != -1 && index != text.length() - 1) {
                    menuItem.setMnemonics(text.substring(index + 1, index + 2));
                }
                switch (action.getStyle()) {
                    case 2: {
                        menuItem.setType(ItemType.CHECK);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    case 8: {
                        menuItem.setType(ItemType.RADIO);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    default: {
                        menuItem.setType(ItemType.PUSH);
                    }
                }
                String itemId = item.getId();
                menuItem.setElementId(itemId == null ? id : itemId);
                return menuItem;
            }
        } else if (id != null) {
            for (MCommand command : application.getCommands()) {
                if (!id.equals(command.getElementId())) continue;
                MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
                menuItem.setCommand(command);
                if (action.getText() != null) {
                    menuItem.setLabel(action.getText());
                } else {
                    menuItem.setLabel(command.getCommandName());
                }
                menuItem.setIconURI(MenuHelper.getIconURI(action.getImageDescriptor(), application.getContext()));
                switch (action.getStyle()) {
                    case 2: {
                        menuItem.setType(ItemType.CHECK);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    case 8: {
                        menuItem.setType(ItemType.RADIO);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    default: {
                        menuItem.setType(ItemType.PUSH);
                    }
                }
                String itemId = item.getId();
                menuItem.setElementId(itemId == null ? id : itemId);
                return menuItem;
            }
        } else {
            String itemId;
            MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
            if (action.getText() != null) {
                menuItem.setLabel(action.getText());
            }
            menuItem.setElementId((itemId = item.getId()) == null ? id : itemId);
            menuItem.setIconURI(MenuHelper.getIconURI(action.getImageDescriptor(), application.getContext()));
            switch (action.getStyle()) {
                case 2: {
                    menuItem.setType(ItemType.CHECK);
                    menuItem.setSelected(action.isChecked());
                    break;
                }
                case 8: {
                    menuItem.setType(ItemType.RADIO);
                    menuItem.setSelected(action.isChecked());
                    break;
                }
                default: {
                    menuItem.setType(ItemType.PUSH);
                }
            }
            menuItem.setContributionURI("bundleclass://org.eclipse.ui.workbench/programmic.contribution");
            menuItem.setObject((Object)new DirectProxy(action));
            return menuItem;
        }
        return null;
    }

    public static String getIconURI(ImageDescriptor descriptor, IEclipseContext context) {
        IAdapterManager adapter;
        if (descriptor == null) {
            return null;
        }
        if (descriptor.getClass().toString().endsWith("URLImageDescriptor")) {
            URL url = MenuHelper.getUrl(descriptor.getClass(), descriptor);
            return MenuHelper.rewriteDurableURL(url.toExternalForm());
        }
        if (descriptor.getClass().toString().endsWith("FileImageDescriptor")) {
            Class<?> sourceClass = MenuHelper.getLocation(descriptor);
            if (sourceClass == null) {
                return null;
            }
            String path = MenuHelper.getName(descriptor);
            if (path == null) {
                return null;
            }
            Bundle bundle = FrameworkUtil.getBundle(sourceClass);
            String parentPath = sourceClass.getName();
            parentPath = parentPath.substring(0, parentPath.lastIndexOf(46));
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(parentPath = parentPath.replace('.', '/')).append(path), null);
            return url == null ? null : MenuHelper.rewriteDurableURL(url.toString());
        }
        if (descriptor instanceof IAdaptable) {
            Object o = ((IAdaptable)descriptor).getAdapter(URL.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
            o = ((IAdaptable)descriptor).getAdapter(URI.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
        } else if (context != null && (adapter = (IAdapterManager)context.get(IAdapterManager.class)) != null) {
            Object o = adapter.getAdapter((Object)descriptor, URL.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
            o = adapter.getAdapter((Object)descriptor, URI.class);
            if (o != null) {
                return MenuHelper.rewriteDurableURL(o.toString());
            }
        }
        return null;
    }

    private static String rewriteDurableURL(String url) {
        if (!url.startsWith("bundleentry:") && !url.startsWith("bundleresource:")) {
            return url;
        }
        BundleContext ctxt = FrameworkUtil.getBundle(WorkbenchWindow.class).getBundleContext();
        try {
            URI uri = new URI(url);
            String host = uri.getHost();
            String bundleId = host.substring(0, host.indexOf(46));
            Bundle bundle = ctxt.getBundle(Long.parseLong(bundleId));
            StringBuilder builder = new StringBuilder("platform:/plugin/");
            builder.append(bundle.getSymbolicName());
            builder.append(uri.getPath());
            return builder.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return url;
        }
    }

    private static String getIconURI(String commandId, IEclipseContext workbench, int type) {
        if (commandId == null) {
            return null;
        }
        ICommandImageService imageService = (ICommandImageService)workbench.get(ICommandImageService.class);
        ImageDescriptor descriptor = imageService.getImageDescriptor(commandId, type);
        return MenuHelper.getIconURI(descriptor, workbench);
    }

    public static void setDisabledIconURI(MToolItem item, String disabledIconURI) {
        item.getTransientData().put("e4_disabled_icon_image_key", disabledIconURI);
    }

    static class DirectProxy {
        private IAction action;

        public DirectProxy(IAction action) {
            this.action = action;
        }

        @CanExecute
        public boolean canExecute() {
            return this.action.isEnabled();
        }

        @Execute
        public void execute() {
            this.action.run();
        }
    }
}

