/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.accessibility.Relation;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.accessibility.TableAccessibleDelegate;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Accessible {
    static boolean DEBUG = false;
    static final int MAX_RELATION_TYPES = 15;
    static NSString[] baseAttributes = new NSString[]{OS.NSAccessibilityRoleAttribute, OS.NSAccessibilitySubroleAttribute, OS.NSAccessibilityRoleDescriptionAttribute, OS.NSAccessibilityHelpAttribute, OS.NSAccessibilityFocusedAttribute, OS.NSAccessibilityParentAttribute, OS.NSAccessibilityChildrenAttribute, OS.NSAccessibilityPositionAttribute, OS.NSAccessibilitySizeAttribute, OS.NSAccessibilityWindowAttribute, OS.NSAccessibilityTopLevelUIElementAttribute};
    NSMutableArray attributeNames = null;
    NSMutableArray parameterizedAttributeNames = null;
    NSMutableArray actionNames = null;
    List<AccessibleListener> accessibleListeners;
    List<AccessibleControlListener> accessibleControlListeners;
    List<AccessibleTextListener> accessibleTextListeners;
    List<AccessibleActionListener> accessibleActionListeners;
    List<AccessibleEditableTextListener> accessibleEditableTextListeners;
    List<AccessibleHyperlinkListener> accessibleHyperlinkListeners;
    List<AccessibleTableListener> accessibleTableListeners;
    List<AccessibleTableCellListener> accessibleTableCellListeners;
    List<AccessibleTextExtendedListener> accessibleTextExtendedListeners;
    List<AccessibleValueListener> accessibleValueListeners;
    List<AccessibleAttributeListener> accessibleAttributeListeners;
    Relation[] relations = new Relation[15];
    Accessible parent;
    Control control;
    int currentRole = -1;
    Map childToIdMap = new HashMap();
    SWTAccessibleDelegate delegate;
    int index = -1;
    TableAccessibleDelegate tableDelegate;

    public Accessible(Accessible parent) {
        if (parent == null) {
            SWT.error(4);
        }
        this.parent = parent;
        this.control = parent.control;
        this.delegate = new SWTAccessibleDelegate(this, -1);
    }

    @Deprecated
    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    id accessibleHandle(Accessible accessible) {
        if (accessible.delegate != null) {
            return accessible.delegate;
        }
        if (accessible.control != null) {
            NSView view = accessible.control.view;
            long handle = OS.objc_msgSend(view.id, OS.sel_accessibleHandle);
            return new id(handle);
        }
        return null;
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners == null) {
            this.accessibleListeners = new ArrayList<AccessibleListener>();
        }
        this.accessibleListeners.add(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners == null) {
            this.accessibleControlListeners = new ArrayList<AccessibleControlListener>();
        }
        this.accessibleControlListeners.add(listener);
    }

    public void addAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (listener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners == null) {
                this.accessibleTextExtendedListeners = new ArrayList<AccessibleTextExtendedListener>();
            }
            this.accessibleTextExtendedListeners.add((AccessibleTextExtendedListener)listener);
        } else {
            if (this.accessibleTextListeners == null) {
                this.accessibleTextListeners = new ArrayList<AccessibleTextListener>();
            }
            this.accessibleTextListeners.add(listener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners == null) {
            this.accessibleActionListeners = new ArrayList<AccessibleActionListener>();
        }
        this.accessibleActionListeners.add(listener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners == null) {
            this.accessibleEditableTextListeners = new ArrayList<AccessibleEditableTextListener>();
        }
        this.accessibleEditableTextListeners.add(listener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners == null) {
            this.accessibleHyperlinkListeners = new ArrayList<AccessibleHyperlinkListener>();
        }
        this.accessibleHyperlinkListeners.add(listener);
    }

    public void addAccessibleTableListener(AccessibleTableListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners == null) {
            this.accessibleTableListeners = new ArrayList<AccessibleTableListener>();
        }
        this.accessibleTableListeners.add(listener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners == null) {
            this.accessibleTableCellListeners = new ArrayList<AccessibleTableCellListener>();
        }
        this.accessibleTableCellListeners.add(listener);
    }

    public void addAccessibleValueListener(AccessibleValueListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners == null) {
            this.accessibleValueListeners = new ArrayList<AccessibleValueListener>();
        }
        this.accessibleValueListeners.add(listener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners == null) {
            this.accessibleAttributeListeners = new ArrayList<AccessibleAttributeListener>();
        }
        this.accessibleAttributeListeners.add(listener);
    }

    void addCGColor(double[] comps, NSMutableAttributedString inAttribString, NSString inAttribute, NSRange inRange) {
        long cgColorSpace = OS.CGColorSpaceCreateDeviceRGB();
        long cgColor = OS.CGColorCreate(cgColorSpace, comps);
        OS.CGColorSpaceRelease(cgColorSpace);
        inAttribString.addAttribute(inAttribute, new id(cgColor), inRange);
        OS.CGColorRelease(cgColor);
    }

    public void addRelation(int type, Accessible target) {
        this.checkWidget();
        if (this.relations[type] == null) {
            this.relations[type] = new Relation(this, type);
        }
        this.relations[type].addTarget(target);
    }

    int accessibleListenersSize() {
        return this.accessibleListeners == null ? 0 : this.accessibleListeners.size();
    }

    int accessibleControlListenersSize() {
        return this.accessibleControlListeners == null ? 0 : this.accessibleControlListeners.size();
    }

    int accessibleValueListenersSize() {
        return this.accessibleValueListeners == null ? 0 : this.accessibleValueListeners.size();
    }

    int accessibleTextExtendedListenersSize() {
        return this.accessibleTextExtendedListeners == null ? 0 : this.accessibleTextExtendedListeners.size();
    }

    int accessibleTextListenersSize() {
        return this.accessibleTextListeners == null ? 0 : this.accessibleTextListeners.size();
    }

    int accessibleTableCellListenersSize() {
        return this.accessibleTableCellListeners == null ? 0 : this.accessibleTableCellListeners.size();
    }

    int accessibleTableListenersSize() {
        return this.accessibleTableListeners == null ? 0 : this.accessibleTableListeners.size();
    }

    int accessibleHyperlinkListenersSize() {
        return this.accessibleHyperlinkListeners == null ? 0 : this.accessibleHyperlinkListeners.size();
    }

    int accessibleEditableTextListenersSize() {
        return this.accessibleEditableTextListeners == null ? 0 : this.accessibleEditableTextListeners.size();
    }

    int accessibleAttributeListenersSize() {
        return this.accessibleAttributeListeners == null ? 0 : this.accessibleAttributeListeners.size();
    }

    int accessibleActionListenersSize() {
        return this.accessibleActionListeners == null ? 0 : this.accessibleActionListeners.size();
    }

    void checkRole(int role) {
        if (role != this.currentRole) {
            this.currentRole = role;
            if (this.attributeNames != null) {
                this.attributeNames.release();
                this.attributeNames = null;
            }
            if (this.parameterizedAttributeNames != null) {
                this.parameterizedAttributeNames.release();
                this.parameterizedAttributeNames = null;
            }
            if (this.actionNames != null) {
                this.actionNames.release();
                this.actionNames = null;
            }
        }
    }

    void createTableDelegate() {
        if (this.tableDelegate == null) {
            this.tableDelegate = new TableAccessibleDelegate(this);
        }
    }

    id getColumnIndexRangeAttribute(int childID) {
        AccessibleTableCellEvent event = new AccessibleTableCellEvent(this);
        int i = 0;
        while (i < this.accessibleTableCellListenersSize()) {
            AccessibleTableCellListener listener = this.accessibleTableCellListeners.get(i);
            listener.getColumnIndex(event);
            listener.getColumnSpan(event);
            ++i;
        }
        NSRange range = new NSRange();
        range.location = event.index;
        range.length = event.count;
        return NSValue.valueWithRange(range);
    }

    id getRowIndexRangeAttribute(int childID) {
        AccessibleTableCellEvent event = new AccessibleTableCellEvent(this);
        int i = 0;
        while (i < this.accessibleTableCellListenersSize()) {
            AccessibleTableCellListener listener = this.accessibleTableCellListeners.get(i);
            listener.getRowIndex(event);
            listener.getRowSpan(event);
            ++i;
        }
        NSRange range = new NSRange();
        range.location = event.index;
        range.length = event.count;
        return NSValue.valueWithRange(range);
    }

    id getSelectedAttribute(int childID) {
        if (this.accessibleTableListenersSize() > 0) {
            AccessibleTableEvent event = new AccessibleTableEvent(this);
            event.row = this.index;
            int i = 0;
            while (i < this.accessibleTableListenersSize()) {
                AccessibleTableListener listener = this.accessibleTableListeners.get(i);
                if (this.currentRole == 28) {
                    listener.isRowSelected(event);
                } else {
                    listener.isColumnSelected(event);
                }
                ++i;
            }
            return NSNumber.numberWithBool(event.isSelected);
        }
        return NSNumber.numberWithBool(false);
    }

    id getIndexAttribute(int childID) {
        return NSNumber.numberWithInt(this.index);
    }

    id getHeaderAttribute(int childID) {
        SWTAccessibleDelegate returnValue = null;
        AccessibleTableEvent tableEvent = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getColumnHeader(tableEvent);
            ++i;
        }
        if (tableEvent.accessible != null) {
            returnValue = tableEvent.accessible.delegate;
        }
        return returnValue;
    }

    id getVisibleColumnsAttribute(int childID) {
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        NSMutableArray returnValue = null;
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getVisibleColumns(event);
            ++i;
        }
        if (event.accessibles != null) {
            NSMutableArray array = NSMutableArray.arrayWithCapacity(event.accessibles.length);
            Accessible[] accessibles = event.accessibles;
            int i2 = 0;
            while (i2 < accessibles.length) {
                Accessible acc = accessibles[i2];
                array.addObject(acc.delegate);
                ++i2;
            }
            returnValue = array;
        }
        return returnValue == null ? NSArray.array() : returnValue;
    }

    id getVisibleRowsAttribute(int childID) {
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        NSMutableArray returnValue = null;
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getVisibleRows(event);
            ++i;
        }
        if (event.accessibles != null) {
            NSMutableArray array = NSMutableArray.arrayWithCapacity(event.accessibles.length);
            Accessible[] accessibles = event.accessibles;
            int i2 = 0;
            while (i2 < accessibles.length) {
                Accessible acc = accessibles[i2];
                array.addObject(acc.delegate);
                ++i2;
            }
            returnValue = array;
        }
        return returnValue == null ? NSArray.array() : returnValue;
    }

    id getSelectedRowsAttribute(int childID) {
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        NSMutableArray returnValue = null;
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getSelectedRows(event);
            ++i;
        }
        if (event.selected != null) {
            int[] selected = event.selected;
            NSMutableArray array = NSMutableArray.arrayWithCapacity(selected.length);
            int i2 = 0;
            while (i2 < selected.length) {
                event.row = selected[i2];
                int j = 0;
                while (j < this.accessibleTableListenersSize()) {
                    AccessibleTableListener listener = this.accessibleTableListeners.get(j);
                    listener.getRow(event);
                    ++j;
                }
                if (event.accessible != null) {
                    array.addObject(event.accessible.delegate);
                }
                ++i2;
            }
            returnValue = array;
        }
        return returnValue == null ? NSArray.array() : returnValue;
    }

    int getRowCount() {
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getRowCount(event);
            ++i;
        }
        return event.count;
    }

    id getRowsAttribute(int childID) {
        AccessibleTableListener listener;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            listener = this.accessibleTableListeners.get(i);
            listener.getRowCount(event);
            listener.getRows(event);
            ++i;
        }
        if (event.accessibles == null) {
            event.accessibles = new Accessible[0];
        }
        if (event.count != event.accessibles.length) {
            this.createTableDelegate();
            i = 0;
            while (i < this.accessibleTableListenersSize()) {
                listener = this.accessibleTableListeners.get(i);
                listener.getRowCount(event);
                listener.getRows(event);
                ++i;
            }
        }
        NSMutableArray array = NSMutableArray.arrayWithCapacity(event.accessibles.length);
        Accessible[] rows = event.accessibles;
        int i2 = 0;
        while (i2 < rows.length) {
            Accessible acc = rows[i2];
            acc.index = i2++;
            array.addObject(acc.delegate);
        }
        return array;
    }

    id getSelectedColumnsAttribute(int childID) {
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        NSMutableArray returnValue = null;
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getSelectedColumns(event);
            ++i;
        }
        if (event.selected != null) {
            int[] selected = event.selected;
            NSMutableArray array = NSMutableArray.arrayWithCapacity(selected.length);
            int i2 = 0;
            while (i2 < selected.length) {
                event.column = selected[i2];
                int j = 0;
                while (j < this.accessibleTableListenersSize()) {
                    AccessibleTableListener listener = this.accessibleTableListeners.get(j);
                    listener.getColumn(event);
                    ++j;
                }
                if (event.accessible != null) {
                    array.addObject(event.accessible.delegate);
                }
                ++i2;
            }
            returnValue = array;
        }
        return returnValue == null ? NSArray.array() : returnValue;
    }

    int getColumnCount() {
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            AccessibleTableListener listener = this.accessibleTableListeners.get(i);
            listener.getColumnCount(event);
            ++i;
        }
        return event.count;
    }

    id getColumnsAttribute(int childID) {
        AccessibleTableListener listener;
        if (this.accessibleTableListenersSize() == 0) {
            return null;
        }
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < this.accessibleTableListenersSize()) {
            listener = this.accessibleTableListeners.get(i);
            listener.getColumnCount(event);
            listener.getColumns(event);
            ++i;
        }
        if (event.accessibles == null) {
            event.accessibles = new Accessible[0];
        }
        if (event.count != event.accessibles.length) {
            this.createTableDelegate();
            i = 0;
            while (i < this.accessibleTableListenersSize()) {
                listener = this.accessibleTableListeners.get(i);
                listener.getColumnCount(event);
                listener.getColumns(event);
                ++i;
            }
        }
        NSMutableArray array = NSMutableArray.arrayWithCapacity(event.accessibles.length);
        Accessible[] accessibles = event.accessibles;
        int i2 = 0;
        while (i2 < accessibles.length) {
            Accessible acc = accessibles[i2];
            acc.index = i2++;
            array.addObject(acc.delegate);
        }
        return array;
    }

    public id internal_accessibilityActionDescription(NSString action, int childID) {
        NSString returnValue = NSString.string();
        String actionName = action.getString();
        if (this.accessibleActionListenersSize() > 0) {
            AccessibleActionEvent event = new AccessibleActionEvent(this);
            int i = 0;
            while (i < this.accessibleActionListenersSize()) {
                AccessibleActionListener listener = this.accessibleActionListeners.get(i);
                listener.getActionCount(event);
                ++i;
            }
            int index = -1;
            int i2 = 0;
            while (i2 < event.count) {
                event.index = i2;
                int j = 0;
                while (j < this.accessibleActionListenersSize()) {
                    AccessibleActionListener listener = this.accessibleActionListeners.get(j);
                    listener.getName(event);
                    ++j;
                }
                if (actionName.equals(event.result)) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            if (index != -1) {
                event.index = index;
                event.result = null;
                i2 = 0;
                while (i2 < this.accessibleActionListenersSize()) {
                    AccessibleActionListener listener = this.accessibleActionListeners.get(i2);
                    listener.getDescription(event);
                    ++i2;
                }
                if (event.result != null) {
                    returnValue = NSString.stringWith(event.result);
                }
            }
        }
        return returnValue;
    }

    public NSArray internal_accessibilityActionNames(int childID) {
        if (this.accessibleActionListenersSize() > 0) {
            AccessibleActionEvent event = new AccessibleActionEvent(this);
            int i = 0;
            while (i < this.accessibleActionListenersSize()) {
                AccessibleActionListener listener = this.accessibleActionListeners.get(i);
                listener.getActionCount(event);
                ++i;
            }
            NSMutableArray array = NSMutableArray.arrayWithCapacity(event.count);
            int i2 = 0;
            while (i2 < event.count) {
                event.index = i2;
                int j = 0;
                while (j < this.accessibleActionListenersSize()) {
                    AccessibleActionListener listener = this.accessibleActionListeners.get(j);
                    listener.getName(event);
                    ++j;
                }
                array.addObject(NSString.stringWith(event.result));
                ++i2;
            }
            return array;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail == -1) {
            return null;
        }
        this.checkRole(event.detail);
        if (childID == -1 && this.actionNames != null) {
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(5L);
        switch (event.detail) {
            case 30: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 62: 
            case 1027: 
            case 1073: {
                returnValue.addObject(OS.NSAccessibilityPressAction);
                break;
            }
            case 46: {
                returnValue.addObject(OS.NSAccessibilityConfirmAction);
                break;
            }
        }
        if (childID == -1) {
            this.actionNames = returnValue;
            this.actionNames.retain();
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        return returnValue;
    }

    public boolean internal_accessibilityIsAttributeSettable(NSString attribute, int childID) {
        if (this.accessibleTextExtendedListenersSize() > 0) {
            if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
                return true;
            }
            if (attribute.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
                return true;
            }
        }
        if (this.accessibleEditableTextListenersSize() > 0 && attribute.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return true;
        }
        return this.accessibleValueListenersSize() > 0 && attribute.isEqualToString(OS.NSAccessibilityValueAttribute);
    }

    public NSArray internal_accessibilityAttributeNames(int childID) {
        String osRole;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail == -1) {
            return null;
        }
        this.checkRole(event.detail);
        if (this.attributeNames != null) {
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(baseAttributes.length);
        int i2 = 0;
        while (i2 < baseAttributes.length) {
            returnValue.addObject(baseAttributes[i2]);
            ++i2;
        }
        switch (event.detail) {
            case 10: {
                break;
            }
            case 9: {
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 2: {
                returnValue.addObject(OS.NSAccessibilitySelectedChildrenAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 11: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedChildrenAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 12: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                break;
            }
            case 21: {
                returnValue.addObject(OS.NSAccessibilityMaxValueAttribute);
                returnValue.addObject(OS.NSAccessibilityMinValueAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 13: {
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 3: {
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 18: {
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 41: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 43: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 44: 
            case 45: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 62: {
                break;
            }
            case 46: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityExpandedAttribute);
                returnValue.addObject(OS.NSAccessibilityNumberOfCharactersAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedTextAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedTextRangeAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleCharacterRangeAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 42: 
            case 1044: 
            case 1054: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityNumberOfCharactersAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedTextAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedTextRangeAttribute);
                returnValue.addObject(OS.NSAccessibilityInsertionPointLineNumberAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedTextRangesAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleCharacterRangeAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 22: {
                break;
            }
            case 33: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilityRowsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityHeaderAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                break;
            }
            case 34: {
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 24: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilityRowsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityHeaderAttribute);
                break;
            }
            case 29: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 35: {
                returnValue.addObject(OS.NSAccessibilityColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilityRowsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityHeaderAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
                break;
            }
            case 36: {
                returnValue.addObject(OS.NSAccessibilityColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedColumnsAttribute);
                returnValue.addObject(OS.NSAccessibilityRowsAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityHeaderAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleColumnsAttribute);
            }
            case 60: {
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                returnValue.addObject(OS.NSAccessibilityContentsAttribute);
                returnValue.addObject(OS.NSAccessibilityTabsAttribute);
                break;
            }
            case 37: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                break;
            }
            case 48: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityMaxValueAttribute);
                returnValue.addObject(OS.NSAccessibilityMinValueAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 51: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityMaxValueAttribute);
                returnValue.addObject(OS.NSAccessibilityMinValueAttribute);
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
                break;
            }
            case 30: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                break;
            }
            case 8: {
                break;
            }
            case 54: {
                break;
            }
            case 1025: {
                break;
            }
            case 27: {
                returnValue.removeObject(OS.NSAccessibilityChildrenAttribute);
                returnValue.removeObject(OS.NSAccessibilityFocusedAttribute);
                returnValue.addObject(OS.NSAccessibilityIndexAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedAttribute);
                returnValue.addObject(OS.NSAccessibilityRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityVisibleRowsAttribute);
                returnValue.addObject(OS.NSAccessibilityHeaderAttribute);
                break;
            }
            case 15: {
                break;
            }
            case 40: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
                returnValue.addObject(OS.NSAccessibilityDescriptionAttribute);
                break;
            }
            case 20: {
                break;
            }
            case 28: {
                returnValue.addObject(OS.NSAccessibilityVisibleChildrenAttribute);
                returnValue.addObject(OS.NSAccessibilityIndexAttribute);
                returnValue.addObject(OS.NSAccessibilitySelectedAttribute);
                break;
            }
            case 52: {
                break;
            }
            case 23: {
                break;
            }
            case 1027: {
                break;
            }
            case 1073: {
                break;
            }
            case 61: {
                break;
            }
            case 1029: {
                break;
            }
            case 47: {
                break;
            }
            case 1038: {
                break;
            }
            case 1043: {
                break;
            }
            case 1040: {
                break;
            }
            case 1053: {
                break;
            }
        }
        if (event.detail != -1 && (osRole = this.roleToOs(event.detail)).indexOf(58) == -1) {
            returnValue.removeObject(OS.NSAccessibilitySubroleAttribute);
        }
        if (childID != -1) {
            returnValue.removeObject(OS.NSAccessibilityChildrenAttribute);
        }
        if (childID == -1) {
            this.attributeNames = returnValue;
            this.attributeNames.retain();
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        return returnValue;
    }

    public id internal_accessibilityAttributeValue(NSString attribute, int childID) {
        if (attribute.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
            return this.getRoleAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySubroleAttribute)) {
            return this.getSubroleAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            return this.getRoleDescriptionAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityExpandedAttribute)) {
            return this.getExpandedAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
            return this.getHelpAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
            return this.getTitleAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            return this.getValueAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityMaxValueAttribute)) {
            return this.getMaxValueAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityMinValueAttribute)) {
            return this.getMinValueAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return this.getEnabledAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            return this.getFocusedAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityParentAttribute)) {
            return this.getParentAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            return this.getChildrenAttribute(childID, false);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityVisibleChildrenAttribute)) {
            return this.getChildrenAttribute(childID, true);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityContentsAttribute)) {
            return this.getChildrenAttribute(childID, false);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTabsAttribute)) {
            return this.getTabsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityWindowAttribute)) {
            return this.getWindowAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTopLevelUIElementAttribute)) {
            return this.getTopLevelUIElementAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityPositionAttribute)) {
            return this.getPositionAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySizeAttribute)) {
            return this.getSizeAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return this.getDescriptionAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityNumberOfCharactersAttribute)) {
            return this.getNumberOfCharactersAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return this.getSelectedTextAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            return this.getSelectedTextRangeAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityInsertionPointLineNumberAttribute)) {
            return this.getInsertionPointLineNumberAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextRangesAttribute)) {
            return this.getSelectedTextRangesAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            return this.getVisibleCharacterRangeAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityServesAsTitleForUIElementsAttribute)) {
            return this.getServesAsTitleForUIElementsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTitleUIElementAttribute)) {
            return this.getTitleUIElementAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityColumnsAttribute)) {
            return this.getColumnsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedColumnsAttribute)) {
            return this.getSelectedColumnsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRowsAttribute)) {
            return this.getRowsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedRowsAttribute)) {
            return this.getSelectedRowsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityVisibleRowsAttribute)) {
            return this.getVisibleRowsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) {
            return this.getVisibleColumnsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityHeaderAttribute)) {
            return this.getHeaderAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityIndexAttribute)) {
            return this.getIndexAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedAttribute)) {
            return this.getSelectedAttribute(childID);
        }
        if (OS.VERSION >= 4192 && attribute.isEqualToString(OS.NSAccessibilityRowIndexRangeAttribute)) {
            return this.getRowIndexRangeAttribute(childID);
        }
        if (OS.VERSION >= 4192 && attribute.isEqualToString(OS.NSAccessibilityColumnIndexRangeAttribute)) {
            return this.getColumnIndexRangeAttribute(childID);
        }
        return null;
    }

    public id internal_accessibilityAttributeValue_forParameter(NSString attribute, id parameter, int childID) {
        if (attribute.isEqualToString(OS.NSAccessibilityStringForRangeParameterizedAttribute)) {
            return this.getStringForRangeParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRangeForLineParameterizedAttribute)) {
            return this.getRangeForLineParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRangeForIndexParameterizedAttribute)) {
            return this.getRangeForIndexParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityLineForIndexParameterizedAttribute)) {
            return this.getLineForIndexParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityBoundsForRangeParameterizedAttribute)) {
            return this.getBoundsForRangeParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRangeForPositionParameterizedAttribute)) {
            return this.getRangeForPositionParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityAttributedStringForRangeParameterizedAttribute)) {
            return this.getAttributedStringForRangeParameterizedAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityStyleRangeForIndexParameterizedAttribute)) {
            return this.getStyleRangeForIndexAttribute(parameter, childID);
        }
        if (OS.VERSION >= 4192 && attribute.isEqualToString(OS.NSAccessibilityCellForColumnAndRowParameterizedAttribute)) {
            return this.getCellForColumnAndRowParameter(parameter, childID);
        }
        return null;
    }

    public id internal_accessibilityFocusedUIElement(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -3;
        event.accessible = null;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getFocus(event);
            ++i;
        }
        if (event.childID == -3) {
            return null;
        }
        if (event.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(event.accessible.control.view.id));
        }
        if (event.childID == -1 || event.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)event.childID).id));
    }

    public id internal_accessibilityHitTest(NSPoint point, int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.x = (int)point.x;
        Monitor primaryMonitor = Display.getCurrent().getPrimaryMonitor();
        event.y = (int)((double)primaryMonitor.getBounds().height - point.y);
        event.childID = -3;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getChildAtPoint(event);
            ++i;
        }
        if (event.childID == -3 && event.accessible == null) {
            return null;
        }
        if (event.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(event.accessible.delegate.id));
        }
        if (event.childID == -1 || event.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)event.childID).id));
    }

    public boolean internal_accessibilityIsIgnored(int childID) {
        boolean shouldIgnore;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        boolean bl = shouldIgnore = event.detail == -1;
        if (shouldIgnore) {
            shouldIgnore = this.getTitleAttribute(childID) == null && this.getHelpAttribute(childID) == null && this.getDescriptionAttribute(childID) == null;
        }
        return shouldIgnore;
    }

    public NSArray internal_accessibilityParameterizedAttributeNames(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail == -1) {
            return null;
        }
        this.checkRole(event.detail);
        if (childID == -1 && this.parameterizedAttributeNames != null) {
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(4L);
        switch (event.detail) {
            case 42: 
            case 1044: 
            case 1054: {
                returnValue.addObject(OS.NSAccessibilityStringForRangeParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityRangeForLineParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityRangeForIndexParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityLineForIndexParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityBoundsForRangeParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityRangeForPositionParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityAttributedStringForRangeParameterizedAttribute);
                returnValue.addObject(OS.NSAccessibilityStyleRangeForIndexParameterizedAttribute);
                break;
            }
            case 24: {
                if (OS.VERSION < 4192) break;
                returnValue.addObject(OS.NSAccessibilityCellForColumnAndRowParameterizedAttribute);
            }
        }
        if (childID == -1) {
            this.parameterizedAttributeNames = returnValue;
            this.parameterizedAttributeNames.retain();
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        return returnValue;
    }

    public boolean internal_accessibilityPerformAction(NSString action, int childID) {
        String actionName = action.getString();
        if (this.accessibleActionListenersSize() > 0) {
            AccessibleActionEvent event = new AccessibleActionEvent(this);
            int i = 0;
            while (i < this.accessibleActionListenersSize()) {
                AccessibleActionListener listener = this.accessibleActionListeners.get(i);
                listener.getActionCount(event);
                ++i;
            }
            int index = -1;
            int i2 = 0;
            while (i2 < event.count) {
                event.index = i2;
                int j = 0;
                while (j < this.accessibleActionListenersSize()) {
                    AccessibleActionListener listener = this.accessibleActionListeners.get(j);
                    listener.getName(event);
                    ++j;
                }
                if (actionName.equals(event.result)) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            if (index != -1) {
                event.index = index;
                event.result = null;
                i2 = 0;
                while (i2 < this.accessibleActionListenersSize()) {
                    AccessibleActionListener listener = this.accessibleActionListeners.get(i2);
                    listener.doAction(event);
                    ++i2;
                }
                return "OK".equals(event.result);
            }
        }
        return false;
    }

    public void internal_accessibilitySetValue_forAttribute(id value, NSString attribute, int childId) {
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            this.setSelectedTextRangeAttribute(value, childId);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            this.setSelectedTextAttribute(value, childId);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            this.setVisibleCharacterRangeAttribute(value, childId);
        }
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent event = new AccessibleValueEvent(this);
            NSNumber number = new NSNumber(value);
            event.value = new Double(number.doubleValue());
            int i = 0;
            while (i < this.accessibleValueListenersSize()) {
                AccessibleValueListener listener = this.accessibleValueListeners.get(i);
                listener.setCurrentValue(event);
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release(true);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        this.release(true);
    }

    id getAttributedStringForRangeParameterizedAttribute(id parameter, int childID) {
        if (this.accessibleAttributeListenersSize() == 0) {
            return null;
        }
        id stringFragment = this.getStringForRangeParameterizedAttribute(parameter, childID);
        NSMutableAttributedString attribString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        attribString.initWithString(new NSString(stringFragment), null);
        attribString.autorelease();
        NSValue parameterObject = new NSValue(parameter.id);
        NSRange range = parameterObject.rangeValue();
        AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(this);
        event.offset = (int)range.location;
        event.end = -1;
        event.start = -1;
        NSRange attributeRange = new NSRange();
        while ((long)event.offset < range.location + range.length) {
            int i = 0;
            while (i < this.accessibleAttributeListenersSize()) {
                AccessibleAttributeListener listener = this.accessibleAttributeListeners.get(i);
                listener.getTextAttributes(event);
                ++i;
            }
            if (event.start == -1 && event.end == -1) {
                return stringFragment;
            }
            attributeRange.location = (long)event.start - range.location;
            attributeRange.length = event.end - event.start;
            if (attributeRange.location < 0L) {
                attributeRange.length -= -attributeRange.location;
                attributeRange.location = 0L;
            }
            if (attributeRange.location + attributeRange.length > range.length) {
                attributeRange.length = range.length - attributeRange.location;
            }
            event.offset = event.end;
            if (event.textStyle == null) continue;
            TextStyle ts = event.textStyle;
            if (ts.font != null) {
                NSMutableDictionary fontInfoDict = NSMutableDictionary.dictionaryWithCapacity(4L);
                NSFont fontUsed = ts.font.handle;
                NSString fontName = fontUsed.fontName();
                fontInfoDict.setValue(fontName, OS.NSAccessibilityFontNameKey);
                NSString familyName = fontUsed.familyName();
                fontInfoDict.setValue(familyName, OS.NSAccessibilityFontFamilyKey);
                NSString displayName = fontUsed.displayName();
                fontInfoDict.setValue(displayName, OS.NSAccessibilityVisibleNameKey);
                double fontSize = fontUsed.pointSize();
                fontInfoDict.setValue(NSNumber.numberWithDouble(fontSize), OS.NSAccessibilityFontSizeKey);
                attribString.addAttribute(OS.NSAccessibilityFontTextAttribute, fontInfoDict, attributeRange);
            }
            if (ts.foreground != null) {
                this.addCGColor(ts.foreground.handle, attribString, OS.NSAccessibilityForegroundColorTextAttribute, attributeRange);
            }
            if (ts.background != null) {
                this.addCGColor(ts.background.handle, attribString, OS.NSAccessibilityBackgroundColorTextAttribute, attributeRange);
            }
            if (ts.underline) {
                int style = ts.underlineStyle;
                NSString attribute = OS.NSAccessibilityUnderlineTextAttribute;
                NSNumber styleObj = null;
                switch (style) {
                    case 0: {
                        styleObj = NSNumber.numberWithInt(1);
                        break;
                    }
                    case 1: {
                        styleObj = NSNumber.numberWithInt(9);
                        break;
                    }
                    case 3: {
                        attribute = OS.NSAccessibilityMisspelledTextAttribute;
                        styleObj = NSNumber.numberWithBool(true);
                        break;
                    }
                    default: {
                        styleObj = NSNumber.numberWithInt(0);
                    }
                }
                attribString.addAttribute(attribute, styleObj, attributeRange);
            }
            if (ts.underlineColor != null) {
                this.addCGColor(ts.underlineColor.handle, attribString, OS.NSAccessibilityUnderlineColorTextAttribute, attributeRange);
            }
            if (ts.strikeout) {
                attribString.addAttribute(OS.NSAccessibilityStrikethroughTextAttribute, NSNumber.numberWithBool(true), attributeRange);
                if (ts.strikeoutColor != null) {
                    this.addCGColor(ts.strikeoutColor.handle, attribString, OS.NSAccessibilityStrikethroughColorTextAttribute, attributeRange);
                }
            }
            if (ts.data == null || !(ts.data instanceof URL)) continue;
            URL dataAsURL = (URL)ts.data;
            NSURL linkURL = NSURL.URLWithString(NSString.stringWith(dataAsURL.toExternalForm()));
            attribString.addAttribute(OS.NSAccessibilityLinkTextAttribute, linkURL, attributeRange);
        }
        AccessibleAttributeEvent docAttributes = new AccessibleAttributeEvent(this);
        docAttributes.indent = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.accessibleAttributeListenersSize()) {
            AccessibleAttributeListener listener = this.accessibleAttributeListeners.get(i);
            listener.getAttributes(docAttributes);
            ++i;
        }
        if (docAttributes.indent != Integer.MAX_VALUE) {
            NSMutableDictionary paragraphDict = NSMutableDictionary.dictionaryWithCapacity(3L);
            int osAlignment = 0;
            switch (docAttributes.alignment) {
                case 0x1000000: {
                    osAlignment = 2;
                    break;
                }
                case 131072: {
                    osAlignment = 1;
                    break;
                }
                default: {
                    osAlignment = 0;
                }
            }
            paragraphDict.setValue(NSNumber.numberWithInt(osAlignment), NSString.stringWith("AXTextAlignment"));
            range.location = 0L;
            attribString.addAttribute(NSString.stringWith("AXParagraphStyle"), paragraphDict, range);
        }
        return attribString;
    }

    id getBoundsForRangeParameterizedAttribute(id parameter, int childID) {
        if (this.accessibleTextExtendedListenersSize() == 0) {
            return null;
        }
        NSValue returnValue = null;
        NSValue parameterObject = new NSValue(parameter.id);
        NSRange range = parameterObject.rangeValue();
        NSRect rect = new NSRect();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.start = (int)range.location;
            event.end = (int)(range.location + range.length);
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getTextBounds(event);
                ++i;
            }
            rect.x = event.x;
            NSArray screens = NSScreen.screens();
            NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
            NSRect frame = screen.frame();
            rect.y = frame.height - (double)event.y - (double)event.height;
            rect.width = event.width;
            rect.height = event.height;
            returnValue = NSValue.valueWithRect(rect);
        }
        return returnValue;
    }

    id getExpandedAttribute(int childID) {
        return NSNumber.numberWithBool(false);
    }

    id getHelpAttribute(int childID) {
        NSString returnValue = null;
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = childID;
        int i = 0;
        while (i < this.accessibleListenersSize()) {
            AccessibleListener listener = this.accessibleListeners.get(i);
            listener.getHelp(event);
            ++i;
        }
        if (event.result != null) {
            returnValue = NSString.stringWith(event.result);
        }
        return returnValue;
    }

    id getRangeForPositionParameterizedAttribute(id parameter, int childID) {
        NSValue returnValue = null;
        NSValue parameterObject = new NSValue(parameter.id);
        NSPoint point = parameterObject.pointValue();
        NSRange range = new NSRange();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            NSArray screens = NSScreen.screens();
            NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
            NSRect frame = screen.frame();
            point.y = frame.height - point.y;
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.x = (int)point.x;
            event.y = (int)point.y;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getOffsetAtPoint(event);
                ++i;
            }
            range.location = event.offset;
            range.length = 1L;
        }
        returnValue = NSValue.valueWithRange(range);
        return returnValue;
    }

    NSString getRoleAttribute(int childID) {
        NSString returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            String appRole = this.roleToOs(event.detail);
            int index = appRole.indexOf(58);
            if (index != -1) {
                appRole = appRole.substring(0, index);
            }
            returnValue = NSString.stringWith(appRole);
        }
        return returnValue;
    }

    id getSubroleAttribute(int childID) {
        String appRole;
        int index;
        NSString returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1 && (index = (appRole = this.roleToOs(event.detail)).indexOf(58)) != -1) {
            appRole = appRole.substring(index + 1);
            returnValue = NSString.stringWith(appRole);
        }
        return returnValue;
    }

    id getRoleDescriptionAttribute(int childID) {
        NSString returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            if (event.detail == 37) {
                returnValue = new NSString(OS.NSAccessibilityRoleDescription(NSString.stringWith((String)"AXTab").id, 0L));
            } else {
                String appRole = this.roleToOs(event.detail);
                String appSubrole = null;
                int index = appRole.indexOf(58);
                if (index != -1) {
                    appSubrole = appRole.substring(index + 1);
                    appRole = appRole.substring(0, index);
                }
                NSString nsAppRole = NSString.stringWith(appRole);
                NSString nsAppSubrole = null;
                if (appSubrole != null) {
                    nsAppSubrole = NSString.stringWith(appSubrole);
                }
                returnValue = new NSString(OS.NSAccessibilityRoleDescription(nsAppRole != null ? nsAppRole.id : 0L, nsAppSubrole != null ? nsAppSubrole.id : 0L));
            }
        }
        return returnValue;
    }

    id getTitleAttribute(int childID) {
        NSString returnValue = null;
        AccessibleControlEvent roleEvent = new AccessibleControlEvent(this);
        roleEvent.childID = childID;
        roleEvent.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getRole(roleEvent);
            ++i;
        }
        if (roleEvent.detail != 41) {
            AccessibleEvent event = new AccessibleEvent(this);
            event.childID = childID;
            event.result = null;
            int i2 = 0;
            while (i2 < this.accessibleListenersSize()) {
                AccessibleListener listener = this.accessibleListeners.get(i2);
                listener.getName(event);
                ++i2;
            }
            if (event.result != null) {
                returnValue = NSString.stringWith(event.result);
            }
        }
        return returnValue;
    }

    id getTitleUIElementAttribute(int childID) {
        id returnValue = null;
        Relation relation = this.relations[9];
        if (relation != null) {
            returnValue = relation.getTitleUIElement();
        }
        return returnValue;
    }

    id getValueAttribute(int childID) {
        id returnValue = null;
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent event = new AccessibleValueEvent(this);
            int i = 0;
            while (i < this.accessibleValueListenersSize()) {
                AccessibleValueListener listener = this.accessibleValueListeners.get(i);
                listener.getCurrentValue(event);
                ++i;
            }
            returnValue = NSNumber.numberWithDouble(event.value.doubleValue());
        } else {
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.detail = -1;
            event.result = null;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getRole(event);
                listener.getValue(event);
                ++i;
            }
            int role = event.detail;
            String value = event.result;
            switch (role) {
                case 3: 
                case 44: 
                case 45: 
                case 48: 
                case 51: {
                    if (value != null) {
                        try {
                            int number = Integer.parseInt(value);
                            returnValue = NSNumber.numberWithBool(number != 0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (value.equalsIgnoreCase("true")) {
                                returnValue = NSNumber.numberWithBool(true);
                                break;
                            }
                            if (!value.equalsIgnoreCase("false")) break;
                            returnValue = NSNumber.numberWithBool(false);
                        }
                        break;
                    }
                    returnValue = NSNumber.numberWithBool(false);
                    break;
                }
                case 37: 
                case 60: {
                    AccessibleControlEvent ace = new AccessibleControlEvent(this);
                    ace.childID = -4;
                    int i2 = 0;
                    while (i2 < this.accessibleControlListenersSize()) {
                        AccessibleControlListener listener = this.accessibleControlListeners.get(i2);
                        listener.getSelection(ace);
                        ++i2;
                    }
                    if (ace.childID >= -1) {
                        if (role == 37) {
                            returnValue = NSNumber.numberWithBool(ace.childID == childID);
                            break;
                        }
                        returnValue = new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)ace.childID).id));
                        break;
                    }
                    returnValue = NSNumber.numberWithBool(false);
                    break;
                }
                case 42: 
                case 46: 
                case 1044: 
                case 1054: {
                    if (value == null) break;
                    returnValue = NSString.stringWith(value);
                    break;
                }
                case 29: 
                case 41: {
                    AccessibleEvent e = new AccessibleEvent(this);
                    e.childID = childID;
                    e.result = null;
                    int i3 = 0;
                    while (i3 < this.accessibleListenersSize()) {
                        AccessibleListener listener = this.accessibleListeners.get(i3);
                        listener.getName(e);
                        ++i3;
                    }
                    if (e.result != null) {
                        returnValue = NSString.stringWith(e.result);
                    } else if (value != null) {
                        returnValue = NSString.stringWith(value);
                    }
                    returnValue = returnValue == null ? NSString.string() : returnValue;
                }
            }
        }
        return returnValue;
    }

    id getEnabledAttribute(int childID) {
        boolean enabled;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.detail = 0;
        event.childID = childID;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getState(event);
            ++i;
        }
        boolean bl = enabled = (event.detail & 1) == 0;
        if (!enabled && this.delegate == null) {
            enabled = this.control.isEnabled();
        }
        return NSNumber.numberWithBool(enabled);
    }

    id getFocusedAttribute(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -3;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getFocus(event);
            ++i;
        }
        if (event.accessible != null) {
            boolean hasFocus = event.accessible.index == childID && event.accessible.control == this.control;
            return NSNumber.numberWithBool(hasFocus);
        }
        if (event.childID == -1) {
            return NSNumber.numberWithBool(true);
        }
        if (event.childID == -2) {
            return NSNumber.numberWithBool(false);
        }
        if (event.childID != -3) {
            return NSNumber.numberWithBool(event.childID == childID);
        }
        return null;
    }

    id getParentAttribute(int childID) {
        id returnValue = null;
        returnValue = childID == -1 ? (this.parent != null ? (this.parent.delegate != null ? this.parent.delegate : new id(OS.NSAccessibilityUnignoredAncestor(this.accessibleHandle((Accessible)this.parent).id))) : null) : new id(OS.NSAccessibilityUnignoredAncestor(this.accessibleHandle((Accessible)this).id));
        return returnValue;
    }

    id getChildrenAttribute(int childID, boolean visibleOnly) {
        id returnValue = null;
        if (childID == -1) {
            if (this.currentRole == 24) {
                this.getRowsAttribute(childID);
                this.getColumnsAttribute(childID);
            }
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.detail = -1;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getChildCount(event);
                ++i;
            }
            int childCount = event.detail;
            int n = event.detail = visibleOnly ? 1 : 0;
            if (childCount >= 0) {
                int i2 = 0;
                while (i2 < this.accessibleControlListenersSize()) {
                    AccessibleControlListener listener = this.accessibleControlListeners.get(i2);
                    listener.getChildren(event);
                    ++i2;
                }
                Object[] children = event.children;
                childCount = children != null ? children.length : 0;
                NSMutableArray childArray = NSMutableArray.arrayWithCapacity(childCount);
                int i3 = 0;
                while (i3 < childCount) {
                    Object child = children[i3];
                    if (child instanceof Accessible) {
                        Accessible accessible = (Accessible)child;
                        if (accessible.delegate != null) {
                            childArray.addObject(accessible.delegate);
                        } else {
                            childArray.addObject(this.accessibleHandle(accessible));
                        }
                    } else if (child instanceof Integer) {
                        id accChild = this.childIDToOs((Integer)child);
                        childArray.addObject(accChild);
                    }
                    ++i3;
                }
                returnValue = new id(OS.NSAccessibilityUnignoredChildren(childArray.id));
            }
        } else {
            returnValue = NSArray.array();
        }
        return returnValue;
    }

    id getTabsAttribute(int childID) {
        id returnValue = null;
        if (childID == -1) {
            AccessibleControlListener listener;
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.detail = -1;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                listener = this.accessibleControlListeners.get(i);
                listener.getChildCount(event);
                ++i;
            }
            if (event.detail > 0) {
                i = 0;
                while (i < this.accessibleControlListenersSize()) {
                    listener = this.accessibleControlListeners.get(i);
                    listener.getChildren(event);
                    ++i;
                }
                Object[] appChildren = event.children;
                if (appChildren != null && appChildren.length > 0) {
                    NSMutableArray childArray = NSMutableArray.arrayWithCapacity(appChildren.length);
                    int i2 = 0;
                    while (i2 < appChildren.length) {
                        Object child = appChildren[i2];
                        if (child instanceof Integer) {
                            int subChildID;
                            event.childID = subChildID = ((Integer)child).intValue();
                            event.detail = -1;
                            int j = 0;
                            while (j < this.accessibleControlListenersSize()) {
                                AccessibleControlListener listener2 = this.accessibleControlListeners.get(j);
                                listener2.getRole(event);
                                ++j;
                            }
                            if (event.detail == 37) {
                                id accChild = this.childIDToOs((Integer)child);
                                childArray.addObject(accChild);
                            }
                        } else {
                            childArray.addObject(((Accessible)child).control.view);
                        }
                        ++i2;
                    }
                    returnValue = new id(OS.NSAccessibilityUnignoredChildren(childArray.id));
                }
            }
        } else {
            returnValue = NSArray.array();
        }
        return returnValue;
    }

    id getWindowAttribute(int childID) {
        return this.control.view.window();
    }

    id getTopLevelUIElementAttribute(int childID) {
        return this.control.view.window();
    }

    id getPositionAttribute(int childID) {
        NSValue returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.width = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getLocation(event);
            ++i;
        }
        Monitor primaryMonitor = Display.getCurrent().getPrimaryMonitor();
        NSPoint osPositionAttribute = new NSPoint();
        if (event.width != -1) {
            osPositionAttribute.x = event.x;
            osPositionAttribute.y = primaryMonitor.getBounds().height - event.y - event.height;
            returnValue = NSValue.valueWithPoint(osPositionAttribute);
        } else if (childID != -1) {
            Point pt = null;
            Rectangle location = this.control.getBounds();
            pt = this.control.getParent() != null ? this.control.getParent().toDisplay(location.x, location.y) : ((Shell)this.control).toDisplay(location.x, location.y);
            osPositionAttribute.x = pt.x;
            osPositionAttribute.y = pt.y;
            returnValue = NSValue.valueWithPoint(osPositionAttribute);
        }
        return returnValue;
    }

    id getSizeAttribute(int childID) {
        NSValue returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.width = -1;
        int i = 0;
        while (i < this.accessibleControlListenersSize()) {
            AccessibleControlListener listener = this.accessibleControlListeners.get(i);
            listener.getLocation(event);
            ++i;
        }
        NSSize controlSize = new NSSize();
        if (event.width != -1) {
            controlSize.width = event.width;
            controlSize.height = event.height;
            returnValue = NSValue.valueWithSize(controlSize);
        } else if (childID != -1) {
            controlSize.height = 0.0;
            controlSize.width = 0.0;
            returnValue = NSValue.valueWithSize(controlSize);
        }
        return returnValue;
    }

    id getCellForColumnAndRowParameter(id parameter, int childID) {
        SWTAccessibleDelegate returnValue = null;
        NSArray parameterObject = new NSArray(parameter.id);
        if (parameterObject.count() == 2L) {
            AccessibleTableEvent event = new AccessibleTableEvent(this);
            event.column = new NSNumber(parameterObject.objectAtIndex(0L)).intValue();
            event.row = new NSNumber(parameterObject.objectAtIndex(1L)).intValue();
            int i = 0;
            while (i < this.accessibleTableListenersSize()) {
                AccessibleTableListener listener = this.accessibleTableListeners.get(i);
                listener.getCell(event);
                returnValue = event.accessible.delegate;
                ++i;
            }
        }
        return returnValue;
    }

    id getDescriptionAttribute(int childID) {
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = childID;
        event.result = null;
        NSString returnValue = null;
        int i = 0;
        while (i < this.accessibleListenersSize()) {
            AccessibleListener listener = this.accessibleListeners.get(i);
            listener.getDescription(event);
            ++i;
        }
        NSString nSString = returnValue = event.result != null ? NSString.stringWith(event.result) : null;
        if (returnValue == null && this.control instanceof Composite) {
            returnValue = NSString.string();
        }
        return returnValue;
    }

    id getInsertionPointLineNumberAttribute(int childID) {
        NSNumber returnValue = null;
        if (this.accessibleTextExtendedListenersSize() > 0) {
            int caretOffset;
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getCaretOffset(event);
                ++i;
            }
            event.start = caretOffset = event.offset;
            event.end = caretOffset;
            event.count = Integer.MIN_VALUE;
            event.type = 4;
            int i2 = 0;
            while (i2 < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i2);
                listener.getText(event);
                ++i2;
            }
            returnValue = NSNumber.numberWithInt(Math.max(0, -event.count));
        } else {
            AccessibleControlEvent controlEvent = new AccessibleControlEvent(this);
            controlEvent.childID = childID;
            controlEvent.result = null;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getValue(controlEvent);
                ++i;
            }
            AccessibleTextEvent textEvent = new AccessibleTextEvent(this);
            textEvent.childID = childID;
            textEvent.offset = -1;
            int i3 = 0;
            while (i3 < this.accessibleTextListenersSize()) {
                AccessibleTextListener listener = this.accessibleTextListeners.get(i3);
                listener.getCaretOffset(textEvent);
                ++i3;
            }
            if (controlEvent.result != null && textEvent.offset != -1) {
                int lineNumber = this.lineNumberForOffset(controlEvent.result, textEvent.offset);
                returnValue = NSNumber.numberWithInt(lineNumber);
            }
        }
        return returnValue;
    }

    id getLineForIndexParameterizedAttribute(id parameter, int childID) {
        NSNumber returnValue = null;
        NSNumber charNumberObj = new NSNumber(parameter.id);
        int charNumber = charNumberObj.intValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.start = charNumber;
            event.end = charNumber;
            event.count = Integer.MIN_VALUE;
            event.type = 4;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getText(event);
                ++i;
            }
            returnValue = NSNumber.numberWithInt(Math.max(0, -event.count));
        } else {
            AccessibleControlEvent controlEvent = new AccessibleControlEvent(this);
            controlEvent.childID = childID;
            controlEvent.result = null;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getValue(controlEvent);
                ++i;
            }
            String text = controlEvent.result;
            if (text != null) {
                returnValue = NSNumber.numberWithInt(this.lineNumberForOffset(text, charNumber));
            }
        }
        return returnValue;
    }

    id getMaxValueAttribute(int childID) {
        NSNumber returnValue = null;
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent event = new AccessibleValueEvent(this);
            int i = 0;
            while (i < this.accessibleValueListenersSize()) {
                AccessibleValueListener listener = this.accessibleValueListeners.get(i);
                listener.getMaximumValue(event);
                ++i;
            }
            returnValue = NSNumber.numberWithDouble(event.value.doubleValue());
        }
        return returnValue;
    }

    id getMinValueAttribute(int childID) {
        NSNumber returnValue = null;
        if (this.accessibleValueListenersSize() > 0) {
            AccessibleValueEvent event = new AccessibleValueEvent(this);
            int i = 0;
            while (i < this.accessibleValueListenersSize()) {
                AccessibleValueListener listener = this.accessibleValueListeners.get(i);
                listener.getMinimumValue(event);
                ++i;
            }
            returnValue = NSNumber.numberWithDouble(event.value.doubleValue());
        }
        return returnValue;
    }

    id getNumberOfCharactersAttribute(int childID) {
        NSNumber returnValue = null;
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.count = -1;
        int i = 0;
        while (i < this.accessibleTextExtendedListenersSize()) {
            AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
            listener.getCharacterCount(event);
            ++i;
        }
        if (event.count != -1) {
            AccessibleControlEvent e = new AccessibleControlEvent(this);
            e.childID = -1;
            int i2 = 0;
            while (i2 < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i2);
                listener.getRole(e);
                listener.getValue(e);
                ++i2;
            }
            event.count = e.detail == 42 && e.result != null ? e.result.length() : 0;
            returnValue = NSNumber.numberWithInt(event.count);
        }
        return returnValue;
    }

    id getRangeForLineParameterizedAttribute(id parameter, int childID) {
        NSValue returnValue = null;
        NSNumber lineNumberObj = new NSNumber(parameter.id);
        int lineNumber = lineNumberObj.intValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.end = 0;
            event.start = 0;
            event.count = lineNumber;
            event.type = 4;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getText(event);
                ++i;
            }
            NSRange range = new NSRange();
            range.location = event.start;
            range.length = event.end - event.start;
            returnValue = NSValue.valueWithRange(range);
        } else if (this.accessibleControlListenersSize() > 0) {
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.result = null;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getValue(event);
                ++i;
            }
            if (event.result != null) {
                NSRange range = this.rangeForLineNumber(lineNumber, event.result);
                if (range.location != -1L) {
                    returnValue = NSValue.valueWithRange(range);
                }
            }
        }
        return returnValue;
    }

    id getRangeForIndexParameterizedAttribute(id parameter, int childID) {
        NSValue returnValue = null;
        NSNumber charNumberObj = new NSNumber(parameter.id);
        int charNumber = charNumberObj.intValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.end = 0;
            event.start = 0;
            event.count = charNumber;
            event.type = 0;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getText(event);
                ++i;
            }
            NSRange range = new NSRange();
            range.location = event.start;
            range.length = event.end - event.start;
            returnValue = NSValue.valueWithRange(range);
        } else {
            this.accessibleControlListenersSize();
        }
        return returnValue;
    }

    id getSelectedTextAttribute(int childID) {
        NSString returnValue = NSString.string();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            String text;
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.index = 0;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getSelection(event);
                ++i;
            }
            int start = event.start;
            int end = event.end;
            if (start != end) {
                event.type = 5;
                int i2 = 0;
                while (i2 < this.accessibleTextExtendedListenersSize()) {
                    AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i2);
                    listener.getText(event);
                    ++i2;
                }
            }
            if ((text = event.result) != null) {
                returnValue = NSString.stringWith(text);
            }
        } else if (this.accessibleTextListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.offset = -1;
            event.length = -1;
            int i = 0;
            while (i < this.accessibleTextListenersSize()) {
                AccessibleTextListener listener = this.accessibleTextListeners.get(i);
                listener.getSelectionRange(event);
                ++i;
            }
            int offset = event.offset;
            int length = event.length;
            if (offset != -1 && length != -1 && length != 0) {
                AccessibleControlEvent event2 = new AccessibleControlEvent(this);
                event2.childID = event.childID;
                event2.result = null;
                int i3 = 0;
                while (i3 < this.accessibleControlListenersSize()) {
                    AccessibleControlListener listener = this.accessibleControlListeners.get(i3);
                    listener.getValue(event2);
                    ++i3;
                }
                String appValue = event2.result;
                if (appValue != null) {
                    returnValue = NSString.stringWith(appValue.substring(offset, offset + length));
                }
            }
        }
        return returnValue;
    }

    id getSelectedTextRangeAttribute(int childID) {
        NSValue returnValue = null;
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.index = 0;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getSelection(event);
                ++i;
            }
            NSRange range = new NSRange();
            range.location = event.start;
            range.length = event.end - event.start;
            returnValue = NSValue.valueWithRange(range);
        } else if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.offset = -1;
            event.length = 0;
            int i = 0;
            while (i < this.accessibleTextListenersSize()) {
                AccessibleTextListener listener = this.accessibleTextListeners.get(i);
                listener.getSelectionRange(event);
                ++i;
            }
            if (event.offset != -1) {
                NSRange range = new NSRange();
                range.location = event.offset;
                range.length = event.length;
                returnValue = NSValue.valueWithRange(range);
            }
        }
        return returnValue;
    }

    id getServesAsTitleForUIElementsAttribute(int childID) {
        id returnValue = null;
        Relation relation = this.relations[8];
        if (relation != null) {
            returnValue = relation.getServesAsTitleForUIElements();
        }
        return returnValue;
    }

    id getStringForRangeParameterizedAttribute(id parameter, int childID) {
        NSString returnValue = null;
        NSValue parameterObject = new NSValue(parameter.id);
        NSRange range = parameterObject.rangeValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.start = (int)range.location;
            event.end = (int)(range.location + range.length);
            event.type = 5;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getText(event);
                ++i;
            }
            if (event.result != null) {
                returnValue = NSString.stringWith(event.result);
            }
        } else if (this.accessibleControlListenersSize() > 0) {
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.result = null;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getValue(event);
                ++i;
            }
            String appValue = event.result;
            if (appValue != null) {
                returnValue = NSString.stringWith(appValue.substring((int)range.location, (int)(range.location + range.length)));
            }
        }
        return returnValue;
    }

    id getSelectedTextRangesAttribute(int childID) {
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(3L);
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getSelectionCount(event);
                ++i;
            }
            if (event.count > 0) {
                i = 0;
                while (i < event.count) {
                    event.index = i;
                    int j = 0;
                    while (j < this.accessibleTextExtendedListenersSize()) {
                        AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(j);
                        listener.getSelection(event);
                        ++j;
                    }
                    NSRange range = new NSRange();
                    range.location = event.start;
                    range.length = event.end - event.start;
                    returnValue.addObject(NSValue.valueWithRange(range));
                    ++i;
                }
            }
        } else if (this.accessibleTextListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            event.offset = -1;
            event.length = 0;
            int i = 0;
            while (i < this.accessibleTextListenersSize()) {
                AccessibleTextListener listener = this.accessibleTextListeners.get(i);
                listener.getSelectionRange(event);
                ++i;
            }
            if (event.offset != -1) {
                NSRange range = new NSRange();
                range.location = event.offset;
                range.length = event.length;
                returnValue.addObject(NSValue.valueWithRange(range));
            }
        }
        if (returnValue.count() == 0L) {
            returnValue.addObject(NSValue.valueWithRange(new NSRange()));
        }
        return returnValue;
    }

    id getStyleRangeForIndexAttribute(id parameter, int childID) {
        if (this.accessibleAttributeListenersSize() == 0) {
            return null;
        }
        NSNumber parameterObject = new NSNumber(parameter.id);
        int index = parameterObject.intValue();
        AccessibleTextAttributeEvent event = new AccessibleTextAttributeEvent(this);
        event.offset = index;
        event.end = -1;
        event.start = -1;
        int i = 0;
        while (i < this.accessibleAttributeListenersSize()) {
            AccessibleAttributeListener listener = this.accessibleAttributeListeners.get(i);
            listener.getTextAttributes(event);
            ++i;
        }
        NSRange range = new NSRange();
        if (event.start == -1 && event.end == -1) {
            range.location = index;
            range.length = 0L;
        } else {
            range.location = event.start;
            range.length = event.end - event.start;
        }
        return NSValue.valueWithRange(range);
    }

    id getVisibleCharacterRangeAttribute(int childID) {
        NSRange range = null;
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.childID = childID;
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.getVisibleRanges(event);
                ++i;
            }
            range = new NSRange();
            range.location = event.start;
            range.length = event.end - event.start;
        } else if (this.accessibleControlListenersSize() > 0) {
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.result = null;
            int i = 0;
            while (i < this.accessibleControlListenersSize()) {
                AccessibleControlListener listener = this.accessibleControlListeners.get(i);
                listener.getValue(event);
                ++i;
            }
            if (event.result != null) {
                range = new NSRange();
                range.location = 0L;
                range.length = event.result.length();
            }
        }
        return range != null ? NSValue.valueWithRange(range) : null;
    }

    int lineNumberForOffset(String text, int offset) {
        int lineNumber = 1;
        int length = text.length();
        int i = 0;
        while (i < offset) {
            switch (text.charAt(i)) {
                case '\r': {
                    if (i + 1 < length && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    ++lineNumber;
                }
            }
            ++i;
        }
        return lineNumber;
    }

    NSRange rangeForLineNumber(int lineNumber, String text) {
        NSRange range = new NSRange();
        range.location = -1L;
        int line = 1;
        int count = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            if (line == lineNumber) {
                if (count == 0) {
                    range.location = i;
                }
                ++count;
            }
            if (line > lineNumber) break;
            switch (text.charAt(i)) {
                case '\r': {
                    if (i + 1 < length && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    ++line;
                }
            }
            ++i;
        }
        range.length = count;
        return range;
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners != null) {
            this.accessibleListeners.remove(listener);
            if (this.accessibleListeners.isEmpty()) {
                this.accessibleListeners = null;
            }
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners != null) {
            this.accessibleControlListeners.remove(listener);
            if (this.accessibleControlListeners.isEmpty()) {
                this.accessibleControlListeners = null;
            }
        }
    }

    public void removeAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (listener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners != null) {
                this.accessibleTextExtendedListeners.remove(listener);
                if (this.accessibleTextExtendedListeners.isEmpty()) {
                    this.accessibleTextExtendedListeners = null;
                }
            }
        } else if (this.accessibleTextListeners != null) {
            this.accessibleTextListeners.remove(listener);
            if (this.accessibleTextListeners.isEmpty()) {
                this.accessibleTextListeners = null;
            }
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners != null) {
            this.accessibleActionListeners.remove(listener);
            if (this.accessibleActionListeners.isEmpty()) {
                this.accessibleActionListeners = null;
            }
        }
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners != null) {
            this.accessibleEditableTextListeners.remove(listener);
            if (this.accessibleEditableTextListeners.isEmpty()) {
                this.accessibleEditableTextListeners = null;
            }
        }
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners != null) {
            this.accessibleHyperlinkListeners.remove(listener);
            if (this.accessibleHyperlinkListeners.isEmpty()) {
                this.accessibleHyperlinkListeners = null;
            }
        }
    }

    public void removeAccessibleTableListener(AccessibleTableListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners != null) {
            this.accessibleTableListeners.remove(listener);
            if (this.accessibleTableListeners.isEmpty()) {
                this.accessibleTableListeners = null;
            }
        }
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners != null) {
            this.accessibleTableCellListeners.remove(listener);
            if (this.accessibleTableCellListeners.isEmpty()) {
                this.accessibleTableCellListeners = null;
            }
        }
    }

    public void removeAccessibleValueListener(AccessibleValueListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners != null) {
            this.accessibleValueListeners.remove(listener);
            if (this.accessibleValueListeners.isEmpty()) {
                this.accessibleValueListeners = null;
            }
        }
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners != null) {
            this.accessibleAttributeListeners.remove(listener);
            if (this.accessibleAttributeListeners.isEmpty()) {
                this.accessibleAttributeListeners = null;
            }
        }
    }

    public void removeRelation(int type, Accessible target) {
        this.checkWidget();
        if (this.relations[type] != null) {
            this.relations[type].removeTarget(target);
        }
    }

    void release(boolean destroy) {
        if (this.actionNames != null) {
            this.actionNames.release();
        }
        this.actionNames = null;
        if (this.attributeNames != null) {
            this.attributeNames.release();
        }
        this.attributeNames = null;
        if (this.parameterizedAttributeNames != null) {
            this.parameterizedAttributeNames.release();
        }
        this.parameterizedAttributeNames = null;
        if (this.delegate != null) {
            this.delegate.internal_dispose_SWTAccessibleDelegate();
            this.delegate.release();
        }
        this.delegate = null;
        this.relations = null;
        if (this.childToIdMap != null) {
            Collection delegates = this.childToIdMap.values();
            for (SWTAccessibleDelegate childDelegate : delegates) {
                childDelegate.internal_dispose_SWTAccessibleDelegate();
                childDelegate.release();
            }
            this.childToIdMap.clear();
            this.childToIdMap = null;
        }
        if (this.tableDelegate != null) {
            this.tableDelegate.release();
        }
    }

    static NSArray retainedAutoreleased(NSArray inObject) {
        id temp = inObject.retain();
        NSObject temp2 = new NSObject(temp.id).autorelease();
        return new NSArray(temp2.id);
    }

    public void sendEvent(int event, Object eventData) {
        this.checkWidget();
        id eventSource = this.accessibleHandle(this);
        if (DEBUG) {
            System.out.println("sendEvent: 0x" + Integer.toHexString(event) + ", data = " + eventData + ", source = " + eventSource);
        }
        switch (event) {
            case 256: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 285: 
            case 512: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 524: 
            case 32778: 
            case 32782: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilityValueChangedNotification.id);
                break;
            }
            case 32777: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
                break;
            }
            case 32788: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 32779: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilityMovedNotification.id);
                break;
            }
            case 32780: 
            case 32781: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilityTitleChangedNotification.id);
                break;
            }
            case 283: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 518: {
                int[] eventParams;
                if (this.tableDelegate != null) {
                    this.tableDelegate.reset();
                    this.getRowsAttribute(-1);
                    this.getColumnsAttribute(-1);
                }
                if (eventData == null || (eventParams = (int[])eventData)[2] == 0) break;
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilityRowCountChangedNotification.id);
                break;
            }
        }
    }

    public void sendEvent(int event, Object eventData, int childID) {
        this.checkWidget();
        id eventSource = this.childIDToOs(childID);
        if (DEBUG) {
            System.out.println("sendEvent: 0x" + Integer.toHexString(event) + ", data = " + eventData + ", source = " + eventSource);
        }
        switch (event) {
            case 32777: 
            case 32778: 
            case 32782: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
                break;
            }
            case 32788: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
                break;
            }
            case 32779: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilityMovedNotification.id);
                break;
            }
            case 32780: 
            case 32781: {
                OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilityTitleChangedNotification.id);
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        id eventSource = this.accessibleHandle(this);
        if (DEBUG) {
            System.out.println("selectionChanged on " + eventSource);
        }
        if (this.currentRole == 24) {
            OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedRowsChangedNotification.id);
        } else {
            OS.NSAccessibilityPostNotification(eventSource.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
        }
    }

    public void setFocus(int childID) {
        this.checkWidget();
        id accessible = this.childIDToOs(childID);
        if (DEBUG) {
            System.out.println("setFocus on " + accessible);
        }
        OS.NSAccessibilityPostNotification(accessible.id, OS.NSAccessibilityFocusedUIElementChangedNotification.id);
    }

    void setSelectedTextAttribute(id value, int childId) {
        NSString newText = new NSString(value.id);
        int rangeStart = 0;
        id charsValue = this.getNumberOfCharactersAttribute(childId);
        int rangeEnd = new NSNumber(charsValue).intValue();
        id rangeObj = this.getSelectedTextRangeAttribute(childId);
        if (rangeObj != null) {
            NSRange range = new NSValue(rangeObj).rangeValue();
            rangeStart = (int)range.location;
            rangeEnd = (int)(range.location + range.length);
        }
        if (this.accessibleEditableTextListenersSize() > 0) {
            AccessibleEditableTextEvent event = new AccessibleEditableTextEvent(this);
            event.start = rangeStart;
            event.end = rangeEnd;
            event.string = newText.getString();
            int i = 0;
            while (i < this.accessibleEditableTextListenersSize()) {
                AccessibleEditableTextListener listener = this.accessibleEditableTextListeners.get(i);
                listener.replaceText(event);
                ++i;
            }
        }
    }

    void setSelectedTextRangeAttribute(id value, int childId) {
        NSRange newRange = new NSValue(value.id).rangeValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.index = 0;
            event.start = (int)newRange.location;
            event.end = (int)(newRange.location + newRange.length);
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.removeSelection(event);
                listener.addSelection(event);
                ++i;
            }
        }
    }

    void setVisibleCharacterRangeAttribute(id value, int childId) {
        NSRange newRange = new NSValue(value.id).rangeValue();
        if (this.accessibleTextExtendedListenersSize() > 0) {
            AccessibleTextEvent event = new AccessibleTextEvent(this);
            event.type = 0;
            event.start = (int)newRange.location;
            event.end = (int)(newRange.location + newRange.length);
            int i = 0;
            while (i < this.accessibleTextExtendedListenersSize()) {
                AccessibleTextExtendedListener listener = this.accessibleTextExtendedListeners.get(i);
                listener.scrollText(event);
                ++i;
            }
        }
    }

    public void textCaretMoved(int index) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    public void textChanged(int type, int startIndex, int length) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityValueChangedNotification.id);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    id childIDToOs(int childID) {
        if (childID == -1) {
            return this.control.view;
        }
        SWTAccessibleDelegate childRef = (SWTAccessibleDelegate)this.childToIdMap.get(childID);
        if (childRef == null) {
            childRef = new SWTAccessibleDelegate(this, childID);
            this.childToIdMap.put(childID, childRef);
        }
        return childRef;
    }

    NSString concatStringsAsRole(NSString str1, NSString str2) {
        NSString returnValue = str1;
        returnValue = returnValue.stringByAppendingString(NSString.stringWith(":"));
        returnValue = returnValue.stringByAppendingString(str2);
        return returnValue;
    }

    String roleToOs(int role) {
        NSString nsReturnValue = null;
        switch (role) {
            case 10: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 9: {
                nsReturnValue = OS.NSAccessibilityWindowRole;
                break;
            }
            case 2: {
                nsReturnValue = OS.NSAccessibilityMenuBarRole;
                break;
            }
            case 11: {
                nsReturnValue = OS.NSAccessibilityMenuRole;
                break;
            }
            case 12: {
                nsReturnValue = OS.NSAccessibilityMenuItemRole;
                break;
            }
            case 21: {
                nsReturnValue = OS.NSAccessibilitySplitterRole;
                break;
            }
            case 13: {
                nsReturnValue = OS.NSAccessibilityHelpTagRole;
                break;
            }
            case 3: {
                nsReturnValue = OS.NSAccessibilityScrollBarRole;
                break;
            }
            case 18: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole);
                break;
            }
            case 41: {
                nsReturnValue = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 43: {
                nsReturnValue = OS.NSAccessibilityButtonRole;
                break;
            }
            case 44: {
                nsReturnValue = OS.NSAccessibilityCheckBoxRole;
                break;
            }
            case 45: {
                nsReturnValue = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 62: {
                nsReturnValue = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 46: {
                nsReturnValue = OS.NSAccessibilityComboBoxRole;
                break;
            }
            case 42: {
                int style = this.control.getStyle();
                if ((style & 2) != 0) {
                    nsReturnValue = OS.NSAccessibilityTextAreaRole;
                    break;
                }
                nsReturnValue = OS.NSAccessibilityTextFieldRole;
                break;
            }
            case 22: {
                nsReturnValue = OS.NSAccessibilityToolbarRole;
                break;
            }
            case 33: {
                nsReturnValue = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 34: {
                nsReturnValue = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 27: {
                nsReturnValue = OS.NSAccessibilityColumnRole;
                break;
            }
            case 28: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 24: {
                nsReturnValue = OS.NSAccessibilityTableRole;
                break;
            }
            case 29: {
                nsReturnValue = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 25: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 26: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 35: {
                nsReturnValue = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 36: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole);
                break;
            }
            case 60: {
                nsReturnValue = OS.NSAccessibilityTabGroupRole;
                break;
            }
            case 37: {
                nsReturnValue = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 48: {
                nsReturnValue = OS.NSAccessibilityProgressIndicatorRole;
                break;
            }
            case 51: {
                nsReturnValue = OS.NSAccessibilitySliderRole;
                break;
            }
            case 30: {
                nsReturnValue = OS.NSAccessibilityLinkRole;
                break;
            }
            case 1025: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 40: {
                nsReturnValue = OS.NSAccessibilityImageRole;
                break;
            }
            case 20: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 1027: {
                nsReturnValue = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 1073: {
                nsReturnValue = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 1038: 
            case 1040: 
            case 1043: 
            case 1053: 
            case 1060: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 1044: 
            case 1054: {
                nsReturnValue = OS.NSAccessibilityTextAreaRole;
                break;
            }
            case 8: 
            case 15: 
            case 23: 
            case 47: 
            case 52: 
            case 54: 
            case 61: 
            case 1029: {
                nsReturnValue = OS.NSAccessibilityUnknownRole;
            }
        }
        return nsReturnValue.getString();
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    public long internal_addRelationAttributes(long defaultAttributes) {
        NSArray attributes = new NSArray(defaultAttributes);
        NSMutableArray returnArray = NSMutableArray.arrayWithCapacity(attributes.count());
        returnArray.addObjectsFromArray(attributes);
        if (this.getTitleAttribute(-1) != null && !returnArray.containsObject(OS.NSAccessibilityTitleAttribute)) {
            returnArray.addObject(OS.NSAccessibilityTitleAttribute);
        }
        if (this.getDescriptionAttribute(-1) != null && !returnArray.containsObject(OS.NSAccessibilityDescriptionAttribute)) {
            returnArray.addObject(OS.NSAccessibilityDescriptionAttribute);
        }
        if (this.relations[8] != null) {
            if (!returnArray.containsObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute)) {
                returnArray.addObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
            }
            if (!returnArray.containsObject(OS.NSAccessibilityTitleAttribute)) {
                returnArray.addObject(OS.NSAccessibilityTitleAttribute);
            }
        } else {
            returnArray.removeObject(OS.NSAccessibilityServesAsTitleForUIElementsAttribute);
        }
        if (this.relations[9] != null) {
            if (!returnArray.containsObject(OS.NSAccessibilityTitleUIElementAttribute)) {
                returnArray.addObject(OS.NSAccessibilityTitleUIElementAttribute);
            }
        } else {
            returnArray.removeObject(OS.NSAccessibilityTitleUIElementAttribute);
        }
        return returnArray.id;
    }
}

