/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.io.EOFException;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.ecl.core.model.CreateVerification;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.scenario.WidgetVerification;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.recording.WidgetPicker;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class VerificationSnapshotAction
extends Action {
    private final IQ7Editor<Verification> editor;
    private boolean join = false;
    private IStatus status = Status.OK_STATUS;
    private final Shell parentShell;
    private final String selector;

    public VerificationSnapshotAction(Shell parentShell, IQ7Editor<Verification> editor, String selector) {
        this.parentShell = parentShell;
        this.selector = selector;
        this.setImageDescriptor(Images.getImageDescriptor("icons/camera.png"));
        this.setToolTipText(Messages.VerificationSnapshotAction_ToolTip);
        this.editor = editor;
    }

    public void run() {
        final AutLaunch aut = LaunchUtils.selectAutLaunch();
        if (this.editor.getElement() instanceof IVerification) {
            NamedElement namedElement;
            try {
                namedElement = this.editor.getElement().getNamedElement();
            }
            catch (ModelException e1) {
                this.status = e1.getStatus();
                return;
            }
            if (namedElement instanceof WidgetVerification) {
                WidgetVerification verification = (WidgetVerification)namedElement;
                if (this.selector != null) {
                    verification.setSelector(this.selector);
                }
                if (StringUtils.isBlank((String)verification.getSelector())) {
                    VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification((Verification)verification);
                    String selector = WidgetPicker.activate(this.parentShell, (BaseAutLaunch)aut, type);
                    if (selector != null) {
                        verification.setSelector(selector);
                    } else {
                        this.status = Status.CANCEL_STATUS;
                        return;
                    }
                }
            }
        }
        Job job = new Job(Messages.VerificationSnapshotAction_Job){

            protected IStatus run(IProgressMonitor monitor) {
                EObject verificationParam;
                monitor.beginTask("", 2);
                try {
                    verificationParam = VerificationSnapshotAction.this.editor.getCreateParam(aut);
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
                IVerification verification = (IVerification)VerificationSnapshotAction.this.editor.getElement();
                try {
                    VerificationType type = verification.getType();
                    monitor.worked(1);
                    final Verification newVerification = VerificationSnapshotAction.createSnapshot(aut, type.getId(), verificationParam);
                    if (newVerification != null) {
                        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                VerificationSnapshotAction.this.editor.copyContentFrom(newVerification, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(operation, monitor);
                        monitor.done();
                    }
                }
                catch (InterruptedException interruptedException) {
                    VerificationSnapshotAction.this.status = Status.CANCEL_STATUS;
                    return VerificationSnapshotAction.this.status;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (Exception e) {
                    return Q7UIPlugin.createStatus(e);
                }
                VerificationSnapshotAction.this.status = Status.OK_STATUS;
                return VerificationSnapshotAction.this.status;
            }
        };
        job.setUser(true);
        job.schedule();
        if (this.isJoin()) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isEnabled() {
        IVerification verification = (IVerification)this.editor.getElement();
        try {
            VerificationType type = verification.getType();
            return type.canCreate();
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
            return false;
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public static Verification createSnapshot(AutLaunch aut, String verificationType, EObject param) throws CoreException, InterruptedException {
        if (aut == null) {
            aut = LaunchUtils.selectAutLaunch();
        }
        if (aut == null) {
            return null;
        }
        if (!Q7LaunchManager.getInstance().cancelDebugExecution(aut, null)) {
            return null;
        }
        SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
        TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
        Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
        aut.execute((Command)setQ7Features);
        try {
            CreateVerification cc = Q7CoreFactory.eINSTANCE.createCreateVerification();
            cc.setType(verificationType);
            cc.setParam(param);
            Object object = aut.execute((Command)cc);
            if (!(object instanceof Verification)) {
                throw new CoreException(Q7UIPlugin.createStatus(Messages.bind((String)Messages.VerificationSnapshotAction_UnexpectedObject, (Object)object)));
            }
            return (Verification)object;
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof EOFException) {
                VerificationSnapshotAction.showPossibleMemoryError();
                return null;
            }
            throw e;
        }
    }

    private static void showPossibleMemoryError() {
        Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox msg = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                msg.setText(Messages.VerificationSnapshotAction_ErrorDialogTitle);
                msg.setMessage(Messages.VerificationSnapshotAction_ErrorDialogMsg);
                msg.open();
            }
        });
    }
}

