/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class RepositoryCache {
    private final Map<File, Reference<Repository>> repositoryCache = new HashMap<File, Reference<Repository>>();

    public synchronized Repository lookupRepository(File gitDir) throws IOException {
        Repository d;
        this.prune();
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Reference<Repository> r = this.repositoryCache.get(normalizedGitDir);
        Repository repository = d = r != null ? r.get() : null;
        if (d == null) {
            d = FileRepositoryBuilder.create((File)normalizedGitDir);
            this.repositoryCache.put(normalizedGitDir, new WeakReference<Repository>(d));
        }
        return d;
    }

    public synchronized Repository getRepository(File gitDir) {
        this.prune();
        if (gitDir == null) {
            return null;
        }
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Reference<Repository> r = this.repositoryCache.get(normalizedGitDir);
        return r != null ? r.get() : null;
    }

    public synchronized Repository[] getAllRepositories() {
        this.prune();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Reference<Repository> reference : this.repositoryCache.values()) {
            Repository repository = reference.get();
            if (repository == null) continue;
            repositories.add(repository);
        }
        return repositories.toArray(new Repository[repositories.size()]);
    }

    public Repository getRepository(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return this.getRepository(location);
    }

    public Repository getRepository(IPath location) {
        Repository[] repositories = this.getAllRepositories();
        Repository repository = null;
        int largestSegmentCount = 0;
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository r = repositoryArray[n2];
            if (!r.isBare()) {
                Path repoPath = new Path(r.getWorkTree().getAbsolutePath());
                if (location != null && repoPath.isPrefixOf(location) && (repository == null || repoPath.segmentCount() > largestSegmentCount)) {
                    repository = r;
                    largestSegmentCount = repoPath.segmentCount();
                }
            }
            ++n2;
        }
        return repository;
    }

    private void prune() {
        Iterator<Map.Entry<File, Reference<Repository>>> i = this.repositoryCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<File, Reference<Repository>> entry = i.next();
            Repository repository = entry.getValue().get();
            if (repository != null && repository.getDirectory().exists()) continue;
            i.remove();
            Activator.getDefault().getIndexDiffCache().remove(entry.getKey());
        }
    }

    public synchronized void clear() {
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        for (Map.Entry<File, Reference<Repository>> entry : this.repositoryCache.entrySet()) {
            cache.remove(entry.getKey());
        }
        this.repositoryCache.clear();
    }
}

