/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedAnnotationElementDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedConstructorDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedFieldDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedMethodDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationElementDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationMirrorImpl;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationValueImpl;
import org.eclipse.jdt.apt.core.internal.declaration.BinaryParameterDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.ClassDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.ConstructorDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.EnumConstantDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EnumDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.ExecutableDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.FieldDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.InterfaceDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.MethodDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.SourceParameterDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.TypeParameterDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.type.ArrayTypeImpl;
import org.eclipse.jdt.apt.core.internal.type.ErrorType;
import org.eclipse.jdt.apt.core.internal.type.WildcardTypeImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class Factory {
    private static final String NULL_BINDING_NAME = "[NullBinding]";
    public static final Byte DUMMY_BYTE = 0;
    public static final Character DUMMY_CHAR = Character.valueOf('0');
    public static final Double DUMMY_DOUBLE = 0.0;
    public static final Float DUMMY_FLOAT = Float.valueOf(0.0f);
    public static final Integer DUMMY_INTEGER = 0;
    public static final Long DUMMY_LONG = 0L;
    public static final Short DUMMY_SHORT = 0;

    public static TypeDeclarationImpl createReferenceType(ITypeBinding binding, BaseProcessorEnv env) {
        if (binding == null || binding.isNullType()) {
            return null;
        }
        if (binding.isRecovered()) {
            return null;
        }
        TypeDeclarationImpl mirror = null;
        if (binding.isAnnotation()) {
            mirror = new AnnotationDeclarationImpl(binding, env);
        } else if (binding.isInterface()) {
            mirror = new InterfaceDeclarationImpl(binding, env);
        } else if (binding.isEnum()) {
            mirror = new EnumDeclarationImpl(binding, env);
        } else if (binding.isClass()) {
            mirror = new ClassDeclarationImpl(binding, env);
        } else {
            throw new IllegalStateException("cannot create type declaration from " + binding);
        }
        return mirror;
    }

    public static EclipseDeclarationImpl createDeclaration(IBinding binding, BaseProcessorEnv env) {
        if (binding == null) {
            return null;
        }
        switch (binding.getKind()) {
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isAnonymous() || typeBinding.isArray() || typeBinding.isWildcardType() || typeBinding.isPrimitive()) {
                    throw new IllegalStateException("failed to create declaration from " + binding);
                }
                if (typeBinding.isTypeVariable()) {
                    return new TypeParameterDeclarationImpl(typeBinding, env);
                }
                return Factory.createReferenceType(typeBinding, env);
            }
            case 3: {
                IVariableBinding varBinding = (IVariableBinding)binding;
                if (varBinding.isEnumConstant()) {
                    return new EnumConstantDeclarationImpl(varBinding, env);
                }
                return new FieldDeclarationImpl(varBinding, env);
            }
            case 4: {
                IMethodBinding method = (IMethodBinding)binding;
                if (method.isConstructor()) {
                    return new ConstructorDeclarationImpl(method, env);
                }
                ITypeBinding declaringType = method.getDeclaringClass();
                if (declaringType != null && declaringType.isAnnotation()) {
                    return new AnnotationElementDeclarationImpl(method, env);
                }
                return new MethodDeclarationImpl(method, env);
            }
            case 1: {
                return null;
            }
        }
        throw new IllegalStateException("failed to create declaration from " + binding);
    }

    public static EclipseDeclarationImpl createDeclaration(ASTNode node, IFile file, BaseProcessorEnv env) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 44: {
                return new SourceParameterDeclarationImpl((SingleVariableDeclaration)node, file, env);
            }
            case 59: {
                return new ASTBasedFieldDeclarationImpl((VariableDeclarationFragment)node, file, env);
            }
            case 31: {
                MethodDeclaration methodDecl = (MethodDeclaration)node;
                if (methodDecl.isConstructor()) {
                    return new ASTBasedConstructorDeclarationImpl((BodyDeclaration)methodDecl, file, env);
                }
                return new ASTBasedMethodDeclarationImpl((BodyDeclaration)methodDecl, file, env);
            }
            case 82: {
                return new ASTBasedMethodDeclarationImpl((BodyDeclaration)((AnnotationTypeMemberDeclaration)node), file, env);
            }
        }
        throw new UnsupportedOperationException("cannot create mirror type from " + node.getClass().getName());
    }

    public static EclipseMirrorType createTypeMirror(ITypeBinding binding, BaseProcessorEnv env) {
        if (binding == null) {
            return null;
        }
        if (binding.isPrimitive()) {
            if ("int".equals(binding.getName())) {
                return env.getIntType();
            }
            if ("byte".equals(binding.getName())) {
                return env.getByteType();
            }
            if ("short".equals(binding.getName())) {
                return env.getShortType();
            }
            if ("char".equals(binding.getName())) {
                return env.getCharType();
            }
            if ("long".equals(binding.getName())) {
                return env.getLongType();
            }
            if ("float".equals(binding.getName())) {
                return env.getFloatType();
            }
            if ("double".equals(binding.getName())) {
                return env.getDoubleType();
            }
            if ("boolean".equals(binding.getName())) {
                return env.getBooleanType();
            }
            if ("void".equals(binding.getName())) {
                return env.getVoidType();
            }
            throw new IllegalStateException("unrecognized primitive type: " + binding);
        }
        if (binding.isArray()) {
            return new ArrayTypeImpl(binding, env);
        }
        if (binding.isWildcardType()) {
            return new WildcardTypeImpl(binding, env);
        }
        if (binding.isTypeVariable()) {
            return new TypeParameterDeclarationImpl(binding, env);
        }
        return Factory.createReferenceType(binding, env);
    }

    public static ParameterDeclaration createParameterDeclaration(SingleVariableDeclaration param, IFile file, BaseProcessorEnv env) {
        return new SourceParameterDeclarationImpl(param, file, env);
    }

    public static ParameterDeclaration createParameterDeclaration(ExecutableDeclarationImpl exec, int paramIndex, ITypeBinding type, BaseProcessorEnv env) {
        return new BinaryParameterDeclarationImpl(exec, type, paramIndex, env);
    }

    public static AnnotationMirror createAnnotationMirror(IAnnotationBinding annotation, EclipseDeclarationImpl annotated, BaseProcessorEnv env) {
        return new AnnotationMirrorImpl(annotation, annotated, env);
    }

    public static AnnotationValue createDefaultValue(Object domValue, AnnotationElementDeclarationImpl decl, BaseProcessorEnv env) {
        if (domValue == null) {
            return null;
        }
        Object converted = Factory.convertDOMValueToMirrorValue(domValue, null, decl, decl, env, decl.getReturnType());
        return Factory.createAnnotationValueFromDOMValue(converted, null, -1, decl, env);
    }

    public static AnnotationValue createDefaultValue(Object domValue, ASTBasedAnnotationElementDeclarationImpl decl, BaseProcessorEnv env) {
        if (domValue == null) {
            return null;
        }
        Object converted = Factory.convertDOMValueToMirrorValue(domValue, null, decl, decl, env, decl.getReturnType());
        return Factory.createAnnotationValueFromDOMValue(converted, null, -1, decl, env);
    }

    public static AnnotationValue createAnnotationMemberValue(Object domValue, String elementName, AnnotationMirrorImpl anno, BaseProcessorEnv env, TypeMirror expectedType) {
        if (domValue == null) {
            return null;
        }
        Object converted = Factory.convertDOMValueToMirrorValue(domValue, elementName, anno, anno.getAnnotatedDeclaration(), env, expectedType);
        return Factory.createAnnotationValueFromDOMValue(converted, elementName, -1, anno, env);
    }

    public static AnnotationValue createAnnotationValueFromDOMValue(Object convertedValue, String name, int index, EclipseMirrorObject mirror, BaseProcessorEnv env) {
        if (convertedValue == null) {
            return null;
        }
        if (mirror instanceof AnnotationMirrorImpl) {
            return new AnnotationValueImpl(convertedValue, name, index, (AnnotationMirrorImpl)mirror, env);
        }
        return new AnnotationValueImpl(convertedValue, index, (AnnotationElementDeclarationImpl)mirror, env);
    }

    private static Object convertDOMValueToMirrorValue(Object domValue, String name, EclipseMirrorObject parent, EclipseDeclarationImpl decl, BaseProcessorEnv env, TypeMirror expectedType) {
        Object returnValue;
        if (domValue == null) {
            return null;
        }
        if (domValue instanceof Boolean || domValue instanceof Byte || domValue instanceof Character || domValue instanceof Double || domValue instanceof Float || domValue instanceof Integer || domValue instanceof Long || domValue instanceof Short || domValue instanceof String) {
            returnValue = domValue;
        } else if (domValue instanceof IVariableBinding) {
            returnValue = Factory.createDeclaration((IBinding)((IVariableBinding)domValue), env);
        } else {
            if (domValue instanceof Object[]) {
                Object[] elements = (Object[])domValue;
                int len = elements.length;
                ArrayList<AnnotationValue> annoValues = new ArrayList<AnnotationValue>(len);
                TypeMirror leaf = expectedType instanceof ArrayType ? ((ArrayType)expectedType).getComponentType() : expectedType;
                int i = 0;
                while (i < len) {
                    if (elements[i] != null) {
                        if (elements[i] instanceof Object[]) {
                            return null;
                        }
                        Object o = Factory.convertDOMValueToMirrorValue(elements[i], name, parent, decl, env, leaf);
                        if (o == null) {
                            return null;
                        }
                        assert (!(o instanceof IAnnotationBinding)) : "Unexpected return value from convertDomValueToMirrorValue! o.getClass().getName() = " + o.getClass().getName();
                        AnnotationValue annoValue = Factory.createAnnotationValueFromDOMValue(o, name, i, parent, env);
                        if (annoValue != null) {
                            annoValues.add(annoValue);
                        }
                    }
                    ++i;
                }
                return annoValues;
            }
            if (domValue instanceof ITypeBinding) {
                returnValue = Factory.createTypeMirror((ITypeBinding)domValue, env);
            } else if (domValue instanceof IAnnotationBinding) {
                returnValue = Factory.createAnnotationMirror((IAnnotationBinding)domValue, decl, env);
            } else {
                throw new IllegalStateException("cannot build annotation value object from " + domValue);
            }
        }
        return Factory.performNecessaryTypeConversion(expectedType, returnValue, name, parent, env);
    }

    public static Object getMatchingDummyValue(Class<?> expectedType) {
        if (expectedType.isPrimitive()) {
            if (expectedType == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (expectedType == Byte.TYPE) {
                return DUMMY_BYTE;
            }
            if (expectedType == Character.TYPE) {
                return DUMMY_CHAR;
            }
            if (expectedType == Double.TYPE) {
                return DUMMY_DOUBLE;
            }
            if (expectedType == Float.TYPE) {
                return DUMMY_FLOAT;
            }
            if (expectedType == Integer.TYPE) {
                return DUMMY_INTEGER;
            }
            if (expectedType == Long.TYPE) {
                return DUMMY_LONG;
            }
            if (expectedType == Short.TYPE) {
                return DUMMY_SHORT;
            }
            return DUMMY_INTEGER;
        }
        return null;
    }

    public static Object performNecessaryPrimitiveTypeConversion(Class<?> expectedType, Object value, boolean avoidReflectException) {
        assert (expectedType.isPrimitive()) : "expectedType is not a primitive type: " + expectedType.getName();
        if (value == null) {
            return avoidReflectException ? Factory.getMatchingDummyValue(expectedType) : null;
        }
        String typeName = expectedType.getName();
        char expectedTypeChar = typeName.charAt(0);
        int nameLen = typeName.length();
        if (value instanceof Byte) {
            byte b = (Byte)value;
            switch (expectedTypeChar) {
                case 'b': {
                    if (nameLen == 4) {
                        return value;
                    }
                    return avoidReflectException ? Boolean.FALSE : value;
                }
                case 'c': {
                    return new Character((char)b);
                }
                case 'd': {
                    return new Double(b);
                }
                case 'f': {
                    return new Float(b);
                }
                case 'i': {
                    return new Integer(b);
                }
                case 'l': {
                    return new Long(b);
                }
                case 's': {
                    return new Short(b);
                }
            }
            throw new IllegalStateException("unknown type " + expectedTypeChar);
        }
        if (value instanceof Short) {
            short s = (Short)value;
            switch (expectedTypeChar) {
                case 'b': {
                    if (nameLen == 4) {
                        return new Byte((byte)s);
                    }
                    return avoidReflectException ? Boolean.FALSE : value;
                }
                case 'c': {
                    return new Character((char)s);
                }
                case 'd': {
                    return new Double(s);
                }
                case 'f': {
                    return new Float(s);
                }
                case 'i': {
                    return new Integer(s);
                }
                case 'l': {
                    return new Long(s);
                }
                case 's': {
                    return value;
                }
            }
            throw new IllegalStateException("unknown type " + expectedTypeChar);
        }
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            switch (expectedTypeChar) {
                case 'b': {
                    if (nameLen == 4) {
                        return new Byte((byte)c);
                    }
                    return avoidReflectException ? Boolean.FALSE : value;
                }
                case 'c': {
                    return value;
                }
                case 'd': {
                    return new Double(c);
                }
                case 'f': {
                    return new Float(c);
                }
                case 'i': {
                    return new Integer(c);
                }
                case 'l': {
                    return new Long(c);
                }
                case 's': {
                    return new Short((short)c);
                }
            }
            throw new IllegalStateException("unknown type " + expectedTypeChar);
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            switch (expectedTypeChar) {
                case 'b': {
                    if (nameLen == 4) {
                        return new Byte((byte)i);
                    }
                    return avoidReflectException ? Boolean.FALSE : value;
                }
                case 'c': {
                    return new Character((char)i);
                }
                case 'd': {
                    return new Double(i);
                }
                case 'f': {
                    return new Float(i);
                }
                case 'i': {
                    return value;
                }
                case 'l': {
                    return new Long(i);
                }
                case 's': {
                    return new Short((short)i);
                }
            }
            throw new IllegalStateException("unknown type " + expectedTypeChar);
        }
        if (value instanceof Long) {
            long l = (Long)value;
            switch (expectedTypeChar) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': {
                    return avoidReflectException ? Factory.getMatchingDummyValue(expectedType) : value;
                }
                case 'd': {
                    return new Double(l);
                }
                case 'f': {
                    return new Float(l);
                }
                case 'l': {
                    return value;
                }
            }
            throw new IllegalStateException("unknown type " + expectedTypeChar);
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            switch (expectedTypeChar) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 'l': 
                case 's': {
                    return avoidReflectException ? Factory.getMatchingDummyValue(expectedType) : value;
                }
                case 'd': {
                    return new Double(f);
                }
                case 'f': {
                    return value;
                }
            }
            throw new IllegalStateException("unknown type " + expectedTypeChar);
        }
        if (value instanceof Double) {
            if (expectedTypeChar == 'd') {
                return value;
            }
            return avoidReflectException ? Factory.getMatchingDummyValue(expectedType) : value;
        }
        if (value instanceof Boolean) {
            if (expectedTypeChar == 'b' && nameLen == 7) {
                return value;
            }
            return avoidReflectException ? Factory.getMatchingDummyValue(expectedType) : value;
        }
        return avoidReflectException ? Factory.getMatchingDummyValue(expectedType) : value;
    }

    private static Class<?> getJavaLangClass_Primitive(PrimitiveType primitiveType) {
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
        }
        throw new IllegalStateException("unknow primitive type " + primitiveType);
    }

    private static Object performNecessaryTypeConversion(TypeMirror expectedType, Object value, String name, EclipseMirrorObject parent, BaseProcessorEnv env) {
        if (expectedType == null) {
            return value;
        }
        if (expectedType instanceof PrimitiveType) {
            Class<?> primitiveClass = Factory.getJavaLangClass_Primitive((PrimitiveType)expectedType);
            return Factory.performNecessaryPrimitiveTypeConversion(primitiveClass, value, false);
        }
        if (expectedType instanceof ArrayType) {
            TypeMirror componentType = ((ArrayType)expectedType).getComponentType();
            Object converted = value;
            if (!(componentType instanceof ArrayType)) {
                converted = Factory.performNecessaryTypeConversion(componentType, value, name, parent, env);
            }
            AnnotationValue annoValue = Factory.createAnnotationValueFromDOMValue(converted, name, 0, parent, env);
            return Collections.singletonList(annoValue);
        }
        return value;
    }

    public static InterfaceType createErrorInterfaceType(ITypeBinding binding) {
        String name = binding == null ? NULL_BINDING_NAME : binding.getName();
        return new ErrorType.ErrorInterface(name);
    }

    public static ClassType createErrorClassType(ITypeBinding binding) {
        String name = binding == null ? NULL_BINDING_NAME : binding.getName();
        return Factory.createErrorClassType(name);
    }

    public static ClassType createErrorClassType(String name) {
        return new ErrorType.ErrorClass(name);
    }

    public static AnnotationType createErrorAnnotationType(ITypeBinding binding) {
        String name = binding == null ? NULL_BINDING_NAME : binding.getName();
        return Factory.createErrorAnnotationType(name);
    }

    public static AnnotationType createErrorAnnotationType(String name) {
        return new ErrorType.ErrorAnnotation(name);
    }

    public static ArrayType createErrorArrayType(String name, int dimension) {
        return new ErrorType.ErrorArrayType(name, dimension);
    }
}

