/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class GitTraceConfigurationDialog
extends TitleAreaDialog {
    private static final String MAINSWITCH = "/debug";
    private static final PluginNode[] PLUGIN_LIST = new PluginNode[]{new PluginNode(Activator.getPluginId()), new PluginNode(org.eclipse.egit.core.Activator.getPluginId())};
    private static final int APPLY_ID = 77;
    private static final int DEFAULT_ID = 88;
    private final Map<PluginNode, Properties> optionsMap = new HashMap<PluginNode, Properties>();
    private boolean isDirty;
    private Button platformSwitch;
    private Text traceFileLocation;
    private CheckboxTreeViewer tv;

    public GitTraceConfigurationDialog(Shell shell) {
        super(shell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        this.platformSwitch = new Button(main, 32);
        this.platformSwitch.setText(UIText.GitTraceConfigurationDialog_PlatformSwitchCheckbox);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.platformSwitch);
        this.platformSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitTraceConfigurationDialog.this.updateEnablement();
            }
        });
        this.tv = new CheckboxTreeViewer(main, 2048);
        this.tv.setContentProvider((IContentProvider)new TraceTableContentProvider(this.optionsMap));
        Tree tree = this.tv.getTree();
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)tree);
        tree.setData("org.eclipse.swtbot.widget.key", (Object)"LocationTree");
        TreeColumn c1 = new TreeColumn(tree, 0);
        c1.setWidth(400);
        c1.setText(UIText.GitTraceConfigurationDialog_LocationHeader);
        tree.setHeaderVisible(true);
        Label fileLabel = new Label(main, 0);
        fileLabel.setText(UIText.GitTraceConfigurationDialog_TraceFileLocationLabel);
        this.traceFileLocation = new Text(main, 2048);
        this.traceFileLocation.setEditable(false);
        GridDataFactory.defaultsFor((Control)this.traceFileLocation).grab(true, false).applyTo((Control)this.traceFileLocation);
        Button openButton = new Button(main, 8);
        openButton.setText(UIText.GitTraceConfigurationDialog_OpenInEditorButton);
        openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(GitTraceConfigurationDialog.this.traceFileLocation.getText()));
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileStoreEditorInput(store), (String)"org.eclipse.ui.DefaultTextEditor");
                }
                catch (PartInitException ex) {
                    Activator.handleError(ex.getMessage(), ex, true);
                }
            }
        });
        this.initValues();
        this.platformSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitTraceConfigurationDialog.this.setDirty(true);
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GitTraceConfigurationDialog.this.setDirty(true);
            }
        });
        Dialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 77, UIText.GitTraceConfigurationDialog_ApplyButton, false);
        this.createButton(parent, 88, UIText.GitTraceConfigurationDialog_DefaultButton, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.GitTraceConfigurationDialog_ShellTitle);
    }

    public void create() {
        super.create();
        this.updateApplyButton();
        this.setTitle(UIText.GitTraceConfigurationDialog_DialogTitle);
    }

    private void initValues() {
        DebugOptions options = this.getOptions();
        this.fillOptionsMapFromCurrent(options);
        this.tv.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                String key;
                Properties props;
                Object node;
                Object data = element;
                if (data instanceof PluginNode) {
                    node = (PluginNode)data;
                    props = (Properties)GitTraceConfigurationDialog.this.optionsMap.get(node);
                    key = String.valueOf(((PluginNode)node).getPlugin()) + GitTraceConfigurationDialog.MAINSWITCH;
                } else if (data instanceof OptionNode) {
                    node = (OptionNode)data;
                    props = (Properties)GitTraceConfigurationDialog.this.optionsMap.get(((OptionNode)node).getPlugin());
                    key = ((OptionNode)node).getOption();
                } else {
                    return false;
                }
                boolean active = Boolean.valueOf(props.getProperty(key));
                return active;
            }
        });
        this.tv.setInput((Object)PLUGIN_LIST);
        this.tv.expandAll();
        if (this.platformSwitch.getSelection() != options.isDebugEnabled()) {
            this.platformSwitch.setSelection(options.isDebugEnabled());
        }
        this.traceFileLocation.setText(this.getOptions().getFile().getPath());
        this.updateEnablement();
    }

    private void updateApplyButton() {
        if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(this.isDirty);
        }
        if (this.getDefaultsButton() != null) {
            this.getDefaultsButton().setEnabled(this.platformSwitch.getSelection());
        }
    }

    private Button getApplyButton() {
        return this.getButton(77);
    }

    private Button getDefaultsButton() {
        return this.getButton(88);
    }

    private void updateEnablement() {
        this.setMessage(null);
        if (!this.platformSwitch.getSelection()) {
            this.setMessage(UIText.GitTraceConfigurationDialog_PlatformTraceDisabledMessage, 1);
        }
        this.tv.getTree().setEnabled(this.platformSwitch.getSelection());
        this.updateApplyButton();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.performOk();
                break;
            }
            case 88: {
                this.fillOptionsMapFromOptions();
                this.tv.refresh();
                break;
            }
            case 77: {
                this.performOk();
                break;
            }
        }
        super.buttonPressed(buttonId);
    }

    private void performOk() {
        DebugOptions options = this.getOptions();
        if (this.isDirty) {
            options.setDebugEnabled(this.platformSwitch.getSelection());
            if (this.platformSwitch.getSelection()) {
                ArrayList<String> checkedKeys = new ArrayList<String>();
                for (Object checked : Arrays.asList(this.tv.getCheckedElements())) {
                    if (checked instanceof PluginNode) {
                        checkedKeys.add(String.valueOf(((PluginNode)checked).getPlugin()) + MAINSWITCH);
                        continue;
                    }
                    if (!(checked instanceof OptionNode)) continue;
                    checkedKeys.add(((OptionNode)checked).getOption());
                }
                for (PluginNode plugin : this.optionsMap.keySet()) {
                    Properties props = this.optionsMap.get(plugin);
                    for (Object keyObject : props.keySet()) {
                        boolean shouldBeOn;
                        String key = (String)keyObject;
                        boolean isOn = options.getBooleanOption(key, false);
                        if (isOn == (shouldBeOn = checkedKeys.contains(key))) continue;
                        options.setOption(key, Boolean.toString(shouldBeOn));
                    }
                }
            }
            this.fillOptionsMapFromCurrent(options);
            this.tv.refresh();
            this.setDirty(false);
        }
    }

    private void fillOptionsMapFromOptions() {
        String key;
        HashMap<String, String> oldValues = new HashMap<String, String>();
        for (Properties props : this.optionsMap.values()) {
            for (Object object : props.keySet()) {
                key = (String)object;
                oldValues.put(key, props.getProperty(key));
            }
        }
        this.optionsMap.clear();
        PluginNode[] pluginNodeArray = PLUGIN_LIST;
        int n = PLUGIN_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            Properties props;
            PluginNode plugin;
            block14: {
                plugin = pluginNodeArray[n2];
                props = new Properties();
                try {
                    URL resource = Platform.getBundle((String)plugin.getPlugin()).getResource(".options");
                    if (resource == null) break block14;
                    try (InputStream is = resource.openStream();){
                        props.load(is);
                    }
                }
                catch (IOException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
            this.optionsMap.put(plugin, props);
            ++n2;
        }
        HashMap newValues = new HashMap();
        for (Properties props : this.optionsMap.values()) {
            for (Object e : props.keySet()) {
                String key2 = (String)e;
                oldValues.put(key2, props.getProperty(key2));
            }
        }
        boolean dirty = false;
        if (oldValues.keySet().containsAll(newValues.keySet()) && newValues.keySet().containsAll(oldValues.keySet())) {
            for (Map.Entry entry : oldValues.entrySet()) {
                key = (String)entry.getKey();
                String newValue = (String)newValues.get(key);
                if (((String)entry.getValue()).equals(newValue)) continue;
                dirty = true;
                break;
            }
        } else {
            dirty = true;
        }
        if (dirty) {
            this.setDirty(true);
        }
    }

    private void fillOptionsMapFromCurrent(DebugOptions options) {
        this.optionsMap.clear();
        PluginNode[] pluginNodeArray = PLUGIN_LIST;
        int n = PLUGIN_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            Properties props;
            PluginNode plugin;
            block7: {
                plugin = pluginNodeArray[n2];
                props = new Properties();
                try {
                    URL resource = Platform.getBundle((String)plugin.getPlugin()).getResource(".options");
                    if (resource == null) break block7;
                    try (InputStream is = resource.openStream();){
                        props.load(is);
                    }
                }
                catch (IOException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
            for (Object keyObject : props.keySet()) {
                String key = (String)keyObject;
                boolean isActive = options.getBooleanOption(key, false);
                props.setProperty(key, Boolean.toString(isActive));
            }
            this.optionsMap.put(plugin, props);
            ++n2;
        }
    }

    private void setDirty(boolean dirty) {
        this.isDirty = dirty;
        this.updateApplyButton();
    }

    private DebugOptions getOptions() {
        return Activator.getDefault().getDebugOptions();
    }

    private static final class OptionNode
    implements Comparable<OptionNode> {
        private final PluginNode plugin;
        private final String option;
        private final String strippedOption;

        OptionNode(PluginNode parent, String option) {
            this.plugin = parent;
            this.option = option;
            this.strippedOption = option.substring(option.indexOf(47));
        }

        public PluginNode getPlugin() {
            return this.plugin;
        }

        public String getOption() {
            return this.option;
        }

        public String toString() {
            return this.strippedOption;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.option.hashCode();
            result = 31 * result + this.plugin.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OptionNode other = (OptionNode)obj;
            if (!this.option.equals(other.option)) {
                return false;
            }
            return this.plugin.equals(other.plugin);
        }

        @Override
        public int compareTo(OptionNode o) {
            return this.option.compareTo(o.option);
        }
    }

    private static final class PluginNode {
        private final String plugin;

        PluginNode(String plugin) {
            this.plugin = plugin;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public String toString() {
            return NLS.bind((String)UIText.GitTraceConfigurationDialog_MainSwitchNodeText, (Object)this.plugin);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.plugin.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PluginNode other = (PluginNode)obj;
            return this.plugin.equals(other.plugin);
        }
    }

    private static final class TraceTableContentProvider
    implements ITreeContentProvider {
        private final Map<PluginNode, Properties> myOptionsMap;

        public TraceTableContentProvider(Map<PluginNode, Properties> optionsMap) {
            this.myOptionsMap = optionsMap;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PluginNode) {
                PluginNode node = (PluginNode)parentElement;
                ArrayList<OptionNode> result = new ArrayList<OptionNode>();
                for (Object key : this.myOptionsMap.get(node).keySet()) {
                    if (key.equals(String.valueOf(node.getPlugin()) + GitTraceConfigurationDialog.MAINSWITCH)) continue;
                    result.add(new OptionNode(node, (String)key));
                }
                Collections.sort(result);
                return result.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof OptionNode) {
                return ((OptionNode)element).getPlugin();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PluginNode;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

