/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.addons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.event.Event;

public class ModelCleanupAddon {
    private static String COMPATIBILITY_EDITOR_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor";
    private static String COMPATIBILITY_VIEW_URI = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
    @Inject
    @Optional
    private MApplication application;
    @Inject
    @Optional
    private Logger logger;

    @Inject
    @Optional
    public void applicationStartUp(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        List descriptors = this.application.getDescriptors();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            MPartDescriptor partDescriptor = (MPartDescriptor)iterator.next();
            boolean validPartDescriptor = this.isValidPartDescriptor(bundle, partDescriptor);
            if (validPartDescriptor) continue;
            this.logger.warn("Removing part descriptor with the '" + partDescriptor.getElementId() + "' id and the '" + partDescriptor.getLocalizedLabel() + "' description. Points to the invalid '" + partDescriptor.getContributionURI() + "' class.");
            iterator.remove();
        }
    }

    private boolean isValidPartDescriptor(Bundle bundle, MPartDescriptor partDescriptor) {
        String contributionURI = partDescriptor.getContributionURI();
        if (!(COMPATIBILITY_EDITOR_URI.equals(contributionURI) || COMPATIBILITY_VIEW_URI.equals(contributionURI) || URIHelper.isBundleClassUri((String)contributionURI))) {
            return false;
        }
        String[] bundleClass = contributionURI.substring(14).split("/");
        String bundleSymbolicName = bundleClass[0];
        String className = bundleClass[1];
        Collection<BundleWiring> wirings = this.findWirings(bundleSymbolicName, bundle.getBundleContext());
        return this.isPartDescriptorClassAvailable(wirings, className);
    }

    private boolean isPartDescriptorClassAvailable(Collection<BundleWiring> wirings, String className) {
        if (wirings.isEmpty()) {
            return false;
        }
        for (BundleWiring bundleWiring : wirings) {
            Class<?> partsClass = this.findClass(className, bundleWiring);
            if (partsClass != null) continue;
            return false;
        }
        return true;
    }

    private Collection<BundleWiring> findWirings(final String bundleSymbolicName, BundleContext bundleContext) {
        Requirement req = new Requirement(){

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "osgi.identity";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.identity=" + bundleSymbolicName + ")");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }
        };
        Collection identities = ((FrameworkWiring)bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class)).findProviders(req);
        ArrayList<BundleWiring> result = new ArrayList<BundleWiring>(1);
        for (BundleCapability identity : identities) {
            BundleRevision revision = identity.getRevision();
            BundleWiring wiring = revision.getWiring();
            if (wiring == null) continue;
            if ((revision.getTypes() & 1) != 0) {
                wiring = ((BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0)).getProviderWiring();
            }
            result.add(wiring);
        }
        return result;
    }

    private Class<?> findClass(String className, BundleWiring wiring) {
        if (wiring == null) {
            return null;
        }
        if ((wiring.getRevision().getTypes() & 1) != 0) {
            wiring = ((BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0)).getProviderWiring();
        }
        try {
            return wiring.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

