/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewBinaryDependenciesOperation;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class NewLibraryPluginCreationOperation
extends NewProjectCreationOperation {
    private static final String SOURCE_PREFIX = "source.";
    private LibraryPluginFieldData fData;

    public NewLibraryPluginCreationOperation(LibraryPluginFieldData data, IProjectProvider provider, IPluginContentWizard contentWizard) {
        super(data, provider, contentWizard);
        this.fData = data;
    }

    private void addJar(File jarFile, IProject project, IProgressMonitor monitor) throws CoreException {
        block14: {
            String jarName = jarFile.getName();
            IFile file = project.getFile(jarName);
            monitor.subTask(NLS.bind((String)PDEUIMessages.NewProjectCreationOperation_copyingJar, (Object)jarName));
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(jarFile);
                    file.create((InputStream)in, true, monitor);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void adjustExportRoot(IProject project, IBundle bundle) throws CoreException {
        IResource[] resources = project.members(false);
        int j = 0;
        while (j < resources.length) {
            if (!(!(resources[j] instanceof IFile) || ".project".equals(resources[j].getName()) || ".classpath".equals(resources[j].getName()) || "plugin.xml".equals(resources[j].getName()) || "build.properties".equals(resources[j].getName()))) {
                return;
            }
            ++j;
        }
        this.removeExportRoot(bundle);
    }

    @Override
    protected void adjustManifests(IProgressMonitor monitor, IProject project, IPluginBase base) throws CoreException {
        IBundle bundle;
        super.adjustManifests(monitor, project, base);
        int units = this.fData.doFindDependencies() ? 4 : 2;
        monitor.beginTask(new String(), units += this.fData.isUpdateReferences() ? 1 : 0);
        IBundle iBundle = bundle = base instanceof BundlePluginBase ? ((BundlePluginBase)base).getBundle() : null;
        if (bundle != null) {
            this.adjustExportRoot(project, bundle);
            monitor.worked(1);
            this.addExportedPackages(project, bundle);
            monitor.worked(1);
            if (this.fData.doFindDependencies()) {
                this.addDependencies(project, base.getModel(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            if (this.fData.isUpdateReferences()) {
                this.updateReferences(monitor, project);
                monitor.worked(1);
            }
        }
        monitor.done();
    }

    protected void updateReferences(IProgressMonitor monitor, IProject project) throws JavaModelException {
        IJavaProject currentProject = JavaCore.create((IProject)project);
        IPluginModelBase[] pluginstoUpdate = this.fData.getPluginsToUpdate();
        int i = 0;
        while (i < pluginstoUpdate.length) {
            IProject proj = pluginstoUpdate[i].getUnderlyingResource().getProject();
            if (!currentProject.getProject().equals((Object)proj)) {
                IJavaProject javaProject = JavaCore.create((IProject)proj);
                IClasspathEntry[] cp = javaProject.getRawClasspath();
                IClasspathEntry[] updated = this.getUpdatedClasspath(cp, currentProject);
                if (updated != null) {
                    javaProject.setRawClasspath(updated, monitor);
                }
                try {
                    NewLibraryPluginCreationOperation.updateRequiredPlugins(javaProject, monitor, pluginstoUpdate[i]);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private static void updateRequiredPlugins(IJavaProject javaProject, IProgressMonitor monitor, IPluginModelBase model) throws CoreException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>();
        ArrayList<IClasspathEntry> requiredProjects = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (NewLibraryPluginCreationOperation.isPluginProjectEntry(entries[i])) {
                requiredProjects.add(entries[i]);
            } else {
                classpath.add(entries[i]);
            }
            ++i;
        }
        if (requiredProjects.size() <= 0) {
            return;
        }
        IFile file = PDEProject.getManifest((IProject)javaProject.getProject());
        try {
            StringBuffer sb;
            Manifest manifest = new Manifest(file.getContents());
            String value = manifest.getMainAttributes().getValue("Require-Bundle");
            StringBuffer stringBuffer = sb = value != null ? new StringBuffer(value) : new StringBuffer();
            if (sb.length() > 0) {
                sb.append(",");
            }
            int i2 = 0;
            while (i2 < requiredProjects.size()) {
                IClasspathEntry entry = (IClasspathEntry)requiredProjects.get(i2);
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(entry.getPath().segment(0));
                if (entry.isExported()) {
                    sb.append(";visibility:=reexport");
                }
                ++i2;
            }
            manifest.getMainAttributes().putValue("Require-Bundle", sb.toString());
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            manifest.write(content);
            file.setContents((InputStream)new ByteArrayInputStream(content.toByteArray()), true, false, monitor);
            javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), monitor);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPluginProjectEntry(IClasspathEntry entry) {
        if (2 != entry.getEntryKind()) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject other = workspaceRoot.getProject(entry.getPath().segment(0));
        if (!PDE.hasPluginNature((IProject)other)) {
            return false;
        }
        if (PDEProject.getFragmentXml((IProject)other).exists()) {
            return false;
        }
        try {
            InputStream is = PDEProject.getManifest((IProject)other).getContents();
            try {
                Manifest mf = new Manifest(is);
                if (mf.getMainAttributes().getValue("Fragment-Host") == null) return true;
                return false;
            }
            finally {
                is.close();
            }
        }
        catch (IOException iOException) {
            return true;
        }
        catch (CoreException coreException) {}
        return true;
    }

    private IClasspathEntry[] getUpdatedClasspath(IClasspathEntry[] cp, IJavaProject currentProject) {
        boolean exposed = false;
        int refIndex = -1;
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        HashSet<Manifest> manifests = new HashSet<Manifest>();
        int i = 0;
        while (i < this.fData.getLibraryPaths().length) {
            try {
                manifests.add(new JarFile(this.fData.getLibraryPaths()[i]).getManifest());
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
            ++i;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i2 = 0;
        while (i2 < cp.length) {
            IClasspathEntry cpe = cp[i2];
            switch (cpe.getEntryKind()) {
                case 1: {
                    String path = null;
                    IPath location = root.getFile(cpe.getPath()).getLocation();
                    if (location != null) {
                        path = location.toString();
                    }
                    if (path == null) {
                        path = cpe.getPath().toString();
                    }
                    JarFile jarFile = null;
                    try {
                        try {
                            jarFile = new JarFile(path);
                            if (manifests.contains(jarFile.getManifest())) {
                                if (refIndex < 0) {
                                    refIndex = result.size();
                                    result.add(null);
                                }
                                exposed |= cpe.isExported();
                            } else {
                                result.add(cpe);
                            }
                        }
                        catch (IOException e) {
                            PDEPlugin.log(e);
                            if (jarFile == null) break;
                            try {
                                jarFile.close();
                            }
                            catch (IOException e2) {
                                PDEPlugin.log(e2);
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException e) {
                                PDEPlugin.log(e);
                            }
                        }
                        throw throwable;
                    }
                    if (jarFile == null) break;
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        PDEPlugin.log(e);
                    }
                    break;
                }
                default: {
                    result.add(cpe);
                }
            }
            ++i2;
        }
        if (refIndex >= 0) {
            result.set(refIndex, JavaCore.newProjectEntry((IPath)currentProject.getPath(), (boolean)exposed));
            return result.toArray(new IClasspathEntry[result.size()]);
        }
        return null;
    }

    @Override
    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
        String[] paths = this.fData.getLibraryPaths();
        int i = paths.length - 1;
        while (i >= 0) {
            File jarFile = new File(paths[i]);
            if (this.fData.isUnzipLibraries()) {
                this.importJar(jarFile, (IResource)project, monitor);
            } else {
                this.addJar(jarFile, project, monitor);
            }
            monitor.worked(1);
            --i;
        }
        IFile importedManifest = PDEProject.getManifest((IProject)project);
        if (importedManifest.exists()) {
            IFolder meta_inf;
            importedManifest.delete(true, false, monitor);
            if (!this.fData.hasBundleStructure() && (meta_inf = project.getFolder("META-INF")).members().length == 0) {
                meta_inf.delete(true, false, monitor);
            }
        }
    }

    @Override
    protected void fillBinIncludes(IProject project, IBuildEntry binEntry) throws CoreException {
        if (this.fData.hasBundleStructure()) {
            binEntry.addToken("META-INF/");
        } else {
            binEntry.addToken("plugin.xml");
        }
        if (this.fData.isUnzipLibraries()) {
            IResource[] resources = project.members(false);
            int j = 0;
            while (j < resources.length) {
                String resourceName = resources[j].getName();
                if (resources[j] instanceof IFolder) {
                    if (!".settings".equals(resourceName) && !binEntry.contains(String.valueOf(resourceName) + "/")) {
                        binEntry.addToken(String.valueOf(resourceName) + "/");
                    }
                } else if (!(".project".equals(resourceName) || ".classpath".equals(resourceName) || "build.properties".equals(resourceName) || binEntry.contains(resourceName))) {
                    binEntry.addToken(resourceName);
                }
                ++j;
            }
        } else {
            String[] libraryPaths = this.fData.getLibraryPaths();
            int j = 0;
            while (j < libraryPaths.length) {
                File jarFile = new File(libraryPaths[j]);
                String name = jarFile.getName();
                if (!binEntry.contains(name)) {
                    binEntry.addToken(name);
                }
                ++j;
            }
        }
    }

    @Override
    protected IClasspathEntry[] getInternalClassPathEntries(IJavaProject project, IFieldData data) {
        String[] libraryPaths = this.fData.isUnzipLibraries() ? new String[]{""} : this.fData.getLibraryPaths();
        IClasspathEntry[] entries = new IClasspathEntry[libraryPaths.length];
        int j = 0;
        while (j < libraryPaths.length) {
            File jarFile = new File(libraryPaths[j]);
            String jarName = jarFile.getName();
            IPath path = project.getProject().getFullPath().append(jarName);
            entries[j] = JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)true);
            ++j;
        }
        return entries;
    }

    @Override
    protected int getNumberOfWorkUnits() {
        int numUnits = super.getNumberOfWorkUnits();
        return numUnits += this.fData.getLibraryPaths().length;
    }

    private void importJar(File jar, IResource destination, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        ZipFile input = null;
        try {
            try {
                input = new ZipFile(jar);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(input);
                ImportOperation op = new ImportOperation(destination.getFullPath(), (Object)provider.getRoot(), (IImportStructureProvider)provider, new IOverwriteQuery(){

                    public String queryOverwrite(String pathString) {
                        return "ALL";
                    }
                });
                op.run(monitor);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 0, NLS.bind((String)PDEUIMessages.NewProjectCreationOperation_errorImportingJar, (Object)jar), (Throwable)e));
        }
    }

    private void removeExportRoot(IBundle bundle) {
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        try {
            ManifestElement[] elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            StringBuffer buff = new StringBuffer(value.length());
            int i = 0;
            while (i < elems.length) {
                if (!elems[i].getValue().equals(".")) {
                    buff.append(elems[i].getValue());
                }
                ++i;
            }
            bundle.setHeader("Bundle-ClassPath", buff.toString());
        }
        catch (BundleException bundleException) {}
    }

    @Override
    protected void setPluginLibraries(WorkspacePluginModelBase model) throws CoreException {
        IPluginBase pluginBase = model.getPluginBase();
        if (this.fData.isUnzipLibraries()) {
            IPluginLibrary library = model.getPluginFactory().createLibrary();
            library.setName(".");
            library.setExported(true);
            pluginBase.add(library);
        } else {
            String[] paths = this.fData.getLibraryPaths();
            int i = 0;
            while (i < paths.length) {
                File jarFile = new File(paths[i]);
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                library.setName(jarFile.getName());
                library.setExported(true);
                pluginBase.add(library);
                ++i;
            }
        }
    }

    @Override
    protected void createSourceOutputBuildEntries(WorkspaceBuildModel model, IBuildModelFactory factory) throws CoreException {
        if (this.fData.isUnzipLibraries()) {
            IBuildEntry entry = factory.createEntry("source..");
            entry.addToken(".");
            model.getBuild().add(entry);
            entry = factory.createEntry("output..");
            entry.addToken(".");
            model.getBuild().add(entry);
        }
    }

    private void addExportedPackages(IProject project, IBundle bundle) {
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        try {
            ManifestElement[] elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            HashMap map = new HashMap();
            int i = 0;
            while (i < elems.length) {
                ArrayList<String> filter = new ArrayList<String>();
                filter.add("*");
                map.put(elems[i].getValue(), filter);
                ++i;
            }
            Set<String> packages = this.getExports(project, map);
            String pkgValue = this.getCommaValuesFromPackagesSet(packages, this.fData.getVersion());
            bundle.setHeader("Export-Package", pkgValue);
        }
        catch (BundleException bundleException) {}
    }

    public Set<String> getExports(IProject proj, Map libs) {
        IFile buildProperties = PDEProject.getBuildProperties((IProject)proj);
        Build build = null;
        if (buildProperties != null) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildProperties);
            build = buildModel.getBuild();
        } else {
            build = new Build();
        }
        return this.findPackages(proj, libs, (IBuild)build);
    }

    private Set<String> findPackages(IProject proj, Map<?, List<?>> libs, IBuild build) {
        TreeSet<String> result = new TreeSet<String>();
        IJavaProject jp = JavaCore.create((IProject)proj);
        for (Map.Entry<?, List<?>> entry : libs.entrySet()) {
            String libName = entry.getKey().toString();
            List<?> filter = entry.getValue();
            IBuildEntry libEntry = build.getEntry(SOURCE_PREFIX + libName);
            if (libEntry != null) {
                String[] tokens = libEntry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    Object folder = null;
                    folder = tokens[i].equals(".") ? proj : proj.getFolder(tokens[i]);
                    if (folder != null) {
                        this.addPackagesFromFragRoot(jp.getPackageFragmentRoot((IResource)folder), result, filter);
                    }
                    ++i;
                }
                continue;
            }
            IResource res = proj.findMember(libName);
            if (res == null) continue;
            this.addPackagesFromFragRoot(jp.getPackageFragmentRoot(res), result, filter);
        }
        return result;
    }

    private void addPackagesFromFragRoot(IPackageFragmentRoot root, Collection<String> result, List<?> filter) {
        if (root == null) {
            return;
        }
        try {
            if (filter != null && !filter.contains("*")) {
                ListIterator<?> li = filter.listIterator();
                while (li.hasNext()) {
                    IPackageFragment frag;
                    String pkgName = li.next().toString();
                    if (pkgName.endsWith(".*")) {
                        pkgName = pkgName.substring(0, pkgName.length() - 2);
                    }
                    if ((frag = root.getPackageFragment(pkgName)) == null) continue;
                    result.add(pkgName);
                }
                return;
            }
            IJavaElement[] children = root.getChildren();
            int j = 0;
            while (j < children.length) {
                IPackageFragment fragment = (IPackageFragment)children[j];
                String name = fragment.getElementName();
                if (fragment.hasChildren() && !result.contains(name)) {
                    result.add(name);
                }
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void addDependencies(IProject project, ISharedPluginModel model, IProgressMonitor monitor) {
        if (!(model instanceof IBundlePluginModelBase)) {
            monitor.done();
            return;
        }
        final boolean unzip = this.fData.isUnzipLibraries();
        try {
            new AddNewBinaryDependenciesOperation(project, (IBundlePluginModelBase)model){

                @Override
                protected String[] findSecondaryBundles(IBundle bundle, Set<String> ignorePkgs) {
                    IPluginModelBase[] bases = PluginRegistry.getActiveModels();
                    String[] ids = new String[bases.length];
                    int i = 0;
                    while (i < bases.length) {
                        BundleDescription desc = bases[i].getBundleDescription();
                        ids[i] = desc == null ? bases[i].getPluginBase().getId() : desc.getSymbolicName();
                        ++i;
                    }
                    return ids;
                }

                @Override
                protected void addProjectPackages(IBundle bundle, Set<String> ignorePkgs) {
                    if (!unzip) {
                        super.addProjectPackages(bundle, ignorePkgs);
                    }
                    Stack<Object> stack = new Stack<Object>();
                    stack.push(this.fProject);
                    try {
                        while (!stack.isEmpty()) {
                            IContainer folder = (IContainer)stack.pop();
                            IResource[] children = folder.members();
                            int i = 0;
                            while (i < children.length) {
                                if (children[i] instanceof IContainer) {
                                    stack.push(children[i]);
                                } else if ("class".equals(((IFile)children[i]).getFileExtension())) {
                                    String path = folder.getProjectRelativePath().toString();
                                    ignorePkgs.add(path.replace('/', '.'));
                                }
                                ++i;
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }.run(monitor);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }
}

