/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.impl.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.ExpandAll;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ExpandAllService
extends AbstractActionService {
    @Override
    protected Object exec(Command command) throws CoreException {
        ExpandAll cmd = (ExpandAll)command;
        ControlHandler handler = cmd.getControl();
        Element element = TeslaBridge.find(handler);
        final Widget widget = ((SWTUIElement)((SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class)).getMapper().get((Element)element)).widget;
        if (!(widget instanceof Tree) && !(widget instanceof TreeItem)) {
            return TeslaImplPlugin.err("'expand-all' can be used only on tree or tree item");
        }
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExpandAllService.expandAll(widget);
            }
        });
        return handler;
    }

    private static void expandAll(Widget widget) {
        TreeItem[] treeItemArray;
        if (widget instanceof Tree) {
            treeItemArray = ((Tree)widget).getItems();
        } else {
            TreeItem[] treeItemArray2 = new TreeItem[1];
            treeItemArray = treeItemArray2;
            treeItemArray2[0] = (TreeItem)widget;
        }
        TreeItem[] roots = treeItemArray;
        ExpandAllService.expand(roots);
    }

    private static void expand(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            Object data = i.getData();
            if (!TeslaSWTAccess.ignoreMarkersView((Object)data)) {
                Event e = new Event();
                e.item = i;
                e.widget = i.getParent();
                e.display = i.getDisplay();
                e.time = (int)System.currentTimeMillis();
                i.getParent().notifyListeners(17, e);
                i.setExpanded(true);
                ExpandAllService.expand(i.getItems());
            }
            ++n2;
        }
    }
}

