/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rcptt.ui.editors.ecl.EditorToolkit;
import org.eclipse.rcptt.ui.editors.ecl.EnhancedSourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class EnhancedSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener,
ISourceViewer {
    protected EditorToolkit toolkit;

    public EnhancedSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public void configure(SourceViewerConfiguration configuration) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        super.configure(configuration);
        if (configuration instanceof EnhancedSourceViewerConfiguration) {
            IDocument document;
            this.toolkit = ((EnhancedSourceViewerConfiguration)configuration).getEditorToolkit();
            if (textWidget != null) {
                textWidget.setFont(JFaceResources.getFont((String)this.toolkit.getEditorTextFont()));
            }
            if ((document = this.getDocument()) != null) {
                FastPartitioner partitioner = new FastPartitioner(this.toolkit.getPartitionScanner(), this.toolkit.getPartitions());
                partitioner.connect(document);
                document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            }
        }
    }

    public void resetVisibleRegion() {
        super.resetVisibleRegion();
        this.enableProjection();
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (document != null && this.toolkit != null) {
            FastPartitioner partitioner = new FastPartitioner(this.toolkit.getPartitionScanner(), this.toolkit.getPartitions());
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
    }

    protected void disposeVisualAnnotationModel() {
        super.disposeVisualAnnotationModel();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }
}

