/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class AbstractBundleContainer
extends PlatformObject
implements ITargetLocation {
    protected TargetBundle[] fBundles;
    protected TargetFeature[] fFeatures;
    protected IStatus fResolutionStatus;
    private String[] fVMArgs;

    protected String resolveVariables(String text) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(text);
    }

    @Override
    public final boolean isResolved() {
        return this.fResolutionStatus != null && this.fResolutionStatus.getSeverity() != 8;
    }

    @Override
    public final IStatus resolve(ITargetDefinition definition, IProgressMonitor monitor) {
        int resolveBundlesWork = this.getResolveBundlesWork();
        int resolveFeaturesWork = this.getResolveFeaturesWork();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(resolveBundlesWork + resolveFeaturesWork));
        try {
            try {
                this.fResolutionStatus = Status.OK_STATUS;
                this.fBundles = this.resolveBundles(definition, (IProgressMonitor)subMonitor.newChild(resolveBundlesWork));
                this.fFeatures = this.resolveFeatures(definition, (IProgressMonitor)subMonitor.newChild(resolveFeaturesWork));
                if (subMonitor.isCanceled()) {
                    this.fBundles = null;
                    this.fResolutionStatus = Status.CANCEL_STATUS;
                }
            }
            catch (CoreException e) {
                this.fBundles = new TargetBundle[0];
                this.fFeatures = new TargetFeature[0];
                this.fResolutionStatus = e.getStatus();
                subMonitor.done();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
        return this.fResolutionStatus;
    }

    protected int getResolveBundlesWork() {
        return 100;
    }

    protected int getResolveFeaturesWork() {
        return 50;
    }

    @Override
    public IStatus getStatus() {
        if (!this.isResolved()) {
            return null;
        }
        return this.fResolutionStatus;
    }

    @Override
    public final TargetBundle[] getBundles() {
        if (this.isResolved()) {
            return this.fBundles;
        }
        return null;
    }

    @Override
    public TargetFeature[] getFeatures() {
        if (this.isResolved()) {
            return this.fFeatures;
        }
        return null;
    }

    protected abstract TargetBundle[] resolveBundles(ITargetDefinition var1, IProgressMonitor var2) throws CoreException;

    protected abstract TargetFeature[] resolveFeatures(ITargetDefinition var1, IProgressMonitor var2) throws CoreException;

    @Override
    public abstract String getType();

    @Override
    public abstract String getLocation(boolean var1) throws CoreException;

    protected void clearResolutionStatus() {
        this.fResolutionStatus = null;
    }

    @Override
    public String[] getVMArguments() {
        String FWK_ADMIN_EQ = "org.eclipse.equinox.frameworkadmin.equinox";
        if (this.fVMArgs == null) {
            try {
                Bundle fwAdminBundle;
                FrameworkAdmin fwAdmin = (FrameworkAdmin)PDECore.getDefault().acquireService(FrameworkAdmin.class.getName());
                if (fwAdmin == null && (fwAdminBundle = Platform.getBundle((String)FWK_ADMIN_EQ)) != null) {
                    fwAdminBundle.start();
                    fwAdmin = (FrameworkAdmin)PDECore.getDefault().acquireService(FrameworkAdmin.class.getName());
                }
                if (fwAdmin != null) {
                    Manipulator manipulator = fwAdmin.getManipulator();
                    ConfigData configData = new ConfigData(null, null, null, null);
                    String home = this.getLocation(true);
                    manipulator.getLauncherData().setLauncher(new File(home, "eclipse"));
                    File installDirectory = new File(home);
                    manipulator.getLauncherData().setLauncherConfigLocation(new File(installDirectory, "eclipse.ini"));
                    manipulator.getLauncherData().setHome(new File(home));
                    manipulator.setConfigData(configData);
                    manipulator.load();
                    this.fVMArgs = manipulator.getLauncherData().getJvmArgs();
                }
            }
            catch (BundleException e) {
                PDECore.log(e);
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        if (this.fVMArgs == null || this.fVMArgs.length == 0) {
            return null;
        }
        return this.fVMArgs;
    }

    protected void associateWithTarget(ITargetDefinition target) {
    }

    @Override
    public String serialize() {
        return null;
    }
}

