/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.logging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.aspects.asyncs.IAsyncEventListener;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.SherlockTimerRunnable;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.swt.events.TeslaTimerExecManager;
import org.eclipse.rcptt.tesla.swt.logging.JobsInfoProvider;

final class AsyncInfoSupport
implements IAsyncEventListener {
    private JobsInfoProvider provider;
    private boolean collectTimerExecs = true;
    private List<SherlockTimerRunnable> runnables = new ArrayList<SherlockTimerRunnable>();
    private List<Runnable> sync = new ArrayList<Runnable>();

    public AsyncInfoSupport(JobsInfoProvider jobsEventProvider) {
        this.provider = jobsEventProvider;
    }

    public void timerCanceled(Runnable timer) {
    }

    public synchronized void timerAdded(Runnable async) {
        IReportBuilder[] builders;
        async = this.getRunnable(async);
        String timerClassName = async.getClass().getName();
        boolean ignoredTimer = SWTUIPlayer.isTimerIgnored(timerClassName);
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            ReportHelper.updateWaitInfo((INodeBuilder)builder.getCurrent(), (String)(ignoredTimer ? "timer (ignored)" : "timer"), (String)timerClassName);
            ++n2;
        }
    }

    private Runnable getRunnable(Runnable async) {
        if (async instanceof SherlockTimerRunnable) {
            async = ((SherlockTimerRunnable)async).getRunnable();
        }
        return async;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable cancelTimerProc(Runnable runnable) {
        if (!this.collectTimerExecs) {
            return runnable;
        }
        List<SherlockTimerRunnable> list = this.runnables;
        synchronized (list) {
            Iterator<SherlockTimerRunnable> iterator = this.runnables.iterator();
            while (iterator.hasNext()) {
                SherlockTimerRunnable r = iterator.next();
                if (r.getDirectChild() != runnable) continue;
                iterator.remove();
                return r;
            }
        }
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable processTimerProc(Runnable newRunnable) {
        if (!this.collectTimerExecs) {
            return newRunnable;
        }
        List<SherlockTimerRunnable> list = this.runnables;
        synchronized (list) {
            for (SherlockTimerRunnable r : this.runnables) {
                if (r.getDirectChild() != newRunnable) continue;
                return r;
            }
        }
        SherlockTimerRunnable result = new SherlockTimerRunnable(newRunnable){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void preExecute() {
                IReportBuilder[] builders;
                boolean ignoredTimer = SWTUIPlayer.isTimerIgnored(this.getRunnable().getClass().getName());
                IReportBuilder[] iReportBuilderArray = builders = AsyncInfoSupport.this.provider.getListeners();
                int n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    IReportBuilder builder = iReportBuilderArray[n2];
                    Q7WaitInfoRoot waitInfo = ReportHelper.getWaitInfo((INodeBuilder)builder.getCurrent());
                    List timers = TeslaTimerExecManager.getManager().getTimers();
                    for (TeslaTimerExecManager.TimerInfo timerInfo : timers) {
                        if (!timerInfo.hasRunnable(this.getRunnable())) continue;
                        String timerClassName = this.getRunnable().getClass().getName();
                        Q7WaitInfoRoot q7WaitInfoRoot = waitInfo;
                        synchronized (q7WaitInfoRoot) {
                            if (timerInfo.execQualifier != null) {
                                waitInfo.getInnerClassMap().put((Object)timerClassName, (Object)timerInfo.execQualifier);
                            }
                        }
                        Q7WaitUtils.updateInfo((String)(ignoredTimer ? "timer (ignored)" : "timer"), (String)timerClassName, (Q7WaitInfoRoot)waitInfo);
                    }
                    ++n2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void postExecute() {
                try {
                    this.preExecute();
                }
                catch (Throwable throwable) {
                    List list = AsyncInfoSupport.this.runnables;
                    synchronized (list) {
                        AsyncInfoSupport.this.runnables.remove((Object)this);
                    }
                    throw throwable;
                }
                List list = AsyncInfoSupport.this.runnables;
                synchronized (list) {
                    AsyncInfoSupport.this.runnables.remove((Object)this);
                }
            }
        };
        List<SherlockTimerRunnable> list2 = this.runnables;
        synchronized (list2) {
            this.runnables.add(result);
        }
        return result;
    }

    public synchronized void asyncRunning(Runnable async) {
        IReportBuilder[] builders;
        if (async == null) {
            return;
        }
        String className = this.getAsyncClassName(async = this.getRunnable(async));
        if (this.isAsyncIgnored(className)) {
            return;
        }
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            String kind = "async";
            if (this.sync.contains(async)) {
                kind = "sync";
            }
            ReportHelper.updateWaitInfo((INodeBuilder)builder.getCurrent(), (String)kind, (String)className);
            ++n2;
        }
    }

    private boolean isAsyncIgnored(String className) {
        return className.startsWith("org.eclipse.ui.internal.UISynchronizer");
    }

    public synchronized void asyncDone(Runnable async) {
        IReportBuilder[] builders;
        String className = this.getAsyncClassName(async = this.getRunnable(async));
        if (this.isAsyncIgnored(className)) {
            return;
        }
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            String kind = "async";
            if (this.sync.contains(async)) {
                kind = "sync";
                this.sync.remove(async);
            }
            ReportHelper.updateWaitInfo((INodeBuilder)builder.getCurrent(), (String)kind, (String)className);
            ++n2;
        }
    }

    public synchronized void asyncAdded(Runnable async, boolean sync) {
        IReportBuilder[] builders;
        async = this.getRunnable(async);
        String className = this.getAsyncClassName(async);
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            String kind;
            IReportBuilder builder = iReportBuilderArray[n2];
            String string = kind = sync ? "sync" : "async";
            if (sync) {
                this.sync.add(async);
            }
            ReportHelper.updateWaitInfo((INodeBuilder)builder.getCurrent(), (String)kind, (String)className);
            ++n2;
        }
    }

    private String getAsyncClassName(Runnable async) {
        Object this1;
        String className = async.getClass().getName();
        if (async instanceof SWTUIPlayer.ExecRunnable) {
            className = async.toString();
        }
        if (className.startsWith("org.eclipse.ui.progress.UIJob") && (this1 = TeslaSWTAccess.getThis(async)) instanceof Job) {
            className = this1.getClass().getName();
        }
        return className;
    }

    public void clear() {
    }
}

