/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.databinding.observable.IDiff;

public abstract class SetDiff
implements IDiff {
    public abstract Set getAdditions();

    public abstract Set getRemovals();

    public boolean isEmpty() {
        return this.getAdditions().isEmpty() && this.getRemovals().isEmpty();
    }

    public void applyTo(Set set) {
        set.addAll(this.getAdditions());
        set.removeAll(this.getRemovals());
    }

    public Set simulateOn(Set set) {
        return new DeltaSet(set, this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("{additions [").append(this.getAdditions() != null ? this.getAdditions().toString() : "null").append("], removals [").append(this.getRemovals() != null ? this.getRemovals().toString() : "null").append("]}");
        return buffer.toString();
    }

    private static class DeltaSet
    extends AbstractSet {
        private Set original;
        private final SetDiff diff;

        public DeltaSet(Set original, SetDiff diff) {
            this.original = original;
            this.diff = diff;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator orig;
                Iterator add;
                boolean haveNext;
                Object next;
                {
                    this.orig = DeltaSet.this.original.iterator();
                    this.add = DeltaSet.this.diff.getAdditions().iterator();
                    this.haveNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                public Object next() {
                    if (!this.findNext()) {
                        throw new NoSuchElementException();
                    }
                    Object myNext = this.next;
                    this.haveNext = false;
                    this.next = null;
                    return myNext;
                }

                private boolean findNext() {
                    Object candidate;
                    if (this.haveNext) {
                        return true;
                    }
                    do {
                        if (this.orig.hasNext()) {
                            candidate = this.orig.next();
                            continue;
                        }
                        if (this.add.hasNext()) {
                            candidate = this.add.next();
                            continue;
                        }
                        return false;
                    } while (DeltaSet.this.diff.getRemovals().contains(candidate));
                    this.haveNext = true;
                    this.next = candidate;
                    return true;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return (this.original.contains(o) || this.diff.getAdditions().contains(o)) && !this.diff.getRemovals().contains(o);
        }

        @Override
        public int size() {
            return this.original.size() + this.diff.getAdditions().size() - this.diff.getRemovals().size();
        }
    }
}

