/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CastCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ImplementInterfaceProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewVariableCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.TypeChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMismatchSubProcessor {
    private TypeMismatchSubProcessor() {
    }

    public static void addTypeMismatchProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws CoreException {
        ASTRewrite rewrite;
        BodyDeclaration decl;
        boolean nullOrVoid;
        String[] args = problem.getProblemArguments();
        if (args.length != 2) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        AST ast = astRoot.getAST();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression nodeToCast = (Expression)selectedNode;
        SimpleName receiverNode = null;
        ITypeBinding castTypeBinding = null;
        int parentNodeType = selectedNode.getParent().getNodeType();
        if (parentNodeType == 7) {
            Assignment assign = (Assignment)selectedNode.getParent();
            Expression leftHandSide = assign.getLeftHandSide();
            if (selectedNode.equals((Object)leftHandSide)) {
                nodeToCast = assign.getRightHandSide();
            }
            castTypeBinding = assign.getLeftHandSide().resolveTypeBinding();
            if (leftHandSide instanceof Name) {
                receiverNode = (Name)leftHandSide;
            } else if (leftHandSide instanceof FieldAccess) {
                receiverNode = ((FieldAccess)leftHandSide).getName();
            }
        } else if (parentNodeType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)selectedNode.getParent();
            if (selectedNode.equals((Object)frag.getName()) || selectedNode.equals((Object)frag.getInitializer())) {
                nodeToCast = frag.getInitializer();
                castTypeBinding = ASTNodes.getType((VariableDeclaration)frag).resolveBinding();
                receiverNode = frag.getName();
            }
        } else if (parentNodeType == 80) {
            receiverNode = ((MemberValuePair)selectedNode.getParent()).getName();
            castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
        } else if (parentNodeType == 79) {
            receiverNode = ((SingleMemberAnnotation)selectedNode.getParent()).getTypeName();
            castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
        } else {
            castTypeBinding = ASTResolving.guessBindingForReference((ASTNode)nodeToCast);
        }
        if (castTypeBinding == null) {
            return;
        }
        ITypeBinding currBinding = nodeToCast.resolveTypeBinding();
        if (!(nodeToCast instanceof ArrayInitializer)) {
            ITypeBinding boxUnboxedTypeBinding;
            ITypeBinding castFixType = null;
            if (currBinding == null || castTypeBinding.isCastCompatible(currBinding) || nodeToCast instanceof CastExpression) {
                castFixType = castTypeBinding;
            } else if (JavaModelUtil.is50OrHigher(cu.getJavaProject()) && (boxUnboxedTypeBinding = TypeMismatchSubProcessor.boxUnboxPrimitives(castTypeBinding, currBinding, ast)) != castTypeBinding && boxUnboxedTypeBinding.isCastCompatible(currBinding)) {
                castFixType = boxUnboxedTypeBinding;
            }
            if (castFixType != null) {
                proposals.add(TypeMismatchSubProcessor.createCastProposal(context, castFixType, nodeToCast, 7));
            }
        }
        boolean bl = nullOrVoid = currBinding == null || "void".equals(currBinding.getName());
        if (!nullOrVoid && parentNodeType == 41 && (decl = ASTResolving.findParentBodyDeclaration(selectedNode)) instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType(currBinding, true, ast);
            }
            rewrite = ASTRewrite.create((AST)ast);
            String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturntype_description, BasicElementLabels.getJavaElementName(currBinding.getName()));
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
            ImportRewrite imports = proposal.createImportRewrite(astRoot);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
            Type newReturnType = imports.addImport(currBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
            rewrite.replace((ASTNode)methodDeclaration.getReturnType2(), (ASTNode)newReturnType, null);
            String returnKey = "return";
            proposal.addLinkedPosition(rewrite.track((ASTNode)newReturnType), true, returnKey);
            ITypeBinding[] typeSuggestions = ASTResolving.getRelaxingTypes(ast, currBinding);
            int i = 0;
            while (i < typeSuggestions.length) {
                proposal.addLinkedPositionProposal(returnKey, typeSuggestions[i]);
                ++i;
            }
            proposals.add(proposal);
        }
        if (!nullOrVoid && receiverNode != null) {
            if ((currBinding = Bindings.normalizeTypeBinding(currBinding)) == null) {
                currBinding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (currBinding.isWildcardType()) {
                currBinding = ASTResolving.normalizeWildcardType(currBinding, true, ast);
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, (Expression)receiverNode, currBinding, true, 6, proposals);
        }
        TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, nodeToCast, castTypeBinding, false, 5, proposals);
        if (castTypeBinding == ast.resolveWellKnownType("boolean") && currBinding != null && !currBinding.isPrimitive() && !Bindings.isVoidType(currBinding)) {
            String label = CorrectionMessages.TypeMismatchSubProcessor_insertnullcheck_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            rewrite = ASTRewrite.create((AST)astRoot.getAST());
            InfixExpression expression = ast.newInfixExpression();
            expression.setLeftOperand((Expression)rewrite.createMoveTarget((ASTNode)nodeToCast));
            expression.setRightOperand((Expression)ast.newNullLiteral());
            expression.setOperator(InfixExpression.Operator.NOT_EQUALS);
            rewrite.replace((ASTNode)nodeToCast, (ASTNode)expression, null);
            proposals.add(new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 2, image));
        }
    }

    public static ITypeBinding boxUnboxPrimitives(ITypeBinding castType, ITypeBinding toCast, AST ast) {
        if (castType.isPrimitive() && !toCast.isPrimitive()) {
            return Bindings.getBoxedTypeBinding(castType, ast);
        }
        if (!castType.isPrimitive() && toCast.isPrimitive()) {
            return Bindings.getUnboxedTypeBinding(castType, ast);
        }
        return castType;
    }

    public static void addChangeSenderTypeProposals(IInvocationContext context, Expression nodeToCast, ITypeBinding castTypeBinding, boolean isAssignedNode, int relevance, Collection<ICommandAccess> proposals) throws JavaModelException {
        IBinding callerBinding = Bindings.resolveExpressionBinding(nodeToCast, false);
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit targetCu = null;
        ITypeBinding declaringType = null;
        IBinding callerBindingDecl = callerBinding;
        if (callerBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)callerBinding;
            if (variableBinding.isEnumConstant()) {
                return;
            }
            if (!variableBinding.isField()) {
                targetCu = cu;
            } else {
                callerBindingDecl = variableBinding.getVariableDeclaration();
                ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                if (declaringClass == null) {
                    return;
                }
                declaringType = declaringClass.getTypeDeclaration();
            }
        } else if (callerBinding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)callerBinding;
            if (!methodBinding.isConstructor()) {
                declaringType = methodBinding.getDeclaringClass().getTypeDeclaration();
                callerBindingDecl = methodBinding.getMethodDeclaration();
            }
        } else if (callerBinding instanceof ITypeBinding && nodeToCast.getLocationInParent() == SingleMemberAnnotation.TYPE_NAME_PROPERTY && (callerBindingDecl = Bindings.findMethodInType(declaringType = (ITypeBinding)callerBinding, "value", null)) == null) {
            return;
        }
        if (declaringType != null && declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null && ASTResolving.isUseableTypeInContext(castTypeBinding, callerBindingDecl, false)) {
            proposals.add(new TypeChangeCorrectionProposal(targetCu, callerBindingDecl, astRoot, castTypeBinding, isAssignedNode, relevance));
        }
        if (!isAssignedNode) {
            ITypeBinding typeDecl;
            ICompilationUnit nodeCu;
            ITypeBinding nodeType = nodeToCast.resolveTypeBinding();
            if (castTypeBinding.isInterface() && nodeType != null && nodeType.isClass() && !nodeType.isAnonymous() && nodeType.isFromSource() && (nodeCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, typeDecl = nodeType.getTypeDeclaration())) != null && ASTResolving.isUseableTypeInContext(castTypeBinding, (IBinding)typeDecl, true)) {
                proposals.add(new ImplementInterfaceProposal(nodeCu, typeDecl, astRoot, castTypeBinding, relevance - 1));
            }
        }
    }

    public static ASTRewriteCorrectionProposal createCastProposal(IInvocationContext context, ITypeBinding castTypeBinding, Expression nodeToCast, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        String castType = BindingLabelProvider.getBindingLabel((IBinding)castTypeBinding, JavaElementLabels.ALL_DEFAULT);
        String label = nodeToCast.getNodeType() == 11 ? Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changecast_description, castType) : Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addcast_description, castType);
        return new CastCorrectionProposal(label, cu, nodeToCast, castTypeBinding, relevance);
    }

    public static void addIncompatibleReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        MethodDeclaration decl = ASTResolving.findParentMethodDeclaration(selectedNode);
        if (decl == null) {
            return;
        }
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        ITypeBinding returnType = methodDeclBinding.getReturnType();
        IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null || overridden.getReturnType() == returnType) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        IMethodBinding methodDecl = methodDeclBinding.getMethodDeclaration();
        ITypeBinding overriddenReturnType = overridden.getReturnType();
        if (!JavaModelUtil.is50OrHigher(context.getCompilationUnit().getJavaProject())) {
            overriddenReturnType = overriddenReturnType.getErasure();
        }
        proposals.add(new TypeChangeCorrectionProposal(cu, (IBinding)methodDecl, astRoot, overriddenReturnType, false, 8));
        ICompilationUnit targetCu = cu;
        IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
        ITypeBinding overridenDeclType = overriddenDecl.getDeclaringClass();
        if (overridenDeclType.isFromSource() && (targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, overridenDeclType)) != null && ASTResolving.isUseableTypeInContext(returnType, (IBinding)overriddenDecl, false)) {
            TypeChangeCorrectionProposal proposal = new TypeChangeCorrectionProposal(targetCu, (IBinding)overriddenDecl, astRoot, returnType, false, 7);
            if (overridenDeclType.isInterface()) {
                proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofimplemented_description, BasicElementLabels.getJavaElementName(overriddenDecl.getName())));
            } else {
                proposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofoverridden_description, BasicElementLabels.getJavaElementName(overriddenDecl.getName())));
            }
            proposals.add(proposal);
        }
    }

    public static void addIncompatibleThrowsProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        IMethodBinding methodDeclBinding = decl.resolveBinding();
        if (methodDeclBinding == null) {
            return;
        }
        IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
        if (overridden == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding[] methodExceptions = methodDeclBinding.getExceptionTypes();
        ITypeBinding[] definedExceptions = overridden.getExceptionTypes();
        ArrayList<ITypeBinding> undeclaredExceptions = new ArrayList<ITypeBinding>();
        ChangeMethodSignatureProposal.ChangeDescription[] changes = new ChangeMethodSignatureProposal.ChangeDescription[methodExceptions.length];
        int i = 0;
        while (i < methodExceptions.length) {
            if (!TypeMismatchSubProcessor.isDeclaredException(methodExceptions[i], definedExceptions)) {
                changes[i] = new ChangeMethodSignatureProposal.RemoveDescription();
                undeclaredExceptions.add(methodExceptions[i]);
            }
            ++i;
        }
        if (undeclaredExceptions.size() == 0) {
            return;
        }
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_removeexceptions_description, BasicElementLabels.getJavaElementName(methodDeclBinding.getName()));
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.remove_correction.gif");
        proposals.add(new ChangeMethodSignatureProposal(label, cu, (ASTNode)astRoot, methodDeclBinding, null, changes, 8, image));
        ITypeBinding declaringType = overridden.getDeclaringClass();
        ICompilationUnit targetCu = null;
        if (declaringType.isFromSource()) {
            targetCu = ASTResolving.findCompilationUnitForBinding(cu, astRoot, declaringType);
        }
        if (targetCu != null) {
            ChangeMethodSignatureProposal.ChangeDescription[] changes2 = new ChangeMethodSignatureProposal.ChangeDescription[definedExceptions.length + undeclaredExceptions.size()];
            int i2 = 0;
            while (i2 < undeclaredExceptions.size()) {
                changes2[i2 + definedExceptions.length] = new ChangeMethodSignatureProposal.InsertDescription((ITypeBinding)undeclaredExceptions.get(i2), "");
                ++i2;
            }
            IMethodBinding overriddenDecl = overridden.getMethodDeclaration();
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(declaringType.getName()), BasicElementLabels.getJavaElementName(overridden.getName())};
            String label2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addexceptions_description, args);
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
            proposals.add(new ChangeMethodSignatureProposal(label2, targetCu, (ASTNode)astRoot, overriddenDecl, null, changes2, 7, image2));
        }
    }

    private static boolean isDeclaredException(ITypeBinding curr, ITypeBinding[] declared) {
        int i = 0;
        while (i < declared.length) {
            if (Bindings.isSuperType(declared[i], curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addTypeMismatchInForEachProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ITypeBinding expectedBinding;
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null || selectedNode.getLocationInParent() != EnhancedForStatement.EXPRESSION_PROPERTY) {
            return;
        }
        EnhancedForStatement forStatement = (EnhancedForStatement)selectedNode.getParent();
        ITypeBinding expressionBinding = forStatement.getExpression().resolveTypeBinding();
        if (expressionBinding == null) {
            return;
        }
        if (expressionBinding.isArray()) {
            expectedBinding = expressionBinding.getComponentType();
        } else {
            IMethodBinding iteratorMethod = Bindings.findMethodInHierarchy(expressionBinding, "iterator", new String[0]);
            if (iteratorMethod == null) {
                return;
            }
            ITypeBinding[] typeArguments = iteratorMethod.getReturnType().getTypeArguments();
            if (typeArguments.length != 1) {
                return;
            }
            expectedBinding = typeArguments[0];
        }
        AST ast = astRoot.getAST();
        expectedBinding = Bindings.normalizeForDeclarationUse(expectedBinding, ast);
        SingleVariableDeclaration parameter = forStatement.getParameter();
        ICompilationUnit cu = context.getCompilationUnit();
        if (parameter.getName().getLength() == 0) {
            SimpleName simpleName = null;
            if (parameter.getType() instanceof SimpleType) {
                SimpleType type = (SimpleType)parameter.getType();
                if (type.getName() instanceof SimpleName) {
                    simpleName = (SimpleName)type.getName();
                }
            } else if (parameter.getType() instanceof NameQualifiedType) {
                simpleName = ((NameQualifiedType)parameter.getType()).getName();
            }
            if (simpleName != null) {
                String name = simpleName.getIdentifier();
                int relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
                String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_create_loop_variable_description, BasicElementLabels.getJavaElementName(name));
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
                proposals.add(new NewVariableCorrectionProposal(label, cu, 1, simpleName, null, relevance, image));
                return;
            }
        }
        String label = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_incompatible_for_each_type_description, new String[]{BasicElementLabels.getJavaElementName(parameter.getName().getIdentifier()), BindingLabelProvider.getBindingLabel((IBinding)expectedBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS)});
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
        ImportRewrite importRewrite = proposal.createImportRewrite(astRoot);
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)ASTResolving.findParentBodyDeclaration(selectedNode), importRewrite);
        Type newType = importRewrite.addImport(expectedBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        rewrite.replace((ASTNode)parameter.getType(), (ASTNode)newType, null);
        proposals.add(proposal);
    }
}

