/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.TextEditFix;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ImportsFix
extends TextEditFix {
    public static ICleanUpFix createCleanUp(CompilationUnit cu, CodeGenerationSettings settings, boolean organizeImports, RefactoringStatus status) throws CoreException {
        if (!organizeImports) {
            return null;
        }
        final boolean[] hasAmbiguity = new boolean[1];
        OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                hasAmbiguity[0] = true;
                return new TypeNameMatch[0];
            }
        };
        ICompilationUnit unit = (ICompilationUnit)cu.getJavaElement();
        OrganizeImportsOperation op = new OrganizeImportsOperation(unit, cu, settings.importIgnoreLowercase, false, false, query);
        TextEdit edit = op.createTextEdit(null);
        if (hasAmbiguity[0]) {
            status.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unresolvable, ImportsFix.getLocationString(cu)));
        }
        if (op.getParseError() != null) {
            status.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_parse, ImportsFix.getLocationString(cu)));
            return null;
        }
        if (edit == null || edit instanceof MultiTextEdit && edit.getChildrenSize() == 0) {
            return null;
        }
        return new ImportsFix(edit, unit, FixMessages.ImportsFix_OrganizeImports_Description);
    }

    private static String getLocationString(CompilationUnit cu) {
        return BasicElementLabels.getPathLabel(cu.getJavaElement().getPath(), false);
    }

    public ImportsFix(TextEdit edit, ICompilationUnit unit, String description) {
        super(edit, unit, description);
    }
}

