/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormTextEditorContributor;
import org.eclipse.pde.internal.ui.nls.GetNonExternalizedStringsAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class ManifestEditorContributor
extends PDEFormTextEditorContributor {
    private ExternalizeAction fExternalizeAction;

    public ManifestEditorContributor() {
        super("&Plugin");
    }

    @Override
    public void contextMenuAboutToShow(IMenuManager mm, boolean addClipboard) {
        super.contextMenuAboutToShow(mm, addClipboard);
        IBaseModel model = this.getEditor().getAggregateModel();
        if (model != null && model.isEditable()) {
            mm.add((IContributionItem)new Separator());
            mm.add((IAction)this.fExternalizeAction);
        }
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.fExternalizeAction = new ExternalizeAction();
        this.fExternalizeAction.setText(PDEUIMessages.ManifestEditorContributor_externStringsActionName);
    }

    @Override
    public boolean supportsContentAssist() {
        return true;
    }

    @Override
    public boolean supportsFormatAction() {
        return true;
    }

    @Override
    public boolean supportsCorrectionAssist() {
        return true;
    }

    @Override
    public boolean supportsHyperlinking() {
        return true;
    }

    class ExternalizeAction
    extends Action {
        public void run() {
            if (ManifestEditorContributor.this.getEditor() != null) {
                BusyIndicator.showWhile((Display)SWTUtil.getStandardDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GetNonExternalizedStringsAction externalizeAction = new GetNonExternalizedStringsAction();
                        StructuredSelection selection = new StructuredSelection((Object)ManifestEditorContributor.this.getEditor().getCommonProject());
                        externalizeAction.runGetNonExternalizedStringsAction((ISelection)selection);
                    }
                });
            }
        }
    }
}

