/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrintStreamMonitor
implements IProgressMonitor {
    private boolean isCanceled;
    private String prefix;
    private OutputStreamWriter out;

    public PrintStreamMonitor() {
        this.prefix = "";
    }

    public PrintStreamMonitor(String prefix, File file) {
        this.prefix = prefix;
        if (file != null) {
            try {
                this.out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void beginTask(String name, int totalWork) {
        if (name != null && this.out != null) {
            try {
                this.out.write("Begin task: " + this.prefix + name + "\n");
                this.out.flush();
            }
            catch (Throwable throwable) {}
        }
    }

    private void print(String name) {
        if (name != null && this.out != null) {
            try {
                this.out.write("progress: " + this.prefix + name + "\n");
                this.out.flush();
            }
            catch (Throwable throwable) {}
        }
    }

    public void done() {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean value) {
        this.isCanceled = value;
    }

    public void setTaskName(String name) {
        this.print(name);
    }

    public void subTask(String name) {
        this.print(name);
    }

    public void worked(int work) {
    }
}

