/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class AcceleratedTreeScrolling
implements MouseWheelListener {
    private Tree fTree;
    private int fSkipLines;

    public AcceleratedTreeScrolling(Tree tree, int skipLines) {
        this.fTree = tree;
        this.fSkipLines = skipLines > 1 ? skipLines : 2;
    }

    public void mouseScrolled(MouseEvent e) {
        TreeItem item;
        if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && this.fTree != null && (item = this.fTree.getTopItem()) != null) {
            TreeItem nextItem = item;
            int i = 0;
            while (i < this.fSkipLines) {
                TreeItem foundItem = null;
                foundItem = e.count < 0 ? this.NextItem(this.fTree, nextItem) : this.PreviousItem(this.fTree, nextItem);
                if (foundItem == null) break;
                nextItem = foundItem;
                ++i;
            }
            this.fTree.setTopItem(nextItem);
        }
    }

    TreeItem PreviousItem(Tree tree, TreeItem item) {
        int index;
        if (item == null) {
            return null;
        }
        TreeItem childItem = item;
        TreeItem parentItem = childItem.getParentItem();
        int n = index = parentItem == null ? tree.indexOf(childItem) : parentItem.indexOf(childItem);
        if (index == 0) {
            return parentItem;
        }
        TreeItem previousItem = parentItem == null ? tree.getItem(index - 1) : parentItem.getItem(index - 1);
        int count = previousItem.getItemCount();
        while (count > 0 && previousItem.getExpanded()) {
            previousItem = previousItem.getItem(count - 1);
            count = previousItem.getItemCount();
        }
        return previousItem;
    }

    TreeItem NextItem(Tree tree, TreeItem item) {
        int count;
        if (item == null) {
            return null;
        }
        if (item.getExpanded() && item.getItemCount() > 0) {
            return item.getItem(0);
        }
        TreeItem childItem = item;
        TreeItem parentItem = childItem.getParentItem();
        int index = parentItem == null ? tree.indexOf(childItem) : parentItem.indexOf(childItem);
        int n = count = parentItem == null ? tree.getItemCount() : parentItem.getItemCount();
        while (index + 1 >= count) {
            if (parentItem == null) {
                return null;
            }
            childItem = parentItem;
            index = (parentItem = childItem.getParentItem()) == null ? tree.indexOf(childItem) : parentItem.indexOf(childItem);
            count = parentItem == null ? tree.getItemCount() : parentItem.getItemCount();
        }
        return parentItem == null ? tree.getItem(index + 1) : parentItem.getItem(index + 1);
    }
}

