/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.ecl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.util.DefaultFormatter;
import org.eclipse.rcptt.ecl.core.util.ICommandFormatter;
import org.eclipse.rcptt.tesla.core.protocol.GetState;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.WaitForState;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.recording.core.IStatementList;
import org.eclipse.rcptt.tesla.recording.core.RecordingCodeGenerator;
import org.eclipse.rcptt.tesla.recording.core.ecl.EclCodePart;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.TeslaParser;
import org.eclipse.rcptt.tesla.recording.core.internal.ecl.ECLStringConverter;
import org.eclipse.rcptt.tesla.recording.core.internal.ecl.TeslaSelectorParser;

public class EclRecorder
extends RecordingCodeGenerator {
    public void generateCode(TeslaScenario scenario, IStatementList statements) {
        throw new UnsupportedOperationException("Doesn't implemented yet");
    }

    public String generateCode(TeslaScenario scenario) {
        TeslaParser parser = new TeslaParser();
        Command eclCommand = parser.teslaScenario(scenario, null);
        return ECLStringConverter.INSTANCE.convert(eclCommand);
    }

    public EclCodePart getCodeLineForCommand(TeslaScenario scenario, int commandIndex) {
        if (commandIndex == 0) {
            return new EclCodePart(1, null);
        }
        TeslaParser parser = new TeslaParser();
        EList commands = scenario.getCommands();
        org.eclipse.rcptt.tesla.core.protocol.raw.Command cm = (org.eclipse.rcptt.tesla.core.protocol.raw.Command)commands.get(commandIndex);
        int realCommandIndex = commandIndex;
        if (this.isSkipCommand(cm)) {
            int i = 0;
            i = commandIndex + 1;
            while (i < commands.size()) {
                if (!this.isSkipCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)commands.get(i))) break;
                ++i;
            }
            realCommandIndex = i + 1;
        }
        Command eclCommand = parser.teslaScenario(scenario, realCommandIndex);
        String result = ECLStringConverter.INSTANCE.convert(eclCommand);
        String[] parts = result.split("\n");
        String lastLine = "";
        int lineNumber = 0;
        int i = parts.length - 1;
        while (i >= 0) {
            String curLine = parts[i].trim();
            if (!curLine.equals("}")) {
                lastLine = curLine;
                lineNumber = i;
                break;
            }
            --i;
        }
        return new EclCodePart(lineNumber + 1, lastLine);
    }

    private boolean isSkipCommand(org.eclipse.rcptt.tesla.core.protocol.raw.Command cm) {
        return cm instanceof SelectCommand || cm instanceof WaitForState || cm instanceof GetState;
    }

    public String selectorOf(TeslaScenario scenario, Element element) {
        TeslaSelectorParser parser = new TeslaSelectorParser(scenario);
        parser.parse();
        return ECLStringConverter.INSTANCE.convert(parser.selectorOf(element, true), (ICommandFormatter)new DefaultFormatter(false));
    }
}

