/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAccess;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public class Reference
implements IReference {
    private int fSourceLine = -1;
    private IApiMember fSourceMember;
    private int fKind = 0;
    private int fFlags = 0;
    private int fType;
    private String fTypeName;
    private String fMemberName;
    private String fSignature;
    private IApiMember fResolved;
    private boolean fStatus = true;
    private List<IApiProblem> fProblems = null;

    public boolean addProblems(IApiProblem problem) {
        if (problem == null) {
            return false;
        }
        if (this.fProblems == null) {
            this.fProblems = new ArrayList<IApiProblem>(2);
        }
        if (this.fProblems.contains(problem)) {
            return false;
        }
        return this.fProblems.add(problem);
    }

    public static Reference methodReference(IApiMember origin, String typeName, String methodName, String signature, int kind) {
        return Reference.methodReference(origin, typeName, methodName, signature, kind, 0);
    }

    public static Reference methodReference(IApiMember origin, String typeName, String methodName, String signature, int kind, int flags) {
        Reference ref = new Reference();
        ref.fSourceMember = origin;
        ref.fTypeName = typeName;
        ref.fMemberName = methodName;
        ref.fSignature = signature;
        ref.fKind = kind;
        ref.fType = 3;
        ref.fFlags = flags;
        return ref;
    }

    public static Reference fieldReference(IApiMember origin, String typeName, String fieldName, int kind) {
        return Reference.fieldReference(origin, typeName, fieldName, kind, 0);
    }

    public static Reference fieldReference(IApiMember origin, String typeName, String fieldName, int kind, int flags) {
        Reference ref = new Reference();
        ref.fSourceMember = origin;
        ref.fTypeName = typeName;
        ref.fMemberName = fieldName;
        ref.fKind = kind;
        ref.fType = 2;
        ref.fFlags = flags;
        return ref;
    }

    public static Reference typeReference(IApiMember origin, String typeName, int kind) {
        return Reference.typeReference(origin, typeName, null, kind, 0);
    }

    public static Reference typeReference(IApiMember origin, String typeName, String signature, int kind) {
        return Reference.typeReference(origin, typeName, signature, kind, 0);
    }

    public static Reference typeReference(IApiMember origin, String typeName, String signature, int kind, int flags) {
        Reference ref = new Reference();
        ref.fSourceMember = origin;
        ref.fTypeName = typeName;
        ref.fKind = kind;
        ref.fType = 1;
        ref.fSignature = signature;
        ref.fFlags = flags;
        return ref;
    }

    @Override
    public int getLineNumber() {
        return this.fSourceLine;
    }

    @Override
    public IApiMember getMember() {
        return this.fSourceMember;
    }

    @Override
    public int getReferenceKind() {
        return this.fKind;
    }

    @Override
    public int getReferenceFlags() {
        return this.fFlags;
    }

    public void setFlags(int newflags) {
        this.fFlags |= newflags;
    }

    @Override
    public int getReferenceType() {
        return this.fType;
    }

    @Override
    public IApiMember getResolvedReference() {
        return this.fResolved;
    }

    @Override
    public String getReferencedMemberName() {
        return this.fMemberName;
    }

    @Override
    public String getReferencedSignature() {
        return this.fSignature;
    }

    @Override
    public String getReferencedTypeName() {
        return this.fTypeName;
    }

    void setLineNumber(int line) {
        this.fSourceLine = line;
    }

    public void resolve() throws CoreException {
        IApiTypeRoot result;
        IApiComponent sourceComponent;
        if (!this.fStatus) {
            return;
        }
        if (this.fResolved == null && (sourceComponent = this.getMember().getApiComponent()) != null && (result = Util.getClassFile(sourceComponent.getBaseline().resolvePackage(sourceComponent, Signatures.getPackageName(this.getReferencedTypeName())), this.getReferencedTypeName())) != null) {
            IApiType type = result.getStructure();
            if (type == null) {
                return;
            }
            switch (this.getReferenceType()) {
                case 1: {
                    this.fResolved = type;
                    break;
                }
                case 2: {
                    this.resolveField(type, this.getReferencedMemberName());
                    break;
                }
                case 3: {
                    this.resolveVirtualMethod(type, this.getReferencedMemberName(), this.getReferencedSignature());
                    break;
                }
            }
        }
    }

    public boolean resolve(int eeValue) throws CoreException {
        IApiComponent sourceComponent = StubApiComponent.getStubApiComponent(eeValue);
        if (sourceComponent == null) {
            return true;
        }
        IApiTypeRoot result = Util.getClassFile(new IApiComponent[]{sourceComponent}, this.getReferencedTypeName());
        if (result != null) {
            IApiType type = result.getStructure();
            if (type == null) {
                return false;
            }
            switch (this.getReferenceType()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return this.resolveField(type, this.getReferencedMemberName());
                }
                case 3: {
                    return this.resolveMethod(sourceComponent, type, this.getReferencedMemberName(), this.getReferencedSignature());
                }
            }
        }
        return false;
    }

    private boolean resolveField(IApiType type, String fieldame) throws CoreException {
        IApiField field = type.getField(fieldame);
        if (field != null) {
            this.fResolved = field;
            return true;
        }
        IApiType superT = type.getSuperclass();
        if (superT != null) {
            return this.resolveField(superT, fieldame);
        }
        return false;
    }

    private boolean resolveVirtualMethod(IApiType type, String methodName, String methodSignature) throws CoreException {
        if (this.setResolvedMethod(type.getMethod(methodName, methodSignature))) {
            return true;
        }
        if (this.getReferenceKind() == 512 ? this.resolveInterfaceMethod(type, methodName, methodSignature) : this.resolveSuperTypeMethod(type, methodName, methodSignature)) {
            return true;
        }
        if ((this.fFlags & 2) > 0) {
            return this.resolveInterfaceMethod(type, methodName, methodSignature);
        }
        return false;
    }

    boolean setResolvedMethod(IApiMethod method) throws CoreException {
        if (method != null) {
            if (method.isSynthetic()) {
                return false;
            }
            if (method.isDefaultMethod()) {
                this.fTypeName = method.getEnclosingType().getName();
            }
            this.fResolved = method;
            return true;
        }
        return false;
    }

    boolean resolveSuperTypeMethod(IApiType type, String methodName, String methodSignature) throws CoreException {
        if (this.setResolvedMethod(type.getMethod(methodName, methodSignature))) {
            return true;
        }
        IApiType superT = type.getSuperclass();
        if (superT != null) {
            return this.resolveVirtualMethod(superT, methodName, methodSignature);
        }
        return false;
    }

    boolean resolveInterfaceMethod(IApiType type, String methodName, String methodSignature) throws CoreException {
        if (this.setResolvedMethod(type.getMethod(methodName, methodSignature))) {
            return true;
        }
        IApiType[] interfaces = type.getSuperInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                if (this.resolveInterfaceMethod(interfaces[i], methodName, methodSignature)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean resolveMethod(IApiComponent sourceComponent, IApiType type, String methodName, String methodSignature) throws CoreException {
        IApiMethod target = type.getMethod(methodName, methodSignature);
        if (target != null) {
            return !target.isSynthetic();
        }
        switch (this.fKind) {
            case 512: {
                String[] interfacesNames = type.getSuperInterfaceNames();
                if (interfacesNames == null) break;
                int i = 0;
                int max = interfacesNames.length;
                while (i < max) {
                    IApiTypeRoot classFile = Util.getClassFile(new IApiComponent[]{sourceComponent}, interfacesNames[i]);
                    if (classFile == null) {
                        ApiPlugin.logErrorMessage("Class file for " + interfacesNames[i] + " was not found for " + sourceComponent.getName());
                        return false;
                    }
                    IApiType superinterface = classFile.getStructure();
                    if (superinterface != null && this.resolveMethod(sourceComponent, superinterface, methodName, methodSignature)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 128: {
                String superclassName = type.getSuperclassName();
                if (superclassName == null) break;
                IApiTypeRoot classFile = Util.getClassFile(new IApiComponent[]{sourceComponent}, superclassName);
                if (classFile == null) {
                    ApiPlugin.logErrorMessage("Class file for " + superclassName + " was not found for " + sourceComponent.getName());
                    return false;
                }
                IApiType superclass = classFile.getStructure();
                boolean resolved = this.resolveMethod(sourceComponent, superclass, methodName, methodSignature);
                if (!resolved) break;
                return resolved;
            }
            case 256: 
            case 0x100000: {
                String[] interfacesNames;
                target = type.getMethod(methodName, "([Ljava/lang/Object;)Ljava/lang/Object;");
                if (target != null && methodName.equals(target.getName()) && target.isPolymorphic()) {
                    return true;
                }
                String superclassName = type.getSuperclassName();
                if (superclassName != null) {
                    IApiTypeRoot classFile = Util.getClassFile(new IApiComponent[]{sourceComponent}, superclassName);
                    if (classFile == null) {
                        ApiPlugin.logErrorMessage("Class file for " + superclassName + " was not found for " + sourceComponent.getName());
                        return false;
                    }
                    IApiType superclass = classFile.getStructure();
                    boolean resolved = this.resolveMethod(sourceComponent, superclass, methodName, methodSignature);
                    if (resolved) {
                        return resolved;
                    }
                }
                if (!Flags.isAbstract((int)type.getModifiers()) || (interfacesNames = type.getSuperInterfaceNames()) == null) break;
                int i = 0;
                int max = interfacesNames.length;
                while (i < max) {
                    IApiTypeRoot classFile = Util.getClassFile(new IApiComponent[]{sourceComponent}, interfacesNames[i]);
                    if (classFile == null) {
                        ApiPlugin.logErrorMessage("Class file for " + interfacesNames[i] + " was not found for " + sourceComponent.getName());
                        return false;
                    }
                    IApiType superinterface = classFile.getStructure();
                    if (superinterface != null && this.resolveMethod(sourceComponent, superinterface, methodName, methodSignature)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    public void setResolution(IApiMember resolution) {
        this.fResolved = resolution;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("From: ");
        IApiMember member = this.getMember();
        buf.append(member.getHandle().toString());
        buf.append(" [line: ").append(this.getLineNumber()).append("]");
        if (this.getResolvedReference() == null) {
            buf.append("\nUnresolved To: ");
            buf.append(this.getReferencedTypeName());
            if (this.getReferencedMemberName() != null) {
                buf.append('#');
                buf.append(this.getReferencedMemberName());
            }
            if (this.getReferencedSignature() != null) {
                buf.append('#');
                buf.append(this.getReferencedSignature());
            }
        } else {
            buf.append("\nResolved To: ");
            buf.append(this.getResolvedReference().getHandle().toString());
        }
        buf.append("\nKind: ");
        buf.append(Reference.getReferenceText(this.getReferenceKind()));
        return buf.toString();
    }

    public void setResolveStatus(boolean value) {
        this.fStatus = value;
    }

    public static final String getReferenceText(int kind) {
        StringBuffer buffer = new StringBuffer();
        if ((kind & 1) > 0) {
            buffer.append("EXTENDS");
        }
        if ((kind & 2) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("IMPLEMENTS");
        }
        if ((kind & 0x100000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INVOKED_SPECIAL");
        }
        if ((kind & 0x80) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INVOKED_STATIC");
        }
        if ((kind & 0x4000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PUT_FIELD");
        }
        if ((kind & 0x1000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PUT_STATIC_FIELD");
        }
        if ((kind & 4) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_FIELD");
        }
        if ((kind & 0x200000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_TYPE");
        }
        if ((kind & 0x400000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_FIELD");
        }
        if ((kind & 0x800000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_METHOD");
        }
        if ((kind & 0x10) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PARAMETER");
        }
        if ((kind & 0x2000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("LOCAL_VAR_DECLARED");
        }
        if ((kind & 0x1000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("DECLARED_PARAMETERIZED_VARIABLE");
        }
        if ((kind & 0x20) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("THROWS");
        }
        if ((kind & 0x40000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CASTS");
        }
        if ((kind & 0x8000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("ALLOCATES_ARRAY");
        }
        if ((kind & 0x20000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CATCHES_EXCEPTION");
        }
        if ((kind & 0x2000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("GETS_FIELD");
        }
        if ((kind & 0x800) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("GETS_STATIC_FIELD");
        }
        if ((kind & 0x80000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INSTANCEOF");
        }
        if ((kind & 0x200) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INTERFACE_METHOD");
        }
        if ((kind & 0x40) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CONSTRUCTOR_METHOD");
        }
        if ((kind & 0x10000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("LOCAL_VARIABLE");
        }
        if ((kind & 0x400) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("PASSED_PARAMETER");
        }
        if ((kind & 8) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("RETURN_TYPE");
        }
        if ((kind & 0x100) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("VIRTUAL_METHOD");
        }
        if ((kind & 0x4000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("CONSTANT_POOL");
        }
        if ((kind & 0x8000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("INSTANTIATION");
        }
        if ((kind & 0x10000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("OVERRIDE");
        }
        if ((kind & 0x20000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("SUPER_CONSTRUCTORMETHOD");
        }
        if ((kind & 0x40000000) > 0) {
            if (buffer.length() != 0) {
                buffer.append(" | ");
            }
            buffer.append("ANNOTATION_USE");
        }
        if (buffer.length() == 0) {
            buffer.append("UNKNOWN_KIND");
        }
        return buffer.toString();
    }

    public IReferenceDescriptor getReferenceDescriptor() throws CoreException {
        IApiMember res = this.getResolvedReference();
        if (res == null) {
            return null;
        }
        IApiComponent rcomponent = res.getApiComponent();
        IApiDescription description = rcomponent.getApiDescription();
        IApiAnnotations annot = description.resolveAnnotations(this.getResolvedReference().getHandle());
        int visibility = -1;
        IApiComponent mcomponent = this.getMember().getApiComponent();
        if (annot != null) {
            visibility = annot.getVisibility();
            if (annot.getVisibility() == 2) {
                IApiComponent host = mcomponent.getHost();
                if (host != null && host.getSymbolicName().equals(rcomponent.getSymbolicName())) {
                    visibility = 5;
                } else {
                    IApiAccess access = description.resolveAccessLevel(Factory.componentDescriptor(mcomponent.getSymbolicName()), this.getResolvedReference().getHandle().getPackage());
                    if (access != null && access.getAccessLevel() == 1) {
                        visibility = 8;
                    }
                }
            }
        } else {
            visibility = 65535;
        }
        String[] messages = null;
        if (this.fProblems != null) {
            messages = new String[this.fProblems.size()];
            int i = 0;
            while (i < messages.length) {
                messages[i] = this.fProblems.get(i).getMessage();
                ++i;
            }
        }
        return Factory.referenceDescriptor((IComponentDescriptor)mcomponent.getHandle(), this.getMember().getHandle(), this.getLineNumber(), (IComponentDescriptor)rcomponent.getHandle(), res.getHandle(), this.getReferenceKind(), this.getReferenceFlags(), visibility, messages);
    }
}

