/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.markers.DefaultApiProfileResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.DuplicateAnnotationResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.DuplicateTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.FilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.FilterProblemWithCommentResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.InstallEEDescriptionProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.MissingEEDescriptionProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.OpenPropertyPageResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.RemoveFilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UnsupportedAnnotationResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UnsupportedTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UpdateProjectSettingResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.VersionNumberingResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ApiMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];
    private MissingEEDescriptionProblemResolution eeResolution = new MissingEEDescriptionProblemResolution();
    private InstallEEDescriptionProblemResolution installEEResolution = new InstallEEDescriptionProblemResolution();
    private DefaultApiProfileResolution profileResolution = new DefaultApiProfileResolution();

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return this.NO_RESOLUTIONS;
        }
        switch (marker.getAttribute("apiMarkerID", -1)) {
            case 3: {
                int id = ApiProblemFactory.getProblemId((IMarker)marker);
                if (id > -1 && ApiProblemFactory.getProblemKind((int)id) == 11) {
                    return new IMarkerResolution[]{this.installEEResolution, this.eeResolution};
                }
                return new IMarkerResolution[]{new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 2: {
                return new IMarkerResolution[]{new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 1: {
                return new IMarkerResolution[]{this.profileResolution};
            }
            case 5: {
                return new IMarkerResolution[]{new SinceTagResolution(marker), new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 4: {
                return new IMarkerResolution[]{new VersionNumberingResolution(marker), new FilterProblemResolution(marker), new FilterProblemWithCommentResolution(marker)};
            }
            case 6: {
                return new IMarkerResolution[]{new UnsupportedTagResolution(marker)};
            }
            case 7: {
                return new IMarkerResolution[]{new DuplicateTagResolution(marker)};
            }
            case 11: {
                return new IMarkerResolution[]{new UnsupportedAnnotationResolution(marker)};
            }
            case 10: {
                return new IMarkerResolution[]{new DuplicateAnnotationResolution(marker)};
            }
            case 8: {
                return new IMarkerResolution[]{new UpdateProjectSettingResolution(marker)};
            }
            case 9: {
                IApiProblemFilter filter = ApiMarkerResolutionGenerator.resolveFilter(marker);
                if (filter != null) {
                    return new IMarkerResolution[]{new RemoveFilterProblemResolution(filter, marker), new OpenPropertyPageResolution(MarkerMessages.ApiMarkerResolutionGenerator_api_problem_filters, "org.eclipse.pde.api.tools.ui.apitools.filterspage", (IAdaptable)marker.getResource().getProject())};
                }
                return new IMarkerResolution[]{new OpenPropertyPageResolution(MarkerMessages.ApiMarkerResolutionGenerator_api_problem_filters, "org.eclipse.pde.api.tools.ui.apitools.filterspage", (IAdaptable)marker.getResource().getProject())};
            }
        }
        return this.NO_RESOLUTIONS;
    }

    static IApiProblemFilter resolveFilter(IMarker marker) {
        try {
            String filterhandle = marker.getAttribute("filterhandle", null);
            String[] values = filterhandle.split("%]");
            IProject project = marker.getResource().getProject();
            IApiComponent component = ApiBaselineManager.getManager().getWorkspaceBaseline().getApiComponent(project);
            if (component != null) {
                IApiFilterStore store = component.getFilterStore();
                Path path = new Path(values[1]);
                IResource resource = project.findMember((IPath)path);
                if (resource == null) {
                    resource = project.getFile((IPath)path);
                }
                int hashcode = ApiProblemFactory.getProblemHashcode((String)filterhandle);
                IApiProblemFilter[] filters = store.getFilters(resource);
                int i = 0;
                while (i < filters.length) {
                    if (filters[i].getUnderlyingProblem().hashCode() == hashcode) {
                        return filters[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public boolean hasResolutions(IMarker marker) {
        return Util.isApiProblemMarker((IMarker)marker);
    }
}

