/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFilterInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private List<String> fExistingEntries;

    public TypeFilterInputDialog(Shell parent, List<String> existingEntries) {
        super(parent);
        this.fExistingEntries = existingEntries;
        this.setTitle(PreferencesMessages.TypeFilterInputDialog_title);
        TypeFilterInputAdapter adapter = new TypeFilterInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(adapter);
        this.fNameDialogField.setLabelText(PreferencesMessages.TypeFilterInputDialog_message);
        this.fNameDialogField.setButtonLabel(PreferencesMessages.TypeFilterInputDialog_browse_button);
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText("");
    }

    public void setInitialString(String input) {
        Assert.isNotNull((Object)input);
        this.fNameDialogField.setText(input);
    }

    public Object getResult() {
        return this.fNameDialogField.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fNameDialogField}, true, 0, 0);
        int fieldWidthHint = this.convertWidthInCharsToPixels(60);
        Text text = this.fNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        BidiUtils.applyBidiProcessing((Text)text, (String)"java");
        TextFieldNavigationHandler.install(text);
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        TypeFilterInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doButtonPressed() {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        int flags = 7;
        PackageSelectionDialog dialog = new PackageSelectionDialog(this.getShell(), context, flags, scope);
        dialog.setTitle(PreferencesMessages.TypeFilterInputDialog_choosepackage_label);
        dialog.setMessage(PreferencesMessages.TypeFilterInputDialog_choosepackage_description);
        dialog.setMultipleSelection(false);
        dialog.setFilter(this.fNameDialogField.getText());
        if (dialog.open() == 0) {
            IPackageFragment res = (IPackageFragment)dialog.getFirstResult();
            this.fNameDialogField.setText(String.valueOf(res.getElementName()) + "*");
        }
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.TypeFilterInputDialog_error_enterName);
        } else {
            IStatus val = JavaConventions.validatePackageName((String)(newText = newText.replace('*', 'X').replace('?', 'Y')), (String)"1.3", (String)"1.3");
            if (val.matches(4)) {
                status.setError(Messages.format(PreferencesMessages.TypeFilterInputDialog_error_invalidName, val.getMessage()));
            } else if (this.fExistingEntries.contains(newText)) {
                status.setError(PreferencesMessages.TypeFilterInputDialog_error_entryExists);
            }
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.import_organize_input_dialog_context");
    }

    private class TypeFilterInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private TypeFilterInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            TypeFilterInputDialog.this.doValidation();
        }

        public void changeControlPressed(DialogField field) {
            TypeFilterInputDialog.this.doButtonPressed();
        }
    }
}

