/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRule;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class RuleTabPropertySection
extends ModelElementTabPropertySection {
    protected Text fIdText = null;
    protected Text fTitleText = null;
    protected Text fDescriptionText = null;
    protected CCombo fClassCombo = null;
    protected CCombo fRankCombo = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fIdText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fIdText.setEditable(false);
        this.fIdText.setToolTipText("An Tag that Identifies this Design Rule");
        this.fIdText.setLayoutData((Object)data);
        CLabel idLabel = widgetFactory.createCLabel(composite, "Id: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fIdText, -5);
        data.top = new FormAttachment((Control)this.fIdText, 0, 0x1000000);
        idLabel.setToolTipText("An Tag that Identifies this Design Rule");
        idLabel.setLayoutData((Object)data);
        this.fTitleText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fIdText, 4);
        this.fTitleText.setEditable(false);
        this.fTitleText.setToolTipText("The Design Rule Title");
        this.fTitleText.setLayoutData((Object)data);
        CLabel titleLabel = widgetFactory.createCLabel(composite, "Title: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fTitleText, -5);
        data.top = new FormAttachment((Control)this.fTitleText, 0, 0x1000000);
        titleLabel.setToolTipText("The Design Rule Title");
        titleLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fDescriptionText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fTitleText, 4);
        this.fDescriptionText.setToolTipText("A Description of the Design Rule");
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!RuleTabPropertySection.this.fRefreshInProgress && RuleTabPropertySection.this.fDescriptionText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EDesignRule modelRule = ((R4EUIRule)RuleTabPropertySection.this.fProperties.getElement()).getRule();
                        String newValue = RuleTabPropertySection.this.fDescriptionText.getText().trim();
                        if (!newValue.equals(modelRule.getDescription())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelRule, currentUser);
                            modelRule.setDescription(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        RuleTabPropertySection.this.fDescriptionText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fDescriptionText);
        CLabel descriptionLabel = widgetFactory.createCLabel(composite, "Description: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDescriptionText, -5);
        data.top = new FormAttachment((Control)this.fDescriptionText, 0, 0x1000000);
        descriptionLabel.setToolTipText("A Description of the Design Rule");
        descriptionLabel.setLayoutData((Object)data);
        this.fClassCombo = widgetFactory.createCCombo(composite, 8);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDescriptionText, 4);
        this.fClassCombo.setToolTipText("The Class for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        this.fClassCombo.setLayoutData((Object)data);
        this.fClassCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!RuleTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EDesignRule modelRule = ((R4EUIRule)RuleTabPropertySection.this.fProperties.getElement()).getRule();
                        R4EDesignRuleClass newClass = UIUtils.getClassFromString(RuleTabPropertySection.this.fClassCombo.getText());
                        R4EDesignRuleClass oldClass = modelRule.getClass_();
                        if (!newClass.equals((Object)oldClass)) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelRule, currentUser);
                            modelRule.setClass(newClass);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                RuleTabPropertySection.this.refresh();
            }
        });
        RuleTabPropertySection.addScrollListener(this.fClassCombo);
        CLabel classLabel = widgetFactory.createCLabel(composite, "Class: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fClassCombo, -5);
        data.top = new FormAttachment((Control)this.fClassCombo, 0, 0x1000000);
        classLabel.setToolTipText("The Class for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        classLabel.setLayoutData((Object)data);
        this.fRankCombo = widgetFactory.createCCombo(composite, 8);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fClassCombo, 4);
        this.fRankCombo.setToolTipText("The Rank (or Severity) for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        this.fRankCombo.setLayoutData((Object)data);
        this.fRankCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!RuleTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EDesignRule modelRule = ((R4EUIRule)RuleTabPropertySection.this.fProperties.getElement()).getRule();
                        R4EDesignRuleRank newRank = UIUtils.getRankFromString(RuleTabPropertySection.this.fRankCombo.getText());
                        R4EDesignRuleRank oldRank = modelRule.getRank();
                        if (!newRank.equals((Object)oldRank)) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelRule, currentUser);
                            modelRule.setRank(UIUtils.getRankFromString(RuleTabPropertySection.this.fRankCombo.getText()));
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                RuleTabPropertySection.this.refresh();
            }
        });
        RuleTabPropertySection.addScrollListener(this.fRankCombo);
        CLabel rankLabel = widgetFactory.createCLabel(composite, "Rank: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fRankCombo, -5);
        data.top = new FormAttachment((Control)this.fRankCombo, 0, 0x1000000);
        rankLabel.setToolTipText("The Rank (or Severity) for this Design Rule.  It will be automatically set in Anomalies that refers to this Rule");
        rankLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        if (((R4EUIRule)this.fProperties.getElement()).getRule() != null) {
            this.fRefreshInProgress = true;
            R4EDesignRule modelRule = ((R4EUIRule)this.fProperties.getElement()).getRule();
            this.fIdText.setText(modelRule.getId());
            this.fTitleText.setText(modelRule.getTitle());
            this.fDescriptionText.setText(modelRule.getDescription());
            this.fClassCombo.setItems(UIUtils.getClasses());
            if (modelRule.getClass() != null) {
                this.fClassCombo.select(modelRule.getClass_().getValue());
            } else {
                this.fClassCombo.setText("");
            }
            this.fRankCombo.setItems(UIUtils.getRanks());
            int rankValue = modelRule.getRank().getValue();
            this.fRankCombo.select(rankValue == 3 ? 1 : rankValue);
            this.setEnabledFields();
            this.fRefreshInProgress = false;
        } else {
            this.fIdText.setText("");
            this.fTitleText.setText("");
            this.fDescriptionText.setText("");
            this.fClassCombo.setText("");
            this.fRankCombo.setText("");
        }
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || !this.fProperties.getElement().isEnabled() || this.fProperties.getElement().isReadOnly()) {
            this.fIdText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTitleText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(false);
            this.fClassCombo.setEnabled(false);
            this.fRankCombo.setEnabled(false);
        } else {
            this.fIdText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fTitleText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(true);
            this.fClassCombo.setEnabled(true);
            this.fRankCombo.setEnabled(true);
        }
    }
}

