/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;

public class RefreshHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Refreshing Review Navigator View...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(RefreshHandler.COMMAND_MESSAGE, -1);
                R4EUIModelController.setJobInProgress(true);
                try {
                    if (R4EUIModelController.getNavigatorView().isDefaultDisplay()) {
                        if (!selectedElements.isEmpty()) {
                            IR4EUIModelElement element = (IR4EUIModelElement)selectedElements.get(0);
                            if (element instanceof R4EUIReviewGroup) {
                                ((R4EUIReviewGroup)element).close();
                                ((R4EUIReviewGroup)element).open();
                            } else {
                                RefreshHandler.this.refreshReview(element);
                            }
                            R4EUIModelController.setJobInProgress(false);
                            UIUtils.setNavigatorViewFocus(element, 0);
                        } else {
                            IR4EUIModelElement[] groups;
                            IR4EUIModelElement[] iR4EUIModelElementArray = groups = R4EUIModelController.getRootElement().getChildren();
                            int n = groups.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IR4EUIModelElement group = iR4EUIModelElementArray[n2];
                                if (group.isOpen()) {
                                    group.close();
                                    group.open();
                                    R4EUIModelController.setJobInProgress(false);
                                    UIUtils.setNavigatorViewFocus(group, 0);
                                }
                                ++n2;
                            }
                        }
                    } else {
                        R4EUIReviewBasic review = R4EUIModelController.getActiveReview();
                        if (review != null) {
                            review.close();
                            review.open();
                            R4EUIModelController.setJobInProgress(false);
                            UIUtils.setNavigatorViewFocus(review, 0);
                        }
                    }
                }
                catch (ResourceHandlingException e) {
                    UIUtils.displayResourceErrorDialog(e);
                }
                catch (FileNotFoundException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
                }
                catch (CompatibilityException e1) {
                    UIUtils.displayCompatibilityErrorDialog(e1);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void refreshReview(IR4EUIModelElement element) {
        IR4EUIModelElement refreshElement = element;
        try {
            while (refreshElement != null && !(refreshElement instanceof R4EUIReviewBasic)) {
                refreshElement = refreshElement.getParent();
            }
            if (refreshElement != null && refreshElement.isOpen()) {
                refreshElement.close();
                refreshElement.open();
            }
        }
        catch (ResourceHandlingException e) {
            UIUtils.displayResourceErrorDialog(e);
        }
        catch (FileNotFoundException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "File not found error detected while refreshing review item ", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        }
        catch (CompatibilityException e) {
            UIUtils.displayCompatibilityErrorDialog(e);
        }
    }
}

