/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.progress.UIJob;

public class NewRuleSetElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Adding New Rule Set...";

    public Object execute(ExecutionEvent event) {
        UIJob job = new UIJob(COMMAND_MESSAGE){
            public String familyName;
            {
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(NewRuleSetElementHandler.COMMAND_MESSAGE, -1);
                final R4EUIRootElement element = R4EUIModelController.getRootElement();
                final ReviewComponent tempModelComponent = element.createRuleSetElement();
                if (tempModelComponent != null) {
                    R4EUIPlugin.Ftracer.traceInfo("Adding Rule Set to the root element ");
                    Job job = new Job(NewRuleSetElementHandler.COMMAND_MESSAGE){

                        public IStatus run(IProgressMonitor monitor) {
                            R4EUIModelController.setJobInProgress(true);
                            monitor.beginTask(NewRuleSetElementHandler.COMMAND_MESSAGE, -1);
                            IR4EUIModelElement newElement = null;
                            try {
                                newElement = element.createChildren(tempModelComponent);
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                                try {
                                    element.removeChildren(newElement, true);
                                }
                                catch (ResourceHandlingException e1) {
                                    UIUtils.displayResourceErrorDialog(e1);
                                }
                                catch (OutOfSyncException e1) {
                                    UIUtils.displaySyncErrorDialog(e1);
                                }
                                catch (CompatibilityException e1) {
                                    UIUtils.displayCompatibilityErrorDialog(e1);
                                }
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                                try {
                                    element.removeChildren(newElement, true);
                                }
                                catch (ResourceHandlingException e1) {
                                    UIUtils.displayResourceErrorDialog(e1);
                                }
                                catch (OutOfSyncException e1) {
                                    UIUtils.displaySyncErrorDialog(e1);
                                }
                                catch (CompatibilityException e1) {
                                    UIUtils.displayCompatibilityErrorDialog(e1);
                                }
                            }
                            catch (OutOfSyncException e) {
                                UIUtils.displaySyncErrorDialog(e);
                                try {
                                    element.removeChildren(newElement, true);
                                }
                                catch (ResourceHandlingException e1) {
                                    UIUtils.displayResourceErrorDialog(e1);
                                }
                                catch (OutOfSyncException e1) {
                                    UIUtils.displaySyncErrorDialog(e1);
                                }
                                catch (CompatibilityException e1) {
                                    UIUtils.displayCompatibilityErrorDialog(e1);
                                }
                            }
                            R4EUIModelController.setJobInProgress(false);
                            UIUtils.setNavigatorViewFocus(newElement, 0);
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

