/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.userSearch.query.IQueryUser;
import org.eclipse.mylyn.reviews.userSearch.query.QueryUserFactory;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;

public class PreferenceConstants {
    public static final String P_DESC = "R4E Global Preferences";
    public static final String P_USER_ID = "userIdPreference";
    public static final String P_USER_EMAIL = "userEmailPreference";
    public static final String P_USER_ID_LABEL = "User ID:";
    public static final String P_USER_EMAIL_LABEL = "User Email:";
    public static final String P_PARTICIPANTS_LISTS = "participantsLists";
    public static final String P_PARTICIPANTS = "participants";
    public static final String P_USE_DELTAS = "useDeltasPreferences";
    public static final String P_IMPORT_GLOBAL_ANOMALIES_POSTPONED = "importPostponedGlobalAnomaliesPreferences";
    public static final String P_SEND_NOTIFICATION_TO_SENDER = "SendNotificationToSenderPreferences";
    public static final String P_USE_DELTAS_LABEL = "Create Delta Elements to track changes for Version-Controlled Review Items";
    public static final String P_IMPORT_POSTPONED_GLOBAL_ANOMALIES_LABEL = "Import Postponed Global Anomalies ";
    public static final String P_SEND_NOTIFICATION_TO_SENDER_LABEL = "Include sender in e-mail notifications";
    public static final String P_GROUP_FILE_PATH = "groupFilePathPreference";
    public static final String P_GROUP_FILE_PATH_LABEL = "Review Group Files:";
    public static final String P_GROUP_FILE_EXT = "*_group_root.xrer";
    public static final String P_RULE_SET_FILE_PATH = "ruleSetFilePathPreference";
    public static final String P_RULE_SET_FILE_PATH_LABEL = "Rule Set Files:";
    public static final String P_RULE_SET_FILE_EXT = "*_rule_set.xrer";
    public static final String P_FILE_EXT_MAC = "*.xrer";
    public static final String P_SHOW_DISABLED = "showDisabled";
    public static final String P_REVIEWS_COMPLETED_FILTER = "reviewsCompletedFilter";
    public static final String P_REVIEWS_ONLY_FILTER = "reviewsOnlyFilter";
    public static final String P_REVIEWS_MY_FILTER = "reviewsMyFilter";
    public static final String P_PARTICIPANT_FILTER = "participantFilter";
    public static final String P_ASSIGN_MY_FILTER = "assignMyFilter";
    public static final String P_ASSIGN_FILTER = "assignFilter";
    public static final String P_UNASSIGN_FILTER = "unassignFilter";
    public static final String P_ANOMALIES_ALL_FILTER = "anomaliesFilter";
    public static final String P_ANOMALIES_MY_FILTER = "anomaliesMyFilter";
    public static final String P_REVIEWED_ITEMS_FILTER = "reviewItemsFilter";
    public static final String P_HIDE_RULE_SETS_FILTER = "hideRuleSetsFilter";
    public static final String P_HIDE_DELTAS_FILTER = "hideDeltasFilter";
    public static final String OPEN_ANOMALY_ANNOTATION_TEXT = "anomalyOpen_text";
    public static final String OPEN_ANOMALY_ANNOTATION_STYLE = "anomalyOpen_style";
    public static final String CLOSED_ANOMALY_ANNOTATION_TEXT = "anomalyClosed_text";
    public static final String CLOSED_ANOMALY_ANNOTATION_STYLE = "anomalyClosed_style";
    public static final String DISABLED_ANOMALY_ANNOTATION_TEXT = "anomalyDisabled_text";
    public static final String DISABLED_ANOMALY_ANNOTATION_STYLE = "anomalyDisabled_style";

    public static void setUserEmailDefaultPreferences() {
        if (R4EUIModelController.isUserQueryAvailable()) {
            try {
                IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
                String userId = store.getDefaultString(P_USER_ID);
                IQueryUser query = new QueryUserFactory().getInstance();
                ArrayList userInfos = query.searchByUserId(userId);
                if (userInfos.size() > 0) {
                    store.setDefault(P_USER_EMAIL, ((IUserInfo)userInfos.get(0)).getEmail());
                }
            }
            catch (NamingException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            }
            catch (IOException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            }
        }
    }
}

